/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import android.net.dhcp.DhcpStateMachine;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;

class DhcpRequestPacket
extends DhcpPacket {
    DhcpRequestPacket(int n, InetAddress inetAddress, byte[] byArray, boolean bl) {
        super(n, inetAddress, Inet4Address.ANY, Inet4Address.ANY, Inet4Address.ANY, byArray, bl);
    }

    @Override
    public ByteBuffer buildPacket(int n, short s, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1500);
        this.fillInPacket(n, Inet4Address.ALL, Inet4Address.ANY, s, s2, byteBuffer, (byte)1, this.mBroadcast);
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doNextOp(DhcpStateMachine dhcpStateMachine) {
        InetAddress inetAddress = this.mRequestedIp == null ? this.mClientIp : this.mRequestedIp;
        Log.v("DhcpPacket", "requested IP is " + this.mRequestedIp + " and client IP is " + this.mClientIp);
        dhcpStateMachine.onRequestReceived(this.mBroadcast, this.mTransId, this.mClientMac, inetAddress, this.mRequestedParams, this.mHostName);
    }

    @Override
    void finishPacket(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[7];
        byArray[0] = 1;
        System.arraycopy((byte[])this.mClientMac, (int)0, (byte[])byArray, (int)1, (int)6);
        this.addTlv(byteBuffer, (byte)53, (byte)3);
        this.addTlv(byteBuffer, (byte)55, this.mRequestedParams);
        this.addTlv(byteBuffer, (byte)50, this.mRequestedIp);
        this.addTlv(byteBuffer, (byte)54, this.mServerIdentifier);
        this.addTlv(byteBuffer, (byte)61, byArray);
        this.addTlvEnd(byteBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toString() {
        int n;
        String string2 = super.toString();
        StringBuilder stringBuilder = new StringBuilder().append(string2).append(" REQUEST, desired IP ").append(this.mRequestedIp).append(" from host '").append(this.mHostName).append("', param list length ");
        if (this.mRequestedParams == null) {
            n = 0;
            return stringBuilder.append(n).toString();
        }
        n = this.mRequestedParams.length;
        return stringBuilder.append(n).toString();
    }
}

