/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.ScanResult;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchedScanResult
implements Parcelable {
    public static final Parcelable.Creator<BatchedScanResult> CREATOR = new Parcelable.Creator<BatchedScanResult>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public BatchedScanResult createFromParcel(Parcel parcel) {
            int n = 1;
            BatchedScanResult batchedScanResult = new BatchedScanResult();
            if (parcel.readInt() != n) {
                n = 0;
            }
            batchedScanResult.truncated = n;
            int n2 = parcel.readInt();
            while (true) {
                int n3 = n2 - 1;
                if (n2 <= 0) {
                    return batchedScanResult;
                }
                batchedScanResult.scanResults.add(ScanResult.CREATOR.createFromParcel(parcel));
                n2 = n3;
            }
        }

        public BatchedScanResult[] newArray(int n) {
            return new BatchedScanResult[n];
        }
    };
    private static final String TAG = "BatchedScanResult";
    public final List<ScanResult> scanResults = new ArrayList<ScanResult>();
    public boolean truncated;

    public BatchedScanResult() {
    }

    public BatchedScanResult(BatchedScanResult batchedScanResult) {
        this.truncated = batchedScanResult.truncated;
        for (ScanResult scanResult : batchedScanResult.scanResults) {
            this.scanResults.add(new ScanResult(scanResult));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BatchedScanResult: ").append("truncated: ").append(String.valueOf(this.truncated)).append("scanResults: [");
        for (ScanResult scanResult : this.scanResults) {
            stringBuffer.append(" <").append(scanResult.toString()).append("> ");
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.truncated ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeInt(this.scanResults.size());
        Iterator<ScanResult> iterator = this.scanResults.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(parcel, n);
        }
        return;
    }
}

