/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BatchedScanSettings
implements Parcelable {
    public static final Parcelable.Creator<BatchedScanSettings> CREATOR = new Parcelable.Creator<BatchedScanSettings>(){

        @Override
        public BatchedScanSettings createFromParcel(Parcel parcel) {
            BatchedScanSettings batchedScanSettings = new BatchedScanSettings();
            batchedScanSettings.maxScansPerBatch = parcel.readInt();
            batchedScanSettings.maxApPerScan = parcel.readInt();
            batchedScanSettings.scanIntervalSec = parcel.readInt();
            batchedScanSettings.maxApForDistance = parcel.readInt();
            int n = parcel.readInt();
            if (n > 0) {
                batchedScanSettings.channelSet = new ArrayList<String>(n);
                int n2 = n;
                while (true) {
                    int n3 = n2 - 1;
                    if (n2 <= 0) break;
                    batchedScanSettings.channelSet.add(parcel.readString());
                    n2 = n3;
                }
            }
            return batchedScanSettings;
        }

        public BatchedScanSettings[] newArray(int n) {
            return new BatchedScanSettings[n];
        }
    };
    public static final int DEFAULT_AP_FOR_DISTANCE = 0;
    public static final int DEFAULT_AP_PER_SCAN = 16;
    public static final int DEFAULT_INTERVAL_SEC = 30;
    public static final int DEFAULT_SCANS_PER_BATCH = 20;
    public static final int MAX_AP_FOR_DISTANCE = 16;
    public static final int MAX_AP_PER_SCAN = 16;
    public static final int MAX_INTERVAL_SEC = 500;
    public static final int MAX_SCANS_PER_BATCH = 20;
    public static final int MAX_WIFI_CHANNEL = 196;
    public static final int MIN_AP_FOR_DISTANCE = 0;
    public static final int MIN_AP_PER_SCAN = 2;
    public static final int MIN_INTERVAL_SEC = 10;
    public static final int MIN_SCANS_PER_BATCH = 2;
    private static final String TAG = "BatchedScanSettings";
    public static final int UNSPECIFIED = Integer.MAX_VALUE;
    public Collection<String> channelSet;
    public int maxApForDistance;
    public int maxApPerScan;
    public int maxScansPerBatch;
    public int scanIntervalSec;

    public BatchedScanSettings() {
        this.clear();
    }

    public BatchedScanSettings(BatchedScanSettings batchedScanSettings) {
        this.maxScansPerBatch = batchedScanSettings.maxScansPerBatch;
        this.maxApPerScan = batchedScanSettings.maxApPerScan;
        if (batchedScanSettings.channelSet != null) {
            this.channelSet = new ArrayList<String>(batchedScanSettings.channelSet);
        }
        this.scanIntervalSec = batchedScanSettings.scanIntervalSec;
        this.maxApForDistance = batchedScanSettings.maxApForDistance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean channelSetIsValid() {
        if (this.channelSet == null) return true;
        if (this.channelSet.isEmpty()) {
            return true;
        }
        Iterator<String> iterator = this.channelSet.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            try {
                int n = Integer.parseInt(string2);
                if (n > 0 && n <= 196) continue;
            }
            catch (NumberFormatException numberFormatException) {}
            if (!string2.equals("A") && !string2.equals("B")) return false;
        }
        return true;
    }

    public void clear() {
        this.maxScansPerBatch = Integer.MAX_VALUE;
        this.maxApPerScan = Integer.MAX_VALUE;
        this.channelSet = null;
        this.scanIntervalSec = Integer.MAX_VALUE;
        this.maxApForDistance = Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void constrain() {
        if (this.scanIntervalSec == Integer.MAX_VALUE) {
            this.scanIntervalSec = 30;
        } else if (this.scanIntervalSec < 10) {
            this.scanIntervalSec = 10;
        } else if (this.scanIntervalSec > 500) {
            this.scanIntervalSec = 500;
        }
        if (this.maxScansPerBatch == Integer.MAX_VALUE) {
            this.maxScansPerBatch = 20;
        } else if (this.maxScansPerBatch < 2) {
            this.maxScansPerBatch = 2;
        } else if (this.maxScansPerBatch > 20) {
            this.maxScansPerBatch = 20;
        }
        if (this.maxApPerScan == Integer.MAX_VALUE) {
            this.maxApPerScan = 16;
        } else if (this.maxApPerScan < 2) {
            this.maxApPerScan = 2;
        } else if (this.maxApPerScan > 16) {
            this.maxApPerScan = 16;
        }
        if (this.maxApForDistance == Integer.MAX_VALUE) {
            this.maxApForDistance = 0;
            return;
        } else {
            if (this.maxApForDistance < 0) {
                this.maxApForDistance = 0;
                return;
            }
            if (this.maxApForDistance <= 16) return;
            this.maxApForDistance = 16;
            return;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (!(object instanceof BatchedScanSettings)) break block4;
                BatchedScanSettings batchedScanSettings = (BatchedScanSettings)object;
                if (this.maxScansPerBatch != batchedScanSettings.maxScansPerBatch || this.maxApPerScan != batchedScanSettings.maxApPerScan || this.scanIntervalSec != batchedScanSettings.scanIntervalSec || this.maxApForDistance != batchedScanSettings.maxApForDistance) break block4;
                if (this.channelSet != null) {
                    return this.channelSet.equals(batchedScanSettings.channelSet);
                }
                if (batchedScanSettings.channelSet == null) break block5;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.maxScansPerBatch + 3 * this.maxApPerScan + 5 * this.scanIntervalSec + 7 * this.maxApForDistance + 11 * this.channelSet.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isInvalid() {
        return this.maxScansPerBatch != Integer.MAX_VALUE && (this.maxScansPerBatch < 2 || this.maxScansPerBatch > 20) || this.maxApPerScan != Integer.MAX_VALUE && (this.maxApPerScan < 2 || this.maxApPerScan > 16) || !this.channelSetIsValid() || this.scanIntervalSec != Integer.MAX_VALUE && (this.scanIntervalSec < 10 || this.scanIntervalSec > 500) || this.maxApForDistance != Integer.MAX_VALUE && (this.maxApForDistance < 0 || this.maxApForDistance > 16);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = "<none>";
        StringBuffer stringBuffer2 = stringBuffer.append("BatchScanSettings [maxScansPerBatch: ");
        Object object2 = this.maxScansPerBatch == Integer.MAX_VALUE ? object : Integer.valueOf(this.maxScansPerBatch);
        StringBuffer stringBuffer3 = stringBuffer2.append(object2).append(", maxApPerScan: ");
        Object object3 = this.maxApPerScan == Integer.MAX_VALUE ? object : Integer.valueOf(this.maxApPerScan);
        StringBuffer stringBuffer4 = stringBuffer3.append(object3).append(", scanIntervalSec: ");
        Object object4 = this.scanIntervalSec == Integer.MAX_VALUE ? object : Integer.valueOf(this.scanIntervalSec);
        StringBuffer stringBuffer5 = stringBuffer4.append(object4).append(", maxApForDistance: ");
        if (this.maxApForDistance != Integer.MAX_VALUE) {
            object = this.maxApForDistance;
        }
        stringBuffer5.append(object).append(", channelSet: ");
        if (this.channelSet == null) {
            stringBuffer.append("ALL");
        } else {
            stringBuffer.append("<");
            for (String string2 : this.channelSet) {
                stringBuffer.append(" " + string2);
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.maxScansPerBatch);
        parcel.writeInt(this.maxApPerScan);
        parcel.writeInt(this.scanIntervalSec);
        parcel.writeInt(this.maxApForDistance);
        int n2 = this.channelSet == null ? 0 : this.channelSet.size();
        parcel.writeInt(n2);
        if (this.channelSet != null) {
            Iterator<String> iterator = this.channelSet.iterator();
            while (iterator.hasNext()) {
                parcel.writeString(iterator.next());
            }
        }
    }
}

