/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pWfdInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiP2pDevice
implements Parcelable {
    public static final int AVAILABLE = 3;
    public static final int CONNECTED = 0;
    public static final Parcelable.Creator<WifiP2pDevice> CREATOR;
    private static final int DEVICE_CAPAB_CLIENT_DISCOVERABILITY = 2;
    private static final int DEVICE_CAPAB_CONCURRENT_OPER = 4;
    private static final int DEVICE_CAPAB_DEVICE_LIMIT = 16;
    private static final int DEVICE_CAPAB_INFRA_MANAGED = 8;
    private static final int DEVICE_CAPAB_INVITATION_PROCEDURE = 32;
    private static final int DEVICE_CAPAB_SERVICE_DISCOVERY = 1;
    public static final int FAILED = 2;
    private static final int GROUP_CAPAB_CROSS_CONN = 16;
    private static final int GROUP_CAPAB_GROUP_FORMATION = 64;
    private static final int GROUP_CAPAB_GROUP_LIMIT = 4;
    private static final int GROUP_CAPAB_GROUP_OWNER = 1;
    private static final int GROUP_CAPAB_INTRA_BSS_DIST = 8;
    private static final int GROUP_CAPAB_PERSISTENT_GROUP = 2;
    private static final int GROUP_CAPAB_PERSISTENT_RECONN = 32;
    public static final int INVITED = 1;
    private static final String TAG = "WifiP2pDevice";
    public static final int UNAVAILABLE = 4;
    private static final int WPS_CONFIG_DISPLAY = 8;
    private static final int WPS_CONFIG_KEYPAD = 256;
    private static final int WPS_CONFIG_PUSHBUTTON = 128;
    private static final Pattern detailedDevicePattern;
    private static final Pattern threeTokenPattern;
    private static final Pattern twoTokenPattern;
    public String deviceAddress = "";
    public int deviceCapability;
    public String deviceName = "";
    public int groupCapability;
    public String interfaceAddress = "";
    public String primaryDeviceType;
    public String secondaryDeviceType;
    public int status = 4;
    public WifiP2pWfdInfo wfdInfo;
    public int wpsConfigMethodsSupported;

    static {
        detailedDevicePattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) (\\d+ )?p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) pri_dev_type=(\\d+-[0-9a-fA-F]+-\\d+) name='(.*)' config_methods=(0x[0-9a-fA-F]+) dev_capab=(0x[0-9a-fA-F]+) group_capab=(0x[0-9a-fA-F]+)( wfd_dev_info=0x([0-9a-fA-F]{12}))?");
        twoTokenPattern = Pattern.compile("(p2p_dev_addr=)?((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
        threeTokenPattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) p2p_dev_addr=((?:[0-9a-f]{2}:){5}[0-9a-f]{2})");
        CREATOR = new Parcelable.Creator<WifiP2pDevice>(){

            @Override
            public WifiP2pDevice createFromParcel(Parcel parcel) {
                WifiP2pDevice wifiP2pDevice = new WifiP2pDevice();
                wifiP2pDevice.deviceName = parcel.readString();
                wifiP2pDevice.deviceAddress = parcel.readString();
                wifiP2pDevice.interfaceAddress = parcel.readString();
                wifiP2pDevice.primaryDeviceType = parcel.readString();
                wifiP2pDevice.secondaryDeviceType = parcel.readString();
                wifiP2pDevice.wpsConfigMethodsSupported = parcel.readInt();
                wifiP2pDevice.deviceCapability = parcel.readInt();
                wifiP2pDevice.groupCapability = parcel.readInt();
                wifiP2pDevice.status = parcel.readInt();
                if (parcel.readInt() == 1) {
                    wifiP2pDevice.wfdInfo = WifiP2pWfdInfo.CREATOR.createFromParcel(parcel);
                }
                return wifiP2pDevice;
            }

            public WifiP2pDevice[] newArray(int n) {
                return new WifiP2pDevice[n];
            }
        };
    }

    public WifiP2pDevice() {
    }

    public WifiP2pDevice(WifiP2pDevice wifiP2pDevice) {
        if (wifiP2pDevice != null) {
            this.deviceName = wifiP2pDevice.deviceName;
            this.deviceAddress = wifiP2pDevice.deviceAddress;
            this.interfaceAddress = wifiP2pDevice.interfaceAddress;
            this.primaryDeviceType = wifiP2pDevice.primaryDeviceType;
            this.secondaryDeviceType = wifiP2pDevice.secondaryDeviceType;
            this.wpsConfigMethodsSupported = wifiP2pDevice.wpsConfigMethodsSupported;
            this.deviceCapability = wifiP2pDevice.deviceCapability;
            this.groupCapability = wifiP2pDevice.groupCapability;
            this.status = wifiP2pDevice.status;
            this.wfdInfo = new WifiP2pWfdInfo(wifiP2pDevice.wfdInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public WifiP2pDevice(String string2) throws IllegalArgumentException {
        Matcher matcher;
        String[] stringArray = string2.split("[ \n]");
        if (stringArray.length < 1) {
            throw new IllegalArgumentException("Malformed supplicant event");
        }
        switch (stringArray.length) {
            default: {
                matcher = detailedDevicePattern.matcher(string2);
                if (matcher.find()) break;
                throw new IllegalArgumentException("Malformed supplicant event");
            }
            case 1: {
                this.deviceAddress = string2;
                return;
            }
            case 2: {
                Matcher matcher2 = twoTokenPattern.matcher(string2);
                if (!matcher2.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = matcher2.group(2);
                return;
            }
            case 3: {
                Matcher matcher3 = threeTokenPattern.matcher(string2);
                if (!matcher3.find()) {
                    throw new IllegalArgumentException("Malformed supplicant event");
                }
                this.deviceAddress = matcher3.group(2);
                this.interfaceAddress = matcher3.group(1);
                return;
            }
        }
        this.interfaceAddress = matcher.group(1);
        this.deviceAddress = matcher.group(3);
        this.primaryDeviceType = matcher.group(4);
        this.deviceName = matcher.group(5);
        this.wpsConfigMethodsSupported = this.parseHex(matcher.group(6));
        this.deviceCapability = this.parseHex(matcher.group(7));
        this.groupCapability = this.parseHex(matcher.group(8));
        if (matcher.group(9) != null) {
            String string3 = matcher.group(10);
            this.wfdInfo = new WifiP2pWfdInfo(this.parseHex(string3.substring(0, 4)), this.parseHex(string3.substring(4, 8)), this.parseHex(string3.substring(8, 12)));
        }
        if (!stringArray[0].startsWith("P2P-DEVICE-FOUND")) return;
        this.status = 3;
    }

    private int parseHex(String string2) {
        if (string2.startsWith("0x") || string2.startsWith("0X")) {
            string2 = string2.substring(2);
        }
        try {
            int n = Integer.parseInt(string2, 16);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(TAG, "Failed to parse hex string " + string2);
            return 0;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block6: {
            block5: {
                if (this == object) break block5;
                if (!(object instanceof WifiP2pDevice)) {
                    return false;
                }
                WifiP2pDevice wifiP2pDevice = (WifiP2pDevice)object;
                if (wifiP2pDevice != null && wifiP2pDevice.deviceAddress != null) {
                    return wifiP2pDevice.deviceAddress.equals(this.deviceAddress);
                }
                if (this.deviceAddress != null) break block6;
            }
            return true;
        }
        return false;
    }

    public boolean isDeviceLimit() {
        return (0x10 & this.deviceCapability) != 0;
    }

    public boolean isGroupLimit() {
        return (4 & this.groupCapability) != 0;
    }

    public boolean isGroupOwner() {
        return (1 & this.groupCapability) != 0;
    }

    public boolean isInvitationCapable() {
        return (0x20 & this.deviceCapability) != 0;
    }

    public boolean isServiceDiscoveryCapable() {
        return (1 & this.deviceCapability) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Device: ").append(this.deviceName);
        stringBuffer.append("\n deviceAddress: ").append(this.deviceAddress);
        stringBuffer.append("\n interfaceAddress: ").append(this.interfaceAddress);
        stringBuffer.append("\n primary type: ").append(this.primaryDeviceType);
        stringBuffer.append("\n secondary type: ").append(this.secondaryDeviceType);
        stringBuffer.append("\n wps: ").append(this.wpsConfigMethodsSupported);
        stringBuffer.append("\n grpcapab: ").append(this.groupCapability);
        stringBuffer.append("\n devcapab: ").append(this.deviceCapability);
        stringBuffer.append("\n status: ").append(this.status);
        stringBuffer.append("\n wfdInfo: ").append(this.wfdInfo);
        return stringBuffer.toString();
    }

    public void update(WifiP2pDevice wifiP2pDevice) {
        this.updateSupplicantDetails(wifiP2pDevice);
        this.status = wifiP2pDevice.status;
    }

    public void updateSupplicantDetails(WifiP2pDevice wifiP2pDevice) {
        if (wifiP2pDevice == null) {
            throw new IllegalArgumentException("device is null");
        }
        if (wifiP2pDevice.deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress is null");
        }
        if (!this.deviceAddress.equals(wifiP2pDevice.deviceAddress)) {
            throw new IllegalArgumentException("deviceAddress does not match");
        }
        this.deviceName = wifiP2pDevice.deviceName;
        this.primaryDeviceType = wifiP2pDevice.primaryDeviceType;
        this.secondaryDeviceType = wifiP2pDevice.secondaryDeviceType;
        this.wpsConfigMethodsSupported = wifiP2pDevice.wpsConfigMethodsSupported;
        this.deviceCapability = wifiP2pDevice.deviceCapability;
        this.groupCapability = wifiP2pDevice.groupCapability;
        this.wfdInfo = wifiP2pDevice.wfdInfo;
    }

    public boolean wpsDisplaySupported() {
        return (8 & this.wpsConfigMethodsSupported) != 0;
    }

    public boolean wpsKeypadSupported() {
        return (0x100 & this.wpsConfigMethodsSupported) != 0;
    }

    public boolean wpsPbcSupported() {
        return (0x80 & this.wpsConfigMethodsSupported) != 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.deviceName);
        parcel.writeString(this.deviceAddress);
        parcel.writeString(this.interfaceAddress);
        parcel.writeString(this.primaryDeviceType);
        parcel.writeString(this.secondaryDeviceType);
        parcel.writeInt(this.wpsConfigMethodsSupported);
        parcel.writeInt(this.deviceCapability);
        parcel.writeInt(this.groupCapability);
        parcel.writeInt(this.status);
        if (this.wfdInfo != null) {
            parcel.writeInt(1);
            this.wfdInfo.writeToParcel(parcel, n);
            return;
        }
        parcel.writeInt(0);
    }
}

