/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class Ndef
extends BasicTagTechnology {
    public static final String EXTRA_NDEF_CARDSTATE = "ndefcardstate";
    public static final String EXTRA_NDEF_MAXLENGTH = "ndefmaxlength";
    public static final String EXTRA_NDEF_MSG = "ndefmsg";
    public static final String EXTRA_NDEF_TYPE = "ndeftype";
    public static final String ICODE_SLI = "com.nxp.ndef.icodesli";
    public static final String MIFARE_CLASSIC = "com.nxp.ndef.mifareclassic";
    public static final int NDEF_MODE_READ_ONLY = 1;
    public static final int NDEF_MODE_READ_WRITE = 2;
    public static final int NDEF_MODE_UNKNOWN = 3;
    public static final String NFC_FORUM_TYPE_1 = "org.nfcforum.ndef.type1";
    public static final String NFC_FORUM_TYPE_2 = "org.nfcforum.ndef.type2";
    public static final String NFC_FORUM_TYPE_3 = "org.nfcforum.ndef.type3";
    public static final String NFC_FORUM_TYPE_4 = "org.nfcforum.ndef.type4";
    private static final String TAG = "NFC";
    public static final int TYPE_1 = 1;
    public static final int TYPE_2 = 2;
    public static final int TYPE_3 = 3;
    public static final int TYPE_4 = 4;
    public static final int TYPE_ICODE_SLI = 102;
    public static final int TYPE_MIFARE_CLASSIC = 101;
    public static final int TYPE_OTHER = -1;
    public static final String UNKNOWN = "android.ndef.unknown";
    private final int mCardState;
    private final int mMaxNdefSize;
    private final NdefMessage mNdefMsg;
    private final int mNdefType;

    public Ndef(Tag tag) throws RemoteException {
        super(tag, 6);
        Bundle bundle = tag.getTechExtras(6);
        if (bundle != null) {
            this.mMaxNdefSize = bundle.getInt(EXTRA_NDEF_MAXLENGTH);
            this.mCardState = bundle.getInt(EXTRA_NDEF_CARDSTATE);
            this.mNdefMsg = (NdefMessage)bundle.getParcelable(EXTRA_NDEF_MSG);
            this.mNdefType = bundle.getInt(EXTRA_NDEF_TYPE);
            return;
        }
        throw new NullPointerException("NDEF tech extras are null.");
    }

    public static Ndef get(Tag tag) {
        if (!tag.hasTech(6)) {
            return null;
        }
        try {
            Ndef ndef = new Ndef(tag);
            return ndef;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean canMakeReadOnly() {
        INfcTag iNfcTag = this.mTag.getTagService();
        if (iNfcTag == null) {
            return false;
        }
        try {
            boolean bl = iNfcTag.canMakeReadOnly(this.mNdefType);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return false;
        }
    }

    public NdefMessage getCachedNdefMessage() {
        return this.mNdefMsg;
    }

    public int getMaxSize() {
        return this.mMaxNdefSize;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NdefMessage getNdefMessage() throws IOException, FormatException {
        INfcTag iNfcTag;
        this.checkConnected();
        try {
            iNfcTag = this.mTag.getTagService();
            if (iNfcTag == null) {
                throw new IOException("Mock tags don't support this operation.");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return null;
        }
        {
            int n = this.mTag.getServiceHandle();
            if (iNfcTag.isNdef(n)) {
                NdefMessage ndefMessage = iNfcTag.ndefRead(n);
                if (ndefMessage != null) return ndefMessage;
                if (iNfcTag.isPresent(n)) return ndefMessage;
                throw new TagLostException();
            }
            if (iNfcTag.isPresent(n)) return null;
            throw new TagLostException();
        }
    }

    public String getType() {
        switch (this.mNdefType) {
            default: {
                return UNKNOWN;
            }
            case 1: {
                return NFC_FORUM_TYPE_1;
            }
            case 2: {
                return NFC_FORUM_TYPE_2;
            }
            case 3: {
                return NFC_FORUM_TYPE_3;
            }
            case 4: {
                return NFC_FORUM_TYPE_4;
            }
            case 101: {
                return MIFARE_CLASSIC;
            }
            case 102: 
        }
        return ICODE_SLI;
    }

    public boolean isWritable() {
        return this.mCardState == 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeReadOnly() throws IOException {
        this.checkConnected();
        try {
            INfcTag iNfcTag = this.mTag.getTagService();
            if (iNfcTag == null) {
                return false;
            }
            if (!iNfcTag.isNdef(this.mTag.getServiceHandle())) throw new IOException("Tag is not ndef");
            switch (iNfcTag.ndefMakeReadOnly(this.mTag.getServiceHandle())) {
                default: {
                    throw new IOException();
                }
                case 0: {
                    return true;
                }
                case -1: {
                    throw new IOException();
                }
                case -8: 
            }
            return false;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeNdefMessage(NdefMessage ndefMessage) throws IOException, FormatException {
        INfcTag iNfcTag;
        this.checkConnected();
        try {
            iNfcTag = this.mTag.getTagService();
            if (iNfcTag == null) {
                throw new IOException("Mock tags don't support this operation.");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return;
        }
        {
            int n = this.mTag.getServiceHandle();
            if (!iNfcTag.isNdef(n)) throw new IOException("Tag is not ndef");
            switch (iNfcTag.ndefWrite(n, ndefMessage)) {
                case 0: {
                    return;
                }
                default: {
                    throw new IOException();
                }
                case -1: {
                    throw new IOException();
                }
                case -8: 
            }
            throw new FormatException();
        }
    }
}

