/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryProperty;
import android.os.IBatteryPropertiesRegistrar;
import android.os.RemoteException;
import android.os.ServiceManager;

public class BatteryManager {
    public static final int BATTERY_HEALTH_COLD = 7;
    public static final int BATTERY_HEALTH_DEAD = 4;
    public static final int BATTERY_HEALTH_GOOD = 2;
    public static final int BATTERY_HEALTH_OVERHEAT = 3;
    public static final int BATTERY_HEALTH_OVER_VOLTAGE = 5;
    public static final int BATTERY_HEALTH_UNKNOWN = 1;
    public static final int BATTERY_HEALTH_UNSPECIFIED_FAILURE = 6;
    public static final int BATTERY_PLUGGED_AC = 1;
    public static final int BATTERY_PLUGGED_ANY = 31;
    public static final int BATTERY_PLUGGED_DOCK = 8;
    public static final int BATTERY_PLUGGED_PAD = 16;
    public static final int BATTERY_PLUGGED_USB = 2;
    public static final int BATTERY_PLUGGED_WIRELESS = 4;
    public static final int BATTERY_PROPERTY_CAPACITY = 4;
    public static final int BATTERY_PROPERTY_CHARGE_COUNTER = 1;
    public static final int BATTERY_PROPERTY_CURRENT_AVERAGE = 3;
    public static final int BATTERY_PROPERTY_CURRENT_NOW = 2;
    public static final int BATTERY_PROPERTY_ENERGY_COUNTER = 5;
    public static final int BATTERY_STATUS_CHARGING = 2;
    public static final int BATTERY_STATUS_DISCHARGING = 3;
    public static final int BATTERY_STATUS_FULL = 5;
    public static final int BATTERY_STATUS_NOT_CHARGING = 4;
    public static final int BATTERY_STATUS_QUICK_CHARGING = 10;
    public static final int BATTERY_STATUS_UNKNOWN = 1;
    public static final String EXTRA_HEALTH = "health";
    public static final String EXTRA_ICON_SMALL = "icon-small";
    public static final String EXTRA_INVALID_CHARGER = "invalid_charger";
    public static final String EXTRA_LEVEL = "level";
    public static final String EXTRA_PEN_BATTERY_CAPACITY = "pen_battery_capacity";
    public static final String EXTRA_PEN_BATTERY_PRESENT = "pen_battery_present";
    public static final String EXTRA_PLUGGED = "plugged";
    public static final String EXTRA_PRESENT = "present";
    public static final String EXTRA_SCALE = "scale";
    public static final String EXTRA_STATUS = "status";
    public static final String EXTRA_TECHNOLOGY = "technology";
    public static final String EXTRA_TEMPERATURE = "temperature";
    public static final String EXTRA_VOLTAGE = "voltage";
    public static final int PEN_BATTERY_CAPACITY_HIGH = 3;
    public static final int PEN_BATTERY_CAPACITY_LOW = 1;
    public static final int PEN_BATTERY_CAPACITY_MIDDLE = 2;
    public static final int PEN_BATTERY_CAPACITY_UNKNOWN;
    private IBatteryPropertiesRegistrar mBatteryPropertiesRegistrar;

    private long queryProperty(int n) {
        if (this.mBatteryPropertiesRegistrar == null) {
            this.mBatteryPropertiesRegistrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getService("batteryproperties"));
            if (this.mBatteryPropertiesRegistrar == null) {
                return Long.MIN_VALUE;
            }
        }
        try {
            BatteryProperty batteryProperty = new BatteryProperty();
            if (this.mBatteryPropertiesRegistrar.getProperty(n, batteryProperty) == 0) {
                long l = batteryProperty.getLong();
                return l;
            }
            return Long.MIN_VALUE;
        }
        catch (RemoteException remoteException) {
            return Long.MIN_VALUE;
        }
    }

    public int getIntProperty(int n) {
        return (int)this.queryProperty(n);
    }

    public long getLongProperty(int n) {
        return this.queryProperty(n);
    }
}

