/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Memory;
import libcore.io.Streams;

public class FileBridge
extends Thread {
    private static final int CMD_CLOSE = 3;
    private static final int CMD_FSYNC = 2;
    private static final int CMD_WRITE = 1;
    private static final int MSG_LENGTH = 8;
    private static final String TAG = "FileBridge";
    private final FileDescriptor mClient;
    private volatile boolean mClosed;
    private final FileDescriptor mServer = new FileDescriptor();
    private FileDescriptor mTarget;

    public FileBridge() {
        this.mClient = new FileDescriptor();
        try {
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, this.mServer, this.mClient);
            return;
        }
        catch (ErrnoException errnoException) {
            throw new RuntimeException("Failed to create bridge");
        }
    }

    public void forceClose() {
        IoUtils.closeQuietly((FileDescriptor)this.mTarget);
        IoUtils.closeQuietly((FileDescriptor)this.mServer);
        IoUtils.closeQuietly((FileDescriptor)this.mClient);
        this.mClosed = true;
    }

    public FileDescriptor getClientSocket() {
        return this.mClient;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        var1_1 = new byte[8192];
        try {
            try {
                while (true) {
                    block12: {
                        block11: {
                            if (IoBridge.read((FileDescriptor)this.mServer, (byte[])var1_1, (int)0, (int)8) != 8) break block11;
                            var7_2 = Memory.peekInt((byte[])var1_1, (int)0, (ByteOrder)ByteOrder.BIG_ENDIAN);
                            if (var7_2 == 1) break block12;
                            if (var7_2 != 2) ** GOTO lbl13
                            Os.fsync(this.mTarget);
                            IoBridge.write((FileDescriptor)this.mServer, (byte[])var1_1, (int)0, (int)8);
                            continue;
lbl13:
                            // 1 sources

                            if (var7_2 != 3) continue;
                            Os.fsync(this.mTarget);
                            Os.close(this.mTarget);
                            this.mClosed = true;
                            IoBridge.write((FileDescriptor)this.mServer, (byte[])var1_1, (int)0, (int)8);
                        }
                        this.forceClose();
                        return;
                    }
                    var8_3 = Memory.peekInt((byte[])var1_1, (int)4, (ByteOrder)ByteOrder.BIG_ENDIAN);
                    while (true) {
                        if (var8_3 <= 0) ** break;
                        var9_4 = IoBridge.read((FileDescriptor)this.mServer, (byte[])var1_1, (int)0, (int)Math.min(var1_1.length, var8_3));
                        if (var9_4 == -1) {
                            throw new IOException("Unexpected EOF; still expected " + var8_3 + " bytes");
                        }
                        IoBridge.write((FileDescriptor)this.mTarget, (byte[])var1_1, (int)0, (int)var9_4);
                        var8_3 -= var9_4;
                    }
                    break;
                }
            }
            catch (ErrnoException var6_5) {
                var4_6 /* !! */  = var6_5;
lbl33:
                // 2 sources

                while (true) {
                    Log.wtf("FileBridge", "Failed during bridge", var4_6 /* !! */ );
                    this.forceClose();
                    return;
                }
            }
        }
        catch (Throwable var2_7) {}
        ** GOTO lbl-1000
        catch (IOException var3_8) {
            var4_6 /* !! */  = var3_8;
            ** continue;
        }
lbl-1000:
        // 1 sources

        {
            this.forceClose();
            throw var2_7;
        }
    }

    public void setTargetFile(FileDescriptor fileDescriptor) {
        this.mTarget = fileDescriptor;
    }

    public static class FileBridgeOutputStream
    extends OutputStream {
        private final FileDescriptor mClient;
        private final ParcelFileDescriptor mClientPfd;
        private final byte[] mTemp = new byte[8];

        public FileBridgeOutputStream(ParcelFileDescriptor parcelFileDescriptor) {
            this.mClientPfd = parcelFileDescriptor;
            this.mClient = parcelFileDescriptor.getFileDescriptor();
        }

        public FileBridgeOutputStream(FileDescriptor fileDescriptor) {
            this.mClientPfd = null;
            this.mClient = fileDescriptor;
        }

        private void writeCommandAndBlock(int n, String string2) throws IOException {
            Memory.pokeInt((byte[])this.mTemp, (int)0, (int)n, (ByteOrder)ByteOrder.BIG_ENDIAN);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8);
            if (IoBridge.read((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8) == 8 && Memory.peekInt((byte[])this.mTemp, (int)0, (ByteOrder)ByteOrder.BIG_ENDIAN) == n) {
                return;
            }
            throw new IOException("Failed to execute " + string2 + " across bridge");
        }

        @Override
        public void close() throws IOException {
            try {
                this.writeCommandAndBlock(3, "close()");
                return;
            }
            finally {
                IoBridge.closeAndSignalBlockedThreads((FileDescriptor)this.mClient);
                IoUtils.closeQuietly((AutoCloseable)this.mClientPfd);
            }
        }

        public void fsync() throws IOException {
            this.writeCommandAndBlock(2, "fsync()");
        }

        @Override
        public void write(int n) throws IOException {
            Streams.writeSingleByte((OutputStream)this, (int)n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Arrays.checkOffsetAndCount((int)byArray.length, (int)n, (int)n2);
            Memory.pokeInt((byte[])this.mTemp, (int)0, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN);
            Memory.pokeInt((byte[])this.mTemp, (int)4, (int)n2, (ByteOrder)ByteOrder.BIG_ENDIAN);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])this.mTemp, (int)0, (int)8);
            IoBridge.write((FileDescriptor)this.mClient, (byte[])byArray, (int)n, (int)n2);
        }
    }
}

