/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceInflater;
import android.preference.PreferenceScreen;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PreferenceManager {
    public static final String KEY_HAS_SET_DEFAULT_VALUES = "_has_set_default_values";
    public static final String METADATA_KEY_PREFERENCES = "android.preference";
    private static final String TAG = "PreferenceManager";
    private Activity mActivity;
    private List<OnActivityDestroyListener> mActivityDestroyListeners;
    private List<OnActivityResultListener> mActivityResultListeners;
    private List<OnActivityStopListener> mActivityStopListeners;
    private Context mContext;
    private SharedPreferences.Editor mEditor;
    private PreferenceFragment mFragment;
    private long mNextId = 0L;
    private int mNextRequestCode;
    private boolean mNoCommit;
    private OnPreferenceTreeClickListener mOnPreferenceTreeClickListener;
    private PreferenceScreen mPreferenceScreen;
    private List<DialogInterface> mPreferencesScreens;
    private SharedPreferences mSharedPreferences;
    private int mSharedPreferencesMode;
    private String mSharedPreferencesName;

    public PreferenceManager(Activity activity, int n) {
        this.mActivity = activity;
        this.mNextRequestCode = n;
        this.init(activity);
    }

    private PreferenceManager(Context context) {
        this.init(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dismissAllScreens() {
        ArrayList<DialogInterface> arrayList;
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            arrayList = new ArrayList<DialogInterface>(this.mPreferencesScreens);
            this.mPreferencesScreens.clear();
        }
        int n = -1 + arrayList.size();
        while (n >= 0) {
            arrayList.get(n).dismiss();
            --n;
        }
        return;
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        return context.getSharedPreferences(PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode());
    }

    private static int getDefaultSharedPreferencesMode() {
        return 0;
    }

    private static String getDefaultSharedPreferencesName(Context context) {
        return context.getPackageName() + "_preferences";
    }

    private void init(Context context) {
        this.mContext = context;
        this.setSharedPreferencesName(PreferenceManager.getDefaultSharedPreferencesName(context));
    }

    private List<ResolveInfo> queryIntentActivities(Intent intent) {
        return this.mContext.getPackageManager().queryIntentActivities(intent, 128);
    }

    public static void setDefaultValues(Context context, int n, boolean bl) {
        PreferenceManager.setDefaultValues(context, PreferenceManager.getDefaultSharedPreferencesName(context), PreferenceManager.getDefaultSharedPreferencesMode(), n, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setDefaultValues(Context context, String string2, int n, int n2, boolean bl) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(KEY_HAS_SET_DEFAULT_VALUES, 0);
        if (!bl && sharedPreferences.getBoolean(KEY_HAS_SET_DEFAULT_VALUES, false)) return;
        PreferenceManager preferenceManager = new PreferenceManager(context);
        preferenceManager.setSharedPreferencesName(string2);
        preferenceManager.setSharedPreferencesMode(n);
        preferenceManager.inflateFromResource(context, n2, null);
        SharedPreferences.Editor editor = sharedPreferences.edit().putBoolean(KEY_HAS_SET_DEFAULT_VALUES, true);
        try {
            editor.apply();
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            editor.commit();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNoCommit(boolean bl) {
        if (!bl && this.mEditor != null) {
            try {
                this.mEditor.apply();
            }
            catch (AbstractMethodError abstractMethodError) {
                this.mEditor.commit();
            }
        }
        this.mNoCommit = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addPreferencesScreen(DialogInterface dialogInterface) {
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                this.mPreferencesScreens = new ArrayList<DialogInterface>();
            }
            this.mPreferencesScreens.add(dialogInterface);
            return;
        }
    }

    public PreferenceScreen createPreferenceScreen(Context context) {
        PreferenceScreen preferenceScreen = new PreferenceScreen(context, null);
        preferenceScreen.onAttachedToHierarchy(this);
        return preferenceScreen;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void dispatchActivityDestroy() {
        // MONITORENTER : this
        List<OnActivityDestroyListener> list = this.mActivityDestroyListeners;
        ArrayList<OnActivityDestroyListener> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<OnActivityDestroyListener>(this.mActivityDestroyListeners);
        }
        // MONITOREXIT : this
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((OnActivityDestroyListener)arrayList.get(i)).onActivityDestroy();
            }
        }
        this.dismissAllScreens();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchActivityResult(int n, int n2, Intent intent) {
        ArrayList<OnActivityResultListener> arrayList;
        synchronized (this) {
            if (this.mActivityResultListeners == null) {
                return;
            }
            arrayList = new ArrayList<OnActivityResultListener>(this.mActivityResultListeners);
        }
        int n3 = arrayList.size();
        for (int i = 0; i < n3 && !((OnActivityResultListener)arrayList.get(i)).onActivityResult(n, n2, intent); ++i) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchActivityStop() {
        ArrayList<OnActivityStopListener> arrayList;
        synchronized (this) {
            if (this.mActivityStopListeners == null) {
                return;
            }
            arrayList = new ArrayList<OnActivityStopListener>(this.mActivityStopListeners);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ((OnActivityStopListener)arrayList.get(n2)).onActivityStop();
            ++n2;
        }
        return;
    }

    void dispatchNewIntent(Intent intent) {
        this.dismissAllScreens();
    }

    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceScreen == null) {
            return null;
        }
        return this.mPreferenceScreen.findPreference(charSequence);
    }

    Activity getActivity() {
        return this.mActivity;
    }

    Context getContext() {
        return this.mContext;
    }

    SharedPreferences.Editor getEditor() {
        if (this.mNoCommit) {
            if (this.mEditor == null) {
                this.mEditor = this.getSharedPreferences().edit();
            }
            return this.mEditor;
        }
        return this.getSharedPreferences().edit();
    }

    PreferenceFragment getFragment() {
        return this.mFragment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getNextId() {
        synchronized (this) {
            long l = this.mNextId;
            this.mNextId = 1L + l;
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getNextRequestCode() {
        synchronized (this) {
            int n = this.mNextRequestCode;
            this.mNextRequestCode = n + 1;
            return n;
        }
    }

    OnPreferenceTreeClickListener getOnPreferenceTreeClickListener() {
        return this.mOnPreferenceTreeClickListener;
    }

    PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceScreen;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = this.mContext.getSharedPreferences(this.mSharedPreferencesName, this.mSharedPreferencesMode);
        }
        return this.mSharedPreferences;
    }

    public int getSharedPreferencesMode() {
        return this.mSharedPreferencesMode;
    }

    public String getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PreferenceScreen inflateFromIntent(Intent intent, PreferenceScreen preferenceScreen) {
        List<ResolveInfo> list = this.queryIntentActivities(intent);
        HashSet<String> hashSet = new HashSet<String>();
        int n = -1 + list.size();
        while (true) {
            String string2;
            if (n < 0) {
                preferenceScreen.onAttachedToHierarchy(this);
                return preferenceScreen;
            }
            ActivityInfo activityInfo = list.get((int)n).activityInfo;
            Bundle bundle = activityInfo.metaData;
            if (bundle != null && bundle.containsKey(METADATA_KEY_PREFERENCES) && !hashSet.contains(string2 = activityInfo.packageName + ":" + activityInfo.metaData.getInt(METADATA_KEY_PREFERENCES))) {
                PreferenceInflater preferenceInflater;
                Context context;
                hashSet.add(string2);
                try {
                    context = this.mContext.createPackageContext(activityInfo.packageName, 0);
                    preferenceInflater = new PreferenceInflater(context, this);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w(TAG, "Could not create context for " + activityInfo.packageName + ": " + Log.getStackTraceString(nameNotFoundException));
                }
                XmlResourceParser xmlResourceParser = activityInfo.loadXmlMetaData(context.getPackageManager(), METADATA_KEY_PREFERENCES);
                preferenceScreen = (PreferenceScreen)preferenceInflater.inflate(xmlResourceParser, preferenceScreen, true);
                xmlResourceParser.close();
            }
            --n;
        }
    }

    public PreferenceScreen inflateFromResource(Context context, int n, PreferenceScreen preferenceScreen) {
        this.setNoCommit(true);
        PreferenceScreen preferenceScreen2 = (PreferenceScreen)new PreferenceInflater(context, this).inflate(n, preferenceScreen, true);
        preferenceScreen2.onAttachedToHierarchy(this);
        this.setNoCommit(false);
        return preferenceScreen2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void registerOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        synchronized (this) {
            if (this.mActivityDestroyListeners == null) {
                this.mActivityDestroyListeners = new ArrayList<OnActivityDestroyListener>();
            }
            if (!this.mActivityDestroyListeners.contains(onActivityDestroyListener)) {
                this.mActivityDestroyListeners.add(onActivityDestroyListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void registerOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        synchronized (this) {
            if (this.mActivityResultListeners == null) {
                this.mActivityResultListeners = new ArrayList<OnActivityResultListener>();
            }
            if (!this.mActivityResultListeners.contains(onActivityResultListener)) {
                this.mActivityResultListeners.add(onActivityResultListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        synchronized (this) {
            if (this.mActivityStopListeners == null) {
                this.mActivityStopListeners = new ArrayList<OnActivityStopListener>();
            }
            if (!this.mActivityStopListeners.contains(onActivityStopListener)) {
                this.mActivityStopListeners.add(onActivityStopListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removePreferencesScreen(DialogInterface dialogInterface) {
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            this.mPreferencesScreens.remove(dialogInterface);
            return;
        }
    }

    void setFragment(PreferenceFragment preferenceFragment) {
        this.mFragment = preferenceFragment;
    }

    void setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener onPreferenceTreeClickListener) {
        this.mOnPreferenceTreeClickListener = onPreferenceTreeClickListener;
    }

    boolean setPreferences(PreferenceScreen preferenceScreen) {
        if (preferenceScreen != this.mPreferenceScreen) {
            this.mPreferenceScreen = preferenceScreen;
            return true;
        }
        return false;
    }

    public void setSharedPreferencesMode(int n) {
        this.mSharedPreferencesMode = n;
        this.mSharedPreferences = null;
    }

    public void setSharedPreferencesName(String string2) {
        this.mSharedPreferencesName = string2;
        this.mSharedPreferences = null;
    }

    boolean shouldCommit() {
        return !this.mNoCommit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unregisterOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        synchronized (this) {
            if (this.mActivityDestroyListeners != null) {
                this.mActivityDestroyListeners.remove(onActivityDestroyListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unregisterOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        synchronized (this) {
            if (this.mActivityResultListeners != null) {
                this.mActivityResultListeners.remove(onActivityResultListener);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        synchronized (this) {
            if (this.mActivityStopListeners != null) {
                this.mActivityStopListeners.remove(onActivityStopListener);
            }
            return;
        }
    }

    public static interface OnActivityDestroyListener {
        public void onActivityDestroy();
    }

    public static interface OnActivityResultListener {
        public boolean onActivityResult(int var1, int var2, Intent var3);
    }

    public static interface OnActivityStopListener {
        public void onActivityStop();
    }

    public static interface OnPreferenceTreeClickListener {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }
}

