/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PrinterDiscoverySession {
    private static final String LOG_TAG = "PrinterDiscoverySession";
    private static int sIdCounter = 0;
    private final int mId;
    private boolean mIsDestroyed;
    private boolean mIsDiscoveryStarted;
    private ArrayMap<PrinterId, PrinterInfo> mLastSentPrinters;
    private IPrintServiceClient mObserver;
    private final ArrayMap<PrinterId, PrinterInfo> mPrinters = new ArrayMap();
    private final List<PrinterId> mTrackedPrinters = new ArrayList<PrinterId>();

    public PrinterDiscoverySession() {
        int n = sIdCounter;
        sIdCounter = n + 1;
        this.mId = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendOutOfDiscoveryPeriodPrinterChanges() {
        if (this.mLastSentPrinters == null || this.mLastSentPrinters.isEmpty()) {
            this.mLastSentPrinters = null;
            return;
        }
        ArrayList<PrinterInfo> arrayList = null;
        for (PrinterInfo printerInfo : this.mPrinters.values()) {
            PrinterInfo printerInfo2 = this.mLastSentPrinters.get(printerInfo.getId());
            if (printerInfo2 != null && printerInfo2.equals(printerInfo)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PrinterInfo>();
            }
            arrayList.add(printerInfo);
        }
        if (arrayList != null) {
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice(arrayList));
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error sending added printers", remoteException);
            }
        }
        ArrayList<PrinterId> arrayList2 = null;
        for (PrinterInfo printerInfo : this.mLastSentPrinters.values()) {
            if (this.mPrinters.containsKey(printerInfo.getId())) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<PrinterId>();
            }
            arrayList2.add(printerInfo.getId());
        }
        if (arrayList2 != null) {
            try {
                this.mObserver.onPrintersRemoved(new ParceledListSlice(arrayList2));
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error sending removed printers", remoteException);
            }
        }
        this.mLastSentPrinters = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addPrinters(List<PrinterInfo> list) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w(LOG_TAG, "Not adding printers - session destroyed.");
            return;
        } else if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterInfo> arrayList = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PrinterInfo printerInfo = list.get(i);
                PrinterInfo printerInfo2 = this.mPrinters.put(printerInfo.getId(), printerInfo);
                if (printerInfo2 != null && printerInfo2.equals(printerInfo)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<PrinterInfo>();
                }
                arrayList.add(printerInfo);
            }
            if (arrayList == null) return;
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice(arrayList));
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error sending added printers", remoteException);
                return;
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap(this.mPrinters);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PrinterInfo printerInfo = list.get(i);
                if (this.mPrinters.get(printerInfo.getId()) != null) continue;
                this.mPrinters.put(printerInfo.getId(), printerInfo);
            }
        }
    }

    void destroy() {
        if (!this.mIsDestroyed) {
            this.mIsDestroyed = true;
            this.mIsDiscoveryStarted = false;
            this.mPrinters.clear();
            this.mLastSentPrinters = null;
            this.mObserver = null;
            this.onDestroy();
        }
    }

    int getId() {
        return this.mId;
    }

    public final List<PrinterInfo> getPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterInfo>(this.mPrinters.values());
    }

    public final List<PrinterId> getTrackedPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterId>(this.mTrackedPrinters);
    }

    public final boolean isDestroyed() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDestroyed;
    }

    public final boolean isPrinterDiscoveryStarted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDiscoveryStarted;
    }

    public abstract void onDestroy();

    public abstract void onStartPrinterDiscovery(List<PrinterId> var1);

    public abstract void onStartPrinterStateTracking(PrinterId var1);

    public abstract void onStopPrinterDiscovery();

    public abstract void onStopPrinterStateTracking(PrinterId var1);

    public abstract void onValidatePrinters(List<PrinterId> var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removePrinters(List<PrinterId> list) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w(LOG_TAG, "Not removing printers - session destroyed.");
            return;
        } else if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterId> arrayList = new ArrayList<PrinterId>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PrinterId printerId = list.get(i);
                if (this.mPrinters.remove(printerId) == null) continue;
                arrayList.add(printerId);
            }
            if (arrayList.isEmpty()) return;
            try {
                this.mObserver.onPrintersRemoved(new ParceledListSlice(arrayList));
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error sending removed printers", remoteException);
                return;
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap(this.mPrinters);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                PrinterId printerId = list.get(i);
                this.mPrinters.remove(printerId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setObserver(IPrintServiceClient iPrintServiceClient) {
        this.mObserver = iPrintServiceClient;
        if (this.mPrinters.isEmpty()) return;
        try {
            this.mObserver.onPrintersAdded(new ParceledListSlice<PrinterInfo>(this.getPrinters()));
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error sending added printers", remoteException);
            return;
        }
    }

    void startPrinterDiscovery(List<PrinterId> list) {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = true;
            this.sendOutOfDiscoveryPeriodPrinterChanges();
            if (list == null) {
                list = Collections.emptyList();
            }
            this.onStartPrinterDiscovery(list);
        }
    }

    void startPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && !this.mTrackedPrinters.contains(printerId)) {
            this.mTrackedPrinters.add(printerId);
            this.onStartPrinterStateTracking(printerId);
        }
    }

    void stopPrinterDiscovery() {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = false;
            this.onStopPrinterDiscovery();
        }
    }

    void stopPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && this.mTrackedPrinters.remove(printerId)) {
            this.onStopPrinterStateTracking(printerId);
        }
    }

    void validatePrinters(List<PrinterId> list) {
        if (!this.mIsDestroyed && this.mObserver != null) {
            this.onValidatePrinters(list);
        }
    }
}

