/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.SystemProperties;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderScript {
    public static final int CREATE_FLAG_LOW_LATENCY = 2;
    public static final int CREATE_FLAG_LOW_POWER = 4;
    public static final int CREATE_FLAG_NONE = 0;
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    static final String LOG_TAG = "RenderScript_jni";
    static final long TRACE_TAG = 32768L;
    static File mCacheDir;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    static boolean sInitialized = false;
    static final long sMinorID = 1L;
    static int sPointerSize;
    static Object sRuntime;
    private Context mApplicationContext;
    long mContext;
    ContextType mContextType = ContextType.NORMAL;
    long mDev;
    Element mElement_ALLOCATION;
    Element mElement_A_8;
    Element mElement_BOOLEAN;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_ELEMENT;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_FONT;
    Element mElement_I16;
    Element mElement_I32;
    Element mElement_I64;
    Element mElement_I8;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_MATRIX_2X2;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_4X4;
    Element mElement_MESH;
    Element mElement_PROGRAM_FRAGMENT;
    Element mElement_PROGRAM_RASTER;
    Element mElement_PROGRAM_STORE;
    Element mElement_PROGRAM_VERTEX;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_8888;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_TYPE;
    Element mElement_U16;
    Element mElement_U32;
    Element mElement_U64;
    Element mElement_U8;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_YUV;
    RSErrorHandler mErrorCallback = null;
    RSMessageHandler mMessageCallback = null;
    MessageThread mMessageThread;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ReentrantReadWriteLock mRWLock;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        sInitialized = false;
        if (SystemProperties.getBoolean("config.disable_renderscript", false)) return;
        try {
            Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
            sRuntime = clazz.getDeclaredMethod("getRuntime", new Class[0]).invoke(null, new Object[0]);
            Class[] classArray = new Class[]{Integer.TYPE};
            registerNativeAllocation = clazz.getDeclaredMethod("registerNativeAllocation", classArray);
            Class[] classArray2 = new Class[]{Integer.TYPE};
            registerNativeFree = clazz.getDeclaredMethod("registerNativeFree", classArray2);
        }
        catch (Exception exception) {
            Log.e(LOG_TAG, "Error loading GC methods: " + exception);
            throw new RSRuntimeException("Error loading GC methods: " + exception);
        }
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
            sPointerSize = RenderScript.rsnSystemGetPointerSize();
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.e(LOG_TAG, "Error loading RS jni library: " + unsatisfiedLinkError);
            throw new RSRuntimeException("Error loading RS jni library: " + unsatisfiedLinkError);
        }
    }

    RenderScript(Context context) {
        if (context != null) {
            this.mApplicationContext = context.getApplicationContext();
        }
        this.mRWLock = new ReentrantReadWriteLock();
    }

    static native void _nInit();

    public static RenderScript create(Context context) {
        return RenderScript.create(context, ContextType.NORMAL);
    }

    public static RenderScript create(Context context, int n) {
        return RenderScript.create(context, n, ContextType.NORMAL, 0);
    }

    public static RenderScript create(Context context, int n, ContextType contextType, int n2) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.create() called when disabled; someone is likely to crash");
            return null;
        }
        if ((n2 & 0xFFFFFFF9) != 0) {
            throw new RSIllegalArgumentException("Invalid flags passed.");
        }
        RenderScript renderScript = new RenderScript(context);
        renderScript.mDev = renderScript.nDeviceCreate();
        renderScript.mContext = renderScript.nContextCreate(renderScript.mDev, n2, n, contextType.mID);
        renderScript.mContextType = contextType;
        if (renderScript.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        renderScript.mMessageThread = new MessageThread(renderScript);
        renderScript.mMessageThread.start();
        return renderScript;
    }

    public static RenderScript create(Context context, ContextType contextType) {
        return RenderScript.create(context, context.getApplicationInfo().targetSdkVersion, contextType, 0);
    }

    public static RenderScript create(Context context, ContextType contextType, int n) {
        return RenderScript.create(context, context.getApplicationInfo().targetSdkVersion, contextType, n);
    }

    public static long getMinorID() {
        return 1L;
    }

    static native int rsnSystemGetPointerSize();

    public static void setupDiskCache(File file) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.setupDiskCache() called when disabled");
            return;
        }
        mCacheDir = file;
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        this.validate();
        this.nContextFinish();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.nContextDestroy();
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0L;
    }

    public void finish() {
        this.nContextFinish();
    }

    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    boolean isAlive() {
        return this.mContext != 0L;
    }

    void nAllocationCopyFromBitmap(long l, Bitmap bitmap) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationCopyFromBitmap(this.mContext, l, bitmap);
            return;
        }
    }

    void nAllocationCopyToBitmap(long l, Bitmap bitmap) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationCopyToBitmap(this.mContext, l, bitmap);
            return;
        }
    }

    long nAllocationCreateBitmapBackedAllocation(long l, int n, Bitmap bitmap, int n2) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, l, n, bitmap, n2);
            return l2;
        }
    }

    long nAllocationCreateBitmapRef(long l, Bitmap bitmap) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnAllocationCreateBitmapRef(this.mContext, l, bitmap);
            return l2;
        }
    }

    long nAllocationCreateFromAssetStream(int n, int n2, int n3) {
        synchronized (this) {
            this.validate();
            long l = this.rsnAllocationCreateFromAssetStream(this.mContext, n, n2, n3);
            return l;
        }
    }

    long nAllocationCreateFromBitmap(long l, int n, Bitmap bitmap, int n2) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnAllocationCreateFromBitmap(this.mContext, l, n, bitmap, n2);
            return l2;
        }
    }

    long nAllocationCreateTyped(long l, int n, int n2, long l2) {
        synchronized (this) {
            this.validate();
            long l3 = this.rsnAllocationCreateTyped(this.mContext, l, n, n2, l2);
            return l3;
        }
    }

    long nAllocationCubeCreateFromBitmap(long l, int n, Bitmap bitmap, int n2) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnAllocationCubeCreateFromBitmap(this.mContext, l, n, bitmap, n2);
            return l2;
        }
    }

    void nAllocationData1D(long l, int n, int n2, int n3, Object object, int n4, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData1D(this.mContext, l, n, n2, n3, object, n4, dataType.mID);
            return;
        }
    }

    void nAllocationData2D(long l, int n, int n2, int n3, int n4, int n5, int n6, long l2, int n7, int n8, int n9, int n10) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData2D(this.mContext, l, n, n2, n3, n4, n5, n6, l2, n7, n8, n9, n10);
            return;
        }
    }

    void nAllocationData2D(long l, int n, int n2, int n3, int n4, int n5, int n6, Object object, int n7, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData2D(this.mContext, l, n, n2, n3, n4, n5, n6, object, n7, dataType.mID);
            return;
        }
    }

    void nAllocationData2D(long l, int n, int n2, int n3, int n4, Bitmap bitmap) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData2D(this.mContext, l, n, n2, n3, n4, bitmap);
            return;
        }
    }

    void nAllocationData3D(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, long l2, int n8, int n9, int n10, int n11) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData3D(this.mContext, l, n, n2, n3, n4, n5, n6, n7, l2, n8, n9, n10, n11);
            return;
        }
    }

    void nAllocationData3D(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object, int n8, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationData3D(this.mContext, l, n, n2, n3, n4, n5, n6, n7, object, n8, dataType.mID);
            return;
        }
    }

    void nAllocationElementData1D(long l, int n, int n2, int n3, byte[] byArray, int n4) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationElementData1D(this.mContext, l, n, n2, n3, byArray, n4);
            return;
        }
    }

    void nAllocationGenerateMipmaps(long l) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationGenerateMipmaps(this.mContext, l);
            return;
        }
    }

    Surface nAllocationGetSurface(long l) {
        synchronized (this) {
            this.validate();
            Surface surface = this.rsnAllocationGetSurface(this.mContext, l);
            return surface;
        }
    }

    long nAllocationGetType(long l) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnAllocationGetType(this.mContext, l);
            return l2;
        }
    }

    void nAllocationIoReceive(long l) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationIoReceive(this.mContext, l);
            return;
        }
    }

    void nAllocationIoSend(long l) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationIoSend(this.mContext, l);
            return;
        }
    }

    void nAllocationRead(long l, Object object, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationRead(this.mContext, l, object, dataType.mID);
            return;
        }
    }

    void nAllocationRead1D(long l, int n, int n2, int n3, Object object, int n4, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationRead1D(this.mContext, l, n, n2, n3, object, n4, dataType.mID);
            return;
        }
    }

    void nAllocationRead2D(long l, int n, int n2, int n3, int n4, int n5, int n6, Object object, int n7, Element.DataType dataType) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationRead2D(this.mContext, l, n, n2, n3, n4, n5, n6, object, n7, dataType.mID);
            return;
        }
    }

    void nAllocationResize1D(long l, int n) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationResize1D(this.mContext, l, n);
            return;
        }
    }

    void nAllocationSetSurface(long l, Surface surface) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationSetSurface(this.mContext, l, surface);
            return;
        }
    }

    void nAllocationSyncAll(long l, int n) {
        synchronized (this) {
            this.validate();
            this.rsnAllocationSyncAll(this.mContext, l, n);
            return;
        }
    }

    void nAssignName(long l, byte[] byArray) {
        synchronized (this) {
            this.validate();
            this.rsnAssignName(this.mContext, l, byArray);
            return;
        }
    }

    void nContextBindProgramFragment(long l) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindProgramFragment(this.mContext, l);
            return;
        }
    }

    void nContextBindProgramRaster(long l) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindProgramRaster(this.mContext, l);
            return;
        }
    }

    void nContextBindProgramStore(long l) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindProgramStore(this.mContext, l);
            return;
        }
    }

    void nContextBindProgramVertex(long l) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindProgramVertex(this.mContext, l);
            return;
        }
    }

    void nContextBindRootScript(long l) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindRootScript(this.mContext, l);
            return;
        }
    }

    void nContextBindSampler(int n, int n2) {
        synchronized (this) {
            this.validate();
            this.rsnContextBindSampler(this.mContext, n, n2);
            return;
        }
    }

    long nContextCreate(long l, int n, int n2, int n3) {
        synchronized (this) {
            long l2 = this.rsnContextCreate(l, n, n2, n3);
            return l2;
        }
    }

    long nContextCreateGL(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, float f, int n13) {
        synchronized (this) {
            long l2 = this.rsnContextCreateGL(l, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, f, n13);
            return l2;
        }
    }

    native void nContextDeinitToClient(long var1);

    void nContextDestroy() {
        synchronized (this) {
            this.validate();
            ReentrantReadWriteLock.WriteLock writeLock = this.mRWLock.writeLock();
            writeLock.lock();
            long l = this.mContext;
            this.mContext = 0L;
            writeLock.unlock();
            this.rsnContextDestroy(l);
            return;
        }
    }

    void nContextDump(int n) {
        synchronized (this) {
            this.validate();
            this.rsnContextDump(this.mContext, n);
            return;
        }
    }

    void nContextFinish() {
        synchronized (this) {
            this.validate();
            this.rsnContextFinish(this.mContext);
            return;
        }
    }

    native String nContextGetErrorMessage(long var1);

    native int nContextGetUserMessage(long var1, int[] var3);

    native void nContextInitToClient(long var1);

    void nContextPause() {
        synchronized (this) {
            this.validate();
            this.rsnContextPause(this.mContext);
            return;
        }
    }

    native int nContextPeekMessage(long var1, int[] var3);

    void nContextResume() {
        synchronized (this) {
            this.validate();
            this.rsnContextResume(this.mContext);
            return;
        }
    }

    void nContextSendMessage(int n, int[] nArray) {
        synchronized (this) {
            this.validate();
            this.rsnContextSendMessage(this.mContext, n, nArray);
            return;
        }
    }

    void nContextSetPriority(int n) {
        synchronized (this) {
            this.validate();
            this.rsnContextSetPriority(this.mContext, n);
            return;
        }
    }

    void nContextSetSurface(int n, int n2, Surface surface) {
        synchronized (this) {
            this.validate();
            this.rsnContextSetSurface(this.mContext, n, n2, surface);
            return;
        }
    }

    void nContextSetSurfaceTexture(int n, int n2, SurfaceTexture surfaceTexture) {
        synchronized (this) {
            this.validate();
            this.rsnContextSetSurfaceTexture(this.mContext, n, n2, surfaceTexture);
            return;
        }
    }

    native long nDeviceCreate();

    native void nDeviceDestroy(long var1);

    native void nDeviceSetConfig(long var1, int var3, int var4);

    long nElementCreate(long l, int n, boolean bl, int n2) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnElementCreate(this.mContext, l, n, bl, n2);
            return l2;
        }
    }

    long nElementCreate2(long[] lArray, String[] stringArray, int[] nArray) {
        synchronized (this) {
            this.validate();
            long l = this.rsnElementCreate2(this.mContext, lArray, stringArray, nArray);
            return l;
        }
    }

    void nElementGetNativeData(long l, int[] nArray) {
        synchronized (this) {
            this.validate();
            this.rsnElementGetNativeData(this.mContext, l, nArray);
            return;
        }
    }

    void nElementGetSubElements(long l, long[] lArray, String[] stringArray, int[] nArray) {
        synchronized (this) {
            this.validate();
            this.rsnElementGetSubElements(this.mContext, l, lArray, stringArray, nArray);
            return;
        }
    }

    long nFileA3DCreateFromAsset(AssetManager assetManager, String string2) {
        synchronized (this) {
            this.validate();
            long l = this.rsnFileA3DCreateFromAsset(this.mContext, assetManager, string2);
            return l;
        }
    }

    long nFileA3DCreateFromAssetStream(long l) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnFileA3DCreateFromAssetStream(this.mContext, l);
            return l2;
        }
    }

    long nFileA3DCreateFromFile(String string2) {
        synchronized (this) {
            this.validate();
            long l = this.rsnFileA3DCreateFromFile(this.mContext, string2);
            return l;
        }
    }

    long nFileA3DGetEntryByIndex(long l, int n) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnFileA3DGetEntryByIndex(this.mContext, l, n);
            return l2;
        }
    }

    void nFileA3DGetIndexEntries(long l, int n, int[] nArray, String[] stringArray) {
        synchronized (this) {
            this.validate();
            this.rsnFileA3DGetIndexEntries(this.mContext, l, n, nArray, stringArray);
            return;
        }
    }

    int nFileA3DGetNumIndexEntries(long l) {
        synchronized (this) {
            this.validate();
            int n = this.rsnFileA3DGetNumIndexEntries(this.mContext, l);
            return n;
        }
    }

    long nFontCreateFromAsset(AssetManager assetManager, String string2, float f, int n) {
        synchronized (this) {
            this.validate();
            long l = this.rsnFontCreateFromAsset(this.mContext, assetManager, string2, f, n);
            return l;
        }
    }

    long nFontCreateFromAssetStream(String string2, float f, int n, long l) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnFontCreateFromAssetStream(this.mContext, string2, f, n, l);
            return l2;
        }
    }

    long nFontCreateFromFile(String string2, float f, int n) {
        synchronized (this) {
            this.validate();
            long l = this.rsnFontCreateFromFile(this.mContext, string2, f, n);
            return l;
        }
    }

    String nGetName(long l) {
        synchronized (this) {
            this.validate();
            String string2 = this.rsnGetName(this.mContext, l);
            return string2;
        }
    }

    long nMeshCreate(long[] lArray, long[] lArray2, int[] nArray) {
        synchronized (this) {
            this.validate();
            long l = this.rsnMeshCreate(this.mContext, lArray, lArray2, nArray);
            return l;
        }
    }

    int nMeshGetIndexCount(long l) {
        synchronized (this) {
            this.validate();
            int n = this.rsnMeshGetIndexCount(this.mContext, l);
            return n;
        }
    }

    void nMeshGetIndices(long l, long[] lArray, int[] nArray, int n) {
        synchronized (this) {
            this.validate();
            this.rsnMeshGetIndices(this.mContext, l, lArray, nArray, n);
            return;
        }
    }

    int nMeshGetVertexBufferCount(long l) {
        synchronized (this) {
            this.validate();
            int n = this.rsnMeshGetVertexBufferCount(this.mContext, l);
            return n;
        }
    }

    void nMeshGetVertices(long l, long[] lArray, int n) {
        synchronized (this) {
            this.validate();
            this.rsnMeshGetVertices(this.mContext, l, lArray, n);
            return;
        }
    }

    void nObjDestroy(long l) {
        if (this.mContext != 0L) {
            this.rsnObjDestroy(this.mContext, l);
        }
    }

    long nPathCreate(int n, boolean bl, long l, long l2, float f) {
        synchronized (this) {
            this.validate();
            long l3 = this.rsnPathCreate(this.mContext, n, bl, l, l2, f);
            return l3;
        }
    }

    void nProgramBindConstants(long l, int n, long l2) {
        synchronized (this) {
            this.validate();
            this.rsnProgramBindConstants(this.mContext, l, n, l2);
            return;
        }
    }

    void nProgramBindSampler(long l, int n, long l2) {
        synchronized (this) {
            this.validate();
            this.rsnProgramBindSampler(this.mContext, l, n, l2);
            return;
        }
    }

    void nProgramBindTexture(long l, int n, long l2) {
        synchronized (this) {
            this.validate();
            this.rsnProgramBindTexture(this.mContext, l, n, l2);
            return;
        }
    }

    long nProgramFragmentCreate(String string2, String[] stringArray, long[] lArray) {
        synchronized (this) {
            this.validate();
            long l = this.rsnProgramFragmentCreate(this.mContext, string2, stringArray, lArray);
            return l;
        }
    }

    long nProgramRasterCreate(boolean bl, int n) {
        synchronized (this) {
            this.validate();
            long l = this.rsnProgramRasterCreate(this.mContext, bl, n);
            return l;
        }
    }

    long nProgramStoreCreate(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, int n2, int n3) {
        synchronized (this) {
            this.validate();
            long l = this.rsnProgramStoreCreate(this.mContext, bl, bl2, bl3, bl4, bl5, bl6, n, n2, n3);
            return l;
        }
    }

    long nProgramVertexCreate(String string2, String[] stringArray, long[] lArray) {
        synchronized (this) {
            this.validate();
            long l = this.rsnProgramVertexCreate(this.mContext, string2, stringArray, lArray);
            return l;
        }
    }

    long nSamplerCreate(int n, int n2, int n3, int n4, int n5, float f) {
        synchronized (this) {
            this.validate();
            long l = this.rsnSamplerCreate(this.mContext, n, n2, n3, n4, n5, f);
            return l;
        }
    }

    void nScriptBindAllocation(long l, long l2, int n) {
        synchronized (this) {
            this.validate();
            this.rsnScriptBindAllocation(this.mContext, l, l2, n);
            return;
        }
    }

    long nScriptCCreate(String string2, String string3, byte[] byArray, int n) {
        synchronized (this) {
            this.validate();
            long l = this.rsnScriptCCreate(this.mContext, string2, string3, byArray, n);
            return l;
        }
    }

    long nScriptFieldIDCreate(long l, int n) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnScriptFieldIDCreate(this.mContext, l, n);
            return l2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void nScriptForEach(long l, int n, long l2, long l3, byte[] byArray) {
        synchronized (this) {
            this.validate();
            if (byArray == null) {
                this.rsnScriptForEach(this.mContext, l, n, l2, l3);
            } else {
                this.rsnScriptForEach(this.mContext, l, n, l2, l3, byArray);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void nScriptForEachClipped(long l, int n, long l2, long l3, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        synchronized (this) {
            this.validate();
            if (byArray == null) {
                this.rsnScriptForEachClipped(this.mContext, l, n, l2, l3, n2, n3, n4, n5, n6, n7);
            } else {
                this.rsnScriptForEachClipped(this.mContext, l, n, l2, l3, byArray, n2, n3, n4, n5, n6, n7);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void nScriptForEachMultiClipped(long l, int n, long[] lArray, long l2, byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        synchronized (this) {
            this.validate();
            if (byArray == null) {
                this.rsnScriptForEachMultiClipped(this.mContext, l, n, lArray, l2, n2, n3, n4, n5, n6, n7);
            } else {
                this.rsnScriptForEachMultiClipped(this.mContext, l, n, lArray, l2, byArray, n2, n3, n4, n5, n6, n7);
            }
            return;
        }
    }

    double nScriptGetVarD(long l, int n) {
        synchronized (this) {
            this.validate();
            double d = this.rsnScriptGetVarD(this.mContext, l, n);
            return d;
        }
    }

    float nScriptGetVarF(long l, int n) {
        synchronized (this) {
            this.validate();
            float f = this.rsnScriptGetVarF(this.mContext, l, n);
            return f;
        }
    }

    int nScriptGetVarI(long l, int n) {
        synchronized (this) {
            this.validate();
            int n2 = this.rsnScriptGetVarI(this.mContext, l, n);
            return n2;
        }
    }

    long nScriptGetVarJ(long l, int n) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnScriptGetVarJ(this.mContext, l, n);
            return l2;
        }
    }

    void nScriptGetVarV(long l, int n, byte[] byArray) {
        synchronized (this) {
            this.validate();
            this.rsnScriptGetVarV(this.mContext, l, n, byArray);
            return;
        }
    }

    long nScriptGroupCreate(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        synchronized (this) {
            this.validate();
            long l = this.rsnScriptGroupCreate(this.mContext, lArray, lArray2, lArray3, lArray4, lArray5);
            return l;
        }
    }

    void nScriptGroupExecute(long l) {
        synchronized (this) {
            this.validate();
            this.rsnScriptGroupExecute(this.mContext, l);
            return;
        }
    }

    void nScriptGroupSetInput(long l, long l2, long l3) {
        synchronized (this) {
            this.validate();
            this.rsnScriptGroupSetInput(this.mContext, l, l2, l3);
            return;
        }
    }

    void nScriptGroupSetOutput(long l, long l2, long l3) {
        synchronized (this) {
            this.validate();
            this.rsnScriptGroupSetOutput(this.mContext, l, l2, l3);
            return;
        }
    }

    long nScriptIntrinsicCreate(int n, long l) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnScriptIntrinsicCreate(this.mContext, n, l);
            return l2;
        }
    }

    void nScriptInvoke(long l, int n) {
        synchronized (this) {
            this.validate();
            this.rsnScriptInvoke(this.mContext, l, n);
            return;
        }
    }

    void nScriptInvokeV(long l, int n, byte[] byArray) {
        synchronized (this) {
            this.validate();
            this.rsnScriptInvokeV(this.mContext, l, n, byArray);
            return;
        }
    }

    long nScriptKernelIDCreate(long l, int n, int n2) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnScriptKernelIDCreate(this.mContext, l, n, n2);
            return l2;
        }
    }

    void nScriptSetTimeZone(long l, byte[] byArray) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetTimeZone(this.mContext, l, byArray);
            return;
        }
    }

    void nScriptSetVarD(long l, int n, double d) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarD(this.mContext, l, n, d);
            return;
        }
    }

    void nScriptSetVarF(long l, int n, float f) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarF(this.mContext, l, n, f);
            return;
        }
    }

    void nScriptSetVarI(long l, int n, int n2) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarI(this.mContext, l, n, n2);
            return;
        }
    }

    void nScriptSetVarJ(long l, int n, long l2) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarJ(this.mContext, l, n, l2);
            return;
        }
    }

    void nScriptSetVarObj(long l, int n, long l2) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarObj(this.mContext, l, n, l2);
            return;
        }
    }

    void nScriptSetVarV(long l, int n, byte[] byArray) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarV(this.mContext, l, n, byArray);
            return;
        }
    }

    void nScriptSetVarVE(long l, int n, byte[] byArray, long l2, int[] nArray) {
        synchronized (this) {
            this.validate();
            this.rsnScriptSetVarVE(this.mContext, l, n, byArray, l2, nArray);
            return;
        }
    }

    long nTypeCreate(long l, int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        synchronized (this) {
            this.validate();
            long l2 = this.rsnTypeCreate(this.mContext, l, n, n2, n3, bl, bl2, n4);
            return l2;
        }
    }

    void nTypeGetNativeData(long l, long[] lArray) {
        synchronized (this) {
            this.validate();
            this.rsnTypeGetNativeData(this.mContext, l, lArray);
            return;
        }
    }

    native void rsnAllocationCopyFromBitmap(long var1, long var3, Bitmap var5);

    native void rsnAllocationCopyToBitmap(long var1, long var3, Bitmap var5);

    native long rsnAllocationCreateBitmapBackedAllocation(long var1, long var3, int var5, Bitmap var6, int var7);

    native long rsnAllocationCreateBitmapRef(long var1, long var3, Bitmap var5);

    native long rsnAllocationCreateFromAssetStream(long var1, int var3, int var4, int var5);

    native long rsnAllocationCreateFromBitmap(long var1, long var3, int var5, Bitmap var6, int var7);

    native long rsnAllocationCreateTyped(long var1, long var3, int var5, int var6, long var7);

    native long rsnAllocationCubeCreateFromBitmap(long var1, long var3, int var5, Bitmap var6, int var7);

    native void rsnAllocationData1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10);

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, int var14, int var15, int var16);

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13);

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, Bitmap var9);

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12, int var14, int var15, int var16, int var17);

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, int var13, int var14);

    native void rsnAllocationElementData1D(long var1, long var3, int var5, int var6, int var7, byte[] var8, int var9);

    native void rsnAllocationGenerateMipmaps(long var1, long var3);

    native Surface rsnAllocationGetSurface(long var1, long var3);

    native long rsnAllocationGetType(long var1, long var3);

    native void rsnAllocationIoReceive(long var1, long var3);

    native void rsnAllocationIoSend(long var1, long var3);

    native void rsnAllocationRead(long var1, long var3, Object var5, int var6);

    native void rsnAllocationRead1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10);

    native void rsnAllocationRead2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13);

    native void rsnAllocationResize1D(long var1, long var3, int var5);

    native void rsnAllocationSetSurface(long var1, long var3, Surface var5);

    native void rsnAllocationSyncAll(long var1, long var3, int var5);

    native void rsnAssignName(long var1, long var3, byte[] var5);

    native void rsnContextBindProgramFragment(long var1, long var3);

    native void rsnContextBindProgramRaster(long var1, long var3);

    native void rsnContextBindProgramStore(long var1, long var3);

    native void rsnContextBindProgramVertex(long var1, long var3);

    native void rsnContextBindRootScript(long var1, long var3);

    native void rsnContextBindSampler(long var1, int var3, int var4);

    native long rsnContextCreate(long var1, int var3, int var4, int var5);

    native long rsnContextCreateGL(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, float var15, int var16);

    native void rsnContextDestroy(long var1);

    native void rsnContextDump(long var1, int var3);

    native void rsnContextFinish(long var1);

    native void rsnContextPause(long var1);

    native void rsnContextResume(long var1);

    native void rsnContextSendMessage(long var1, int var3, int[] var4);

    native void rsnContextSetPriority(long var1, int var3);

    native void rsnContextSetSurface(long var1, int var3, int var4, Surface var5);

    native void rsnContextSetSurfaceTexture(long var1, int var3, int var4, SurfaceTexture var5);

    native long rsnElementCreate(long var1, long var3, int var5, boolean var6, int var7);

    native long rsnElementCreate2(long var1, long[] var3, String[] var4, int[] var5);

    native void rsnElementGetNativeData(long var1, long var3, int[] var5);

    native void rsnElementGetSubElements(long var1, long var3, long[] var5, String[] var6, int[] var7);

    native long rsnFileA3DCreateFromAsset(long var1, AssetManager var3, String var4);

    native long rsnFileA3DCreateFromAssetStream(long var1, long var3);

    native long rsnFileA3DCreateFromFile(long var1, String var3);

    native long rsnFileA3DGetEntryByIndex(long var1, long var3, int var5);

    native void rsnFileA3DGetIndexEntries(long var1, long var3, int var5, int[] var6, String[] var7);

    native int rsnFileA3DGetNumIndexEntries(long var1, long var3);

    native long rsnFontCreateFromAsset(long var1, AssetManager var3, String var4, float var5, int var6);

    native long rsnFontCreateFromAssetStream(long var1, String var3, float var4, int var5, long var6);

    native long rsnFontCreateFromFile(long var1, String var3, float var4, int var5);

    native String rsnGetName(long var1, long var3);

    native long rsnMeshCreate(long var1, long[] var3, long[] var4, int[] var5);

    native int rsnMeshGetIndexCount(long var1, long var3);

    native void rsnMeshGetIndices(long var1, long var3, long[] var5, int[] var6, int var7);

    native int rsnMeshGetVertexBufferCount(long var1, long var3);

    native void rsnMeshGetVertices(long var1, long var3, long[] var5, int var6);

    native void rsnObjDestroy(long var1, long var3);

    native long rsnPathCreate(long var1, int var3, boolean var4, long var5, long var7, float var9);

    native void rsnProgramBindConstants(long var1, long var3, int var5, long var6);

    native void rsnProgramBindSampler(long var1, long var3, int var5, long var6);

    native void rsnProgramBindTexture(long var1, long var3, int var5, long var6);

    native long rsnProgramFragmentCreate(long var1, String var3, String[] var4, long[] var5);

    native long rsnProgramRasterCreate(long var1, boolean var3, int var4);

    native long rsnProgramStoreCreate(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11);

    native long rsnProgramVertexCreate(long var1, String var3, String[] var4, long[] var5);

    native long rsnSamplerCreate(long var1, int var3, int var4, int var5, int var6, int var7, float var8);

    native void rsnScriptBindAllocation(long var1, long var3, long var5, int var7);

    native long rsnScriptCCreate(long var1, String var3, String var4, byte[] var5, int var6);

    native long rsnScriptFieldIDCreate(long var1, long var3, int var5);

    native void rsnScriptForEach(long var1, long var3, int var5, long var6, long var8);

    native void rsnScriptForEach(long var1, long var3, int var5, long var6, long var8, byte[] var10);

    native void rsnScriptForEachClipped(long var1, long var3, int var5, long var6, long var8, int var10, int var11, int var12, int var13, int var14, int var15);

    native void rsnScriptForEachClipped(long var1, long var3, int var5, long var6, long var8, byte[] var10, int var11, int var12, int var13, int var14, int var15, int var16);

    native void rsnScriptForEachMultiClipped(long var1, long var3, int var5, long[] var6, long var7, int var9, int var10, int var11, int var12, int var13, int var14);

    native void rsnScriptForEachMultiClipped(long var1, long var3, int var5, long[] var6, long var7, byte[] var9, int var10, int var11, int var12, int var13, int var14, int var15);

    native double rsnScriptGetVarD(long var1, long var3, int var5);

    native float rsnScriptGetVarF(long var1, long var3, int var5);

    native int rsnScriptGetVarI(long var1, long var3, int var5);

    native long rsnScriptGetVarJ(long var1, long var3, int var5);

    native void rsnScriptGetVarV(long var1, long var3, int var5, byte[] var6);

    native long rsnScriptGroupCreate(long var1, long[] var3, long[] var4, long[] var5, long[] var6, long[] var7);

    native void rsnScriptGroupExecute(long var1, long var3);

    native void rsnScriptGroupSetInput(long var1, long var3, long var5, long var7);

    native void rsnScriptGroupSetOutput(long var1, long var3, long var5, long var7);

    native long rsnScriptIntrinsicCreate(long var1, int var3, long var4);

    native void rsnScriptInvoke(long var1, long var3, int var5);

    native void rsnScriptInvokeV(long var1, long var3, int var5, byte[] var6);

    native long rsnScriptKernelIDCreate(long var1, long var3, int var5, int var6);

    native void rsnScriptSetTimeZone(long var1, long var3, byte[] var5);

    native void rsnScriptSetVarD(long var1, long var3, int var5, double var6);

    native void rsnScriptSetVarF(long var1, long var3, int var5, float var6);

    native void rsnScriptSetVarI(long var1, long var3, int var5, int var6);

    native void rsnScriptSetVarJ(long var1, long var3, int var5, long var6);

    native void rsnScriptSetVarObj(long var1, long var3, int var5, long var6);

    native void rsnScriptSetVarV(long var1, long var3, int var5, byte[] var6);

    native void rsnScriptSetVarVE(long var1, long var3, int var5, byte[] var6, long var7, int[] var9);

    native long rsnTypeCreate(long var1, long var3, int var5, int var6, int var7, boolean var8, boolean var9, int var10);

    native void rsnTypeGetNativeData(long var1, long var3, long[] var5);

    long safeID(BaseObj baseObj) {
        if (baseObj != null) {
            return baseObj.getID(this);
        }
        return 0L;
    }

    public void sendMessage(int n, int[] nArray) {
        this.nContextSendMessage(n, nArray);
    }

    public void setErrorHandler(RSErrorHandler rSErrorHandler) {
        this.mErrorCallback = rSErrorHandler;
    }

    public void setMessageHandler(RSMessageHandler rSMessageHandler) {
        this.mMessageCallback = rSMessageHandler;
    }

    public void setPriority(Priority priority) {
        this.validate();
        this.nContextSetPriority(priority.mID);
    }

    void validate() {
        if (this.mContext == 0L) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    void validateObject(BaseObj baseObj) {
        if (baseObj != null && baseObj.mRS != this) {
            throw new RSIllegalArgumentException("Attempting to use an object across contexts.");
        }
    }

    public static final class ContextType
    extends Enum<ContextType> {
        private static final /* synthetic */ ContextType[] $VALUES;
        public static final /* enum */ ContextType DEBUG;
        public static final /* enum */ ContextType NORMAL;
        public static final /* enum */ ContextType PROFILE;
        int mID;

        static {
            NORMAL = new ContextType(0);
            DEBUG = new ContextType(1);
            PROFILE = new ContextType(2);
            ContextType[] contextTypeArray = new ContextType[]{NORMAL, DEBUG, PROFILE};
            $VALUES = contextTypeArray;
        }

        private ContextType(int n2) {
            this.mID = n2;
        }

        public static ContextType valueOf(String string2) {
            return Enum.valueOf(ContextType.class, string2);
        }

        public static ContextType[] values() {
            return (ContextType[])$VALUES.clone();
        }
    }

    static class MessageThread
    extends Thread {
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_NEW_BUFFER = 5;
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        int[] mAuxData = new int[2];
        RenderScript mRS;
        boolean mRun = true;

        MessageThread(RenderScript renderScript) {
            super("RSMessageThread");
            this.mRS = renderScript;
        }

        @Override
        public void run() {
            int[] nArray = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                nArray[0] = 0;
                int n = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int n2 = this.mAuxData[1];
                int n3 = this.mAuxData[0];
                if (n == 4) {
                    if (n2 >> 2 >= nArray.length) {
                        nArray = new int[n2 + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, nArray) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = nArray;
                        this.mRS.mMessageCallback.mID = n3;
                        this.mRS.mMessageCallback.mLength = n2;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (n == 3) {
                    String string2 = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (n3 >= 4096 || n3 >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        throw new RSRuntimeException("Fatal error " + n3 + ", details: " + string2);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = string2;
                        this.mRS.mErrorCallback.mErrorNum = n3;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e(RenderScript.LOG_TAG, "non fatal RS error, " + string2);
                    continue;
                }
                if (n == 5) {
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, nArray) != 5) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    Allocation.sendBufferNotification(((long)nArray[1] << 32) + (0xFFFFFFFFL & (long)nArray[0]));
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static final class Priority
    extends Enum<Priority> {
        private static final /* synthetic */ Priority[] $VALUES;
        public static final /* enum */ Priority LOW = new Priority(15);
        public static final /* enum */ Priority NORMAL = new Priority(-4);
        int mID;

        static {
            Priority[] priorityArray = new Priority[]{LOW, NORMAL};
            $VALUES = priorityArray;
        }

        private Priority(int n2) {
            this.mID = n2;
        }

        public static Priority valueOf(String string2) {
            return Enum.valueOf(Priority.class, string2);
        }

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        @Override
        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        @Override
        public void run() {
        }
    }
}

