/*
 * Decompiled with CFR 0.152.
 */
package android.service.persistentdata;

import android.os.RemoteException;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Slog;

public class PersistentDataBlockManager {
    private static final String TAG = PersistentDataBlockManager.class.getSimpleName();
    private IPersistentDataBlockService sService;

    public PersistentDataBlockManager(IPersistentDataBlockService iPersistentDataBlockService) {
        this.sService = iPersistentDataBlockService;
    }

    private void onError(String string2) {
        Slog.v(TAG, "Remote exception while " + string2);
    }

    public int getDataBlockSize() {
        try {
            int n = this.sService.getDataBlockSize();
            return n;
        }
        catch (RemoteException remoteException) {
            this.onError("getting data block size");
            return -1;
        }
    }

    public long getMaximumDataBlockSize() {
        try {
            long l = this.sService.getMaximumDataBlockSize();
            return l;
        }
        catch (RemoteException remoteException) {
            this.onError("getting maximum data block size");
            return -1L;
        }
    }

    public boolean getOemUnlockEnabled() {
        try {
            boolean bl = this.sService.getOemUnlockEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            this.onError("getting OEM unlock enabled bit");
            return false;
        }
    }

    public byte[] read() {
        try {
            byte[] byArray = this.sService.read();
            return byArray;
        }
        catch (RemoteException remoteException) {
            this.onError("reading data");
            return null;
        }
    }

    public void setOemUnlockEnabled(boolean bl) {
        try {
            this.sService.setOemUnlockEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError("setting OEM unlock enabled to " + bl);
            return;
        }
    }

    public void wipe() {
        try {
            this.sService.wipe();
            return;
        }
        catch (RemoteException remoteException) {
            this.onError("wiping persistent partition");
            return;
        }
    }

    public int write(byte[] byArray) {
        try {
            int n = this.sService.write(byArray);
            return n;
        }
        catch (RemoteException remoteException) {
            this.onError("writing data");
            return -1;
        }
    }
}

