/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.telecom.DisconnectCause;
import android.telecom.GatewayInfo;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Call {
    public static final String AVAILABLE_PHONE_ACCOUNTS = "selectPhoneAccountAccounts";
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_CONNECTING = 9;
    public static final int STATE_DIALING = 1;
    public static final int STATE_DISCONNECTED = 7;
    public static final int STATE_DISCONNECTING = 10;
    public static final int STATE_HOLDING = 3;
    public static final int STATE_NEW = 0;
    public static final int STATE_PRE_DIAL_WAIT = 8;
    public static final int STATE_RINGING = 2;
    private List<String> mCannedTextResponses = null;
    private final List<Call> mChildren;
    private boolean mChildrenCached;
    private final List<String> mChildrenIds = new ArrayList<String>();
    private final List<Call> mConferenceableCalls;
    private Details mDetails;
    private final InCallAdapter mInCallAdapter;
    public boolean mIsActiveSub = false;
    private final List<Listener> mListeners;
    private int mNotificationCode;
    private int mNotificationType;
    private String mParentId = null;
    private final Phone mPhone;
    private String mRemainingPostDialSequence;
    private int mState;
    private final String mTelecomCallId;
    private final List<Call> mUnmodifiableChildren;
    private final List<Call> mUnmodifiableConferenceableCalls;
    private InCallService.VideoCall mVideoCall;

    Call(Phone phone, String string2, InCallAdapter inCallAdapter, boolean bl) {
        this.mChildren = new ArrayList<Call>();
        this.mUnmodifiableChildren = Collections.unmodifiableList(this.mChildren);
        this.mListeners = new CopyOnWriteArrayList<Listener>();
        this.mConferenceableCalls = new ArrayList<Call>();
        this.mUnmodifiableConferenceableCalls = Collections.unmodifiableList(this.mConferenceableCalls);
        this.mPhone = phone;
        this.mTelecomCallId = string2;
        this.mInCallAdapter = inCallAdapter;
        this.mState = 0;
        this.mIsActiveSub = bl;
    }

    private void fireCallDestroyed() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCallDestroyed(this);
        }
    }

    private void fireCannedTextResponsesLoaded(List<String> list) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCannedTextResponsesLoaded(this, list);
        }
    }

    private void fireChildrenChanged(List<Call> list) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onChildrenChanged(this, list);
        }
    }

    private void fireConferenceableCallsChanged() {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConferenceableCallsChanged(this, this.mUnmodifiableConferenceableCalls);
        }
    }

    private void fireDetailsChanged(Details details) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDetailsChanged(this, details);
        }
    }

    private void fireParentChanged(Call call) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onParentChanged(this, call);
        }
    }

    private void firePostDialWait(String string2) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onPostDialWait(this, string2);
        }
    }

    private void fireStateChanged(int n) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStateChanged(this, n);
        }
    }

    private void fireVideoCallChanged(InCallService.VideoCall videoCall) {
        Iterator<Listener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onVideoCallChanged(this, videoCall);
        }
    }

    private int stateFromParcelableCallState(int n) {
        switch (n) {
            default: {
                Object[] objectArray = new Object[]{n};
                Log.wtf((Object)this, "Unrecognized CallState %s", objectArray);
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 7;
            }
            case 9: 
        }
        return 10;
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void answer(int n) {
        this.mInCallAdapter.answerCall(this.mTelecomCallId, n);
    }

    public void conference(Call call) {
        if (call != null) {
            this.mInCallAdapter.conference(this.mTelecomCallId, call.mTelecomCallId);
        }
    }

    public void deflectCall(String string2) {
        this.mInCallAdapter.deflectCall(this.mTelecomCallId, string2);
    }

    public void disconnect() {
        this.mInCallAdapter.disconnectCall(this.mTelecomCallId);
    }

    public List<String> getCannedTextResponses() {
        return this.mCannedTextResponses;
    }

    public List<Call> getChildren() {
        if (!this.mChildrenCached) {
            this.mChildrenCached = true;
            this.mChildren.clear();
            for (String string2 : this.mChildrenIds) {
                Call call = this.mPhone.internalGetCallByTelecomId(string2);
                if (call == null) {
                    this.mChildrenCached = false;
                    continue;
                }
                this.mChildren.add(call);
            }
        }
        return this.mUnmodifiableChildren;
    }

    public List<Call> getConferenceableCalls() {
        return this.mUnmodifiableConferenceableCalls;
    }

    public Details getDetails() {
        return this.mDetails;
    }

    public int getNotificationCode() {
        return this.mNotificationCode;
    }

    public int getNotificationType() {
        return this.mNotificationType;
    }

    public Call getParent() {
        if (this.mParentId != null) {
            return this.mPhone.internalGetCallByTelecomId(this.mParentId);
        }
        return null;
    }

    public String getRemainingPostDialSequence() {
        return this.mRemainingPostDialSequence;
    }

    public int getState() {
        return this.mState;
    }

    public InCallService.VideoCall getVideoCall() {
        return this.mVideoCall;
    }

    public void hold() {
        this.mInCallAdapter.holdCall(this.mTelecomCallId);
    }

    final String internalGetCallId() {
        return this.mTelecomCallId;
    }

    final void internalSetDisconnected() {
        if (this.mState != 7) {
            this.mState = 7;
            this.fireStateChanged(this.mState);
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    final void internalSetPostDialWait(String string2) {
        this.mRemainingPostDialSequence = string2;
        this.firePostDialWait(this.mRemainingPostDialSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    final void internalUpdate(ParcelableCall parcelableCall, Map<String, Call> map) {
        boolean bl;
        String string2;
        boolean bl2;
        int n;
        boolean bl3;
        boolean bl4;
        Details details = new Details(parcelableCall.getHandle(), parcelableCall.getHandlePresentation(), parcelableCall.getCallerDisplayName(), parcelableCall.getCallerDisplayNamePresentation(), parcelableCall.getAccountHandle(), parcelableCall.getCapabilities(), parcelableCall.getProperties(), parcelableCall.getDisconnectCause(), parcelableCall.getConnectTimeMillis(), parcelableCall.getGatewayInfo(), parcelableCall.getVideoState(), parcelableCall.getStatusHints(), parcelableCall.getExtras(), parcelableCall.getCallSubstate());
        boolean bl5 = !Objects.equals(this.mDetails, details);
        if (bl5) {
            this.mDetails = details;
        }
        this.mNotificationType = parcelableCall.getNotificationType();
        this.mNotificationCode = parcelableCall.getNotificationCode();
        if (this.mCannedTextResponses == null && parcelableCall.getCannedSmsResponses() != null && !parcelableCall.getCannedSmsResponses().isEmpty()) {
            this.mCannedTextResponses = Collections.unmodifiableList(parcelableCall.getCannedSmsResponses());
        }
        if (bl4 = !Objects.equals(this.mVideoCall, parcelableCall.getVideoCall())) {
            this.mVideoCall = parcelableCall.getVideoCall();
        }
        if (bl3 = this.mState != (n = this.stateFromParcelableCallState(parcelableCall.getState())) || this.mIsActiveSub != parcelableCall.mIsActiveSub) {
            this.mState = n;
            this.mIsActiveSub = parcelableCall.mIsActiveSub;
        }
        if (bl2 = !Objects.equals(this.mParentId, string2 = parcelableCall.getParentCallId())) {
            this.mParentId = string2;
        }
        if (bl = !Objects.equals(parcelableCall.getChildCallIds(), this.mChildrenIds)) {
            this.mChildrenIds.clear();
            this.mChildrenIds.addAll(parcelableCall.getChildCallIds());
            this.mChildrenCached = false;
        }
        List<String> list = parcelableCall.getConferenceableCallIds();
        ArrayList<Call> arrayList = new ArrayList<Call>(list.size());
        for (String string3 : list) {
            if (!map.containsKey(string3)) continue;
            arrayList.add(map.get(string3));
        }
        if (!Objects.equals(this.mConferenceableCalls, arrayList)) {
            this.mConferenceableCalls.clear();
            this.mConferenceableCalls.addAll(arrayList);
            this.fireConferenceableCallsChanged();
        }
        if (bl3) {
            this.fireStateChanged(this.mState);
        }
        if (bl5) {
            this.fireDetailsChanged(this.mDetails);
        }
        if (bl4) {
            this.fireVideoCallChanged(this.mVideoCall);
        }
        if (bl2) {
            this.fireParentChanged(this.getParent());
        }
        if (bl) {
            this.fireChildrenChanged(this.getChildren());
        }
        if (this.mState == 7) {
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    public void mergeConference() {
        this.mInCallAdapter.mergeConference(this.mTelecomCallId);
    }

    public void phoneAccountSelected(PhoneAccountHandle phoneAccountHandle) {
        this.mInCallAdapter.phoneAccountSelected(this.mTelecomCallId, phoneAccountHandle);
    }

    public void playDtmfTone(char c) {
        this.mInCallAdapter.playDtmfTone(this.mTelecomCallId, c);
    }

    public void postDialContinue(boolean bl) {
        this.mInCallAdapter.postDialContinue(this.mTelecomCallId, bl);
    }

    public void reject(boolean bl, String string2) {
        this.mInCallAdapter.rejectCall(this.mTelecomCallId, bl, string2);
    }

    public void removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public void splitFromConference() {
        this.mInCallAdapter.splitFromConference(this.mTelecomCallId);
    }

    public void stopDtmfTone() {
        this.mInCallAdapter.stopDtmfTone(this.mTelecomCallId);
    }

    public void swapConference() {
        this.mInCallAdapter.swapConference(this.mTelecomCallId);
    }

    public void unhold() {
        this.mInCallAdapter.unholdCall(this.mTelecomCallId);
    }

    public static class Details {
        private final PhoneAccountHandle mAccountHandle;
        private final int mCallCapabilities;
        private final int mCallProperties;
        private final int mCallSubstate;
        private final String mCallerDisplayName;
        private final int mCallerDisplayNamePresentation;
        private final long mConnectTimeMillis;
        private final DisconnectCause mDisconnectCause;
        private final Bundle mExtras;
        private final GatewayInfo mGatewayInfo;
        private final Uri mHandle;
        private final int mHandlePresentation;
        private final StatusHints mStatusHints;
        private final int mVideoState;

        public Details(Uri uri, int n, String string2, int n2, PhoneAccountHandle phoneAccountHandle, int n3, int n4, DisconnectCause disconnectCause, long l, GatewayInfo gatewayInfo, int n5, StatusHints statusHints, Bundle bundle, int n6) {
            this.mHandle = uri;
            this.mHandlePresentation = n;
            this.mCallerDisplayName = string2;
            this.mCallerDisplayNamePresentation = n2;
            this.mAccountHandle = phoneAccountHandle;
            this.mCallCapabilities = n3;
            this.mCallProperties = n4;
            this.mDisconnectCause = disconnectCause;
            this.mConnectTimeMillis = l;
            this.mGatewayInfo = gatewayInfo;
            this.mVideoState = n5;
            this.mStatusHints = statusHints;
            this.mExtras = bundle;
            this.mCallSubstate = n6;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof Details;
            boolean bl2 = false;
            if (bl) {
                Details details = (Details)object;
                boolean bl3 = Objects.equals(this.mHandle, details.mHandle);
                bl2 = false;
                if (bl3) {
                    boolean bl4 = Objects.equals(this.mHandlePresentation, details.mHandlePresentation);
                    bl2 = false;
                    if (bl4) {
                        boolean bl5 = Objects.equals(this.mCallerDisplayName, details.mCallerDisplayName);
                        bl2 = false;
                        if (bl5) {
                            boolean bl6 = Objects.equals(this.mCallerDisplayNamePresentation, details.mCallerDisplayNamePresentation);
                            bl2 = false;
                            if (bl6) {
                                boolean bl7 = Objects.equals(this.mAccountHandle, details.mAccountHandle);
                                bl2 = false;
                                if (bl7) {
                                    boolean bl8 = Objects.equals(this.mCallCapabilities, details.mCallCapabilities);
                                    bl2 = false;
                                    if (bl8) {
                                        boolean bl9 = Objects.equals(this.mCallProperties, details.mCallProperties);
                                        bl2 = false;
                                        if (bl9) {
                                            boolean bl10 = Objects.equals(this.mDisconnectCause, details.mDisconnectCause);
                                            bl2 = false;
                                            if (bl10) {
                                                boolean bl11 = Objects.equals(this.mConnectTimeMillis, details.mConnectTimeMillis);
                                                bl2 = false;
                                                if (bl11) {
                                                    boolean bl12 = Objects.equals(this.mGatewayInfo, details.mGatewayInfo);
                                                    bl2 = false;
                                                    if (bl12) {
                                                        boolean bl13 = Objects.equals(this.mVideoState, details.mVideoState);
                                                        bl2 = false;
                                                        if (bl13) {
                                                            boolean bl14 = Objects.equals(this.mStatusHints, details.mStatusHints);
                                                            bl2 = false;
                                                            if (bl14) {
                                                                boolean bl15 = Objects.equals(this.mExtras, details.mExtras);
                                                                bl2 = false;
                                                                if (bl15) {
                                                                    boolean bl16 = Objects.equals(this.mCallSubstate, details.mCallSubstate);
                                                                    bl2 = false;
                                                                    if (bl16) {
                                                                        bl2 = true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bl2;
        }

        public PhoneAccountHandle getAccountHandle() {
            return this.mAccountHandle;
        }

        public int getCallCapabilities() {
            return this.mCallCapabilities;
        }

        public int getCallProperties() {
            return this.mCallProperties;
        }

        public int getCallSubstate() {
            return this.mCallSubstate;
        }

        public String getCallerDisplayName() {
            return this.mCallerDisplayName;
        }

        public int getCallerDisplayNamePresentation() {
            return this.mCallerDisplayNamePresentation;
        }

        public long getConnectTimeMillis() {
            return this.mConnectTimeMillis;
        }

        public DisconnectCause getDisconnectCause() {
            return this.mDisconnectCause;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public GatewayInfo getGatewayInfo() {
            return this.mGatewayInfo;
        }

        public Uri getHandle() {
            return this.mHandle;
        }

        public int getHandlePresentation() {
            return this.mHandlePresentation;
        }

        public StatusHints getStatusHints() {
            return this.mStatusHints;
        }

        public int getVideoState() {
            return this.mVideoState;
        }

        public int hashCode() {
            return Objects.hashCode(this.mHandle) + Objects.hashCode(this.mHandlePresentation) + Objects.hashCode(this.mCallerDisplayName) + Objects.hashCode(this.mCallerDisplayNamePresentation) + Objects.hashCode(this.mAccountHandle) + Objects.hashCode(this.mCallCapabilities) + Objects.hashCode(this.mCallProperties) + Objects.hashCode(this.mDisconnectCause) + Objects.hashCode(this.mConnectTimeMillis) + Objects.hashCode(this.mGatewayInfo) + Objects.hashCode(this.mVideoState) + Objects.hashCode(this.mStatusHints) + Objects.hashCode(this.mExtras) + Objects.hashCode(this.mCallSubstate);
        }
    }

    public static abstract class Listener {
        public void onCallDestroyed(Call call) {
        }

        public void onCannedTextResponsesLoaded(Call call, List<String> list) {
        }

        public void onChildrenChanged(Call call, List<Call> list) {
        }

        public void onConferenceableCallsChanged(Call call, List<Call> list) {
        }

        public void onDetailsChanged(Call call, Details details) {
        }

        public void onParentChanged(Call call, Call call2) {
        }

        public void onPostDialWait(Call call, String string2) {
        }

        public void onStateChanged(Call call, int n) {
        }

        public void onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
        }
    }
}

