/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.os.RemoteException;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionService;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionService;
import com.android.internal.telecom.IConnectionService;
import java.util.HashMap;
import java.util.Map;

public class RemoteConnectionManager {
    private final ConnectionService mOurConnectionServiceImpl;
    private final Map<ComponentName, RemoteConnectionService> mRemoteConnectionServices = new HashMap<ComponentName, RemoteConnectionService>();

    public RemoteConnectionManager(ConnectionService connectionService) {
        this.mOurConnectionServiceImpl = connectionService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addConnectionService(ComponentName componentName, IConnectionService iConnectionService) {
        if (this.mRemoteConnectionServices.containsKey(componentName)) return;
        try {
            RemoteConnectionService remoteConnectionService = new RemoteConnectionService(iConnectionService, this.mOurConnectionServiceImpl);
            this.mRemoteConnectionServices.put(componentName, remoteConnectionService);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void conferenceRemoteConnections(RemoteConnection remoteConnection, RemoteConnection remoteConnection2) {
        if (remoteConnection.getConnectionService() != remoteConnection2.getConnectionService()) {
            Object[] objectArray = new Object[]{remoteConnection.getConnectionService(), remoteConnection.getId(), remoteConnection2.getConnectionService(), remoteConnection2.getId()};
            Log.w(this, "Request to conference incompatible remote connections (%s,%s) (%s,%s)", objectArray);
            return;
        }
        try {
            remoteConnection.getConnectionService().conference(remoteConnection.getId(), remoteConnection2.getId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public RemoteConnection createRemoteConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest, boolean bl) {
        if (connectionRequest.getAccountHandle() == null) {
            throw new IllegalArgumentException("accountHandle must be specified.");
        }
        ComponentName componentName = connectionRequest.getAccountHandle().getComponentName();
        if (!this.mRemoteConnectionServices.containsKey(componentName)) {
            throw new UnsupportedOperationException("accountHandle not supported: " + componentName);
        }
        RemoteConnectionService remoteConnectionService = this.mRemoteConnectionServices.get(componentName);
        if (remoteConnectionService != null) {
            return remoteConnectionService.createRemoteConnection(phoneAccountHandle, connectionRequest, bl);
        }
        return null;
    }
}

