/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import java.util.MissingResourceException;
import java.util.Objects;

public final class StatusHints
implements Parcelable {
    public static final Parcelable.Creator<StatusHints> CREATOR = new Parcelable.Creator<StatusHints>(){

        @Override
        public StatusHints createFromParcel(Parcel parcel) {
            return new StatusHints(parcel);
        }

        public StatusHints[] newArray(int n) {
            return new StatusHints[n];
        }
    };
    private final Bundle mExtras;
    private final int mIconResId;
    private final CharSequence mLabel;
    private final ComponentName mPackageName;

    public StatusHints(ComponentName componentName, CharSequence charSequence, int n, Bundle bundle) {
        this.mPackageName = componentName;
        this.mLabel = charSequence;
        this.mIconResId = n;
        this.mExtras = bundle;
    }

    private StatusHints(Parcel parcel) {
        this.mPackageName = (ComponentName)parcel.readParcelable(this.getClass().getClassLoader());
        this.mLabel = parcel.readCharSequence();
        this.mIconResId = parcel.readInt();
        this.mExtras = (Bundle)parcel.readParcelable(this.getClass().getClassLoader());
    }

    private Drawable getIcon(Context context, int n) {
        Context context2;
        try {
            context2 = context.createPackageContext(this.mPackageName.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object[] objectArray = new Object[]{this.mPackageName.getPackageName()};
            Log.e(this, (Throwable)nameNotFoundException, "Cannot find package %s", objectArray);
            return null;
        }
        try {
            Drawable drawable2 = context2.getDrawable(n);
            return drawable2;
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{n, this.mPackageName.getPackageName()};
            Log.e(this, (Throwable)missingResourceException, "Cannot find icon %d in package %s", objectArray);
            return null;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null) {
            boolean bl2 = object instanceof StatusHints;
            bl = false;
            if (bl2) {
                StatusHints statusHints = (StatusHints)object;
                boolean bl3 = Objects.equals(statusHints.getPackageName(), this.getPackageName());
                bl = false;
                if (bl3) {
                    boolean bl4 = Objects.equals(statusHints.getLabel(), this.getLabel());
                    bl = false;
                    if (bl4) {
                        int n = statusHints.getIconResId();
                        int n2 = this.getIconResId();
                        bl = false;
                        if (n == n2) {
                            boolean bl5 = Objects.equals(statusHints.getExtras(), this.getExtras());
                            bl = false;
                            if (bl5) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public Drawable getIcon(Context context) {
        return this.getIcon(context, this.mIconResId);
    }

    public int getIconResId() {
        return this.mIconResId;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public ComponentName getPackageName() {
        return this.mPackageName;
    }

    public int hashCode() {
        return Objects.hashCode(this.mPackageName) + Objects.hashCode(this.mLabel) + this.mIconResId + Objects.hashCode(this.mExtras);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mPackageName, n);
        parcel.writeCharSequence(this.mLabel);
        parcel.writeInt(this.mIconResId);
        parcel.writeParcelable(this.mExtras, 0);
    }
}

