/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.Editable;
import android.text.Layout;
import android.text.PackedIntVector;
import android.text.PackedObjectVector;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.UpdateLayout;
import android.text.style.WrapTogetherSpan;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.ref.WeakReference;

public class DynamicLayout
extends Layout {
    private static final int BLOCK_MINIMUM_CHARACTER_LENGTH = 400;
    private static final int COLUMNS_ELLIPSIZE = 5;
    private static final int COLUMNS_NORMAL = 3;
    private static final int DESCENT = 2;
    private static final int DIR = 0;
    private static final int DIR_SHIFT = 30;
    private static final int ELLIPSIS_COUNT = 4;
    private static final int ELLIPSIS_START = 3;
    private static final int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;
    public static final int INVALID_BLOCK_INDEX = -1;
    private static final int PRIORITY = 128;
    private static final int START = 0;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int TAB = 0;
    private static final int TAB_MASK = 0x20000000;
    private static final int TOP = 1;
    private static final Object[] sLock;
    private static StaticLayout sStaticLayout;
    private CharSequence mBase;
    private int[] mBlockEndLines;
    private int[] mBlockIndices;
    private int mBottomPadding;
    private CharSequence mDisplay;
    private boolean mEllipsize;
    private TextUtils.TruncateAt mEllipsizeAt;
    private int mEllipsizedWidth;
    private boolean mIncludePad;
    private int mIndexFirstChangedBlock;
    private PackedIntVector mInts;
    private int mNumberOfBlocks;
    private PackedObjectVector<Layout.Directions> mObjects;
    private int mTopPadding;
    private ChangeWatcher mWatcher;

    static {
        sStaticLayout = new StaticLayout(null);
        sLock = new Object[0];
    }

    public DynamicLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, charSequence, textPaint, n, alignment, f, f2, bl);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, charSequence2, textPaint, n, alignment, f, f2, bl, null, 0);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        this(charSequence, charSequence2, textPaint, n, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2, bl, truncateAt, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        int[] nArray;
        CharSequence charSequence3 = truncateAt == null ? charSequence2 : (charSequence2 instanceof Spanned ? new Layout.SpannedEllipsizer(charSequence2) : new Layout.Ellipsizer(charSequence2));
        super(charSequence3, textPaint, n, alignment, textDirectionHeuristic, f, f2);
        this.mBase = charSequence;
        this.mDisplay = charSequence2;
        if (truncateAt != null) {
            this.mInts = new PackedIntVector(5);
            this.mEllipsizedWidth = n2;
            this.mEllipsizeAt = truncateAt;
        } else {
            this.mInts = new PackedIntVector(3);
            this.mEllipsizedWidth = n;
            this.mEllipsizeAt = null;
        }
        this.mObjects = new PackedObjectVector(1);
        this.mIncludePad = bl;
        if (truncateAt != null) {
            Layout.Ellipsizer ellipsizer = (Layout.Ellipsizer)this.getText();
            ellipsizer.mLayout = this;
            ellipsizer.mWidth = n2;
            ellipsizer.mMethod = truncateAt;
            this.mEllipsize = true;
        }
        if (truncateAt != null) {
            nArray = new int[5];
            nArray[3] = Integer.MIN_VALUE;
        } else {
            nArray = new int[3];
        }
        Layout.Directions[] directionsArray = new Layout.Directions[]{DIRS_ALL_LEFT_TO_RIGHT};
        Paint.FontMetricsInt fontMetricsInt = textPaint.getFontMetricsInt();
        int n3 = fontMetricsInt.ascent;
        int n4 = fontMetricsInt.descent;
        nArray[0] = 0x40000000;
        nArray[1] = 0;
        nArray[2] = n4;
        this.mInts.insertAt(0, nArray);
        nArray[1] = n4 - n3;
        this.mInts.insertAt(1, nArray);
        this.mObjects.insertAt(0, (Layout.Directions[])directionsArray);
        this.reflow(charSequence, 0, 0, charSequence.length());
        if (charSequence instanceof Spannable) {
            if (this.mWatcher == null) {
                this.mWatcher = new ChangeWatcher(this);
            }
            Spannable spannable = (Spannable)charSequence;
            ChangeWatcher[] changeWatcherArray = spannable.getSpans(0, spannable.length(), ChangeWatcher.class);
            for (int i = 0; i < changeWatcherArray.length; ++i) {
                spannable.removeSpan(changeWatcherArray[i]);
            }
            spannable.setSpan(this.mWatcher, 0, charSequence.length(), 8388626);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addBlockAtOffset(int n) {
        int n2 = this.getLineForOffset(n);
        if (this.mBlockEndLines == null) {
            this.mBlockEndLines = ArrayUtils.newUnpaddedIntArray(1);
            this.mBlockEndLines[this.mNumberOfBlocks] = n2;
            this.mNumberOfBlocks = 1 + this.mNumberOfBlocks;
            return;
        } else {
            if (n2 <= this.mBlockEndLines[-1 + this.mNumberOfBlocks]) return;
            this.mBlockEndLines = GrowingArrayUtils.append(this.mBlockEndLines, this.mNumberOfBlocks, n2);
            this.mNumberOfBlocks = 1 + this.mNumberOfBlocks;
            return;
        }
    }

    private void createBlocks() {
        int n = 400;
        this.mNumberOfBlocks = 0;
        CharSequence charSequence = this.mDisplay;
        while (true) {
            int n2;
            if ((n2 = TextUtils.indexOf(charSequence, '\n', n)) < 0) {
                this.addBlockAtOffset(charSequence.length());
                this.mBlockIndices = new int[this.mBlockEndLines.length];
                for (int i = 0; i < this.mBlockEndLines.length; ++i) {
                    this.mBlockIndices[i] = -1;
                }
                break;
            }
            this.addBlockAtOffset(n2);
            n = n2 + 400;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reflow(CharSequence charSequence, int n, int n2, int n3) {
        int[] nArray;
        if (charSequence != this.mBase) {
            return;
        }
        CharSequence charSequence2 = this.mDisplay;
        int n4 = charSequence2.length();
        int n5 = TextUtils.lastIndexOf(charSequence2, '\n', n - 1);
        int n6 = n5 < 0 ? 0 : n5 + 1;
        int n7 = n - n6;
        int n8 = n2 + n7;
        int n9 = n - n7;
        int n10 = n3 + n7;
        int n11 = TextUtils.indexOf(charSequence2, '\n', n9 + n10);
        int n12 = n11 < 0 ? n4 : n11 + 1;
        int n13 = n12 - (n9 + n10);
        int n14 = n8 + n13;
        int n15 = n10 + n13;
        if (charSequence2 instanceof Spanned) {
            boolean bl;
            Spanned spanned = (Spanned)charSequence2;
            do {
                int n16;
                bl = false;
                int n17 = n9 + n15;
                WrapTogetherSpan[] wrapTogetherSpanArray = spanned.getSpans(n9, n17, WrapTogetherSpan.class);
                for (int i = 0; i < (n16 = wrapTogetherSpanArray.length); ++i) {
                    int n18 = spanned.getSpanStart(wrapTogetherSpanArray[i]);
                    int n19 = spanned.getSpanEnd(wrapTogetherSpanArray[i]);
                    if (n18 < n9) {
                        bl = true;
                        int n20 = n9 - n18;
                        n14 += n20;
                        n15 += n20;
                        n9 -= n20;
                    }
                    if (n19 <= n9 + n15) continue;
                    bl = true;
                    int n21 = n19 - (n9 + n15);
                    n14 += n21;
                    n15 += n21;
                }
            } while (bl);
        }
        int n22 = this.getLineForOffset(n9);
        int n23 = this.getLineTop(n22);
        int n24 = this.getLineForOffset(n9 + n14);
        if (n9 + n15 == n4) {
            n24 = this.getLineCount();
        }
        int n25 = this.getLineTop(n24);
        int n26 = this.getLineCount();
        boolean bl = n24 == n26;
        Object[] objectArray = sLock;
        // MONITORENTER : objectArray
        StaticLayout staticLayout = sStaticLayout;
        sStaticLayout = null;
        // MONITOREXIT : objectArray
        if (staticLayout == null) {
            staticLayout = new StaticLayout(null);
        } else {
            staticLayout.prepare();
        }
        int n27 = n9 + n15;
        TextPaint textPaint = this.getPaint();
        int n28 = this.getWidth();
        TextDirectionHeuristic textDirectionHeuristic = this.getTextDirectionHeuristic();
        float f = this.getSpacingMultiplier();
        float f2 = this.getSpacingAdd();
        float f3 = this.mEllipsizedWidth;
        TextUtils.TruncateAt truncateAt = this.mEllipsizeAt;
        staticLayout.generate(charSequence2, n9, n27, textPaint, n28, textDirectionHeuristic, f, f2, false, true, f3, truncateAt);
        int n29 = staticLayout.getLineCount();
        if (n9 + n15 != n4 && staticLayout.getLineStart(n29 - 1) == n9 + n15) {
            --n29;
        }
        this.mInts.deleteAt(n22, n24 - n22);
        this.mObjects.deleteAt(n22, n24 - n22);
        int n30 = staticLayout.getLineTop(n29);
        boolean bl2 = this.mIncludePad;
        int n31 = 0;
        if (bl2) {
            n31 = 0;
            if (n22 == 0) {
                this.mTopPadding = n31 = staticLayout.getTopPadding();
                n30 -= n31;
            }
        }
        boolean bl3 = this.mIncludePad;
        int n32 = 0;
        if (bl3) {
            n32 = 0;
            if (bl) {
                this.mBottomPadding = n32 = staticLayout.getBottomPadding();
                n30 += n32;
            }
        }
        this.mInts.adjustValuesBelow(n22, 0, n15 - n14);
        this.mInts.adjustValuesBelow(n22, 1, n30 + (n23 - n25));
        if (this.mEllipsize) {
            nArray = new int[5];
            nArray[3] = Integer.MIN_VALUE;
        } else {
            nArray = new int[3];
        }
        Layout.Directions[] directionsArray = new Layout.Directions[1];
        int n33 = 0;
        while (true) {
            if (n33 >= n29) {
                this.updateBlocks(n22, n24 - 1, n29);
                Object[] objectArray2 = sLock;
                // MONITORENTER : objectArray2
                sStaticLayout = staticLayout;
                staticLayout.finish();
                // MONITOREXIT : objectArray2
                return;
            }
            int n34 = staticLayout.getLineStart(n33) | staticLayout.getParagraphDirection(n33) << 30;
            int n35 = staticLayout.getLineContainsTab(n33) ? 0x20000000 : 0;
            nArray[0] = n35 | n34;
            int n36 = n23 + staticLayout.getLineTop(n33);
            if (n33 > 0) {
                n36 -= n31;
            }
            nArray[1] = n36;
            int n37 = staticLayout.getLineDescent(n33);
            int n38 = n29 - 1;
            if (n33 == n38) {
                n37 += n32;
            }
            nArray[2] = n37;
            directionsArray[0] = staticLayout.getLineDirections(n33);
            if (this.mEllipsize) {
                nArray[3] = staticLayout.getEllipsisStart(n33);
                nArray[4] = staticLayout.getEllipsisCount(n33);
            }
            this.mInts.insertAt(n22 + n33, nArray);
            this.mObjects.insertAt(n22 + n33, (Layout.Directions[])directionsArray);
            ++n33;
        }
    }

    public int[] getBlockEndLines() {
        return this.mBlockEndLines;
    }

    public int[] getBlockIndices() {
        return this.mBlockIndices;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getEllipsisCount(int n) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(n, 4);
    }

    @Override
    public int getEllipsisStart(int n) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(n, 3);
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    public int getIndexFirstChangedBlock() {
        return this.mIndexFirstChangedBlock;
    }

    @Override
    public boolean getLineContainsTab(int n) {
        int n2 = 0x20000000 & this.mInts.getValue(n, 0);
        boolean bl = false;
        if (n2 != 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int getLineCount() {
        return -1 + this.mInts.size();
    }

    @Override
    public int getLineDescent(int n) {
        return this.mInts.getValue(n, 2);
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return this.mObjects.getValue(n, 0);
    }

    @Override
    public int getLineStart(int n) {
        return 0x1FFFFFFF & this.mInts.getValue(n, 0);
    }

    @Override
    public int getLineTop(int n) {
        return this.mInts.getValue(n, 1);
    }

    public int getNumberOfBlocks() {
        return this.mNumberOfBlocks;
    }

    @Override
    public int getParagraphDirection(int n) {
        return this.mInts.getValue(n, 0) >> 30;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    void setBlocksDataForTest(int[] nArray, int[] nArray2, int n) {
        this.mBlockEndLines = new int[nArray.length];
        this.mBlockIndices = new int[nArray2.length];
        System.arraycopy((int[])nArray, (int)0, (int[])this.mBlockEndLines, (int)0, (int)nArray.length);
        System.arraycopy((int[])nArray2, (int)0, (int[])this.mBlockIndices, (int)0, (int)nArray2.length);
        this.mNumberOfBlocks = n;
    }

    public void setIndexFirstChangedBlock(int n) {
        this.mIndexFirstChangedBlock = n;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    void updateBlocks(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n7;
        if (this.mBlockEndLines == null) {
            this.createBlocks();
            return;
        }
        int n8 = -1;
        int n9 = -1;
        int n10 = 0;
        while (true) {
            if (n10 >= this.mNumberOfBlocks) break;
            if (this.mBlockEndLines[n10] >= n) {
                n8 = n10;
                break;
            }
            ++n10;
        }
        int n11 = n8;
        while (true) {
            block18: {
                int n12;
                block17: {
                    if (n11 >= this.mNumberOfBlocks) break block17;
                    if (this.mBlockEndLines[n11] < n2) break block18;
                    n9 = n11;
                }
                n7 = this.mBlockEndLines[n9];
                int n13 = n8 == 0 ? 0 : 1 + this.mBlockEndLines[n8 - 1];
                bl3 = n > n13;
                bl2 = n3 > 0;
                bl = n2 < this.mBlockEndLines[n9];
                n6 = 0;
                if (bl3) {
                    n6 = 0 + 1;
                }
                if (bl2) {
                    ++n6;
                }
                if (bl) {
                    ++n6;
                }
                if ((n5 = n6 + this.mNumberOfBlocks - (n12 = 1 + (n9 - n8))) != 0) break;
                this.mBlockEndLines[0] = 0;
                this.mBlockIndices[0] = -1;
                this.mNumberOfBlocks = 1;
                return;
            }
            ++n11;
        }
        if (n5 > this.mBlockEndLines.length) {
            int[] nArray = ArrayUtils.newUnpaddedIntArray(Math.max(2 * this.mBlockEndLines.length, n5));
            int[] nArray2 = new int[nArray.length];
            System.arraycopy((int[])this.mBlockEndLines, (int)0, (int[])nArray, (int)0, (int)n8);
            System.arraycopy((int[])this.mBlockIndices, (int)0, (int[])nArray2, (int)0, (int)n8);
            System.arraycopy((int[])this.mBlockEndLines, (int)(n9 + 1), (int[])nArray, (int)(n8 + n6), (int)(-1 + (this.mNumberOfBlocks - n9)));
            System.arraycopy((int[])this.mBlockIndices, (int)(n9 + 1), (int[])nArray2, (int)(n8 + n6), (int)(-1 + (this.mNumberOfBlocks - n9)));
            this.mBlockEndLines = nArray;
            this.mBlockIndices = nArray2;
        } else {
            System.arraycopy((int[])this.mBlockEndLines, (int)(n9 + 1), (int[])this.mBlockEndLines, (int)(n8 + n6), (int)(-1 + (this.mNumberOfBlocks - n9)));
            System.arraycopy((int[])this.mBlockIndices, (int)(n9 + 1), (int[])this.mBlockIndices, (int)(n8 + n6), (int)(-1 + (this.mNumberOfBlocks - n9)));
        }
        this.mNumberOfBlocks = n5;
        int n14 = n3 - (1 + (n2 - n));
        if (n14 != 0) {
            for (int i = n4 = n8 + n6; i < this.mNumberOfBlocks; ++i) {
                int[] nArray = this.mBlockEndLines;
                nArray[i] = n14 + nArray[i];
            }
        } else {
            n4 = this.mNumberOfBlocks;
        }
        this.mIndexFirstChangedBlock = Math.min(this.mIndexFirstChangedBlock, n4);
        int n15 = n8;
        if (bl3) {
            this.mBlockEndLines[n15] = n - 1;
            this.mBlockIndices[n15] = -1;
            ++n15;
        }
        if (bl2) {
            this.mBlockEndLines[n15] = -1 + (n + n3);
            this.mBlockIndices[n15] = -1;
            ++n15;
        }
        if (!bl) return;
        this.mBlockEndLines[n15] = n7 + n14;
        this.mBlockIndices[n15] = -1;
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private WeakReference<DynamicLayout> mLayout;

        public ChangeWatcher(DynamicLayout dynamicLayout) {
            this.mLayout = new WeakReference<DynamicLayout>(dynamicLayout);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void reflow(CharSequence charSequence, int n, int n2, int n3) {
            DynamicLayout dynamicLayout = (DynamicLayout)this.mLayout.get();
            if (dynamicLayout != null) {
                dynamicLayout.reflow(charSequence, n, n2, n3);
                return;
            } else {
                if (!(charSequence instanceof Spannable)) return;
                ((Spannable)charSequence).removeSpan(this);
                return;
            }
        }

        @Override
        public void afterTextChanged(Editable editable) {
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            if (object instanceof UpdateLayout) {
                this.reflow(spannable, n, n2 - n, n2 - n);
            }
        }

        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            if (object instanceof UpdateLayout) {
                this.reflow(spannable, n, n2 - n, n2 - n);
                this.reflow(spannable, n3, n4 - n3, n4 - n3);
            }
        }

        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            if (object instanceof UpdateLayout) {
                this.reflow(spannable, n, n2 - n, n2 - n);
            }
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            this.reflow(charSequence, n, n2, n3);
        }
    }
}

