/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.res.Resources;
import java.nio.CharBuffer;
import java.util.Formatter;
import java.util.Locale;
import libcore.icu.LocaleData;
import libcore.util.ZoneInfo;

class TimeFormatter {
    private static final int DAYSPERLYEAR = 366;
    private static final int DAYSPERNYEAR = 365;
    private static final int DAYSPERWEEK = 7;
    private static final int FORCE_LOWER_CASE = -1;
    private static final int HOURSPERDAY = 24;
    private static final int MINSPERHOUR = 60;
    private static final int MONSPERYEAR = 12;
    private static final int SECSPERMIN = 60;
    private static String sDateOnlyFormat;
    private static String sDateTimeFormat;
    private static Locale sLocale;
    private static LocaleData sLocaleData;
    private static String sTimeOnlyFormat;
    private final String dateOnlyFormat;
    private final String dateTimeFormat;
    private final LocaleData localeData;
    private Formatter numberFormatter;
    private StringBuilder outputBuilder;
    private final String timeOnlyFormat;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeFormatter() {
        synchronized (TimeFormatter.class) {
            Locale locale = Locale.getDefault();
            if (sLocale == null || !locale.equals(sLocale)) {
                sLocale = locale;
                sLocaleData = LocaleData.get((Locale)locale);
                Resources resources = Resources.getSystem();
                sTimeOnlyFormat = resources.getString(17039449);
                sDateOnlyFormat = resources.getString(17039448);
                sDateTimeFormat = resources.getString(17039450);
            }
            this.dateTimeFormat = sDateTimeFormat;
            this.timeOnlyFormat = sTimeOnlyFormat;
            this.dateOnlyFormat = sDateOnlyFormat;
            this.localeData = sLocaleData;
            return;
        }
    }

    private static boolean brokenIsLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean brokenIsUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static char brokenToLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(97 + (c - 65));
        }
        return c;
    }

    private static char brokenToUpper(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(65 + (c - 97));
        }
        return c;
    }

    private void formatInternal(String string2, ZoneInfo.WallTime wallTime, ZoneInfo zoneInfo) {
        CharBuffer charBuffer = CharBuffer.wrap(string2);
        while (charBuffer.remaining() > 0) {
            boolean bl = true;
            if (charBuffer.get(charBuffer.position()) == '%') {
                bl = this.handleToken(charBuffer, wallTime, zoneInfo);
            }
            if (bl) {
                this.outputBuilder.append(charBuffer.get(charBuffer.position()));
            }
            charBuffer.position(1 + charBuffer.position());
        }
    }

    private static String getFormat(int n, String string2, String string3, String string4, String string5) {
        switch (n) {
            default: {
                string3 = string2;
            }
            case 95: {
                return string3;
            }
            case 45: {
                return string4;
            }
            case 48: 
        }
        return string5;
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleToken(CharBuffer var1_1, ZoneInfo.WallTime var2_2, ZoneInfo var3_3) {
        var4_4 = '\u0000';
        block43: while (var1_1.remaining() > 1) {
            var1_1.position(1 + var1_1.position());
            var6_5 = var1_1.get(var1_1.position());
            switch (var6_5) {
                case 'E': 
                case 'O': {
                    continue block43;
                }
                default: {
                    return true;
                }
                case 'A': {
                    if (var2_2.getWeekDay() < 0 || var2_2.getWeekDay() >= 7) {
                        var101_6 = "?";
lbl14:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var101_6, var4_4);
                            return false;
                        }
                    }
                    var101_6 = this.localeData.longWeekdayNames[1 + var2_2.getWeekDay()];
                    ** continue;
                }
                case 'a': {
                    if (var2_2.getWeekDay() < 0 || var2_2.getWeekDay() >= 7) {
                        var100_7 = "?";
lbl22:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var100_7, var4_4);
                            return false;
                        }
                    }
                    var100_7 = this.localeData.shortWeekdayNames[1 + var2_2.getWeekDay()];
                    ** continue;
                }
                case 'B': {
                    if (var4_4 == '-') {
                        if (var2_2.getMonth() < 0 || var2_2.getMonth() >= 12) {
                            var99_8 = "?";
lbl31:
                            // 2 sources

                            while (true) {
                                this.modifyAndAppend(var99_8, var4_4);
lbl33:
                                // 2 sources

                                return false;
                            }
                        }
                        var99_8 = this.localeData.longStandAloneMonthNames[var2_2.getMonth()];
                        ** continue;
                    }
                    if (var2_2.getMonth() < 0 || var2_2.getMonth() >= 12) {
                        var98_9 = "?";
lbl39:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var98_9, var4_4);
                            ** continue;
                            break;
                        }
                    }
                    var98_9 = this.localeData.longMonthNames[var2_2.getMonth()];
                    ** continue;
                }
                case 'b': 
                case 'h': {
                    if (var2_2.getMonth() < 0 || var2_2.getMonth() >= 12) {
                        var97_10 = "?";
lbl47:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var97_10, var4_4);
                            return false;
                        }
                    }
                    var97_10 = this.localeData.shortMonthNames[var2_2.getMonth()];
                    ** continue;
                }
                case 'C': {
                    this.outputYear(var2_2.getYear(), true, false, var4_4);
                    return false;
                }
                case 'c': {
                    this.formatInternal(this.dateTimeFormat, var2_2, var3_3);
                    return false;
                }
                case 'D': {
                    this.formatInternal("%m/%d/%y", var2_2, var3_3);
                    return false;
                }
                case 'd': {
                    var93_11 = this.numberFormatter;
                    var94_12 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var95_13 = new Object[]{var2_2.getMonthDay()};
                    var93_11.format(var94_12, var95_13);
                    return false;
                }
                case '#': 
                case '-': 
                case '0': 
                case '^': 
                case '_': {
                    var4_4 = var6_5;
                    continue block43;
                }
                case 'e': {
                    var89_14 = this.numberFormatter;
                    var90_15 = TimeFormatter.getFormat(var4_4, "%2d", "%2d", "%d", "%02d");
                    var91_16 = new Object[]{var2_2.getMonthDay()};
                    var89_14.format(var90_15, var91_16);
                    return false;
                }
                case 'F': {
                    this.formatInternal("%Y-%m-%d", var2_2, var3_3);
                    return false;
                }
                case 'H': {
                    var85_17 = this.numberFormatter;
                    var86_18 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var87_19 = new Object[]{var2_2.getHour()};
                    var85_17.format(var86_18, var87_19);
                    return false;
                }
                case 'I': {
                    if (var2_2.getHour() % 12 != 0) {
                        var80_20 = var2_2.getHour() % 12;
lbl91:
                        // 2 sources

                        while (true) {
                            var81_21 = this.numberFormatter;
                            var82_22 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                            var83_23 = new Object[]{var80_20};
                            var81_21.format(var82_22, var83_23);
                            return false;
                        }
                    }
                    var80_20 = 12;
                    ** continue;
                }
                case 'j': {
                    var75_24 = 1 + var2_2.getYearDay();
                    var76_25 = this.numberFormatter;
                    var77_26 = TimeFormatter.getFormat(var4_4, "%03d", "%3d", "%d", "%03d");
                    var78_27 = new Object[]{var75_24};
                    var76_25.format(var77_26, var78_27);
                    return false;
                }
                case 'k': {
                    var71_28 = this.numberFormatter;
                    var72_29 = TimeFormatter.getFormat(var4_4, "%2d", "%2d", "%d", "%02d");
                    var73_30 = new Object[]{var2_2.getHour()};
                    var71_28.format(var72_29, var73_30);
                    return false;
                }
                case 'l': {
                    if (var2_2.getHour() % 12 != 0) {
                        var66_31 = var2_2.getHour() % 12;
lbl118:
                        // 2 sources

                        while (true) {
                            var67_32 = this.numberFormatter;
                            var68_33 = TimeFormatter.getFormat(var4_4, "%2d", "%2d", "%d", "%02d");
                            var69_34 = new Object[]{var66_31};
                            var67_32.format(var68_33, var69_34);
                            return false;
                        }
                    }
                    var66_31 = 12;
                    ** continue;
                }
                case 'M': {
                    var62_35 = this.numberFormatter;
                    var63_36 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var64_37 = new Object[]{var2_2.getMinute()};
                    var62_35.format(var63_36, var64_37);
                    return false;
                }
                case 'm': {
                    var58_38 = this.numberFormatter;
                    var59_39 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var60_40 = new Object[]{1 + var2_2.getMonth()};
                    var58_38.format(var59_39, var60_40);
                    return false;
                }
                case 'n': {
                    this.outputBuilder.append('\n');
                    return false;
                }
                case 'p': {
                    if (var2_2.getHour() >= 12) {
                        var56_41 = this.localeData.amPm[1];
lbl148:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var56_41, var4_4);
                            return false;
                        }
                    }
                    var56_41 = this.localeData.amPm[0];
                    ** continue;
                }
                case 'P': {
                    if (var2_2.getHour() >= 12) {
                        var55_42 = this.localeData.amPm[1];
lbl156:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var55_42, -1);
                            return false;
                        }
                    }
                    var55_42 = this.localeData.amPm[0];
                    ** continue;
                }
                case 'R': {
                    this.formatInternal("%H:%M", var2_2, var3_3);
                    return false;
                }
                case 'r': {
                    this.formatInternal("%I:%M:%S %p", var2_2, var3_3);
                    return false;
                }
                case 'S': {
                    var51_43 = this.numberFormatter;
                    var52_44 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var53_45 = new Object[]{var2_2.getSecond()};
                    var51_43.format(var52_44, var53_45);
                    return false;
                }
                case 's': {
                    var49_46 = var2_2.mktime(var3_3);
                    this.outputBuilder.append(Integer.toString(var49_46));
                    return false;
                }
                case 'T': {
                    this.formatInternal("%H:%M:%S", var2_2, var3_3);
                    return false;
                }
                case 't': {
                    this.outputBuilder.append('\t');
                    return false;
                }
                case 'U': {
                    var44_47 = this.numberFormatter;
                    var45_48 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                    var46_49 = new Object[]{(7 + var2_2.getYearDay() - var2_2.getWeekDay()) / 7};
                    var44_47.format(var45_48, var46_49);
                    return false;
                }
                case 'u': {
                    if (var2_2.getWeekDay() == 0) {
                        var40_50 = 7;
lbl196:
                        // 2 sources

                        while (true) {
                            var41_51 = this.numberFormatter;
                            var42_52 = new Object[]{var40_50};
                            var41_51.format("%d", var42_52);
                            return false;
                        }
                    }
                    var40_50 = var2_2.getWeekDay();
                    ** continue;
                }
                case 'G': 
                case 'V': 
                case 'g': {
                    var27_53 = var2_2.getYear();
                    var28_54 = var2_2.getYearDay();
                    var29_55 = var2_2.getWeekDay();
                    block55: while (true) {
                        if (!TimeFormatter.isLeap(var27_53)) ** GOTO lbl228
                        var30_59 = 366;
lbl211:
                        // 2 sources

                        while (true) {
                            var31_60 = -3 + (var28_54 + 11 - var29_55) % 7;
                            var32_56 = var31_60 - var30_59 % 7;
                            if (var32_56 < -3) {
                                var32_56 += 7;
                            }
                            if (var28_54 < (var33_57 = var32_56 + var30_59)) ** GOTO lbl230
                            ++var27_53;
                            var35_61 = 1;
lbl219:
                            // 2 sources

                            while (var6_5 == 'V') {
                                var36_62 = this.numberFormatter;
                                var37_63 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                                var38_64 = new Object[]{var35_61};
                                var36_62.format(var37_63, var38_64);
lbl225:
                                // 3 sources

                                return false;
                            }
                            ** GOTO lbl240
                            break;
                        }
lbl228:
                        // 1 sources

                        var30_59 = 365;
                        ** continue;
lbl230:
                        // 1 sources

                        if (var28_54 < var31_60) ** GOTO lbl233
                        var35_61 = 1 + (var28_54 - var31_60) / 7;
                        ** GOTO lbl219
lbl233:
                        // 1 sources

                        if (!TimeFormatter.isLeap(--var27_53)) break;
                        var34_58 = 366;
lbl235:
                        // 2 sources

                        while (true) {
                            var28_54 += var34_58;
                            continue block55;
                            break;
                        }
                        break;
                    }
                    var34_58 = 365;
                    ** continue;
lbl240:
                    // 1 sources

                    if (var6_5 != 'g') ** GOTO lbl243
                    this.outputYear(var27_53, false, true, var4_4);
                    ** GOTO lbl225
lbl243:
                    // 1 sources

                    this.outputYear(var27_53, true, true, var4_4);
                    ** continue;
                }
                case 'v': {
                    this.formatInternal("%e-%b-%Y", var2_2, var3_3);
                    return false;
                }
                case 'W': {
                    var20_65 = 7 + var2_2.getYearDay();
                    if (var2_2.getWeekDay() != 0) {
                        var21_66 = -1 + var2_2.getWeekDay();
lbl252:
                        // 2 sources

                        while (true) {
                            var22_67 = (var20_65 - var21_66) / 7;
                            var23_68 = this.numberFormatter;
                            var24_69 = TimeFormatter.getFormat(var4_4, "%02d", "%2d", "%d", "%02d");
                            var25_70 = new Object[]{var22_67};
                            var23_68.format(var24_69, var25_70);
                            return false;
                        }
                    }
                    var21_66 = 6;
                    ** continue;
                }
                case 'w': {
                    var17_71 = this.numberFormatter;
                    var18_72 = new Object[]{var2_2.getWeekDay()};
                    var17_71.format("%d", var18_72);
                    return false;
                }
                case 'X': {
                    this.formatInternal(this.timeOnlyFormat, var2_2, var3_3);
                    return false;
                }
                case 'x': {
                    this.formatInternal(this.dateOnlyFormat, var2_2, var3_3);
                    return false;
                }
                case 'y': {
                    this.outputYear(var2_2.getYear(), false, true, var4_4);
                    return false;
                }
                case 'Y': {
                    this.outputYear(var2_2.getYear(), true, true, var4_4);
                    return false;
                }
                case 'Z': {
                    if (var2_2.getIsDst() < 0) {
                        return false;
                    }
                    if (var2_2.getIsDst() != 0) {
                        var16_73 = true;
lbl285:
                        // 2 sources

                        while (true) {
                            this.modifyAndAppend(var3_3.getDisplayName(var16_73, 0), var4_4);
                            return false;
                        }
                    }
                    var16_73 = false;
                    ** continue;
                }
                case 'z': {
                    if (var2_2.getIsDst() < 0) {
                        return false;
                    }
                    var7_74 = var2_2.getGmtOffset();
                    if (var7_74 < 0) {
                        var8_75 = '-';
                        var7_74 = -var7_74;
lbl297:
                        // 2 sources

                        while (true) {
                            this.outputBuilder.append(var8_75);
                            var10_76 = var7_74 / 60;
                            var11_77 = 100 * (var10_76 / 60) + var10_76 % 60;
                            var12_78 = this.numberFormatter;
                            var13_79 = TimeFormatter.getFormat(var4_4, "%04d", "%4d", "%d", "%04d");
                            var14_80 = new Object[]{var11_77};
                            var12_78.format(var13_79, var14_80);
                            return false;
                        }
                    }
                    var8_75 = '+';
                    ** continue;
                }
                case '+': 
            }
            this.formatInternal("%a %b %e %H:%M:%S %Z %Y", var2_2, var3_3);
            return false;
        }
        return true;
    }

    private static boolean isLeap(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private String localizeDigits(String string2) {
        int n = string2.length();
        int n2 = -48 + this.localeData.zeroDigit;
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= '0' && c <= '9') {
                c = (char)(c + n2);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void modifyAndAppend(CharSequence charSequence, int n) {
        switch (n) {
            default: {
                this.outputBuilder.append(charSequence);
                return;
            }
            case -1: {
                int n2 = 0;
                while (n2 < charSequence.length()) {
                    this.outputBuilder.append(TimeFormatter.brokenToLower(charSequence.charAt(n2)));
                    ++n2;
                }
                return;
            }
            case 94: {
                int n3 = 0;
                while (n3 < charSequence.length()) {
                    this.outputBuilder.append(TimeFormatter.brokenToUpper(charSequence.charAt(n3)));
                    ++n3;
                }
                return;
            }
            case 35: 
        }
        int n4 = 0;
        while (n4 < charSequence.length()) {
            char c = charSequence.charAt(n4);
            if (TimeFormatter.brokenIsUpper(c)) {
                c = TimeFormatter.brokenToLower(c);
            } else if (TimeFormatter.brokenIsLower(c)) {
                c = TimeFormatter.brokenToUpper(c);
            }
            this.outputBuilder.append(c);
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void outputYear(int n, boolean bl, boolean bl2, int n2) {
        int n3 = n % 100;
        int n4 = n / 100 + n3 / 100;
        int n5 = n3 % 100;
        if (n5 < 0 && n4 > 0) {
            n5 += 100;
            --n4;
        } else if (n4 < 0 && n5 > 0) {
            n5 -= 100;
            ++n4;
        }
        if (bl) {
            if (n4 == 0 && n5 < 0) {
                this.outputBuilder.append("-0");
            } else {
                Formatter formatter = this.numberFormatter;
                String string2 = TimeFormatter.getFormat(n2, "%02d", "%2d", "%d", "%02d");
                Object[] objectArray = new Object[]{n4};
                formatter.format(string2, objectArray);
            }
        }
        if (bl2) {
            int n6 = n5 < 0 ? -n5 : n5;
            Formatter formatter = this.numberFormatter;
            String string3 = TimeFormatter.getFormat(n2, "%02d", "%2d", "%d", "%02d");
            Object[] objectArray = new Object[]{n6};
            formatter.format(string3, objectArray);
        }
    }

    public String format(String string2, ZoneInfo.WallTime wallTime, ZoneInfo zoneInfo) {
        try {
            StringBuilder stringBuilder;
            this.outputBuilder = stringBuilder = new StringBuilder();
            this.numberFormatter = new Formatter(stringBuilder, Locale.US);
            this.formatInternal(string2, wallTime, zoneInfo);
            String string3 = stringBuilder.toString();
            if (this.localeData.zeroDigit != '0') {
                String string4;
                string3 = string4 = this.localizeDigits(string3);
            }
            this.outputBuilder = null;
            this.numberFormatter = null;
            return string3;
        }
        catch (Throwable throwable) {
            this.outputBuilder = null;
            this.numberFormatter = null;
            throw throwable;
        }
    }
}

