/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class BaseMovementMethod
implements MovementMethod {
    private int getBottomLine(TextView textView) {
        return textView.getLayout().getLineForVertical(textView.getScrollY() + this.getInnerHeight(textView));
    }

    private int getCharacterWidth(TextView textView) {
        return (int)Math.ceil(textView.getPaint().getFontSpacing());
    }

    private int getInnerHeight(TextView textView) {
        return textView.getHeight() - textView.getTotalPaddingTop() - textView.getTotalPaddingBottom();
    }

    private int getInnerWidth(TextView textView) {
        return textView.getWidth() - textView.getTotalPaddingLeft() - textView.getTotalPaddingRight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getScrollBoundsLeft(TextView textView) {
        int n;
        Layout layout2 = textView.getLayout();
        int n2 = this.getTopLine(textView);
        if (n2 > (n = this.getBottomLine(textView))) {
            return 0;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = n2;
        while (n4 <= n) {
            int n5 = (int)Math.floor(layout2.getLineLeft(n4));
            if (n5 < n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getScrollBoundsRight(TextView textView) {
        int n;
        Layout layout2 = textView.getLayout();
        int n2 = this.getTopLine(textView);
        if (n2 > (n = this.getBottomLine(textView))) {
            return 0;
        }
        int n3 = Integer.MIN_VALUE;
        int n4 = n2;
        while (n4 <= n) {
            int n5 = (int)Math.ceil(layout2.getLineRight(n4));
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    private int getTopLine(TextView textView) {
        return textView.getLayout().getLineForVertical(textView.getScrollY());
    }

    protected boolean bottom(TextView textView, Spannable spannable) {
        return false;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return false;
    }

    protected boolean down(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean end(TextView textView, Spannable spannable) {
        return false;
    }

    protected int getMovementMetaState(Spannable spannable, KeyEvent keyEvent) {
        return 0xFFFFFF3E & KeyEvent.normalizeMetaState(0xFFFFF9FF & MetaKeyKeyListener.getMetaState((CharSequence)spannable, keyEvent));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean handleMovementKey(TextView textView, Spannable spannable, int n, int n2, KeyEvent keyEvent) {
        switch (n) {
            case 21: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.left(textView, spannable);
                }
                if (KeyEvent.metaStateHasModifiers(n2, 4096)) {
                    return this.leftWord(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.lineStart(textView, spannable);
            }
            case 22: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.right(textView, spannable);
                }
                if (KeyEvent.metaStateHasModifiers(n2, 4096)) {
                    return this.rightWord(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.lineEnd(textView, spannable);
            }
            case 19: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.up(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.top(textView, spannable);
            }
            case 20: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.down(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.bottom(textView, spannable);
            }
            case 92: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.pageUp(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.top(textView, spannable);
            }
            case 93: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.pageDown(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 2)) return false;
                return this.bottom(textView, spannable);
            }
            case 122: {
                if (KeyEvent.metaStateHasNoModifiers(n2)) {
                    return this.home(textView, spannable);
                }
                if (!KeyEvent.metaStateHasModifiers(n2, 4096)) return false;
                return this.top(textView, spannable);
            }
            default: {
                return false;
            }
            case 123: 
        }
        if (KeyEvent.metaStateHasNoModifiers(n2)) {
            return this.end(textView, spannable);
        }
        if (!KeyEvent.metaStateHasModifiers(n2, 4096)) return false;
        return this.bottom(textView, spannable);
    }

    protected boolean home(TextView textView, Spannable spannable) {
        return false;
    }

    @Override
    public void initialize(TextView textView, Spannable spannable) {
    }

    protected boolean left(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean leftWord(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean lineEnd(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean lineStart(TextView textView, Spannable spannable) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGenericMotionEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        if ((2 & motionEvent.getSource()) == 0) return false;
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 8: {
                boolean bl;
                float f;
                float f2;
                if ((1 & motionEvent.getMetaState()) != 0) {
                    f2 = 0.0f;
                    f = motionEvent.getAxisValue(9);
                } else {
                    f2 = -motionEvent.getAxisValue(9);
                    f = motionEvent.getAxisValue(10);
                }
                if (f < 0.0f) {
                    bl = false | this.scrollLeft(textView, spannable, (int)Math.ceil(-f));
                } else {
                    float f3 = f - 0.0f;
                    float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
                    bl = false;
                    if (f4 > 0) {
                        bl = false | this.scrollRight(textView, spannable, (int)Math.ceil(f));
                    }
                }
                if (f2 < 0.0f) {
                    return bl | this.scrollUp(textView, spannable, (int)Math.ceil(-f2));
                }
                if (!(f2 > 0.0f)) return bl;
                return bl | this.scrollDown(textView, spannable, (int)Math.ceil(f2));
            }
        }
    }

    @Override
    public boolean onKeyDown(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        boolean bl = this.handleMovementKey(textView, spannable, n, this.getMovementMetaState(spannable, keyEvent), keyEvent);
        if (bl) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
            MetaKeyKeyListener.resetLockedMeta(spannable);
        }
        return bl;
    }

    @Override
    public boolean onKeyOther(TextView textView, Spannable spannable, KeyEvent keyEvent) {
        int n = this.getMovementMetaState(spannable, keyEvent);
        int n2 = keyEvent.getKeyCode();
        if (n2 != 0 && keyEvent.getAction() == 2) {
            int n3 = keyEvent.getRepeatCount();
            boolean bl = false;
            int n4 = 0;
            while (true) {
                if (n4 >= n3 || !this.handleMovementKey(textView, spannable, n2, n, keyEvent)) {
                    if (bl) {
                        MetaKeyKeyListener.adjustMetaAfterKeypress(spannable);
                        MetaKeyKeyListener.resetLockedMeta(spannable);
                    }
                    return bl;
                }
                bl = true;
                ++n4;
            }
        }
        return false;
    }

    @Override
    public boolean onKeyUp(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public void onTakeFocus(TextView textView, Spannable spannable, int n) {
    }

    @Override
    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        return false;
    }

    @Override
    public boolean onTrackballEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        return false;
    }

    protected boolean pageDown(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean pageUp(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean right(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean rightWord(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean scrollBottom(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n = layout2.getLineCount();
        if (this.getBottomLine(textView) <= n - 1) {
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(n) - this.getInnerHeight(textView));
            return true;
        }
        return false;
    }

    protected boolean scrollDown(TextView textView, Spannable spannable, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Layout layout2 = textView.getLayout();
        if (layout2.getLineTop((n5 = layout2.getLineForVertical(n4 = (n3 = this.getInnerHeight(textView)) + textView.getScrollY())) + 1) < n4 + 1) {
            ++n5;
        }
        if (n5 <= (n2 = -1 + layout2.getLineCount())) {
            int n6 = Math.min(-1 + (n5 + n), n2);
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(n6 + 1) - n3);
            return true;
        }
        return false;
    }

    protected boolean scrollLeft(TextView textView, Spannable spannable, int n) {
        int n2 = this.getScrollBoundsLeft(textView);
        int n3 = textView.getScrollX();
        if (n3 > n2) {
            textView.scrollTo(Math.max(n3 - n * this.getCharacterWidth(textView), n2), textView.getScrollY());
            return true;
        }
        return false;
    }

    protected boolean scrollLineEnd(TextView textView, Spannable spannable) {
        int n = this.getScrollBoundsRight(textView) - this.getInnerWidth(textView);
        if (textView.getScrollX() < n) {
            textView.scrollTo(n, textView.getScrollY());
            return true;
        }
        return false;
    }

    protected boolean scrollLineStart(TextView textView, Spannable spannable) {
        int n = this.getScrollBoundsLeft(textView);
        if (textView.getScrollX() > n) {
            textView.scrollTo(n, textView.getScrollY());
            return true;
        }
        return false;
    }

    protected boolean scrollPageDown(TextView textView, Spannable spannable) {
        int n;
        Layout layout2 = textView.getLayout();
        int n2 = layout2.getLineForVertical((n = this.getInnerHeight(textView)) + (n + textView.getScrollY()));
        if (n2 <= -1 + layout2.getLineCount()) {
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(n2 + 1) - n);
            return true;
        }
        return false;
    }

    protected boolean scrollPageUp(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n = layout2.getLineForVertical(textView.getScrollY() - this.getInnerHeight(textView));
        if (n >= 0) {
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(n));
            return true;
        }
        return false;
    }

    protected boolean scrollRight(TextView textView, Spannable spannable, int n) {
        int n2 = this.getScrollBoundsRight(textView) - this.getInnerWidth(textView);
        int n3 = textView.getScrollX();
        if (n3 < n2) {
            textView.scrollTo(Math.min(n3 + n * this.getCharacterWidth(textView), n2), textView.getScrollY());
            return true;
        }
        return false;
    }

    protected boolean scrollTop(TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n = this.getTopLine(textView);
        boolean bl = false;
        if (n >= 0) {
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(0));
            bl = true;
        }
        return bl;
    }

    protected boolean scrollUp(TextView textView, Spannable spannable, int n) {
        int n2;
        int n3;
        Layout layout2 = textView.getLayout();
        if (layout2.getLineTop(n3 = layout2.getLineForVertical(n2 = textView.getScrollY())) == n2) {
            --n3;
        }
        boolean bl = false;
        if (n3 >= 0) {
            int n4 = Math.max(1 + (n3 - n), 0);
            Touch.scrollTo(textView, layout2, textView.getScrollX(), layout2.getLineTop(n4));
            bl = true;
        }
        return bl;
    }

    protected boolean top(TextView textView, Spannable spannable) {
        return false;
    }

    protected boolean up(TextView textView, Spannable spannable) {
        return false;
    }
}

