/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Spannable;
import android.text.method.NumberKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;

public class DialerKeyListener
extends NumberKeyListener {
    public static final char[] CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '#', '*', '+', '-', '(', ')', ',', '/', 'N', '.', ' ', ';'};
    private static DialerKeyListener sInstance;

    public static DialerKeyListener getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new DialerKeyListener();
        return sInstance;
    }

    @Override
    protected char[] getAcceptedChars() {
        return CHARACTERS;
    }

    @Override
    public int getInputType() {
        return 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int lookup(KeyEvent keyEvent, Spannable spannable) {
        int n = DialerKeyListener.getMetaState((CharSequence)spannable, keyEvent);
        char c = keyEvent.getNumber();
        if ((n & 3) != 0 || c == '\u0000') {
            int n2 = super.lookup(keyEvent, spannable);
            if (n2 != 0) {
                return n2;
            }
            if (n != 0) {
                KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
                char[] cArray = this.getAcceptedChars();
                if (keyEvent.getKeyData(keyData)) {
                    for (int i = 1; i < keyData.meta.length; ++i) {
                        if (!DialerKeyListener.ok(cArray, keyData.meta[i])) continue;
                        return keyData.meta[i];
                    }
                }
            }
        }
        return c;
    }
}

