/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.view.KeyEvent;
import android.view.View;

public abstract class MetaKeyKeyListener {
    private static final Object ALT;
    private static final Object CAP;
    private static final int LOCKED = 0x4000011;
    private static final int LOCKED_RETURN_VALUE = 2;
    public static final int META_ALT_LOCKED = 512;
    private static final long META_ALT_MASK = 0x2020200000202L;
    public static final int META_ALT_ON = 2;
    private static final long META_ALT_PRESSED = 0x20000000000L;
    private static final long META_ALT_RELEASED = 0x2000000000000L;
    private static final long META_ALT_USED = 0x200000000L;
    public static final int META_CAP_LOCKED = 256;
    private static final long META_CAP_PRESSED = 0x10000000000L;
    private static final long META_CAP_RELEASED = 0x1000000000000L;
    private static final long META_CAP_USED = 0x100000000L;
    public static final int META_SELECTING = 2048;
    private static final long META_SHIFT_MASK = 0x1010100000101L;
    public static final int META_SHIFT_ON = 1;
    public static final int META_SYM_LOCKED = 1024;
    private static final long META_SYM_MASK = 0x4040400000404L;
    public static final int META_SYM_ON = 4;
    private static final long META_SYM_PRESSED = 0x40000000000L;
    private static final long META_SYM_RELEASED = 0x4000000000000L;
    private static final long META_SYM_USED = 0x400000000L;
    private static final int PRESSED = 0x1000011;
    private static final int PRESSED_RETURN_VALUE = 1;
    private static final int RELEASED = 0x2000011;
    private static final Object SELECTING;
    private static final Object SYM;
    private static final int USED = 0x3000011;

    static {
        CAP = new NoCopySpan.Concrete();
        ALT = new NoCopySpan.Concrete();
        SYM = new NoCopySpan.Concrete();
        SELECTING = new NoCopySpan.Concrete();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void adjust(Spannable spannable, Object object) {
        int n = spannable.getSpanFlags(object);
        if (n == 0x1000011) {
            spannable.setSpan(object, 0, 0, 0x3000011);
            return;
        } else {
            if (n != 0x2000011) return;
            spannable.removeSpan(object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long adjustMetaAfterKeypress(long l) {
        if ((0x10000000000L & l) != 0L) {
            l = 0x100000000L | (1L | l & 0xFFFEFEFEFFFFFEFEL);
        } else if ((0x1000000000000L & l) != 0L) {
            l &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((0x20000000000L & l) != 0L) {
            l = 0x200000000L | (2L | l & 0xFFFDFDFDFFFFFDFDL);
        } else if ((0x2000000000000L & l) != 0L) {
            l &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((0x40000000000L & l) != 0L) {
            return 0x400000000L | (4L | l & 0xFFFBFBFBFFFFFBFBL);
        }
        if ((0x4000000000000L & l) == 0L) return l;
        return l & 0xFFFBFBFBFFFFFBFBL;
    }

    public static void adjustMetaAfterKeypress(Spannable spannable) {
        MetaKeyKeyListener.adjust(spannable, CAP);
        MetaKeyKeyListener.adjust(spannable, ALT);
        MetaKeyKeyListener.adjust(spannable, SYM);
    }

    public static void clearMetaKeyState(Editable editable, int n) {
        if ((n & 1) != 0) {
            editable.removeSpan(CAP);
        }
        if ((n & 2) != 0) {
            editable.removeSpan(ALT);
        }
        if ((n & 4) != 0) {
            editable.removeSpan(SYM);
        }
        if ((n & 0x800) != 0) {
            editable.removeSpan(SELECTING);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getActive(CharSequence charSequence, Object object, int n, int n2) {
        if (!(charSequence instanceof Spanned)) {
            return 0;
        }
        int n3 = ((Spanned)charSequence).getSpanFlags(object);
        if (n3 == 0x4000011) return n2;
        if (n3 == 0) return 0;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final int getMetaState(long l) {
        int n;
        if ((0x100L & l) != 0L) {
            n = 0 | 0x100;
        } else {
            long l2 = (1L & l) - 0L;
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            n = 0;
            if (l3 != false) {
                n = 0 | 1;
            }
        }
        if ((0x200L & l) != 0L) {
            n |= 0x200;
        } else if ((2L & l) != 0L) {
            n |= 2;
        }
        if ((0x400L & l) != 0L) {
            n |= 0x400;
            return n;
        } else {
            if ((4L & l) == 0L) return n;
            return n | 4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int getMetaState(long l, int n) {
        int n2 = 2;
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                if ((0x100L & l) != 0L) return n2;
                if ((1L & l) == 0L) return 0;
                return 1;
            }
            case 2: {
                if ((0x200L & l) != 0L) return n2;
                if ((2L & l) == 0L) return 0;
                return 1;
            }
            case 4: 
        }
        if ((0x400L & l) != 0L) return n2;
        if ((4L & l) == 0L) return 0;
        return 1;
    }

    public static final int getMetaState(CharSequence charSequence) {
        return MetaKeyKeyListener.getActive(charSequence, CAP, 1, 256) | MetaKeyKeyListener.getActive(charSequence, ALT, 2, 512) | MetaKeyKeyListener.getActive(charSequence, SYM, 4, 1024) | MetaKeyKeyListener.getActive(charSequence, SELECTING, 2048, 2048);
    }

    public static final int getMetaState(CharSequence charSequence, int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 1: {
                return MetaKeyKeyListener.getActive(charSequence, CAP, 1, 2);
            }
            case 2: {
                return MetaKeyKeyListener.getActive(charSequence, ALT, 1, 2);
            }
            case 4: {
                return MetaKeyKeyListener.getActive(charSequence, SYM, 1, 2);
            }
            case 2048: 
        }
        return MetaKeyKeyListener.getActive(charSequence, SELECTING, 1, 2);
    }

    public static final int getMetaState(CharSequence charSequence, int n, KeyEvent keyEvent) {
        int n2 = keyEvent.getMetaState();
        if (keyEvent.getKeyCharacterMap().getModifierBehavior() == 1) {
            n2 |= MetaKeyKeyListener.getMetaState(charSequence);
        }
        if (2048 == n) {
            if ((n2 & 0x800) != 0) {
                return 1;
            }
            return 0;
        }
        return MetaKeyKeyListener.getMetaState(n2, n);
    }

    public static final int getMetaState(CharSequence charSequence, KeyEvent keyEvent) {
        int n = keyEvent.getMetaState();
        if (keyEvent.getKeyCharacterMap().getModifierBehavior() == 1) {
            n |= MetaKeyKeyListener.getMetaState(charSequence);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long handleKeyDown(long l, int n, KeyEvent keyEvent) {
        if (n == 59) return MetaKeyKeyListener.press(l, 1, 0x1010100000101L, 256L, 0x10000000000L, 0x1000000000000L, 0x100000000L);
        if (n == 60) {
            return MetaKeyKeyListener.press(l, 1, 0x1010100000101L, 256L, 0x10000000000L, 0x1000000000000L, 0x100000000L);
        }
        if (n == 57) return MetaKeyKeyListener.press(l, 2, 0x2020200000202L, 512L, 0x20000000000L, 0x2000000000000L, 0x200000000L);
        if (n == 58) return MetaKeyKeyListener.press(l, 2, 0x2020200000202L, 512L, 0x20000000000L, 0x2000000000000L, 0x200000000L);
        if (n == 78) {
            return MetaKeyKeyListener.press(l, 2, 0x2020200000202L, 512L, 0x20000000000L, 0x2000000000000L, 0x200000000L);
        }
        if (n != 63) return l;
        return MetaKeyKeyListener.press(l, 4, 0x4040400000404L, 1024L, 0x40000000000L, 0x4000000000000L, 0x400000000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long handleKeyUp(long l, int n, KeyEvent keyEvent) {
        if (n == 59) return MetaKeyKeyListener.release(l, 1, 0x1010100000101L, 0x10000000000L, 0x1000000000000L, 0x100000000L, keyEvent);
        if (n == 60) {
            return MetaKeyKeyListener.release(l, 1, 0x1010100000101L, 0x10000000000L, 0x1000000000000L, 0x100000000L, keyEvent);
        }
        if (n == 57) return MetaKeyKeyListener.release(l, 2, 0x2020200000202L, 0x20000000000L, 0x2000000000000L, 0x200000000L, keyEvent);
        if (n == 58) return MetaKeyKeyListener.release(l, 2, 0x2020200000202L, 0x20000000000L, 0x2000000000000L, 0x200000000L, keyEvent);
        if (n == 78) {
            return MetaKeyKeyListener.release(l, 2, 0x2020200000202L, 0x20000000000L, 0x2000000000000L, 0x200000000L, keyEvent);
        }
        if (n != 63) return l;
        return MetaKeyKeyListener.release(l, 4, 0x4040400000404L, 0x40000000000L, 0x4000000000000L, 0x400000000L, keyEvent);
    }

    public static boolean isMetaTracker(CharSequence charSequence, Object object) {
        return object == CAP || object == ALT || object == SYM || object == SELECTING;
    }

    public static boolean isSelectingMetaTracker(CharSequence charSequence, Object object) {
        return object == SELECTING;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long press(long l, int n, long l2, long l3, long l4, long l5, long l6) {
        block6: {
            block5: {
                if ((l & l4) != 0L) break block5;
                if ((l & l5) != 0L) {
                    return l3 | (l & (0xFFFFFFFFFFFFFFFFL ^ l2) | (long)n);
                }
                if ((l & l6) == 0L) break block6;
            }
            return l;
        }
        if ((l & l3) != 0L) {
            return l & (0xFFFFFFFFFFFFFFFFL ^ l2);
        }
        return l | (l4 | (long)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void press(Editable editable, Object object) {
        int n;
        block6: {
            block5: {
                n = editable.getSpanFlags(object);
                if (n == 0x1000011) break block5;
                if (n == 0x2000011) {
                    editable.setSpan(object, 0, 0, 0x4000011);
                    return;
                }
                if (n != 0x3000011) break block6;
            }
            return;
        }
        if (n == 0x4000011) {
            editable.removeSpan(object);
            return;
        }
        editable.setSpan(object, 0, 0, 0x1000011);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long release(long l, int n, long l2, long l3, long l4, long l5, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCharacterMap().getModifierBehavior()) {
            default: {
                l &= 0xFFFFFFFFFFFFFFFFL ^ l2;
                return l;
            }
            case 1: {
                if ((l & l5) != 0L) {
                    return l & (0xFFFFFFFFFFFFFFFFL ^ l2);
                }
                if ((l & l3) == 0L) return l;
                return l | (l4 | (long)n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void release(Editable editable, Object object, KeyEvent keyEvent) {
        int n = editable.getSpanFlags(object);
        switch (keyEvent.getKeyCharacterMap().getModifierBehavior()) {
            default: {
                editable.removeSpan(object);
                return;
            }
            case 1: {
                if (n == 0x3000011) {
                    editable.removeSpan(object);
                    return;
                }
                if (n != 0x1000011) return;
                editable.setSpan(object, 0, 0, 0x2000011);
                return;
            }
        }
    }

    private static void resetLock(Spannable spannable, Object object) {
        if (spannable.getSpanFlags(object) == 0x4000011) {
            spannable.removeSpan(object);
        }
    }

    public static long resetLockedMeta(long l) {
        if ((0x100L & l) != 0L) {
            l &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((0x200L & l) != 0L) {
            l &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((0x400L & l) != 0L) {
            l &= 0xFFFBFBFBFFFFFBFBL;
        }
        return l;
    }

    protected static void resetLockedMeta(Spannable spannable) {
        MetaKeyKeyListener.resetLock(spannable, CAP);
        MetaKeyKeyListener.resetLock(spannable, ALT);
        MetaKeyKeyListener.resetLock(spannable, SYM);
        MetaKeyKeyListener.resetLock(spannable, SELECTING);
    }

    public static void resetMetaState(Spannable spannable) {
        spannable.removeSpan(CAP);
        spannable.removeSpan(ALT);
        spannable.removeSpan(SYM);
        spannable.removeSpan(SELECTING);
    }

    public static void startSelecting(View view, Spannable spannable) {
        spannable.setSpan(SELECTING, 0, 0, 0x1000011);
    }

    public static void stopSelecting(View view, Spannable spannable) {
        spannable.removeSpan(SELECTING);
    }

    public long clearMetaKeyState(long l, int n) {
        if ((n & 1) != 0 && (0x100L & l) != 0L) {
            l &= 0xFFFEFEFEFFFFFEFEL;
        }
        if ((n & 2) != 0 && (0x200L & l) != 0L) {
            l &= 0xFFFDFDFDFFFFFDFDL;
        }
        if ((n & 4) != 0 && (0x400L & l) != 0L) {
            l &= 0xFFFBFBFBFFFFFBFBL;
        }
        return l;
    }

    public void clearMetaKeyState(View view, Editable editable, int n) {
        MetaKeyKeyListener.clearMetaKeyState(editable, n);
    }

    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        if (n == 59 || n == 60) {
            this.press(editable, CAP);
            return true;
        }
        if (n == 57 || n == 58 || n == 78) {
            this.press(editable, ALT);
            return true;
        }
        if (n == 63) {
            this.press(editable, SYM);
            return true;
        }
        return false;
    }

    public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
        if (n == 59 || n == 60) {
            this.release(editable, CAP, keyEvent);
            return true;
        }
        if (n == 57 || n == 58 || n == 78) {
            this.release(editable, ALT, keyEvent);
            return true;
        }
        if (n == 63) {
            this.release(editable, SYM, keyEvent);
            return true;
        }
        return false;
    }
}

