/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import android.provider.Settings;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.BaseKeyListener;
import android.text.method.KeyListener;
import android.text.method.MultiTapKeyListener;
import android.text.method.QwertyKeyListener;
import android.view.KeyEvent;
import android.view.View;
import java.lang.ref.WeakReference;

public class TextKeyListener
extends BaseKeyListener
implements SpanWatcher {
    static final Object ACTIVE;
    static final int AUTO_CAP = 1;
    static final int AUTO_PERIOD = 4;
    static final int AUTO_TEXT = 2;
    static final Object CAPPED;
    static final Object INHIBIT_REPLACEMENT;
    static final Object LAST_TYPED;
    static final int SHOW_PASSWORD = 8;
    private static TextKeyListener[] sInstance;
    private Capitalize mAutoCap;
    private boolean mAutoText;
    private SettingsObserver mObserver;
    private int mPrefs;
    private boolean mPrefsInited;
    private WeakReference<ContentResolver> mResolver;

    static {
        sInstance = new TextKeyListener[2 * Capitalize.values().length];
        ACTIVE = new NoCopySpan.Concrete();
        CAPPED = new NoCopySpan.Concrete();
        INHIBIT_REPLACEMENT = new NoCopySpan.Concrete();
        LAST_TYPED = new NoCopySpan.Concrete();
    }

    public TextKeyListener(Capitalize capitalize, boolean bl) {
        this.mAutoCap = capitalize;
        this.mAutoText = bl;
    }

    static /* synthetic */ boolean access$102(TextKeyListener textKeyListener, boolean bl) {
        textKeyListener.mPrefsInited = bl;
        return bl;
    }

    public static void clear(Editable editable) {
        editable.clear();
        editable.removeSpan(ACTIVE);
        editable.removeSpan(CAPPED);
        editable.removeSpan(INHIBIT_REPLACEMENT);
        editable.removeSpan(LAST_TYPED);
        QwertyKeyListener.Replaced[] replacedArray = editable.getSpans(0, editable.length(), QwertyKeyListener.Replaced.class);
        int n = replacedArray.length;
        for (int i = 0; i < n; ++i) {
            editable.removeSpan(replacedArray[i]);
        }
    }

    public static TextKeyListener getInstance() {
        return TextKeyListener.getInstance(false, Capitalize.NONE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static TextKeyListener getInstance(boolean bl, Capitalize capitalize) {
        int n;
        int n2 = 2 * capitalize.ordinal();
        int n3 = n2 + (n = bl ? 1 : 0);
        if (sInstance[n3] == null) {
            TextKeyListener.sInstance[n3] = new TextKeyListener(capitalize, bl);
        }
        return sInstance[n3];
    }

    private KeyListener getKeyListener(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCharacterMap().getKeyboardType();
        if (n == 3) {
            return QwertyKeyListener.getInstance(this.mAutoText, this.mAutoCap);
        }
        if (n == 1) {
            return MultiTapKeyListener.getInstance(this.mAutoText, this.mAutoCap);
        }
        if (n == 4 || n == 5) {
            return QwertyKeyListener.getInstanceForFullKeyboard();
        }
        return NullKeyListener.getInstance();
    }

    private void initPrefs(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        this.mResolver = new WeakReference<ContentResolver>(contentResolver);
        if (this.mObserver == null) {
            this.mObserver = new SettingsObserver();
            contentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mObserver);
        }
        this.updatePrefs(contentResolver);
        this.mPrefsInited = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean shouldCap(Capitalize capitalize, CharSequence charSequence, int n) {
        if (capitalize == Capitalize.NONE) {
            return false;
        }
        if (capitalize == Capitalize.CHARACTERS) {
            return true;
        }
        int n2 = capitalize == Capitalize.WORDS ? 8192 : 16384;
        if (TextUtils.getCapsMode(charSequence, n, n2) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePrefs(ContentResolver contentResolver) {
        boolean bl = Settings.System.getInt(contentResolver, "auto_caps", 1) > 0;
        boolean bl2 = Settings.System.getInt(contentResolver, "auto_replace", 1) > 0;
        boolean bl3 = Settings.System.getInt(contentResolver, "auto_punctuate", 1) > 0;
        boolean bl4 = Settings.System.getInt(contentResolver, "show_password", 1) > 0;
        int n = bl ? 1 : 0;
        int n2 = bl2 ? 2 : 0;
        int n3 = n | n2;
        int n4 = bl3 ? 4 : 0;
        int n5 = n4 | n3;
        int n6 = 0;
        if (bl4) {
            n6 = 8;
        }
        this.mPrefs = n5 | n6;
    }

    @Override
    public int getInputType() {
        return TextKeyListener.makeTextContentType(this.mAutoCap, this.mAutoText);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getPrefs(Context context) {
        synchronized (this) {
            if (!this.mPrefsInited || this.mResolver.get() == null) {
                this.initPrefs(context);
            }
            return this.mPrefs;
        }
    }

    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyDown(view, editable, n, keyEvent);
    }

    @Override
    public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyOther(view, editable, keyEvent);
    }

    @Override
    public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
        return this.getKeyListener(keyEvent).onKeyUp(view, editable, n, keyEvent);
    }

    @Override
    public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
    }

    @Override
    public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
        if (object == Selection.SELECTION_END) {
            spannable.removeSpan(ACTIVE);
        }
    }

    @Override
    public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
    }

    public void release() {
        if (this.mResolver != null) {
            ContentResolver contentResolver = (ContentResolver)this.mResolver.get();
            if (contentResolver != null) {
                contentResolver.unregisterContentObserver(this.mObserver);
                this.mResolver.clear();
            }
            this.mObserver = null;
            this.mResolver = null;
            this.mPrefsInited = false;
        }
    }

    public static final class Capitalize
    extends Enum<Capitalize> {
        private static final /* synthetic */ Capitalize[] $VALUES;
        public static final /* enum */ Capitalize CHARACTERS;
        public static final /* enum */ Capitalize NONE;
        public static final /* enum */ Capitalize SENTENCES;
        public static final /* enum */ Capitalize WORDS;

        static {
            NONE = new Capitalize();
            SENTENCES = new Capitalize();
            WORDS = new Capitalize();
            CHARACTERS = new Capitalize();
            Capitalize[] capitalizeArray = new Capitalize[]{NONE, SENTENCES, WORDS, CHARACTERS};
            $VALUES = capitalizeArray;
        }

        public static Capitalize valueOf(String string2) {
            return Enum.valueOf(Capitalize.class, string2);
        }

        public static Capitalize[] values() {
            return (Capitalize[])$VALUES.clone();
        }
    }

    private static class NullKeyListener
    implements KeyListener {
        private static NullKeyListener sInstance;

        private NullKeyListener() {
        }

        public static NullKeyListener getInstance() {
            if (sInstance != null) {
                return sInstance;
            }
            sInstance = new NullKeyListener();
            return sInstance;
        }

        @Override
        public void clearMetaKeyState(View view, Editable editable, int n) {
        }

        @Override
        public int getInputType() {
            return 0;
        }

        @Override
        public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
            return false;
        }

        @Override
        public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
            return false;
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver() {
            super(new Handler());
        }

        @Override
        public void onChange(boolean bl) {
            if (TextKeyListener.this.mResolver != null) {
                ContentResolver contentResolver = (ContentResolver)TextKeyListener.this.mResolver.get();
                if (contentResolver == null) {
                    TextKeyListener.access$102(TextKeyListener.this, false);
                    return;
                }
                TextKeyListener.this.updatePrefs(contentResolver);
                return;
            }
            TextKeyListener.access$102(TextKeyListener.this, false);
        }
    }
}

