/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.internal.R;

public abstract class Visibility
extends Transition {
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    private static final String PROPNAME_PARENT = "android:visibility:parent";
    private static final String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    static final String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static final String[] sTransitionProperties = new String[]{"android:visibility:visibility"};
    private int mForcedEndVisibility = -1;
    private int mForcedStartVisibility = -1;
    private int mMode = 3;

    public Visibility() {
    }

    public Visibility(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.VisibilityTransition);
        int n = typedArray.getInt(0, 0);
        typedArray.recycle();
        if (n != 0) {
            this.setMode(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void captureValues(TransitionValues transitionValues, int n) {
        int n2 = n != -1 ? n : transitionValues.view.getVisibility();
        transitionValues.values.put(PROPNAME_VISIBILITY, n2);
        transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
        int[] nArray = new int[2];
        transitionValues.view.getLocationOnScreen(nArray);
        transitionValues.values.put(PROPNAME_SCREEN_LOCATION, nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private VisibilityInfo getVisibilityChangeInfo(TransitionValues transitionValues, TransitionValues transitionValues2) {
        VisibilityInfo visibilityInfo = new VisibilityInfo();
        visibilityInfo.visibilityChange = false;
        visibilityInfo.fadeIn = false;
        if (transitionValues != null && transitionValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visibilityInfo.startVisibility = (Integer)transitionValues.values.get(PROPNAME_VISIBILITY);
            visibilityInfo.startParent = (ViewGroup)transitionValues.values.get(PROPNAME_PARENT);
        } else {
            visibilityInfo.startVisibility = -1;
            visibilityInfo.startParent = null;
        }
        if (transitionValues2 != null && transitionValues2.values.containsKey(PROPNAME_VISIBILITY)) {
            visibilityInfo.endVisibility = (Integer)transitionValues2.values.get(PROPNAME_VISIBILITY);
            visibilityInfo.endParent = (ViewGroup)transitionValues2.values.get(PROPNAME_PARENT);
        } else {
            visibilityInfo.endVisibility = -1;
            visibilityInfo.endParent = null;
        }
        if (transitionValues != null && transitionValues2 != null) {
            if (visibilityInfo.startVisibility == visibilityInfo.endVisibility && visibilityInfo.startParent == visibilityInfo.endParent) return visibilityInfo;
            if (visibilityInfo.startVisibility != visibilityInfo.endVisibility) {
                if (visibilityInfo.startVisibility == 0) {
                    visibilityInfo.fadeIn = false;
                    visibilityInfo.visibilityChange = true;
                    return visibilityInfo;
                }
                if (visibilityInfo.endVisibility != 0) return visibilityInfo;
                visibilityInfo.fadeIn = true;
                visibilityInfo.visibilityChange = true;
                return visibilityInfo;
            } else {
                if (visibilityInfo.startParent == visibilityInfo.endParent) return visibilityInfo;
                if (visibilityInfo.endParent == null) {
                    visibilityInfo.fadeIn = false;
                    visibilityInfo.visibilityChange = true;
                    return visibilityInfo;
                }
                if (visibilityInfo.startParent != null) return visibilityInfo;
                visibilityInfo.fadeIn = true;
                visibilityInfo.visibilityChange = true;
                return visibilityInfo;
            }
        }
        if (transitionValues == null && visibilityInfo.endVisibility == 0) {
            visibilityInfo.fadeIn = true;
            visibilityInfo.visibilityChange = true;
            return visibilityInfo;
        }
        if (transitionValues2 != null || visibilityInfo.startVisibility != 0) {
            return visibilityInfo;
        }
        visibilityInfo.fadeIn = false;
        visibilityInfo.visibilityChange = true;
        return visibilityInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    boolean areValuesChanged(TransitionValues transitionValues, TransitionValues transitionValues2) {
        VisibilityInfo visibilityInfo = this.getVisibilityChangeInfo(transitionValues, transitionValues2);
        return (transitionValues != null || transitionValues2 != null) && visibilityInfo.visibilityChange && (visibilityInfo.startVisibility == 0 || visibilityInfo.endVisibility == 0);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedEndVisibility);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedStartVisibility);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        VisibilityInfo visibilityInfo = this.getVisibilityChangeInfo(transitionValues, transitionValues2);
        if (visibilityInfo.visibilityChange && (visibilityInfo.startParent != null || visibilityInfo.endParent != null)) {
            if (visibilityInfo.fadeIn) {
                return this.onAppear(viewGroup, transitionValues, visibilityInfo.startVisibility, transitionValues2, visibilityInfo.endVisibility);
            }
            return this.onDisappear(viewGroup, transitionValues, visibilityInfo.startVisibility, transitionValues2, visibilityInfo.endVisibility);
        }
        return null;
    }

    @Override
    public void forceVisibility(int n, boolean bl) {
        if (bl) {
            this.mForcedStartVisibility = n;
            return;
        }
        this.mForcedEndVisibility = n;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVisible(TransitionValues transitionValues) {
        if (transitionValues == null) {
            return false;
        }
        int n = (Integer)transitionValues.values.get(PROPNAME_VISIBILITY);
        View view = (View)transitionValues.values.get(PROPNAME_PARENT);
        if (n != 0) return false;
        if (view == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Animator onAppear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        block3: {
            block2: {
                if ((1 & this.mMode) != 1 || transitionValues2 == null) break block2;
                if (transitionValues != null) break block3;
                View view = (View)((Object)transitionValues2.view.getParent());
                if (!this.getVisibilityChangeInfo((TransitionValues)this.getMatchedTransitionValues((View)view, (boolean)false), (TransitionValues)this.getTransitionValues((View)view, (boolean)false)).visibilityChange) break block3;
            }
            return null;
        }
        return this.onAppear(viewGroup, transitionValues2.view, transitionValues, transitionValues2);
    }

    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Animator onDisappear(final ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, final int n2) {
        Animator animator2;
        View view;
        View view2;
        block14: {
            View view3;
            View view4;
            block12: {
                View view5;
                block16: {
                    block15: {
                        block13: {
                            if ((2 & this.mMode) != 2) {
                                return null;
                            }
                            view4 = transitionValues != null ? transitionValues.view : null;
                            view3 = transitionValues2 != null ? transitionValues2.view : null;
                            view2 = null;
                            if (view3 != null && view3.getParent() != null) break block12;
                            if (view3 == null) break block13;
                            view = view3;
                            break block14;
                        }
                        view = null;
                        view2 = null;
                        if (view4 == null) break block14;
                        if (view4.getParent() != null) break block15;
                        view = view4;
                        view2 = null;
                        break block14;
                    }
                    boolean bl = view4.getParent() instanceof View;
                    view = null;
                    view2 = null;
                    if (!bl) break block14;
                    view5 = (View)((Object)view4.getParent());
                    if (this.getVisibilityChangeInfo((TransitionValues)this.getTransitionValues((View)view5, (boolean)true), (TransitionValues)this.getMatchedTransitionValues((View)view5, (boolean)true)).visibilityChange) break block16;
                    view = TransitionUtils.copyViewImage(viewGroup, view4, view5);
                    view2 = null;
                    break block14;
                }
                ViewParent viewParent = view5.getParent();
                view = null;
                view2 = null;
                if (viewParent != null) break block14;
                int n3 = view5.getId();
                view = null;
                view2 = null;
                if (n3 == -1) break block14;
                View view6 = viewGroup.findViewById(n3);
                view = null;
                view2 = null;
                if (view6 != null) {
                    boolean bl = this.mCanRemoveViews;
                    view = null;
                    view2 = null;
                    if (bl) {
                        view = view4;
                        view2 = null;
                    }
                }
                break block14;
            }
            if (n2 == 4) {
                view2 = view3;
                view = null;
            } else if (view4 == view3) {
                view2 = view3;
                view = null;
            } else {
                view = view4;
                view2 = null;
            }
        }
        if (view != null) {
            int[] nArray = (int[])transitionValues.values.get(PROPNAME_SCREEN_LOCATION);
            int n4 = nArray[0];
            int n5 = nArray[1];
            int[] nArray2 = new int[2];
            viewGroup.getLocationOnScreen(nArray2);
            int n6 = n4 - nArray2[0] - view.getLeft();
            view.offsetLeftAndRight(n6);
            int n7 = n5 - nArray2[1] - view.getTop();
            view.offsetTopAndBottom(n7);
            viewGroup.getOverlay().add(view);
            Animator animator3 = this.onDisappear(viewGroup, view, transitionValues, transitionValues2);
            if (animator3 == null) {
                viewGroup.getOverlay().remove(view);
                return animator3;
            }
            final View view7 = view;
            AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    viewGroup.getOverlay().remove(view7);
                }
            };
            animator3.addListener(animatorListenerAdapter);
            return animator3;
        }
        if (view2 == null) {
            return null;
        }
        int n8 = -1;
        final boolean bl = this.mForcedStartVisibility != -1 || this.mForcedEndVisibility != -1;
        if (!bl) {
            n8 = view2.getVisibility();
            view2.setVisibility(0);
        }
        if ((animator2 = this.onDisappear(viewGroup, view2, transitionValues, transitionValues2)) != null) {
            final View view8 = view2;
            AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){
                boolean mCanceled = false;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mCanceled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    block3: {
                        block2: {
                            if (this.mCanceled) break block2;
                            if (!bl) break block3;
                            view8.setTransitionAlpha(0.0f);
                        }
                        return;
                    }
                    view8.setVisibility(n2);
                }

                @Override
                public void onAnimationPause(Animator animator2) {
                    if (!this.mCanceled && !bl) {
                        view8.setVisibility(n2);
                    }
                }

                @Override
                public void onAnimationResume(Animator animator2) {
                    if (!this.mCanceled && !bl) {
                        view8.setVisibility(0);
                    }
                }
            };
            animator2.addListener(animatorListenerAdapter);
            return animator2;
        }
        if (bl) return animator2;
        view2.setVisibility(n8);
        return animator2;
    }

    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return null;
    }

    public void setMode(int n) {
        if ((n & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = n;
    }

    private static class VisibilityInfo {
        ViewGroup endParent;
        int endVisibility;
        boolean fadeIn;
        ViewGroup startParent;
        int startVisibility;
        boolean visibilityChange;

        private VisibilityInfo() {
        }
    }
}

