/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Base64;
import android.util.Base64DataException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 2048;
    private static byte[] EMPTY = new byte[0];
    private final Base64.Coder coder;
    private boolean eof = false;
    private byte[] inputBuffer = new byte[2048];
    private int outputEnd;
    private int outputStart;

    public Base64InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Base64InputStream(InputStream inputStream, int n, boolean bl) {
        super(inputStream);
        this.coder = bl ? new Base64.Encoder(n, null) : new Base64.Decoder(n, null);
        this.coder.output = new byte[this.coder.maxOutputSize(2048)];
        this.outputStart = 0;
        this.outputEnd = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refill() throws IOException {
        boolean bl;
        if (this.eof) {
            return;
        }
        int n = this.in.read(this.inputBuffer);
        if (n == -1) {
            this.eof = true;
            bl = this.coder.process(EMPTY, 0, 0, true);
        } else {
            bl = this.coder.process(this.inputBuffer, 0, n, false);
        }
        if (!bl) {
            throw new Base64DataException("bad base-64");
        }
        this.outputEnd = this.coder.op;
        this.outputStart = 0;
    }

    @Override
    public int available() {
        return this.outputEnd - this.outputStart;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.inputBuffer = null;
    }

    @Override
    public void mark(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return -1;
        }
        byte[] byArray = this.coder.output;
        int n = this.outputStart;
        this.outputStart = n + 1;
        return 0xFF & byArray[n];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return -1;
        }
        int n3 = Math.min(n2, this.outputEnd - this.outputStart);
        System.arraycopy((byte[])this.coder.output, (int)this.outputStart, (byte[])byArray, (int)n, (int)n3);
        this.outputStart = n3 + this.outputStart;
        return n3;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.outputStart >= this.outputEnd) {
            this.refill();
        }
        if (this.outputStart >= this.outputEnd) {
            return 0L;
        }
        long l2 = Math.min(l, (long)(this.outputEnd - this.outputStart));
        this.outputStart = (int)(l2 + (long)this.outputStart);
        return l2;
    }
}

