/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.JsonReader;
import android.util.Log;
import android.util.Pair;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class DeviceConf
extends ArrayList<Pair<String, String>> {
    private static final String LOG_TAG = "DeviceConf";
    private static final long serialVersionUID = 4154379133222419302L;
    private final String DEFAULT_PATH;

    public DeviceConf(String string2) {
        this.DEFAULT_PATH = "/system/etc/devconf.json";
        this.init("/system/etc/devconf.json", string2);
    }

    public DeviceConf(String string2, String string3) {
        this.DEFAULT_PATH = "/system/etc/devconf.json";
        this.init(string2, string3);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(String var1_1, String var2_2) {
        block12: {
            block10: {
                block11: {
                    var3_3 = new JsonReader(new FileReader(var1_1));
                    try {}
                    catch (IOException var4_6) {
                        Log.d("DeviceConf", "Syntax error in configuration file.");
lbl7:
                        // 2 sources

                        while (true) {
                            try {
                                var3_3.close();
                                return;
                            }
                            catch (IOException var6_8) {
                                return;
                            }
                            break;
                        }
                    }
                    break block11;
lbl14:
                    // 3 sources

                    while (true) {
                        this.skipToNextObject(var3_3);
                        break block10;
                        break;
                    }
                    catch (FileNotFoundException var10_7) {
                        Log.d("DeviceConf", "Configuration file not found.");
                        return;
                    }
                }
                var3_3.beginArray();
            }
            if (!var3_3.hasNext()) break block12;
            var3_3.beginObject();
            if (!var3_3.hasNext()) ** GOTO lbl14
            var7_4 = var3_3.nextName();
            var8_5 = var3_3.nextString();
            if (!"topic".equalsIgnoreCase(var7_4) || !var2_2.equalsIgnoreCase(var8_5)) ** GOTO lbl14
            while (true) {
                if (var3_3.hasNext()) ** break;
                ** continue;
                this.add(new Pair<String, String>(var3_3.nextName(), var3_3.nextString()));
            }
        }
        var3_3.endArray();
        ** while (true)
    }

    private void skipToNextObject(JsonReader jsonReader) throws IOException {
        while (jsonReader.hasNext()) {
            jsonReader.nextName();
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    public String get(String string2) {
        for (Pair pair : this) {
            if (!string2.equalsIgnoreCase((String)pair.first)) continue;
            return (String)pair.second;
        }
        return null;
    }

    public String get(String string2, String string3) {
        for (Pair pair : this) {
            if (!string2.equalsIgnoreCase((String)pair.first)) continue;
            if (pair.second != null) {
                return (String)pair.second;
            }
            return string3;
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(String string2, boolean bl) {
        String string3 = this.get(string2);
        if (string3 == null) {
            return bl;
        }
        if (string3.equals("1")) return true;
        if (string3.equalsIgnoreCase("true")) return true;
        if (string3.equalsIgnoreCase("yes")) return true;
        if (!string3.equalsIgnoreCase("y")) return false;
        return true;
    }

    public float getFloat(String string2, float f) throws NumberFormatException {
        String string3 = this.get(string2);
        if (string3 == null) {
            return f;
        }
        return Float.parseFloat(string3.trim());
    }

    public float[] getFloatArray(String string2, float[] fArray) throws NumberFormatException {
        String[] stringArray = this.getStringArray(string2, null);
        if (stringArray == null) {
            return fArray;
        }
        float[] fArray2 = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fArray2[i] = Float.parseFloat(stringArray[i]);
        }
        return fArray2;
    }

    public int getInt(String string2, int n) throws NumberFormatException {
        String string3 = this.get(string2);
        if (string3 == null) {
            return n;
        }
        return Integer.parseInt(string3.trim());
    }

    public int[] getIntArray(String string2, int[] nArray) throws NumberFormatException {
        String[] stringArray = this.getStringArray(string2, null);
        if (stringArray == null) {
            return nArray;
        }
        int[] nArray2 = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray2[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray2;
    }

    public String[] getStringArray(String string2, String[] stringArray) {
        String string3 = this.get(string2);
        if (string3 == null) {
            return stringArray;
        }
        String[] stringArray2 = string3.split(",");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray2[i].trim();
        }
        return stringArray2;
    }
}

