/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.AbstractSet;
import java.util.Iterator;

public final class FastImmutableArraySet<T>
extends AbstractSet<T> {
    T[] mContents;
    FastIterator<T> mIterator;

    public FastImmutableArraySet(T[] TArray) {
        this.mContents = TArray;
    }

    @Override
    public Iterator<T> iterator() {
        FastIterator<T> fastIterator = this.mIterator;
        if (fastIterator == null) {
            FastIterator<T> fastIterator2 = new FastIterator<T>(this.mContents);
            this.mIterator = fastIterator2;
            return fastIterator2;
        }
        fastIterator.mIndex = 0;
        return fastIterator;
    }

    @Override
    public int size() {
        return this.mContents.length;
    }

    private static final class FastIterator<T>
    implements Iterator<T> {
        private final T[] mContents;
        int mIndex;

        public FastIterator(T[] TArray) {
            this.mContents = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex != this.mContents.length;
        }

        @Override
        public T next() {
            T[] TArray = this.mContents;
            int n = this.mIndex;
            this.mIndex = n + 1;
            return TArray[n];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

