/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

public class SparseBooleanArray
implements Cloneable {
    private int[] mKeys;
    private int mSize;
    private boolean[] mValues;

    public SparseBooleanArray() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SparseBooleanArray(int n) {
        if (n == 0) {
            this.mKeys = EmptyArray.INT;
            this.mValues = EmptyArray.BOOLEAN;
        } else {
            this.mKeys = ArrayUtils.newUnpaddedIntArray(n);
            this.mValues = new boolean[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public void append(int n, boolean bl) {
        if (this.mSize != 0 && n <= this.mKeys[-1 + this.mSize]) {
            this.put(n, bl);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, n);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, bl);
        this.mSize = 1 + this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    public SparseBooleanArray clone() {
        SparseBooleanArray sparseBooleanArray = null;
        try {
            sparseBooleanArray = (SparseBooleanArray)super.clone();
            sparseBooleanArray.mKeys = (int[])this.mKeys.clone();
            sparseBooleanArray.mValues = (boolean[])this.mValues.clone();
            return sparseBooleanArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sparseBooleanArray;
        }
    }

    public void delete(int n) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            System.arraycopy((int[])this.mKeys, (int)(n2 + 1), (int[])this.mKeys, (int)n2, (int)(this.mSize - (n2 + 1)));
            System.arraycopy((boolean[])this.mValues, (int)(n2 + 1), (boolean[])this.mValues, (int)n2, (int)(this.mSize - (n2 + 1)));
            this.mSize = -1 + this.mSize;
        }
    }

    public boolean get(int n) {
        return this.get(n, false);
    }

    public boolean get(int n, boolean bl) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 < 0) {
            return bl;
        }
        return this.mValues[n2];
    }

    public int indexOfKey(int n) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
    }

    public int indexOfValue(boolean bl) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != bl) continue;
            return i;
        }
        return -1;
    }

    public int keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(int n, boolean bl) {
        int n2 = ContainerHelpers.binarySearch(this.mKeys, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = bl;
            return;
        }
        int n3 = ~n2;
        this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, n3, n);
        this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, n3, bl);
        this.mSize = 1 + this.mSize;
    }

    public void removeAt(int n) {
        System.arraycopy((int[])this.mKeys, (int)(n + 1), (int[])this.mKeys, (int)n, (int)(this.mSize - (n + 1)));
        System.arraycopy((boolean[])this.mValues, (int)(n + 1), (boolean[])this.mValues, (int)n, (int)(this.mSize - (n + 1)));
        this.mSize = -1 + this.mSize;
    }

    public void setValueAt(int n, boolean bl) {
        this.mValues[n] = bl;
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(28 * this.mSize);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyAt(i));
            stringBuilder.append('=');
            stringBuilder.append(this.valueAt(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean valueAt(int n) {
        return this.mValues[n];
    }
}

