/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import dalvik.system.CloseGuard;

public abstract class DisplayEventReceiver {
    private static final String TAG = "DisplayEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private MessageQueue mMessageQueue;
    private long mReceiverPtr;

    public DisplayEventReceiver(Looper looper) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(this, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    private void dispatchHotplug(long l, int n, boolean bl) {
        this.onHotplug(l, n, bl);
    }

    private void dispatchVsync(long l, int n, int n2) {
        this.onVsync(l, n, n2);
    }

    private void dispose(boolean bl) {
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            DisplayEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mMessageQueue = null;
    }

    private static native void nativeDispose(long var0);

    private static native long nativeInit(DisplayEventReceiver var0, MessageQueue var1);

    private static native void nativeScheduleVsync(long var0);

    public void dispose() {
        this.dispose(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void onHotplug(long l, int n, boolean bl) {
    }

    public void onVsync(long l, int n, int n2) {
    }

    public void scheduleVsync() {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
            return;
        }
        DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
    }
}

