/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.ClipDescription;
import android.os.Parcel;
import android.os.Parcelable;

public class DragEvent
implements Parcelable {
    public static final int ACTION_DRAG_ENDED = 4;
    public static final int ACTION_DRAG_ENTERED = 5;
    public static final int ACTION_DRAG_EXITED = 6;
    public static final int ACTION_DRAG_LOCATION = 2;
    public static final int ACTION_DRAG_STARTED = 1;
    public static final int ACTION_DROP = 3;
    public static final Parcelable.Creator<DragEvent> CREATOR;
    private static final int MAX_RECYCLED = 10;
    private static final boolean TRACK_RECYCLED_LOCATION;
    private static final Object gRecyclerLock;
    private static DragEvent gRecyclerTop;
    private static int gRecyclerUsed;
    int mAction;
    ClipData mClipData;
    ClipDescription mClipDescription;
    boolean mDragResult;
    Object mLocalState;
    private DragEvent mNext;
    private boolean mRecycled;
    private RuntimeException mRecycledLocation;
    float mX;
    float mY;

    static {
        gRecyclerLock = new Object();
        gRecyclerUsed = 0;
        gRecyclerTop = null;
        CREATOR = new Parcelable.Creator<DragEvent>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public DragEvent createFromParcel(Parcel parcel) {
                DragEvent dragEvent = DragEvent.obtain();
                dragEvent.mAction = parcel.readInt();
                dragEvent.mX = parcel.readFloat();
                dragEvent.mY = parcel.readFloat();
                boolean bl = parcel.readInt() != 0;
                dragEvent.mDragResult = bl;
                if (parcel.readInt() != 0) {
                    dragEvent.mClipData = ClipData.CREATOR.createFromParcel(parcel);
                }
                if (parcel.readInt() != 0) {
                    dragEvent.mClipDescription = ClipDescription.CREATOR.createFromParcel(parcel);
                }
                return dragEvent;
            }

            public DragEvent[] newArray(int n) {
                return new DragEvent[n];
            }
        };
    }

    private DragEvent() {
    }

    private void init(int n, float f, float f2, ClipDescription clipDescription, ClipData clipData, Object object, boolean bl) {
        this.mAction = n;
        this.mX = f;
        this.mY = f2;
        this.mClipDescription = clipDescription;
        this.mClipData = clipData;
        this.mLocalState = object;
        this.mDragResult = bl;
    }

    static DragEvent obtain() {
        return DragEvent.obtain(0, 0.0f, 0.0f, null, null, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DragEvent obtain(int n, float f, float f2, Object object, ClipDescription clipDescription, ClipData clipData, boolean bl) {
        DragEvent dragEvent;
        Object object2 = gRecyclerLock;
        synchronized (object2) {
            if (gRecyclerTop == null) {
                DragEvent dragEvent2 = new DragEvent();
                dragEvent2.init(n, f, f2, clipDescription, clipData, object, bl);
                return dragEvent2;
            }
            dragEvent = gRecyclerTop;
            gRecyclerTop = dragEvent.mNext;
            gRecyclerUsed = -1 + gRecyclerUsed;
        }
        dragEvent.mRecycledLocation = null;
        dragEvent.mRecycled = false;
        dragEvent.mNext = null;
        dragEvent.init(n, f, f2, clipDescription, clipData, object, bl);
        return dragEvent;
    }

    public static DragEvent obtain(DragEvent dragEvent) {
        return DragEvent.obtain(dragEvent.mAction, dragEvent.mX, dragEvent.mY, dragEvent.mLocalState, dragEvent.mClipDescription, dragEvent.mClipData, dragEvent.mDragResult);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAction() {
        return this.mAction;
    }

    public ClipData getClipData() {
        return this.mClipData;
    }

    public ClipDescription getClipDescription() {
        return this.mClipDescription;
    }

    public Object getLocalState() {
        return this.mLocalState;
    }

    public boolean getResult() {
        return this.mDragResult;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        this.mClipData = null;
        this.mClipDescription = null;
        this.mLocalState = null;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                gRecyclerUsed = 1 + gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
            return;
        }
    }

    public String toString() {
        return "DragEvent{" + Integer.toHexString(System.identityHashCode(this)) + " action=" + this.mAction + " @ (" + this.mX + ", " + this.mY + ") desc=" + this.mClipDescription + " data=" + this.mClipData + " local=" + this.mLocalState + " result=" + this.mDragResult + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mAction);
        parcel.writeFloat(this.mX);
        parcel.writeFloat(this.mY);
        int n2 = this.mDragResult ? 1 : 0;
        parcel.writeInt(n2);
        if (this.mClipData == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            this.mClipData.writeToParcel(parcel, n);
        }
        if (this.mClipDescription == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(1);
        this.mClipDescription.writeToParcel(parcel, n);
    }
}

