/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.RenderNode;

class GLES20Canvas
extends HardwareCanvas {
    private static boolean sIsAvailable = GLES20Canvas.nIsAvailable();
    private Rect mClipBounds;
    private DrawFilter mFilter;
    private CanvasFinalizer mFinalizer;
    private int mHeight;
    private float[] mLine;
    private final boolean mOpaque;
    private RectF mPathBounds;
    private float[] mPoint;
    protected long mRenderer = GLES20Canvas.nCreateDisplayListRenderer();
    private int mWidth;

    protected GLES20Canvas() {
        this.mOpaque = false;
        this.setupFinalizer();
    }

    private Rect getInternalClipBounds() {
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect();
        }
        return this.mClipBounds;
    }

    private float[] getLineStorage() {
        if (this.mLine == null) {
            this.mLine = new float[4];
        }
        return this.mLine;
    }

    private RectF getPathBounds() {
        if (this.mPathBounds == null) {
            this.mPathBounds = new RectF();
        }
        return this.mPathBounds;
    }

    private float[] getPointStorage() {
        if (this.mPoint == null) {
            this.mPoint = new float[2];
        }
        return this.mPoint;
    }

    static boolean isAvailable() {
        return sIsAvailable;
    }

    private static native int nCallDrawGLFunction(long var0, long var2);

    private static native boolean nClipPath(long var0, long var2, int var4);

    private static native boolean nClipRect(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native boolean nClipRect(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native boolean nClipRegion(long var0, long var2, int var4);

    private static native void nConcatMatrix(long var0, long var2);

    private static native long nCreateDisplayListRenderer();

    private static native void nDestroyRenderer(long var0);

    private static native void nDrawArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, long var13);

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, float var5, float var6, long var7);

    private static native void nDrawBitmap(long var0, long var2, byte[] var4, long var5, long var7);

    private static native void nDrawBitmap(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    private static native void nDrawBitmapMesh(long var0, long var2, byte[] var4, int var5, int var6, float[] var7, int var8, int[] var9, int var10, long var11);

    private static native void nDrawCircle(long var0, float var2, float var3, float var4, long var5);

    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    private static native void nDrawColor(long var0, int var2, int var3);

    private static native void nDrawLayer(long var0, long var2, float var4, float var5);

    private static native void nDrawLines(long var0, float[] var2, int var3, int var4, long var5);

    private static native void nDrawOval(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void nDrawPatch(long var0, long var2, byte[] var4, long var5, float var7, float var8, float var9, float var10, long var11);

    private static native void nDrawPath(long var0, long var2, long var4);

    private static native void nDrawPoints(long var0, float[] var2, int var3, int var4, long var5);

    private static native void nDrawRect(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void nDrawRects(long var0, long var2, long var4);

    private static native int nDrawRenderNode(long var0, long var2, Rect var4, int var5);

    private static native void nDrawRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void nDrawText(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static native void nDrawText(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static native void nDrawTextOnPath(long var0, String var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    private static native void nDrawTextOnPath(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    private static native void nDrawTextRun(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static native void nDrawTextRun(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static native void nFinish(long var0);

    protected static native long nFinishRecording(long var0);

    private static native boolean nGetClipBounds(long var0, Rect var2);

    private static native void nGetMatrix(long var0, long var2);

    private static native int nGetMaximumTextureHeight();

    private static native int nGetMaximumTextureWidth();

    private static native int nGetSaveCount(long var0);

    private static native void nInsertReorderBarrier(long var0, boolean var2);

    private static native boolean nIsAvailable();

    private static native int nPrepare(long var0, boolean var2);

    private static native int nPrepareDirty(long var0, int var2, int var3, int var4, int var5, boolean var6);

    private static native boolean nQuickReject(long var0, float var2, float var3, float var4, float var5);

    private static native void nResetDisplayListRenderer(long var0);

    private static native void nResetPaintFilter(long var0);

    private static native void nRestore(long var0);

    private static native void nRestoreToCount(long var0, int var2);

    private static native void nRotate(long var0, float var2);

    private static native int nSave(long var0, int var2);

    private static native int nSaveLayer(long var0, float var2, float var3, float var4, float var5, long var6, int var8);

    private static native int nSaveLayer(long var0, long var2, int var4);

    private static native int nSaveLayerAlpha(long var0, float var2, float var3, float var4, float var5, int var6, int var7);

    private static native int nSaveLayerAlpha(long var0, int var2, int var3);

    private static native void nScale(long var0, float var2, float var3);

    private static native void nSetHighContrastText(long var0, boolean var2);

    private static native void nSetMatrix(long var0, long var2);

    private static native void nSetProperty(String var0, String var1);

    private static native void nSetViewport(long var0, int var2, int var3);

    private static native void nSetupPaintFilter(long var0, int var2, int var3);

    private static native void nSkew(long var0, float var2, float var3);

    private static native void nTranslate(long var0, float var2, float var3);

    public static void setProperty(String string2, String string3) {
        GLES20Canvas.nSetProperty(string2, string3);
    }

    private void setupFinalizer() {
        if (this.mRenderer == 0L) {
            throw new IllegalStateException("Could not create GLES20Canvas renderer");
        }
        this.mFinalizer = new CanvasFinalizer(this.mRenderer);
    }

    @Override
    public int callDrawGLFunction(long l) {
        return GLES20Canvas.nCallDrawGLFunction(this.mRenderer, l);
    }

    @Override
    public boolean clipPath(Path path) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipPath(Path path, Region.Op op) {
        return GLES20Canvas.nClipPath(this.mRenderer, path.mNativePath, op.nativeInt);
    }

    @Override
    public boolean clipRect(float f, float f2, float f3, float f4) {
        return GLES20Canvas.nClipRect(this.mRenderer, f, f2, f3, f4, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(float f, float f2, float f3, float f4, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, f, f2, f3, f4, op.nativeInt);
    }

    @Override
    public boolean clipRect(int n, int n2, int n3, int n4) {
        return GLES20Canvas.nClipRect(this.mRenderer, n, n2, n3, n4, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(Rect rect) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(Rect rect, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rectF) {
        return GLES20Canvas.nClipRect(this.mRenderer, rectF.left, rectF.top, rectF.right, rectF.bottom, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRect(RectF rectF, Region.Op op) {
        return GLES20Canvas.nClipRect(this.mRenderer, rectF.left, rectF.top, rectF.right, rectF.bottom, op.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, Region.Op.INTERSECT.nativeInt);
    }

    @Override
    public boolean clipRegion(Region region, Region.Op op) {
        return GLES20Canvas.nClipRegion(this.mRenderer, region.mNativeRegion, op.nativeInt);
    }

    @Override
    public void concat(Matrix matrix) {
        if (matrix != null) {
            GLES20Canvas.nConcatMatrix(this.mRenderer, matrix.native_instance);
        }
    }

    @Override
    public void drawARGB(int n, int n2, int n3, int n4) {
        this.drawColor((n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF);
    }

    @Override
    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Paint paint) {
        GLES20Canvas.nDrawArc(this.mRenderer, f, f2, f3, f4, f5, f6, bl, paint.mNativePaint);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, f, f2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, matrix.native_instance, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        int n;
        int n2;
        int n3;
        int n4;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        if (rect == null) {
            n4 = 0;
            n3 = 0;
            n2 = bitmap.getWidth();
            n = bitmap.getHeight();
        } else {
            n3 = rect.left;
            n2 = rect.right;
            n4 = rect.top;
            n = rect.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, n3, n4, n2, n, rect2.left, rect2.top, rect2.right, rect2.bottom, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        float f;
        float f2;
        float f3;
        float f4;
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        if (rect == null) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = bitmap.getWidth();
            f = bitmap.getHeight();
        } else {
            f3 = rect.left;
            f2 = rect.right;
            f4 = rect.top;
            f = rect.bottom;
        }
        GLES20Canvas.nDrawBitmap(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, f3, f4, f2, f, rectF.left, rectF.top, rectF.right, rectF.bottom, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        if (n3 < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(n2) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n5 = n + n2 * (n4 - 1);
        int n6 = nArray.length;
        if (n < 0 || n + n3 > n6 || n5 < 0 || n5 + n3 > n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmap(this.mRenderer, nArray, n, n2, f, f2, n3, n4, bl, l);
    }

    @Override
    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        this.drawBitmap(nArray, n, n2, (float)n3, (float)n4, n5, n6, bl, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        GLES20Canvas.throwIfCannotDraw(bitmap);
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        int n5 = (n + 1) * (n2 + 1);
        GLES20Canvas.checkRange(fArray.length, n3, n5 * 2);
        if (nArray != null) {
            GLES20Canvas.checkRange(nArray.length, n4, n5);
        }
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawBitmapMesh(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, n, n2, fArray, n3, nArray, n4, l);
    }

    @Override
    public void drawCircle(float f, float f2, float f3, Paint paint) {
        GLES20Canvas.nDrawCircle(this.mRenderer, f, f2, f3, paint.mNativePaint);
    }

    @Override
    public void drawCircle(CanvasProperty<Float> canvasProperty, CanvasProperty<Float> canvasProperty2, CanvasProperty<Float> canvasProperty3, CanvasProperty<Paint> canvasProperty4) {
        GLES20Canvas.nDrawCircle(this.mRenderer, canvasProperty.getNativeContainer(), canvasProperty2.getNativeContainer(), canvasProperty3.getNativeContainer(), canvasProperty4.getNativeContainer());
    }

    @Override
    public void drawColor(int n) {
        this.drawColor(n, PorterDuff.Mode.SRC_OVER);
    }

    @Override
    public void drawColor(int n, PorterDuff.Mode mode) {
        GLES20Canvas.nDrawColor(this.mRenderer, n, mode.nativeInt);
    }

    @Override
    void drawHardwareLayer(HardwareLayer hardwareLayer, float f, float f2, Paint paint) {
        hardwareLayer.setLayerPaint(paint);
        GLES20Canvas.nDrawLayer(this.mRenderer, hardwareLayer.getLayer(), f, f2);
    }

    @Override
    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        float[] fArray = this.getLineStorage();
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f4;
        this.drawLines(fArray, 0, 4, paint);
    }

    @Override
    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        if (n2 < 4) {
            return;
        }
        if ((n | n2) < 0 || n + n2 > fArray.length) {
            throw new IllegalArgumentException("The lines array must contain 4 elements per line.");
        }
        GLES20Canvas.nDrawLines(this.mRenderer, fArray, n, n2, paint.mNativePaint);
    }

    @Override
    public void drawLines(float[] fArray, Paint paint) {
        this.drawLines(fArray, 0, fArray.length, paint);
    }

    @Override
    public void drawOval(float f, float f2, float f3, float f4, Paint paint) {
        GLES20Canvas.nDrawOval(this.mRenderer, f, f2, f3, f4, paint.mNativePaint);
    }

    @Override
    public void drawPaint(Paint paint) {
        Rect rect = this.getInternalClipBounds();
        GLES20Canvas.nGetClipBounds(this.mRenderer, rect);
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawPatch(NinePatch ninePatch, Rect rect, Paint paint) {
        Bitmap bitmap = ninePatch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, ninePatch.mNativeChunk, rect.left, rect.top, rect.right, rect.bottom, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawPatch(NinePatch ninePatch, RectF rectF, Paint paint) {
        Bitmap bitmap = ninePatch.getBitmap();
        GLES20Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        GLES20Canvas.nDrawPatch(this.mRenderer, bitmap.mNativeBitmap, bitmap.mBuffer, ninePatch.mNativeChunk, rectF.left, rectF.top, rectF.right, rectF.bottom, l);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath) {
            if (path.rects != null) {
                GLES20Canvas.nDrawRects(this.mRenderer, path.rects.mNativeRegion, paint.mNativePaint);
            }
            return;
        }
        GLES20Canvas.nDrawPath(this.mRenderer, path.mNativePath, paint.mNativePaint);
    }

    @Override
    public void drawPicture(Picture picture) {
        picture.endRecording();
    }

    @Override
    public void drawPoint(float f, float f2, Paint paint) {
        float[] fArray = this.getPointStorage();
        fArray[0] = f;
        fArray[1] = f2;
        this.drawPoints(fArray, 0, 2, paint);
    }

    @Override
    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        if (n2 < 2) {
            return;
        }
        GLES20Canvas.nDrawPoints(this.mRenderer, fArray, n, n2, paint.mNativePaint);
    }

    @Override
    public void drawPoints(float[] fArray, Paint paint) {
        this.drawPoints(fArray, 0, fArray.length, paint);
    }

    @Override
    public void drawRGB(int n, int n2, int n3) {
        this.drawColor(0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF);
    }

    @Override
    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        if (f == f3 || f2 == f4) {
            return;
        }
        GLES20Canvas.nDrawRect(this.mRenderer, f, f2, f3, f4, paint.mNativePaint);
    }

    @Override
    public void drawRect(Rect rect, Paint paint) {
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    @Override
    public void drawRect(RectF rectF, Paint paint) {
        this.drawRect(rectF.left, rectF.top, rectF.right, rectF.bottom, paint);
    }

    @Override
    public int drawRenderNode(RenderNode renderNode, Rect rect, int n) {
        return GLES20Canvas.nDrawRenderNode(this.mRenderer, renderNode.getNativeDisplayList(), rect, n);
    }

    @Override
    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Paint paint) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, f, f2, f3, f4, f5, f6, paint.mNativePaint);
    }

    @Override
    public void drawRoundRect(CanvasProperty<Float> canvasProperty, CanvasProperty<Float> canvasProperty2, CanvasProperty<Float> canvasProperty3, CanvasProperty<Float> canvasProperty4, CanvasProperty<Float> canvasProperty5, CanvasProperty<Float> canvasProperty6, CanvasProperty<Paint> canvasProperty7) {
        GLES20Canvas.nDrawRoundRect(this.mRenderer, canvasProperty.getNativeContainer(), canvasProperty2.getNativeContainer(), canvasProperty3.getNativeContainer(), canvasProperty4.getNativeContainer(), canvasProperty5.getNativeContainer(), canvasProperty6.getNativeContainer(), canvasProperty7.getNativeContainer());
    }

    @Override
    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        paint.set(paint);
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            GLES20Canvas.nDrawText(this.mRenderer, charSequence.toString(), n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
            return;
        }
        if (charSequence instanceof GraphicsOperations) {
            ((GraphicsOperations)charSequence).drawText(this, n, n2, f, f2, paint);
            return;
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        GLES20Canvas.nDrawText(this.mRenderer, cArray, 0, n2 - n, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        TemporaryBuffer.recycle(cArray);
    }

    @Override
    public void drawText(String string2, float f, float f2, Paint paint) {
        paint.set(paint);
        GLES20Canvas.nDrawText(this.mRenderer, string2, 0, string2.length(), f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        GLES20Canvas.nDrawText(this.mRenderer, string2, n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        if ((n | n2 | n + n2 | cArray.length - n - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        GLES20Canvas.nDrawText(this.mRenderer, cArray, n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        if (string2.length() == 0) {
            return;
        }
        paint.set(paint);
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, string2, 0, string2.length(), path.mNativePath, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        if (n < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        paint.set(paint);
        GLES20Canvas.nDrawTextOnPath(this.mRenderer, cArray, n, n2, path.mNativePath, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawTextRun(CharSequence charSequence, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        if ((n | n2 | n2 - n | charSequence.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            GLES20Canvas.nDrawTextRun(this.mRenderer, charSequence.toString(), n, n2, n3, n4, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
            return;
        }
        if (charSequence instanceof GraphicsOperations) {
            ((GraphicsOperations)charSequence).drawTextRun(this, n, n2, n3, n4, f, f2, bl, paint);
            return;
        }
        int n5 = n4 - n3;
        int n6 = n2 - n;
        char[] cArray = TemporaryBuffer.obtain(n5);
        TextUtils.getChars(charSequence, n3, n4, cArray, 0);
        GLES20Canvas.nDrawTextRun(this.mRenderer, cArray, n - n3, n6, 0, n5, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
        TemporaryBuffer.recycle(cArray);
    }

    @Override
    public void drawTextRun(char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        if ((n | n2 | cArray.length - n - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        GLES20Canvas.nDrawTextRun(this.mRenderer, cArray, n, n2, n3, n4, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
    }

    @Override
    public void drawVertices(Canvas.VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
    }

    @Override
    public boolean getClipBounds(Rect rect) {
        return GLES20Canvas.nGetClipBounds(this.mRenderer, rect);
    }

    @Override
    public DrawFilter getDrawFilter() {
        return this.mFilter;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public void getMatrix(Matrix matrix) {
        GLES20Canvas.nGetMatrix(this.mRenderer, matrix.native_instance);
    }

    @Override
    public int getMaximumBitmapHeight() {
        return GLES20Canvas.nGetMaximumTextureHeight();
    }

    @Override
    public int getMaximumBitmapWidth() {
        return GLES20Canvas.nGetMaximumTextureWidth();
    }

    long getRenderer() {
        return this.mRenderer;
    }

    @Override
    public int getSaveCount() {
        return GLES20Canvas.nGetSaveCount(this.mRenderer);
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public void insertInorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, false);
    }

    @Override
    public void insertReorderBarrier() {
        GLES20Canvas.nInsertReorderBarrier(this.mRenderer, true);
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public void onPostDraw() {
        GLES20Canvas.nFinish(this.mRenderer);
    }

    @Override
    public int onPreDraw(Rect rect) {
        if (rect != null) {
            return GLES20Canvas.nPrepareDirty(this.mRenderer, rect.left, rect.top, rect.right, rect.bottom, this.mOpaque);
        }
        return GLES20Canvas.nPrepare(this.mRenderer, this.mOpaque);
    }

    @Override
    public boolean quickReject(float f, float f2, float f3, float f4, Canvas.EdgeType edgeType) {
        return GLES20Canvas.nQuickReject(this.mRenderer, f, f2, f3, f4);
    }

    @Override
    public boolean quickReject(Path path, Canvas.EdgeType edgeType) {
        RectF rectF = this.getPathBounds();
        path.computeBounds(rectF, true);
        return GLES20Canvas.nQuickReject(this.mRenderer, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    @Override
    public boolean quickReject(RectF rectF, Canvas.EdgeType edgeType) {
        return GLES20Canvas.nQuickReject(this.mRenderer, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    @Override
    public void restore() {
        GLES20Canvas.nRestore(this.mRenderer);
    }

    @Override
    public void restoreToCount(int n) {
        GLES20Canvas.nRestoreToCount(this.mRenderer, n);
    }

    @Override
    public void rotate(float f) {
        GLES20Canvas.nRotate(this.mRenderer, f);
    }

    @Override
    public int save() {
        return GLES20Canvas.nSave(this.mRenderer, 3);
    }

    @Override
    public int save(int n) {
        return GLES20Canvas.nSave(this.mRenderer, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int saveLayer(float f, float f2, float f3, float f4, Paint paint, int n) {
        long l;
        if (!(f < f3) || !(f2 < f4)) return this.save(n);
        if (paint == null) {
            l = 0L;
            return GLES20Canvas.nSaveLayer(this.mRenderer, f, f2, f3, f4, l, n);
        }
        l = paint.mNativePaint;
        return GLES20Canvas.nSaveLayer(this.mRenderer, f, f2, f3, f4, l, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int saveLayer(RectF rectF, Paint paint, int n) {
        long l;
        if (rectF != null) {
            return this.saveLayer(rectF.left, rectF.top, rectF.right, rectF.bottom, paint, n);
        }
        if (paint == null) {
            l = 0L;
            return GLES20Canvas.nSaveLayer(this.mRenderer, l, n);
        }
        l = paint.mNativePaint;
        return GLES20Canvas.nSaveLayer(this.mRenderer, l, n);
    }

    @Override
    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n, int n2) {
        if (f < f3 && f2 < f4) {
            return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, f, f2, f3, f4, n, n2);
        }
        return this.save(n2);
    }

    @Override
    public int saveLayerAlpha(RectF rectF, int n, int n2) {
        if (rectF != null) {
            return this.saveLayerAlpha(rectF.left, rectF.top, rectF.right, rectF.bottom, n, n2);
        }
        return GLES20Canvas.nSaveLayerAlpha(this.mRenderer, n, n2);
    }

    @Override
    public void scale(float f, float f2) {
        GLES20Canvas.nScale(this.mRenderer, f, f2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDrawFilter(DrawFilter drawFilter) {
        this.mFilter = drawFilter;
        if (drawFilter == null) {
            GLES20Canvas.nResetPaintFilter(this.mRenderer);
            return;
        } else {
            if (!(drawFilter instanceof PaintFlagsDrawFilter)) return;
            PaintFlagsDrawFilter paintFlagsDrawFilter = (PaintFlagsDrawFilter)drawFilter;
            GLES20Canvas.nSetupPaintFilter(this.mRenderer, paintFlagsDrawFilter.clearBits, paintFlagsDrawFilter.setBits);
            return;
        }
    }

    @Override
    public void setHighContrastText(boolean bl) {
        GLES20Canvas.nSetHighContrastText(this.mRenderer, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMatrix(Matrix matrix) {
        long l = this.mRenderer;
        long l2 = matrix == null ? 0L : matrix.native_instance;
        GLES20Canvas.nSetMatrix(l, l2);
    }

    @Override
    public void setViewport(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        GLES20Canvas.nSetViewport(this.mRenderer, n, n2);
    }

    @Override
    public void skew(float f, float f2) {
        GLES20Canvas.nSkew(this.mRenderer, f, f2);
    }

    @Override
    public void translate(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            GLES20Canvas.nTranslate(this.mRenderer, f, f2);
        }
    }

    private static final class CanvasFinalizer {
        private final long mRenderer;

        public CanvasFinalizer(long l) {
            this.mRenderer = l;
        }

        protected void finalize() throws Throwable {
            try {
                GLES20Canvas.nDestroyRenderer(this.mRenderer);
                return;
            }
            finally {
                super.finalize();
            }
        }
    }
}

