/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.InputChannel;
import android.view.InputEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public abstract class InputEventReceiver {
    private static final String TAG = "InputEventReceiver";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;
    private long mReceiverPtr;
    private final SparseIntArray mSeqMap = new SparseIntArray();

    public InputEventReceiver(InputChannel inputChannel, Looper looper) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = InputEventReceiver.nativeInit(new WeakReference<InputEventReceiver>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    private void dispatchBatchedInputEventPending() {
        this.onBatchedInputEventPending();
    }

    private void dispatchInputEvent(int n, InputEvent inputEvent) {
        this.mSeqMap.put(inputEvent.getSequenceNumber(), n);
        this.onInputEvent(inputEvent);
    }

    private void dispose(boolean bl) {
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            InputEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    private static native boolean nativeConsumeBatchedInputEvents(long var0, long var2);

    private static native void nativeDispose(long var0);

    private static native void nativeFinishInputEvent(long var0, int var2, boolean var3);

    private static native long nativeInit(WeakReference<InputEventReceiver> var0, InputChannel var1, MessageQueue var2);

    public final boolean consumeBatchedInputEvents(long l) {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to consume batched input events but the input event receiver has already been disposed.");
            return false;
        }
        return InputEventReceiver.nativeConsumeBatchedInputEvents(this.mReceiverPtr, l);
    }

    public void dispose() {
        this.dispose(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void finishInputEvent(InputEvent inputEvent, boolean bl) {
        if (inputEvent == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to finish an input event but the input event receiver has already been disposed.");
        } else {
            int n = this.mSeqMap.indexOfKey(inputEvent.getSequenceNumber());
            if (n < 0) {
                Log.w(TAG, "Attempted to finish an input event that is not in progress.");
            } else {
                int n2 = this.mSeqMap.valueAt(n);
                this.mSeqMap.removeAt(n);
                InputEventReceiver.nativeFinishInputEvent(this.mReceiverPtr, n2, bl);
            }
        }
        inputEvent.recycleIfNeededAfterDispatch();
    }

    public void onBatchedInputEventPending() {
        this.consumeBatchedInputEvents(-1L);
    }

    public void onInputEvent(InputEvent inputEvent) {
        this.finishInputEvent(inputEvent, false);
    }

    public static interface Factory {
        public InputEventReceiver createInputEventReceiver(InputChannel var1, Looper var2);
    }
}

