/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.SystemClock;
import android.util.FloatMath;
import android.view.GestureDetector;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final int DOUBLE_TAP_MODE_IN_PROGRESS = 1;
    private static final int DOUBLE_TAP_MODE_NONE = 0;
    private static final float SCALE_FACTOR = 0.5f;
    private static final String TAG = "ScaleGestureDetector";
    private static final long TOUCH_STABILIZE_TIME = 128L;
    private final Context mContext;
    private float mCurrSpan;
    private float mCurrSpanX;
    private float mCurrSpanY;
    private long mCurrTime;
    private MotionEvent mDoubleTapEvent;
    private int mDoubleTapMode = 0;
    private boolean mEventBeforeOrAboveStartingGestureEvent;
    private float mFocusX;
    private float mFocusY;
    private GestureDetector mGestureDetector;
    private final Handler mHandler;
    private boolean mInProgress;
    private float mInitialSpan;
    private final InputEventConsistencyVerifier mInputEventConsistencyVerifier;
    private final OnScaleGestureListener mListener;
    private int mMinSpan;
    private float mPrevSpan;
    private float mPrevSpanX;
    private float mPrevSpanY;
    private long mPrevTime;
    private boolean mQuickScaleEnabled;
    private int mSpanSlop;
    private int mTouchHistoryDirection;
    private float mTouchHistoryLastAccepted;
    private long mTouchHistoryLastAcceptedTime;
    private float mTouchLower;
    private int mTouchMinMajor;
    private float mTouchUpper;

    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener) {
        this(context, onScaleGestureListener, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener, Handler handler) {
        InputEventConsistencyVerifier inputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
        this.mInputEventConsistencyVerifier = inputEventConsistencyVerifier;
        this.mContext = context;
        this.mListener = onScaleGestureListener;
        this.mSpanSlop = 2 * ViewConfiguration.get(context).getScaledTouchSlop();
        Resources resources = context.getResources();
        this.mTouchMinMajor = resources.getDimensionPixelSize(17104910);
        this.mMinSpan = resources.getDimensionPixelSize(17104909);
        this.mHandler = handler;
        if (context.getApplicationInfo().targetSdkVersion > 18) {
            this.setQuickScaleEnabled(true);
        }
    }

    static /* synthetic */ MotionEvent access$002(ScaleGestureDetector scaleGestureDetector, MotionEvent motionEvent) {
        scaleGestureDetector.mDoubleTapEvent = motionEvent;
        return motionEvent;
    }

    static /* synthetic */ int access$102(ScaleGestureDetector scaleGestureDetector, int n) {
        scaleGestureDetector.mDoubleTapMode = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addTouchHistory(MotionEvent motionEvent) {
        long l = SystemClock.uptimeMillis();
        int n = motionEvent.getPointerCount();
        boolean bl = l - this.mTouchHistoryLastAcceptedTime >= 128L;
        float f = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            boolean bl2;
            if (n3 < n) {
                bl2 = !Float.isNaN(this.mTouchHistoryLastAccepted);
                n5 = motionEvent.getHistorySize();
                n4 = n5 + 1;
            } else {
                float f2 = f / (float)n2;
                if (bl) {
                    float f3 = (f2 + (this.mTouchUpper + this.mTouchLower)) / 3.0f;
                    this.mTouchUpper = (f3 + this.mTouchUpper) / 2.0f;
                    this.mTouchLower = (f3 + this.mTouchLower) / 2.0f;
                    this.mTouchHistoryLastAccepted = f3;
                    this.mTouchHistoryDirection = 0;
                    this.mTouchHistoryLastAcceptedTime = motionEvent.getEventTime();
                }
                return;
            }
            for (int i = 0; i < n4; ++i) {
                int n6;
                float f4 = i < n5 ? motionEvent.getHistoricalTouchMajor(n3, i) : motionEvent.getTouchMajor(n3);
                if (f4 < (float)this.mTouchMinMajor) {
                    f4 = this.mTouchMinMajor;
                }
                f += f4;
                if (Float.isNaN(this.mTouchUpper) || f4 > this.mTouchUpper) {
                    this.mTouchUpper = f4;
                }
                if (Float.isNaN(this.mTouchLower) || f4 < this.mTouchLower) {
                    this.mTouchLower = f4;
                }
                if (!bl2 || (n6 = (int)Math.signum(f4 - this.mTouchHistoryLastAccepted)) == this.mTouchHistoryDirection && (n6 != 0 || this.mTouchHistoryDirection != 0)) continue;
                this.mTouchHistoryDirection = n6;
                long l2 = i < n5 ? motionEvent.getHistoricalEventTime(i) : motionEvent.getEventTime();
                this.mTouchHistoryLastAcceptedTime = l2;
                bl = false;
            }
            n2 += n4;
            ++n3;
        }
    }

    private void clearTouchHistory() {
        this.mTouchUpper = Float.NaN;
        this.mTouchLower = Float.NaN;
        this.mTouchHistoryLastAccepted = Float.NaN;
        this.mTouchHistoryDirection = 0;
        this.mTouchHistoryLastAcceptedTime = 0L;
    }

    private boolean inDoubleTapMode() {
        return this.mDoubleTapMode == 1;
    }

    public float getCurrentSpan() {
        return this.mCurrSpan;
    }

    public float getCurrentSpanX() {
        return this.mCurrSpanX;
    }

    public float getCurrentSpanY() {
        return this.mCurrSpanY;
    }

    public long getEventTime() {
        return this.mCurrTime;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getPreviousSpan() {
        return this.mPrevSpan;
    }

    public float getPreviousSpanX() {
        return this.mPrevSpanX;
    }

    public float getPreviousSpanY() {
        return this.mPrevSpanY;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getScaleFactor() {
        if (this.inDoubleTapMode()) {
            boolean bl = this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan < this.mPrevSpan || !this.mEventBeforeOrAboveStartingGestureEvent && this.mCurrSpan > this.mPrevSpan;
            float f = 0.5f * Math.abs(1.0f - this.mCurrSpan / this.mPrevSpan);
            if (this.mPrevSpan <= 0.0f) return 1.0f;
            if (!bl) return 1.0f - f;
            return 1.0f + f;
        }
        if (this.mPrevSpan > 0.0f) return this.mCurrSpan / this.mPrevSpan;
        return 1.0f;
    }

    public long getTimeDelta() {
        return this.mCurrTime - this.mPrevTime;
    }

    public boolean isInProgress() {
        return this.mInProgress;
    }

    public boolean isQuickScaleEnabled() {
        return this.mQuickScaleEnabled;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block31: {
            block30: {
                block32: {
                    block29: {
                        block28: {
                            block33: {
                                block36: {
                                    block35: {
                                        block27: {
                                            block26: {
                                                block34: {
                                                    if (this.mInputEventConsistencyVerifier != null) {
                                                        this.mInputEventConsistencyVerifier.onTouchEvent(var1_1, 0);
                                                    }
                                                    this.mCurrTime = var1_1.getEventTime();
                                                    var2_2 = var1_1.getActionMasked();
                                                    if (this.mQuickScaleEnabled) {
                                                        this.mGestureDetector.onTouchEvent(var1_1);
                                                    }
                                                    if (var2_2 != 1 && var2_2 != 3) break block34;
                                                    var3_3 = true;
lbl10:
                                                    // 2 sources

                                                    while (var2_2 == 0 || var3_3) {
                                                        if (!this.mInProgress) break block26;
                                                        this.mListener.onScaleEnd(this);
                                                        this.mInProgress = false;
                                                        this.mInitialSpan = 0.0f;
                                                        this.mDoubleTapMode = 0;
lbl16:
                                                        // 3 sources

                                                        while (var3_3) {
                                                            this.clearTouchHistory();
                                                            return true;
                                                        }
                                                        break block27;
                                                    }
                                                    break block27;
                                                }
                                                var3_3 = false;
                                                ** GOTO lbl10
                                            }
                                            if (this.mDoubleTapMode != 1 || !var3_3) ** GOTO lbl16
                                            this.mInProgress = false;
                                            this.mInitialSpan = 0.0f;
                                            this.mDoubleTapMode = 0;
                                            ** GOTO lbl16
                                        }
                                        if (var2_2 != 0 && var2_2 != 6 && var2_2 != 5) break block35;
                                        var4_4 = true;
lbl33:
                                        // 2 sources

                                        while (var2_2 == 6) {
                                            var5_5 = true;
lbl35:
                                            // 2 sources

                                            while (var5_5) {
                                                var6_6 = var1_1.getActionIndex();
lbl37:
                                                // 2 sources

                                                while (true) {
                                                    var7_7 = 0.0f;
                                                    var8_8 = 0.0f;
                                                    var9_9 = var1_1.getPointerCount();
                                                    if (!var5_5) break block28;
                                                    var10_10 = var9_9 - 1;
lbl43:
                                                    // 2 sources

                                                    while (this.mDoubleTapMode == 1) {
                                                        var12_11 = this.mDoubleTapEvent.getX();
                                                        var13_12 = this.mDoubleTapEvent.getY();
                                                        if (!(var1_1.getY() < var13_12)) break block29;
                                                        this.mEventBeforeOrAboveStartingGestureEvent = true;
lbl48:
                                                        // 3 sources

                                                        while (true) {
                                                            this.addTouchHistory(var1_1);
                                                            var14_14 = 0.0f;
                                                            var15_15 = 0.0f;
                                                            block7: for (var16_16 = 0; var16_16 < var9_9; ++var16_16) {
                                                                if (var6_6 == var16_16) lbl-1000:
                                                                // 2 sources

                                                                {
                                                                    continue block7;
                                                                }
                                                                break block30;
                                                            }
                                                            break block31;
                                                            break;
                                                        }
                                                    }
                                                    break block32;
                                                    break;
                                                }
                                            }
                                            break block33;
                                        }
                                        break block36;
                                    }
                                    var4_4 = false;
                                    ** GOTO lbl33
                                }
                                var5_5 = false;
                                ** GOTO lbl35
                            }
                            var6_6 = -1;
                            ** while (true)
                        }
                        var10_10 = var9_9;
                        ** GOTO lbl43
                    }
                    this.mEventBeforeOrAboveStartingGestureEvent = false;
                    ** GOTO lbl48
                }
                block9: for (var11_13 = 0; var11_13 < var9_9; ++var11_13) {
                    if (var6_6 == var11_13) lbl-1000:
                    // 2 sources

                    {
                        continue block9;
                    }
                    var7_7 += var1_1.getX(var11_13);
                    var8_8 += var1_1.getY(var11_13);
                    ** continue;
                }
                var12_11 = var7_7 / (float)var10_10;
                var13_12 = var8_8 / (float)var10_10;
                ** while (true)
            }
            var25_17 = this.mTouchHistoryLastAccepted / 2.0f;
            var14_14 += var25_17 + Math.abs(var1_1.getX(var16_16) - var12_11);
            var15_15 += var25_17 + Math.abs(var1_1.getY(var16_16) - var13_12);
            ** while (true)
        }
        var17_18 = var14_14 / (float)var10_10;
        var18_19 = var15_15 / (float)var10_10;
        var19_20 = var17_18 * 2.0f;
        var20_21 = var18_19 * 2.0f;
        if (this.inDoubleTapMode()) {
            var21_22 = var20_21;
lbl99:
            // 2 sources

            while (true) {
                var22_23 = this.mInProgress;
                this.mFocusX = var12_11;
                this.mFocusY = var13_12;
                if (!this.inDoubleTapMode() && this.mInProgress && (var21_22 < (float)this.mMinSpan || var4_4)) {
                    this.mListener.onScaleEnd(this);
                    this.mInProgress = false;
                    this.mInitialSpan = var21_22;
                    this.mDoubleTapMode = 0;
                }
                if (var4_4) {
                    this.mCurrSpanX = var19_20;
                    this.mPrevSpanX = var19_20;
                    this.mCurrSpanY = var20_21;
                    this.mPrevSpanY = var20_21;
                    this.mCurrSpan = var21_22;
                    this.mPrevSpan = var21_22;
                    this.mInitialSpan = var21_22;
                }
                if (this.inDoubleTapMode()) {
                    var23_24 = this.mSpanSlop;
lbl118:
                    // 2 sources

                    while (true) {
                        if (!this.mInProgress && var21_22 >= (float)var23_24 && (var22_23 || Math.abs(var21_22 - this.mInitialSpan) > (float)this.mSpanSlop)) {
                            this.mCurrSpanX = var19_20;
                            this.mPrevSpanX = var19_20;
                            this.mCurrSpanY = var20_21;
                            this.mPrevSpanY = var20_21;
                            this.mCurrSpan = var21_22;
                            this.mPrevSpan = var21_22;
                            this.mPrevTime = this.mCurrTime;
                            this.mInProgress = this.mListener.onScaleBegin(this);
                        }
                        if (var2_2 == 2) {
                            this.mCurrSpanX = var19_20;
                            this.mCurrSpanY = var20_21;
                            this.mCurrSpan = var21_22;
                            var24_25 = true;
                            if (this.mInProgress) {
                                var24_25 = this.mListener.onScale(this);
                            }
                            if (var24_25) {
                                this.mPrevSpanX = this.mCurrSpanX;
                                this.mPrevSpanY = this.mCurrSpanY;
                                this.mPrevSpan = this.mCurrSpan;
                                this.mPrevTime = this.mCurrTime;
                            }
                        }
                        return true;
                    }
                }
                break;
            }
        } else {
            var21_22 = FloatMath.sqrt(var19_20 * var19_20 + var20_21 * var20_21);
            ** continue;
        }
        var23_24 = this.mMinSpan;
        ** while (true)
    }

    public void setQuickScaleEnabled(boolean bl) {
        this.mQuickScaleEnabled = bl;
        if (this.mQuickScaleEnabled && this.mGestureDetector == null) {
            GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

                @Override
                public boolean onDoubleTap(MotionEvent motionEvent) {
                    ScaleGestureDetector.access$002(ScaleGestureDetector.this, motionEvent);
                    ScaleGestureDetector.access$102(ScaleGestureDetector.this, 1);
                    return true;
                }
            };
            this.mGestureDetector = new GestureDetector(this.mContext, simpleOnGestureListener, this.mHandler);
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        @Override
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            return false;
        }

        @Override
        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            return true;
        }

        @Override
        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        }
    }
}

