/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.ref.WeakReference;

@RemoteViews.RemoteView
public final class ViewStub
extends View {
    private OnInflateListener mInflateListener;
    private int mInflatedId;
    private WeakReference<View> mInflatedViewRef;
    private LayoutInflater mInflater;
    private int mLayoutResource = 0;

    public ViewStub(Context context) {
        this.initialize(context);
    }

    public ViewStub(Context context, int n) {
        this.mLayoutResource = n;
        this.initialize(context);
    }

    public ViewStub(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ViewStub(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ViewStub(Context context, AttributeSet attributeSet, int n, int n2) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewStub, n, n2);
        this.mInflatedId = typedArray.getResourceId(1, -1);
        this.mLayoutResource = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.View, n, n2);
        this.mID = typedArray2.getResourceId(9, -1);
        typedArray2.recycle();
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.mContext = context;
        this.setVisibility(8);
        this.setWillNotDraw(true);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
    }

    @Override
    public void draw(Canvas canvas) {
    }

    public int getInflatedId() {
        return this.mInflatedId;
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public int getLayoutResource() {
        return this.mLayoutResource;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View inflate() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (this.mLayoutResource == 0) {
                throw new IllegalArgumentException("ViewStub must have a valid layoutResource");
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            LayoutInflater layoutInflater = this.mInflater != null ? this.mInflater : LayoutInflater.from(this.mContext);
            View view = layoutInflater.inflate(this.mLayoutResource, viewGroup, false);
            if (this.mInflatedId != -1) {
                view.setId(this.mInflatedId);
            }
            int n = viewGroup.indexOfChild(this);
            viewGroup.removeViewInLayout(this);
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams != null) {
                viewGroup.addView(view, n, layoutParams);
            } else {
                viewGroup.addView(view, n);
            }
            this.mInflatedViewRef = new WeakReference<View>(view);
            if (this.mInflateListener != null) {
                this.mInflateListener.onInflate(this, view);
            }
            return view;
        }
        throw new IllegalStateException("ViewStub must have a non-null ViewGroup viewParent");
    }

    @Override
    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(0, 0);
    }

    @RemotableViewMethod
    public void setInflatedId(int n) {
        this.mInflatedId = n;
    }

    public void setLayoutInflater(LayoutInflater layoutInflater) {
        this.mInflater = layoutInflater;
    }

    @RemotableViewMethod
    public void setLayoutResource(int n) {
        this.mLayoutResource = n;
    }

    public void setOnInflateListener(OnInflateListener onInflateListener) {
        this.mInflateListener = onInflateListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        if (this.mInflatedViewRef != null) {
            View view = (View)this.mInflatedViewRef.get();
            if (view == null) {
                throw new IllegalStateException("setVisibility called on un-referenced view");
            }
            view.setVisibility(n);
            return;
        } else {
            super.setVisibility(n);
            if (n != 0 && n != 4) return;
            this.inflate();
            return;
        }
    }

    public static interface OnInflateListener {
        public void onInflate(ViewStub var1, View var2);
    }
}

