/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class AnticipateInterpolator
implements Interpolator,
NativeInterpolatorFactory {
    private final float mTension;

    public AnticipateInterpolator() {
        this.mTension = 2.0f;
    }

    public AnticipateInterpolator(float f) {
        this.mTension = f;
    }

    public AnticipateInterpolator(Context context, AttributeSet attributeSet) {
        this(context.getResources(), context.getTheme(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AnticipateInterpolator(Resources resources, Resources.Theme theme, AttributeSet attributeSet) {
        TypedArray typedArray = theme != null ? theme.obtainStyledAttributes(attributeSet, R.styleable.AnticipateInterpolator, 0, 0) : resources.obtainAttributes(attributeSet, R.styleable.AnticipateInterpolator);
        this.mTension = typedArray.getFloat(0, 2.0f);
        typedArray.recycle();
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createAnticipateInterpolator(this.mTension);
    }

    @Override
    public float getInterpolation(float f) {
        return f * f * (f * (1.0f + this.mTension) - this.mTension);
    }
}

