/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.inputmethod.SparseRectFArray;
import java.util.Objects;

public final class CursorAnchorInfo
implements Parcelable {
    public static final Parcelable.Creator<CursorAnchorInfo> CREATOR = new Parcelable.Creator<CursorAnchorInfo>(){

        @Override
        public CursorAnchorInfo createFromParcel(Parcel parcel) {
            return new CursorAnchorInfo(parcel);
        }

        public CursorAnchorInfo[] newArray(int n) {
            return new CursorAnchorInfo[n];
        }
    };
    public static final int FLAG_HAS_INVISIBLE_REGION = 2;
    public static final int FLAG_HAS_VISIBLE_REGION = 1;
    public static final int FLAG_IS_RTL = 4;
    private final SparseRectFArray mCharacterBoundsArray;
    private final CharSequence mComposingText;
    private final int mComposingTextStart;
    private final float mInsertionMarkerBaseline;
    private final float mInsertionMarkerBottom;
    private final int mInsertionMarkerFlags;
    private final float mInsertionMarkerHorizontal;
    private final float mInsertionMarkerTop;
    private final Matrix mMatrix;
    private final int mSelectionEnd;
    private final int mSelectionStart;

    public CursorAnchorInfo(Parcel parcel) {
        this.mSelectionStart = parcel.readInt();
        this.mSelectionEnd = parcel.readInt();
        this.mComposingTextStart = parcel.readInt();
        this.mComposingText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mInsertionMarkerFlags = parcel.readInt();
        this.mInsertionMarkerHorizontal = parcel.readFloat();
        this.mInsertionMarkerTop = parcel.readFloat();
        this.mInsertionMarkerBaseline = parcel.readFloat();
        this.mInsertionMarkerBottom = parcel.readFloat();
        this.mCharacterBoundsArray = (SparseRectFArray)parcel.readParcelable(SparseRectFArray.class.getClassLoader());
        this.mMatrix = new Matrix();
        this.mMatrix.setValues(parcel.createFloatArray());
    }

    /*
     * Enabled aggressive block sorting
     */
    private CursorAnchorInfo(Builder builder) {
        this.mSelectionStart = builder.mSelectionStart;
        this.mSelectionEnd = builder.mSelectionEnd;
        this.mComposingTextStart = builder.mComposingTextStart;
        this.mComposingText = builder.mComposingText;
        this.mInsertionMarkerFlags = builder.mInsertionMarkerFlags;
        this.mInsertionMarkerHorizontal = builder.mInsertionMarkerHorizontal;
        this.mInsertionMarkerTop = builder.mInsertionMarkerTop;
        this.mInsertionMarkerBaseline = builder.mInsertionMarkerBaseline;
        this.mInsertionMarkerBottom = builder.mInsertionMarkerBottom;
        SparseRectFArray sparseRectFArray = builder.mCharacterBoundsArrayBuilder != null ? builder.mCharacterBoundsArrayBuilder.build() : null;
        this.mCharacterBoundsArray = sparseRectFArray;
        this.mMatrix = new Matrix(builder.mMatrix);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean areSameFloatImpl(float f, float f2) {
        return Float.isNaN(f) && Float.isNaN(f2) || f == f2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == null) break block4;
                if (this == object) {
                    return true;
                }
                if (!(object instanceof CursorAnchorInfo)) break block4;
                CursorAnchorInfo cursorAnchorInfo = (CursorAnchorInfo)object;
                if (this.hashCode() == cursorAnchorInfo.hashCode() && this.mSelectionStart == cursorAnchorInfo.mSelectionStart && this.mSelectionEnd == cursorAnchorInfo.mSelectionEnd && this.mComposingTextStart == cursorAnchorInfo.mComposingTextStart && Objects.equals(this.mComposingText, cursorAnchorInfo.mComposingText) && this.mInsertionMarkerFlags == cursorAnchorInfo.mInsertionMarkerFlags && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerHorizontal, cursorAnchorInfo.mInsertionMarkerHorizontal) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerTop, cursorAnchorInfo.mInsertionMarkerTop) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerBaseline, cursorAnchorInfo.mInsertionMarkerBaseline) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerBottom, cursorAnchorInfo.mInsertionMarkerBottom) && Objects.equals(this.mCharacterBoundsArray, cursorAnchorInfo.mCharacterBoundsArray) && Objects.equals(this.mMatrix, cursorAnchorInfo.mMatrix)) break block5;
            }
            return false;
        }
        return true;
    }

    public RectF getCharacterBounds(int n) {
        if (this.mCharacterBoundsArray == null) {
            return null;
        }
        return this.mCharacterBoundsArray.get(n);
    }

    public int getCharacterBoundsFlags(int n) {
        if (this.mCharacterBoundsArray == null) {
            return 0;
        }
        return this.mCharacterBoundsArray.getFlags(n, 0);
    }

    public CharSequence getComposingText() {
        return this.mComposingText;
    }

    public int getComposingTextStart() {
        return this.mComposingTextStart;
    }

    public float getInsertionMarkerBaseline() {
        return this.mInsertionMarkerBaseline;
    }

    public float getInsertionMarkerBottom() {
        return this.mInsertionMarkerBottom;
    }

    public int getInsertionMarkerFlags() {
        return this.mInsertionMarkerFlags;
    }

    public float getInsertionMarkerHorizontal() {
        return this.mInsertionMarkerHorizontal;
    }

    public float getInsertionMarkerTop() {
        return this.mInsertionMarkerTop;
    }

    public Matrix getMatrix() {
        return new Matrix(this.mMatrix);
    }

    public int getSelectionEnd() {
        return this.mSelectionEnd;
    }

    public int getSelectionStart() {
        return this.mSelectionStart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        float f = this.mInsertionMarkerHorizontal + this.mInsertionMarkerTop + this.mInsertionMarkerBaseline + this.mInsertionMarkerBottom;
        if (f > 0.0f) {
            n = (int)f;
            return 31 * (31 * (31 * (31 * (n * 31 + this.mInsertionMarkerFlags) + (this.mSelectionStart + this.mSelectionEnd + this.mComposingTextStart)) + Objects.hashCode(this.mComposingText)) + Objects.hashCode(this.mCharacterBoundsArray)) + Objects.hashCode(this.mMatrix);
        }
        n = (int)(-f);
        return 31 * (31 * (31 * (31 * (n * 31 + this.mInsertionMarkerFlags) + (this.mSelectionStart + this.mSelectionEnd + this.mComposingTextStart)) + Objects.hashCode(this.mComposingText)) + Objects.hashCode(this.mCharacterBoundsArray)) + Objects.hashCode(this.mMatrix);
    }

    public String toString() {
        return "SelectionInfo{mSelection=" + this.mSelectionStart + "," + this.mSelectionEnd + " mComposingTextStart=" + this.mComposingTextStart + " mComposingText=" + Objects.toString(this.mComposingText) + " mInsertionMarkerFlags=" + this.mInsertionMarkerFlags + " mInsertionMarkerHorizontal=" + this.mInsertionMarkerHorizontal + " mInsertionMarkerTop=" + this.mInsertionMarkerTop + " mInsertionMarkerBaseline=" + this.mInsertionMarkerBaseline + " mInsertionMarkerBottom=" + this.mInsertionMarkerBottom + " mCharacterBoundsArray=" + Objects.toString(this.mCharacterBoundsArray) + " mMatrix=" + Objects.toString(this.mMatrix) + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSelectionStart);
        parcel.writeInt(this.mSelectionEnd);
        parcel.writeInt(this.mComposingTextStart);
        TextUtils.writeToParcel(this.mComposingText, parcel, n);
        parcel.writeInt(this.mInsertionMarkerFlags);
        parcel.writeFloat(this.mInsertionMarkerHorizontal);
        parcel.writeFloat(this.mInsertionMarkerTop);
        parcel.writeFloat(this.mInsertionMarkerBaseline);
        parcel.writeFloat(this.mInsertionMarkerBottom);
        parcel.writeParcelable(this.mCharacterBoundsArray, n);
        float[] fArray = new float[9];
        this.mMatrix.getValues(fArray);
        parcel.writeFloatArray(fArray);
    }

    public static final class Builder {
        private SparseRectFArray.SparseRectFArrayBuilder mCharacterBoundsArrayBuilder = null;
        private CharSequence mComposingText = null;
        private int mComposingTextStart = -1;
        private float mInsertionMarkerBaseline;
        private float mInsertionMarkerBottom;
        private int mInsertionMarkerFlags = 0;
        private float mInsertionMarkerHorizontal = Float.NaN;
        private float mInsertionMarkerTop = Float.NaN;
        private final Matrix mMatrix;
        private boolean mMatrixInitialized = false;
        private int mSelectionEnd = -1;
        private int mSelectionStart = -1;

        public Builder() {
            this.mInsertionMarkerBaseline = Float.NaN;
            this.mInsertionMarkerBottom = Float.NaN;
            this.mMatrix = new Matrix(Matrix.IDENTITY_MATRIX);
        }

        public Builder addCharacterBounds(int n, float f, float f2, float f3, float f4, int n2) {
            if (n < 0) {
                throw new IllegalArgumentException("index must not be a negative integer.");
            }
            if (this.mCharacterBoundsArrayBuilder == null) {
                this.mCharacterBoundsArrayBuilder = new SparseRectFArray.SparseRectFArrayBuilder();
            }
            this.mCharacterBoundsArrayBuilder.append(n, f, f2, f3, f4, n2);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public CursorAnchorInfo build() {
            boolean bl;
            if (!(this.mMatrixInitialized || !(bl = this.mCharacterBoundsArrayBuilder != null && !this.mCharacterBoundsArrayBuilder.isEmpty()) && Float.isNaN(this.mInsertionMarkerHorizontal) && Float.isNaN(this.mInsertionMarkerTop) && Float.isNaN(this.mInsertionMarkerBaseline) && Float.isNaN(this.mInsertionMarkerBottom))) {
                throw new IllegalArgumentException("Coordinate transformation matrix is required when positional parameters are specified.");
            }
            return new CursorAnchorInfo(this);
        }

        public void reset() {
            this.mSelectionStart = -1;
            this.mSelectionEnd = -1;
            this.mComposingTextStart = -1;
            this.mComposingText = null;
            this.mInsertionMarkerFlags = 0;
            this.mInsertionMarkerHorizontal = Float.NaN;
            this.mInsertionMarkerTop = Float.NaN;
            this.mInsertionMarkerBaseline = Float.NaN;
            this.mInsertionMarkerBottom = Float.NaN;
            this.mMatrix.set(Matrix.IDENTITY_MATRIX);
            this.mMatrixInitialized = false;
            if (this.mCharacterBoundsArrayBuilder != null) {
                this.mCharacterBoundsArrayBuilder.reset();
            }
        }

        public Builder setComposingText(int n, CharSequence charSequence) {
            this.mComposingTextStart = n;
            if (charSequence == null) {
                this.mComposingText = null;
                return this;
            }
            this.mComposingText = new SpannedString(charSequence);
            return this;
        }

        public Builder setInsertionMarkerLocation(float f, float f2, float f3, float f4, int n) {
            this.mInsertionMarkerHorizontal = f;
            this.mInsertionMarkerTop = f2;
            this.mInsertionMarkerBaseline = f3;
            this.mInsertionMarkerBottom = f4;
            this.mInsertionMarkerFlags = n;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder setMatrix(Matrix matrix) {
            Matrix matrix2 = this.mMatrix;
            if (matrix == null) {
                matrix = Matrix.IDENTITY_MATRIX;
            }
            matrix2.set(matrix);
            this.mMatrixInitialized = true;
            return this;
        }

        public Builder setSelectionRange(int n, int n2) {
            this.mSelectionStart = n;
            this.mSelectionEnd = n2;
            return this;
        }
    }
}

