/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.Xml;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

public final class SpellCheckerInfo
implements Parcelable {
    public static final Parcelable.Creator<SpellCheckerInfo> CREATOR;
    private static final String TAG;
    private final String mId;
    private final int mLabel;
    private final ResolveInfo mService;
    private final String mSettingsActivityName;
    private final ArrayList<SpellCheckerSubtype> mSubtypes;

    static {
        TAG = SpellCheckerInfo.class.getSimpleName();
        CREATOR = new Parcelable.Creator<SpellCheckerInfo>(){

            @Override
            public SpellCheckerInfo createFromParcel(Parcel parcel) {
                return new SpellCheckerInfo(parcel);
            }

            public SpellCheckerInfo[] newArray(int n) {
                return new SpellCheckerInfo[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpellCheckerInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        int n;
        int n2;
        String string2;
        int n3;
        AttributeSet attributeSet;
        Resources resources;
        XmlResourceParser xmlResourceParser;
        block12: {
            int n4;
            this.mSubtypes = new ArrayList();
            this.mService = resolveInfo;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            this.mId = new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString();
            PackageManager packageManager = context.getPackageManager();
            xmlResourceParser = null;
            try {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.view.textservice.scs");
                if (xmlResourceParser == null) {
                    throw new XmlPullParserException("No android.view.textservice.scs meta-data");
                }
            }
            catch (Exception exception) {
                Slog.e(TAG, "Caught exception: " + exception);
                throw new XmlPullParserException("Unable to create context for: " + serviceInfo.packageName);
            }
            resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n4 = xmlResourceParser.next()) != 1 && n4 != 2) {
            }
            if (!"spell-checker".equals(xmlResourceParser.getName())) {
                throw new XmlPullParserException("Meta-data does not start with spell-checker tag");
            }
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.SpellChecker);
            n3 = typedArray.getResourceId(0, 0);
            string2 = typedArray.getString(1);
            typedArray.recycle();
            n2 = xmlResourceParser.getDepth();
            break block12;
            finally {
                if (xmlResourceParser != null) {
                    xmlResourceParser.close();
                }
            }
        }
        while (((n = xmlResourceParser.next()) != 3 || xmlResourceParser.getDepth() > n2) && n != 1) {
            if (n != 2) continue;
            if (!"subtype".equals(xmlResourceParser.getName())) {
                throw new XmlPullParserException("Meta-data in spell-checker does not start with subtype tag");
            }
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.SpellChecker_Subtype);
            SpellCheckerSubtype spellCheckerSubtype = new SpellCheckerSubtype(typedArray.getResourceId(0, 0), typedArray.getString(1), typedArray.getString(2));
            this.mSubtypes.add(spellCheckerSubtype);
        }
        this.mLabel = n3;
        this.mSettingsActivityName = string2;
    }

    public SpellCheckerInfo(Parcel parcel) {
        this.mSubtypes = new ArrayList();
        this.mLabel = parcel.readInt();
        this.mId = parcel.readString();
        this.mSettingsActivityName = parcel.readString();
        this.mService = ResolveInfo.CREATOR.createFromParcel(parcel);
        parcel.readTypedList(this.mSubtypes, SpellCheckerSubtype.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public String getId() {
        return this.mId;
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public SpellCheckerSubtype getSubtypeAt(int n) {
        return this.mSubtypes.get(n);
    }

    public int getSubtypeCount() {
        return this.mSubtypes.size();
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mService.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        if (this.mLabel == 0 || packageManager == null) {
            return "";
        }
        return packageManager.getText(this.getPackageName(), this.mLabel, this.mService.serviceInfo.applicationInfo);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mLabel);
        parcel.writeString(this.mId);
        parcel.writeString(this.mSettingsActivityName);
        this.mService.writeToParcel(parcel, n);
        parcel.writeTypedList(this.mSubtypes);
    }
}

