/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.SpellCheckSpan;

public final class TextInfo
implements Parcelable {
    public static final Parcelable.Creator<TextInfo> CREATOR = new Parcelable.Creator<TextInfo>(){

        @Override
        public TextInfo createFromParcel(Parcel parcel) {
            return new TextInfo(parcel);
        }

        public TextInfo[] newArray(int n) {
            return new TextInfo[n];
        }
    };
    private static final int DEFAULT_COOKIE;
    private static final int DEFAULT_SEQUENCE_NUMBER;
    private final CharSequence mCharSequence;
    private final int mCookie;
    private final int mSequenceNumber;

    public TextInfo(Parcel parcel) {
        this.mCharSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mCookie = parcel.readInt();
        this.mSequenceNumber = parcel.readInt();
    }

    public TextInfo(CharSequence charSequence, int n, int n2, int n3, int n4) {
        if (TextUtils.isEmpty(charSequence)) {
            throw new IllegalArgumentException("charSequence is empty");
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
        SpellCheckSpan[] spellCheckSpanArray = spannableStringBuilder.getSpans(0, spannableStringBuilder.length(), SpellCheckSpan.class);
        for (int i = 0; i < spellCheckSpanArray.length; ++i) {
            spannableStringBuilder.removeSpan(spellCheckSpanArray[i]);
        }
        this.mCharSequence = spannableStringBuilder;
        this.mCookie = n3;
        this.mSequenceNumber = n4;
    }

    public TextInfo(String string2) {
        this(string2, 0, TextInfo.getStringLengthOrZero(string2), 0, 0);
    }

    public TextInfo(String string2, int n, int n2) {
        this(string2, 0, TextInfo.getStringLengthOrZero(string2), n, n2);
    }

    private static int getStringLengthOrZero(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return 0;
        }
        return string2.length();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public CharSequence getCharSequence() {
        return this.mCharSequence;
    }

    public int getCookie() {
        return this.mCookie;
    }

    public int getSequence() {
        return this.mSequenceNumber;
    }

    public String getText() {
        if (this.mCharSequence == null) {
            return null;
        }
        return this.mCharSequence.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TextUtils.writeToParcel(this.mCharSequence, parcel, n);
        parcel.writeInt(this.mCookie);
        parcel.writeInt(this.mSequenceNumber);
    }
}

