/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ProgressBar;
import com.android.internal.R;

public abstract class AbsSeekBar
extends ProgressBar {
    private static final int NO_ALPHA = 255;
    private static final int PROGRESS_ANIMATION_DURATION = 250;
    private float mDisabledAlpha;
    private boolean mHasThumbTint = false;
    private boolean mHasThumbTintMode = false;
    private boolean mIsDragging;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private ObjectAnimator mPositionAnimator;
    private int mScaledTouchSlop;
    private boolean mSplitTrack;
    private final Rect mTempRect = new Rect();
    private Drawable mThumb;
    private int mThumbOffset;
    private ColorStateList mThumbTintList = null;
    private PorterDuff.Mode mThumbTintMode = null;
    private float mTouchDownX;
    float mTouchProgressOffset;

    public AbsSeekBar(Context context) {
        super(context);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AbsSeekBar(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SeekBar, n, n2);
        this.setThumb(typedArray.getDrawable(0));
        if (typedArray.hasValue(4)) {
            this.mThumbTintMode = Drawable.parseTintMode(typedArray.getInt(4, -1), this.mThumbTintMode);
            this.mHasThumbTintMode = true;
        }
        if (typedArray.hasValue(3)) {
            this.mThumbTintList = typedArray.getColorStateList(3);
            this.mHasThumbTint = true;
        }
        this.setThumbOffset(typedArray.getDimensionPixelOffset(1, this.getThumbOffset()));
        this.mSplitTrack = typedArray.getBoolean(2, false);
        typedArray.recycle();
        TypedArray typedArray2 = context.obtainStyledAttributes(attributeSet, R.styleable.Theme, 0, 0);
        this.mDisabledAlpha = typedArray2.getFloat(3, 0.5f);
        typedArray2.recycle();
        this.applyThumbTint();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
    }

    private void applyThumbTint() {
        if (this.mThumb != null && (this.mHasThumbTint || this.mHasThumbTintMode)) {
            this.mThumb = this.mThumb.mutate();
            if (this.mHasThumbTint) {
                this.mThumb.setTintList(this.mThumbTintList);
            }
            if (this.mHasThumbTintMode) {
                this.mThumb.setTintMode(this.mThumbTintMode);
            }
        }
    }

    private void attemptClaimDrag() {
        if (this.mParent != null) {
            this.mParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private float getScale() {
        int n = this.getMax();
        if (n > 0) {
            return (float)this.getProgress() / (float)n;
        }
        return 0.0f;
    }

    private void setHotspot(float f, float f2) {
        Drawable drawable2 = this.getBackground();
        if (drawable2 != null) {
            drawable2.setHotspot(f, f2);
        }
    }

    private void setThumbPos(float f) {
        Drawable drawable2 = this.mThumb;
        if (drawable2 != null) {
            this.setThumbPos(this.getWidth(), drawable2, f, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setThumbPos(int n, Drawable drawable2, float f, int n2) {
        int n3;
        int n4;
        int n5 = n - this.mPaddingLeft - this.mPaddingRight;
        int n6 = drawable2.getIntrinsicWidth();
        int n7 = drawable2.getIntrinsicHeight();
        int n8 = n5 - n6 + 2 * this.mThumbOffset;
        int n9 = (int)(0.5f + f * (float)n8);
        if (n2 == Integer.MIN_VALUE) {
            Rect rect = drawable2.getBounds();
            n4 = rect.top;
            n3 = rect.bottom;
        } else {
            n4 = n2;
            n3 = n2 + n7;
        }
        int n10 = this.isLayoutRtl() && this.mMirrorForRtl ? n8 - n9 : n9;
        int n11 = n10 + n6;
        Drawable drawable3 = this.getBackground();
        if (drawable3 != null) {
            drawable2.getBounds();
            int n12 = this.mPaddingLeft - this.mThumbOffset;
            int n13 = this.mPaddingTop;
            drawable3.setHotspotBounds(n10 + n12, n4 + n13, n11 + n12, n3 + n13);
        }
        drawable2.setBounds(n10, n4, n11, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void trackTouchEvent(MotionEvent motionEvent) {
        float f;
        float f2;
        int n;
        block8: {
            int n2;
            int n3;
            block9: {
                n3 = this.getWidth();
                n2 = n3 - this.mPaddingLeft - this.mPaddingRight;
                n = (int)motionEvent.getX();
                f2 = 0.0f;
                if (!this.isLayoutRtl() || !this.mMirrorForRtl) break block9;
                if (n > n3 - this.mPaddingRight) {
                    f = 0.0f;
                    break block8;
                } else if (n < this.mPaddingLeft) {
                    f = 1.0f;
                    f2 = 0.0f;
                    break block8;
                } else {
                    f = (float)(n2 - n + this.mPaddingLeft) / (float)n2;
                    f2 = this.mTouchProgressOffset;
                }
                break block8;
            }
            if (n < this.mPaddingLeft) {
                f2 = 0.0f;
                f = 0.0f;
            } else if (n > n3 - this.mPaddingRight) {
                f = 1.0f;
                f2 = 0.0f;
            } else {
                f = (float)(n - this.mPaddingLeft) / (float)n2;
                f2 = this.mTouchProgressOffset;
            }
        }
        float f3 = f2 + f * (float)this.getMax();
        this.setHotspot(n, (int)motionEvent.getY());
        this.setProgress((int)f3, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateThumbAndTrackPos(int n, int n2) {
        int n3;
        int n4;
        int n5;
        Drawable drawable2 = this.getCurrentDrawable();
        Drawable drawable3 = this.mThumb;
        int n6 = drawable3 == null ? 0 : drawable3.getIntrinsicHeight();
        if (n6 > (n5 = Math.min(this.mMaxHeight, n2 - this.mPaddingTop - this.mPaddingBottom))) {
            n4 = (n6 - n5) / 2;
            n3 = 0;
        } else {
            n3 = (n5 - n6) / 2;
            n4 = 0;
        }
        if (drawable2 != null) {
            drawable2.setBounds(0, n4, n - this.mPaddingRight - this.mPaddingLeft, n2 - this.mPaddingBottom - n4 - this.mPaddingTop);
        }
        if (drawable3 != null) {
            this.setThumbPos(n, drawable3, this.getScale(), n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void animateSetProgress(int n) {
        float f = this.isAnimationRunning() ? this.getAnimationPosition() : (float)this.getProgress();
        if (n < 0) {
            n = 0;
        } else if (n > this.getMax()) {
            n = this.getMax();
        }
        this.setProgressValueOnly(n);
        float[] fArray = new float[]{f, n};
        this.mPositionAnimator = ObjectAnimator.ofFloat((Object)this, "animationPosition", fArray);
        this.mPositionAnimator.setDuration(250L);
        this.mPositionAnimator.setAutoCancel(true);
        this.mPositionAnimator.start();
    }

    void drawThumb(Canvas canvas) {
        if (this.mThumb != null) {
            canvas.save();
            canvas.translate(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            this.mThumb.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    void drawTrack(Canvas canvas) {
        Drawable drawable2 = this.mThumb;
        if (drawable2 != null && this.mSplitTrack) {
            Insets insets = drawable2.getOpticalInsets();
            Rect rect = this.mTempRect;
            drawable2.copyBounds(rect);
            rect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            rect.left += insets.left;
            rect.right -= insets.right;
            int n = canvas.save();
            canvas.clipRect(rect, Region.Op.DIFFERENCE);
            super.drawTrack(canvas);
            canvas.restoreToCount(n);
            return;
        }
        super.drawTrack(canvas);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mThumb != null) {
            this.mThumb.setHotspot(f, f2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void drawableStateChanged() {
        Drawable drawable2;
        super.drawableStateChanged();
        Drawable drawable3 = this.getProgressDrawable();
        if (drawable3 != null) {
            int n = this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha);
            drawable3.setAlpha(n);
        }
        if ((drawable2 = this.mThumb) != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public int getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public Drawable getThumb() {
        return this.mThumb;
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public ColorStateList getThumbTintList() {
        return this.mThumbTintList;
    }

    public PorterDuff.Mode getThumbTintMode() {
        return this.mThumbTintMode;
    }

    boolean isAnimationRunning() {
        return this.mPositionAnimator != null && this.mPositionAnimator.isRunning();
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumb != null) {
            this.mThumb.jumpToCurrentState();
        }
    }

    @Override
    void onAnimatePosition(float f, boolean bl) {
        this.setThumbPos(f);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            super.onDraw(canvas);
            this.drawThumb(canvas);
            return;
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AbsSeekBar.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AbsSeekBar.class.getName());
        if (this.isEnabled()) {
            int n = this.getProgress();
            if (n > 0) {
                accessibilityNodeInfo.addAction(8192);
            }
            if (n < this.getMax()) {
                accessibilityNodeInfo.addAction(4096);
            }
        }
    }

    void onKeyChange() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isEnabled()) return super.onKeyDown(n, keyEvent);
        int n2 = this.getProgress();
        switch (n) {
            case 21: {
                if (n2 <= 0) return super.onKeyDown(n, keyEvent);
                this.animateSetProgress(n2 - this.mKeyProgressIncrement);
                this.onKeyChange();
                return true;
            }
            default: {
                return super.onKeyDown(n, keyEvent);
            }
            case 22: {
                if (n2 >= this.getMax()) return super.onKeyDown(n, keyEvent);
                this.animateSetProgress(n2 + this.mKeyProgressIncrement);
                this.onKeyChange();
                return true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            Drawable drawable2 = this.getCurrentDrawable();
            Drawable drawable3 = this.mThumb;
            int n3 = 0;
            if (drawable3 != null) {
                int n4;
                n3 = n4 = this.mThumb.getIntrinsicHeight();
            }
            int n5 = 0;
            int n6 = 0;
            if (drawable2 != null) {
                n6 = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, drawable2.getIntrinsicWidth()));
                n5 = Math.max(n3, Math.max(this.mMinHeight, Math.min(this.mMaxHeight, drawable2.getIntrinsicHeight())));
            }
            int n7 = n6 + (this.mPaddingLeft + this.mPaddingRight);
            int n8 = n5 + (this.mPaddingTop + this.mPaddingBottom);
            this.setMeasuredDimension(AbsSeekBar.resolveSizeAndState(n7, n, 0), AbsSeekBar.resolveSizeAndState(n8, n2, 0));
            return;
        }
    }

    @Override
    void onProgressRefresh(float f, boolean bl) {
        super.onProgressRefresh(f, bl);
        if (!this.isAnimationRunning()) {
            this.setThumbPos(f);
        }
    }

    @Override
    public void onResolveDrawables(int n) {
        super.onResolveDrawables(n);
        if (this.mThumb != null) {
            this.mThumb.setLayoutDirection(n);
        }
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        super.onRtlPropertiesChanged(n);
        Drawable drawable2 = this.mThumb;
        if (drawable2 != null) {
            this.setThumbPos(this.getWidth(), drawable2, this.getScale(), Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.updateThumbAndTrackPos(n, n2);
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = true;
        if (!this.mIsUserSeekable) return false;
        if (!this.isEnabled()) {
            return false;
        }
        switch (motionEvent.getAction()) {
            default: {
                return bl;
            }
            case 0: {
                if (this.isInScrollingContainer()) {
                    this.mTouchDownX = motionEvent.getX();
                    return bl;
                }
                this.setPressed(bl);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(motionEvent);
                this.attemptClaimDrag();
                return bl;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(motionEvent);
                    return bl;
                }
                if (!(Math.abs(motionEvent.getX() - this.mTouchDownX) > (float)this.mScaledTouchSlop)) return bl;
                this.setPressed(bl);
                if (this.mThumb != null) {
                    this.invalidate(this.mThumb.getBounds());
                }
                this.onStartTrackingTouch();
                this.trackTouchEvent(motionEvent);
                this.attemptClaimDrag();
                return bl;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(motionEvent);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(motionEvent);
                    this.onStopTrackingTouch();
                }
                this.invalidate();
                return bl;
            }
            case 3: 
        }
        if (this.mIsDragging) {
            this.onStopTrackingTouch();
            this.setPressed(false);
        }
        this.invalidate();
        return bl;
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        int n2 = this.getProgress();
        int n3 = Math.max(1, Math.round((float)this.getMax() / 5.0f));
        switch (n) {
            default: {
                return false;
            }
            case 8192: {
                if (n2 <= 0) {
                    return false;
                }
                this.setProgress(n2 - n3, true);
                this.onKeyChange();
                return true;
            }
            case 4096: 
        }
        if (n2 >= this.getMax()) {
            return false;
        }
        this.setProgress(n2 + n3, true);
        this.onKeyChange();
        return true;
    }

    public void setKeyProgressIncrement(int n) {
        if (n < 0) {
            n = -n;
        }
        this.mKeyProgressIncrement = n;
    }

    @Override
    public void setMax(int n) {
        synchronized (this) {
            super.setMax(n);
            if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
                this.setKeyProgressIncrement(Math.max(1, Math.round((float)this.getMax() / 20.0f)));
            }
            return;
        }
    }

    @Override
    public void setProgress(int n, boolean bl) {
        if (this.isAnimationRunning()) {
            this.mPositionAnimator.cancel();
        }
        super.setProgress(n, bl);
    }

    public void setSplitTrack(boolean bl) {
        this.mSplitTrack = bl;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setThumb(Drawable drawable2) {
        boolean bl;
        if (this.mThumb != null && drawable2 != this.mThumb) {
            this.mThumb.setCallback(null);
            bl = true;
        } else {
            bl = false;
        }
        if (drawable2 != null) {
            drawable2.setCallback(this);
            if (this.canResolveLayoutDirection()) {
                drawable2.setLayoutDirection(this.getLayoutDirection());
            }
            this.mThumbOffset = drawable2.getIntrinsicWidth() / 2;
            if (bl && (drawable2.getIntrinsicWidth() != this.mThumb.getIntrinsicWidth() || drawable2.getIntrinsicHeight() != this.mThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        this.mThumb = drawable2;
        this.applyThumbTint();
        this.invalidate();
        if (bl) {
            this.updateThumbAndTrackPos(this.getWidth(), this.getHeight());
            if (drawable2 != null && drawable2.isStateful()) {
                drawable2.setState(this.getDrawableState());
            }
        }
    }

    public void setThumbOffset(int n) {
        this.mThumbOffset = n;
        this.invalidate();
    }

    public void setThumbTintList(ColorStateList colorStateList) {
        this.mThumbTintList = colorStateList;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    public void setThumbTintMode(PorterDuff.Mode mode) {
        this.mThumbTintMode = mode;
        this.mHasThumbTintMode = true;
        this.applyThumbTint();
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mThumb || super.verifyDrawable(drawable2);
    }
}

