/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.AnimatorInflater;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Advanceable;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AdapterViewAnimator
extends AdapterView<Adapter>
implements RemoteViewsAdapter.RemoteAdapterConnectionCallback,
Advanceable {
    private static final int DEFAULT_ANIMATION_DURATION = 200;
    private static final String TAG = "RemoteViewAnimator";
    static final int TOUCH_MODE_DOWN_IN_CURRENT_VIEW = 1;
    static final int TOUCH_MODE_HANDLED = 2;
    static final int TOUCH_MODE_NONE;
    int mActiveOffset = 0;
    Adapter mAdapter;
    boolean mAnimateFirstTime = true;
    int mCurrentWindowEnd = -1;
    int mCurrentWindowStart = 0;
    int mCurrentWindowStartUnbounded = 0;
    AdapterView.AdapterDataSetObserver mDataSetObserver;
    boolean mDeferNotifyDataSetChanged = false;
    boolean mFirstTime = true;
    ObjectAnimator mInAnimation;
    boolean mLoopViews = true;
    int mMaxNumActiveViews = 1;
    ObjectAnimator mOutAnimation;
    private Runnable mPendingCheckForTap;
    ArrayList<Integer> mPreviousViews;
    int mReferenceChildHeight = -1;
    int mReferenceChildWidth = -1;
    RemoteViewsAdapter mRemoteViewsAdapter;
    private int mRestoreWhichChild = -1;
    private int mTouchMode = 0;
    HashMap<Integer, ViewAndMetaData> mViewsMap = new HashMap();
    int mWhichChild = 0;

    public AdapterViewAnimator(Context context) {
        this(context, null);
    }

    public AdapterViewAnimator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AdapterViewAnimator(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AdapterViewAnimator(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AdapterViewAnimator, n, n2);
        int n4 = typedArray.getResourceId(0, 0);
        if (n4 > 0) {
            this.setInAnimation(context, n4);
        } else {
            this.setInAnimation(this.getDefaultInAnimation());
        }
        if ((n3 = typedArray.getResourceId(1, 0)) > 0) {
            this.setOutAnimation(context, n3);
        } else {
            this.setOutAnimation(this.getDefaultOutAnimation());
        }
        this.setAnimateFirstView(typedArray.getBoolean(2, true));
        this.mLoopViews = typedArray.getBoolean(3, false);
        typedArray.recycle();
        this.initViewAnimator();
    }

    private void addChild(View view) {
        this.addViewInLayout(view, -1, this.createOrReuseLayoutParams(view));
        if (this.mReferenceChildWidth == -1 || this.mReferenceChildHeight == -1) {
            int n = View.MeasureSpec.makeMeasureSpec(0, 0);
            view.measure(n, n);
            this.mReferenceChildWidth = view.getMeasuredWidth();
            this.mReferenceChildHeight = view.getMeasuredHeight();
        }
    }

    private ViewAndMetaData getMetaDataForChild(View view) {
        for (ViewAndMetaData viewAndMetaData : this.mViewsMap.values()) {
            if (viewAndMetaData.view != view) continue;
            return viewAndMetaData;
        }
        return null;
    }

    private void initViewAnimator() {
        this.mPreviousViews = new ArrayList();
    }

    private void measureChildren() {
        int n = this.getChildCount();
        int n2 = this.getMeasuredWidth() - this.mPaddingLeft - this.mPaddingRight;
        int n3 = this.getMeasuredHeight() - this.mPaddingTop - this.mPaddingBottom;
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).measure(View.MeasureSpec.makeMeasureSpec(n2, 0x40000000), View.MeasureSpec.makeMeasureSpec(n3, 0x40000000));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDisplayedChild(int n, boolean bl) {
        if (this.mAdapter != null) {
            this.mWhichChild = n;
            if (n >= this.getWindowSize()) {
                int n2 = this.mLoopViews ? 0 : -1 + this.getWindowSize();
                this.mWhichChild = n2;
            } else if (n < 0) {
                int n3 = this.mLoopViews ? -1 + this.getWindowSize() : 0;
                this.mWhichChild = n3;
            }
            boolean bl2 = this.getFocusedChild() != null;
            this.showOnly(this.mWhichChild, bl);
            if (bl2) {
                this.requestFocus(2);
            }
        }
    }

    @Override
    public void advance() {
        this.showNext();
    }

    void applyTransformForChildAtIndex(View view, int n) {
    }

    void cancelHandleClick() {
        View view = this.getCurrentView();
        if (view != null) {
            this.hideTapFeedback(view);
        }
        this.mTouchMode = 0;
    }

    void checkForAndHandleDataChanged() {
        if (this.mDataChanged) {
            this.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    AdapterViewAnimator.this.handleDataChanged();
                    if (AdapterViewAnimator.this.mWhichChild >= AdapterViewAnimator.this.getWindowSize()) {
                        AdapterViewAnimator.this.mWhichChild = 0;
                        AdapterViewAnimator.this.showOnly(AdapterViewAnimator.this.mWhichChild, false);
                    } else if (AdapterViewAnimator.this.mOldItemCount != AdapterViewAnimator.this.getCount()) {
                        AdapterViewAnimator.this.showOnly(AdapterViewAnimator.this.mWhichChild, false);
                    }
                    AdapterViewAnimator.this.refreshChildren();
                    AdapterViewAnimator.this.requestLayout();
                }
            });
        }
        this.mDataChanged = false;
    }

    void configureViewAnimator(int n, int n2) {
        if (n2 > n - 1) {
            // empty if block
        }
        this.mMaxNumActiveViews = n;
        this.mActiveOffset = n2;
        this.mPreviousViews.clear();
        this.mViewsMap.clear();
        this.removeAllViewsInLayout();
        this.mCurrentWindowStart = 0;
        this.mCurrentWindowEnd = -1;
    }

    ViewGroup.LayoutParams createOrReuseLayoutParams(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof ViewGroup.LayoutParams) {
            return layoutParams;
        }
        return new ViewGroup.LayoutParams(0, 0);
    }

    @Override
    public void deferNotifyDataSetChanged() {
        this.mDeferNotifyDataSetChanged = true;
    }

    @Override
    public void fyiWillBeAdvancedByHostKThx() {
    }

    @Override
    public Adapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public int getBaseline() {
        if (this.getCurrentView() != null) {
            return this.getCurrentView().getBaseline();
        }
        return super.getBaseline();
    }

    public View getCurrentView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    ObjectAnimator getDefaultInAnimation() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
        objectAnimator.setDuration(200L);
        return objectAnimator;
    }

    ObjectAnimator getDefaultOutAnimation() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
        objectAnimator.setDuration(200L);
        return objectAnimator;
    }

    public int getDisplayedChild() {
        return this.mWhichChild;
    }

    FrameLayout getFrameForChild() {
        return new FrameLayout(this.mContext);
    }

    public ObjectAnimator getInAnimation() {
        return this.mInAnimation;
    }

    int getNumActiveViews() {
        if (this.mAdapter != null) {
            return Math.min(1 + this.getCount(), this.mMaxNumActiveViews);
        }
        return this.mMaxNumActiveViews;
    }

    public ObjectAnimator getOutAnimation() {
        return this.mOutAnimation;
    }

    @Override
    public View getSelectedView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    View getViewAtRelativeIndex(int n) {
        int n2;
        if (n >= 0 && n <= -1 + this.getNumActiveViews() && this.mAdapter != null && this.mViewsMap.get(n2 = this.modulo(n + this.mCurrentWindowStartUnbounded, this.getWindowSize())) != null) {
            return this.mViewsMap.get((Object)Integer.valueOf((int)n2)).view;
        }
        return null;
    }

    int getWindowSize() {
        if (this.mAdapter != null) {
            int n = this.getCount();
            if (n <= this.getNumActiveViews() && this.mLoopViews) {
                n *= this.mMaxNumActiveViews;
            }
            return n;
        }
        return 0;
    }

    void hideTapFeedback(View view) {
        view.setPressed(false);
    }

    int modulo(int n, int n2) {
        if (n2 > 0) {
            return (n2 + n % n2) % n2;
        }
        return 0;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AdapterViewAnimator.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AdapterViewAnimator.class.getName());
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.checkForAndHandleDataChanged();
        int n5 = this.getChildCount();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            int n6 = this.mPaddingLeft + view.getMeasuredWidth();
            int n7 = this.mPaddingTop + view.getMeasuredHeight();
            view.layout(this.mPaddingLeft, this.mPaddingTop, n6, n7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getSize(n2);
        int n5 = View.MeasureSpec.getMode(n);
        int n6 = View.MeasureSpec.getMode(n2);
        boolean bl = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        if (n6 == 0) {
            n4 = bl ? this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (n6 == Integer.MIN_VALUE && bl) {
            int n7 = this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom;
            n4 = n7 > n4 ? (n4 |= 0x1000000) : n7;
        }
        if (n5 == 0) {
            n3 = bl ? this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (n6 == Integer.MIN_VALUE && bl) {
            int n8 = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight;
            n3 = n8 > n3 ? (n3 |= 0x1000000) : n8;
        }
        this.setMeasuredDimension(n3, n4);
        this.measureChildren();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onRemoteAdapterConnected() {
        if (this.mRemoteViewsAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteViewsAdapter);
            if (this.mDeferNotifyDataSetChanged) {
                this.mRemoteViewsAdapter.notifyDataSetChanged();
                this.mDeferNotifyDataSetChanged = false;
            }
            if (this.mRestoreWhichChild <= -1) return false;
            this.setDisplayedChild(this.mRestoreWhichChild, false);
            this.mRestoreWhichChild = -1;
            return false;
        }
        if (this.mRemoteViewsAdapter == null) return false;
        this.mRemoteViewsAdapter.superNotifyDataSetChanged();
        return true;
    }

    @Override
    public void onRemoteAdapterDisconnected() {
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mWhichChild = savedState.whichChild;
        if (this.mRemoteViewsAdapter != null && this.mAdapter == null) {
            this.mRestoreWhichChild = this.mWhichChild;
            return;
        }
        this.setDisplayedChild(this.mWhichChild, false);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.saveRemoteViewsCache();
        }
        return new SavedState(parcelable, this.mWhichChild);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                View view = this.getCurrentView();
                if (view != null && this.isTransformedTouchPointInView(motionEvent.getX(), motionEvent.getY(), view, null)) {
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap();
                    }
                    this.mTouchMode = 1;
                    this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    return false;
                }
            }
            default: {
                return false;
            }
            case 1: {
                int n = this.mTouchMode;
                boolean bl = false;
                if (n == 1) {
                    final View view = this.getCurrentView();
                    final ViewAndMetaData viewAndMetaData = this.getMetaDataForChild(view);
                    bl = false;
                    if (view != null) {
                        boolean bl2 = this.isTransformedTouchPointInView(motionEvent.getX(), motionEvent.getY(), view, null);
                        bl = false;
                        if (bl2) {
                            Handler handler = this.getHandler();
                            if (handler != null) {
                                handler.removeCallbacks(this.mPendingCheckForTap);
                            }
                            this.showTapFeedback(view);
                            this.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    AdapterViewAnimator.this.hideTapFeedback(view);
                                    AdapterViewAnimator.this.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (viewAndMetaData != null) {
                                                AdapterViewAnimator.this.performItemClick(view, viewAndMetaData.adapterPosition, viewAndMetaData.itemId);
                                                return;
                                            }
                                            AdapterViewAnimator.this.performItemClick(view, 0, 0L);
                                        }
                                    });
                                }
                            }, ViewConfiguration.getPressedStateDuration());
                            bl = true;
                        }
                    }
                }
                this.mTouchMode = 0;
                return bl;
            }
            case 3: 
        }
        View view = this.getCurrentView();
        if (view != null) {
            this.hideTapFeedback(view);
        }
        this.mTouchMode = 0;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    void refreshChildren() {
        if (this.mAdapter != null) {
            for (int i = this.mCurrentWindowStart; i <= this.mCurrentWindowEnd; ++i) {
                int n = this.modulo(i, this.getWindowSize());
                int n2 = this.getCount();
                View view = this.mAdapter.getView(this.modulo(i, n2), null, this);
                if (view.getImportantForAccessibility() == 0) {
                    view.setImportantForAccessibility(1);
                }
                if (!this.mViewsMap.containsKey(n)) continue;
                FrameLayout frameLayout = (FrameLayout)this.mViewsMap.get((Object)Integer.valueOf((int)n)).view;
                if (view == null) continue;
                frameLayout.removeAllViewsInLayout();
                frameLayout.addView(view);
            }
        }
    }

    @Override
    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter;
        this.checkFocus();
        if (this.mAdapter != null) {
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mItemCount = this.mAdapter.getCount();
        }
        this.setFocusable(true);
        this.mWhichChild = 0;
        this.showOnly(this.mWhichChild, false);
    }

    public void setAnimateFirstView(boolean bl) {
        this.mAnimateFirstTime = bl;
    }

    @RemotableViewMethod
    public void setDisplayedChild(int n) {
        this.setDisplayedChild(n, true);
    }

    public void setInAnimation(ObjectAnimator objectAnimator) {
        this.mInAnimation = objectAnimator;
    }

    public void setInAnimation(Context context, int n) {
        this.setInAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, n));
    }

    public void setOutAnimation(ObjectAnimator objectAnimator) {
        this.mOutAnimation = objectAnimator;
    }

    public void setOutAnimation(Context context, int n) {
        this.setOutAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, n));
    }

    /*
     * Enabled aggressive block sorting
     */
    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        block3: {
            block2: {
                if (this.mRemoteViewsAdapter != null && new Intent.FilterComparison(intent).equals(new Intent.FilterComparison(this.mRemoteViewsAdapter.getRemoteViewsServiceIntent()))) break block2;
                this.mDeferNotifyDataSetChanged = false;
                this.mRemoteViewsAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
                if (this.mRemoteViewsAdapter.isDataReady()) break block3;
            }
            return;
        }
        this.setAdapter(this.mRemoteViewsAdapter);
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.setRemoteViewsOnClickHandler(onClickHandler);
        }
    }

    @Override
    public void setSelection(int n) {
        this.setDisplayedChild(n);
    }

    public void showNext() {
        this.setDisplayedChild(1 + this.mWhichChild);
    }

    /*
     * Enabled aggressive block sorting
     */
    void showOnly(int n, boolean bl) {
        int n2;
        int n3;
        if (this.mAdapter == null || (n3 = this.getCount()) == 0) {
            return;
        }
        for (int i = 0; i < this.mPreviousViews.size(); ++i) {
            View view = this.mViewsMap.get((Object)this.mPreviousViews.get((int)i)).view;
            this.mViewsMap.remove(this.mPreviousViews.get(i));
            view.clearAnimation();
            if (view instanceof ViewGroup) {
                ((ViewGroup)view).removeAllViewsInLayout();
            }
            this.applyTransformForChildAtIndex(view, -1);
            this.removeViewInLayout(view);
        }
        this.mPreviousViews.clear();
        int n4 = n - this.mActiveOffset;
        int n5 = -1 + (n4 + this.getNumActiveViews());
        int n6 = Math.max(0, n4);
        int n7 = Math.min(n3 - 1, n5);
        if (this.mLoopViews) {
            n6 = n4;
            n7 = n5;
        }
        int n8 = this.getWindowSize();
        int n9 = this.modulo(n6, n8);
        int n10 = this.getWindowSize();
        int n11 = this.modulo(n7, n10);
        boolean bl2 = false;
        if (n9 > n11) {
            bl2 = true;
        }
        for (Integer n12 : this.mViewsMap.keySet()) {
            boolean bl3;
            if (!(bl2 || n12 >= n9 && n12 <= n11)) {
                bl3 = true;
            } else {
                bl3 = false;
                if (bl2) {
                    int n13 = n12;
                    bl3 = false;
                    if (n13 > n11) {
                        int n14 = n12;
                        bl3 = false;
                        if (n14 < n9) {
                            bl3 = true;
                        }
                    }
                }
            }
            if (!bl3) continue;
            View view = this.mViewsMap.get((Object)n12).view;
            int n15 = this.mViewsMap.get((Object)n12).relativeIndex;
            this.mPreviousViews.add(n12);
            this.transformViewForTransition(n15, -1, view, bl);
        }
        int n16 = this.mCurrentWindowStart;
        if (n6 != n16 || n7 != (n2 = this.mCurrentWindowEnd) || n4 != this.mCurrentWindowStartUnbounded) {
            for (int i = n6; i <= n7; ++i) {
                int n17 = this.modulo(i, this.getWindowSize());
                int n18 = this.mViewsMap.containsKey(n17) ? this.mViewsMap.get((Object)Integer.valueOf((int)n17)).relativeIndex : -1;
                int n19 = i - n4;
                boolean bl4 = this.mViewsMap.containsKey(n17) && !this.mPreviousViews.contains(n17);
                if (bl4) {
                    View view = this.mViewsMap.get((Object)Integer.valueOf((int)n17)).view;
                    this.mViewsMap.get((Object)Integer.valueOf((int)n17)).relativeIndex = n19;
                    this.applyTransformForChildAtIndex(view, n19);
                    this.transformViewForTransition(n18, n19, view, bl);
                } else {
                    int n20 = this.modulo(i, n3);
                    View view = this.mAdapter.getView(n20, null, this);
                    long l = this.mAdapter.getItemId(n20);
                    FrameLayout frameLayout = this.getFrameForChild();
                    if (view != null) {
                        frameLayout.addView(view);
                    }
                    this.mViewsMap.put(n17, new ViewAndMetaData(frameLayout, n19, n20, l));
                    this.addChild(frameLayout);
                    this.applyTransformForChildAtIndex(frameLayout, n19);
                    this.transformViewForTransition(-1, n19, frameLayout, bl);
                }
                this.mViewsMap.get((Object)Integer.valueOf((int)n17)).view.bringToFront();
            }
            this.mCurrentWindowStart = n6;
            this.mCurrentWindowEnd = n7;
            this.mCurrentWindowStartUnbounded = n4;
            if (this.mRemoteViewsAdapter != null) {
                int n21 = this.modulo(this.mCurrentWindowStart, n3);
                int n22 = this.modulo(this.mCurrentWindowEnd, n3);
                this.mRemoteViewsAdapter.setVisibleRangeHint(n21, n22);
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    public void showPrevious() {
        this.setDisplayedChild(-1 + this.mWhichChild);
    }

    void showTapFeedback(View view) {
        view.setPressed(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void transformViewForTransition(int n, int n2, View view, boolean bl) {
        if (n == -1) {
            this.mInAnimation.setTarget(view);
            this.mInAnimation.start();
            return;
        } else {
            if (n2 != -1) return;
            this.mOutAnimation.setTarget(view);
            this.mOutAnimation.start();
            return;
        }
    }

    final class CheckForTap
    implements Runnable {
        CheckForTap() {
        }

        @Override
        public void run() {
            if (AdapterViewAnimator.this.mTouchMode == 1) {
                View view = AdapterViewAnimator.this.getCurrentView();
                AdapterViewAnimator.this.showTapFeedback(view);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int whichChild;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.whichChild = parcel.readInt();
        }

        SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.whichChild = n;
        }

        public String toString() {
            return "AdapterViewAnimator.SavedState{ whichChild = " + this.whichChild + " }";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.whichChild);
        }
    }

    class ViewAndMetaData {
        int adapterPosition;
        long itemId;
        int relativeIndex;
        View view;

        ViewAndMetaData(View view, int n, int n2, long l) {
            this.view = view;
            this.relativeIndex = n;
            this.adapterPosition = n2;
            this.itemId = l;
        }
    }
}

