/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListPosition;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.internal.R;
import java.util.ArrayList;

public class ExpandableListView
extends ListView {
    public static final int CHILD_INDICATOR_INHERIT = -1;
    private static final int[] CHILD_LAST_STATE_SET;
    private static final int[] EMPTY_STATE_SET;
    private static final int[] GROUP_EMPTY_STATE_SET;
    private static final int[] GROUP_EXPANDED_EMPTY_STATE_SET;
    private static final int[] GROUP_EXPANDED_STATE_SET;
    private static final int[][] GROUP_STATE_SETS;
    private static final int INDICATOR_UNDEFINED = -2;
    private static final long PACKED_POSITION_INT_MASK_CHILD = -1L;
    private static final long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    private static final long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    private static final long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    private static final long PACKED_POSITION_SHIFT_GROUP = 32L;
    private static final long PACKED_POSITION_SHIFT_TYPE = 63L;
    public static final int PACKED_POSITION_TYPE_CHILD = 1;
    public static final int PACKED_POSITION_TYPE_GROUP = 0;
    public static final int PACKED_POSITION_TYPE_NULL = 2;
    public static final long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    private ExpandableListAdapter mAdapter;
    private Drawable mChildDivider;
    private Drawable mChildIndicator;
    private int mChildIndicatorEnd;
    private int mChildIndicatorLeft;
    private int mChildIndicatorRight;
    private int mChildIndicatorStart;
    private ExpandableListConnector mConnector;
    private Drawable mGroupIndicator;
    private int mIndicatorEnd;
    private int mIndicatorLeft;
    private final Rect mIndicatorRect = new Rect();
    private int mIndicatorRight;
    private int mIndicatorStart;
    private OnChildClickListener mOnChildClickListener;
    private OnGroupClickListener mOnGroupClickListener;
    private OnGroupCollapseListener mOnGroupCollapseListener;
    private OnGroupExpandListener mOnGroupExpandListener;

    static {
        EMPTY_STATE_SET = new int[0];
        GROUP_EXPANDED_STATE_SET = new int[]{16842920};
        GROUP_EMPTY_STATE_SET = new int[]{16842921};
        GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
        int[][] nArrayArray = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
        GROUP_STATE_SETS = nArrayArray;
        CHILD_LAST_STATE_SET = new int[]{16842918};
    }

    public ExpandableListView(Context context) {
        this(context, null);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842863);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ExpandableListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ExpandableListView, n, n2);
        this.mGroupIndicator = typedArray.getDrawable(0);
        this.mChildIndicator = typedArray.getDrawable(1);
        this.mIndicatorLeft = typedArray.getDimensionPixelSize(2, 0);
        this.mIndicatorRight = typedArray.getDimensionPixelSize(3, 0);
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
        this.mChildIndicatorLeft = typedArray.getDimensionPixelSize(4, -1);
        this.mChildIndicatorRight = typedArray.getDimensionPixelSize(5, -1);
        this.mChildDivider = typedArray.getDrawable(6);
        if (!this.isRtlCompatibilityMode()) {
            this.mIndicatorStart = typedArray.getDimensionPixelSize(7, -2);
            this.mIndicatorEnd = typedArray.getDimensionPixelSize(8, -2);
            this.mChildIndicatorStart = typedArray.getDimensionPixelSize(9, -1);
            this.mChildIndicatorEnd = typedArray.getDimensionPixelSize(10, -1);
        }
        typedArray.recycle();
    }

    private int getAbsoluteFlatPosition(int n) {
        return n + this.getHeaderViewsCount();
    }

    private long getChildOrGroupId(ExpandableListPosition expandableListPosition) {
        if (expandableListPosition.type == 1) {
            return this.mAdapter.getChildId(expandableListPosition.groupPos, expandableListPosition.childPos);
        }
        return this.mAdapter.getGroupId(expandableListPosition.groupPos);
    }

    private int getFlatPositionForConnector(int n) {
        return n - this.getHeaderViewsCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Drawable getIndicator(ExpandableListConnector.PositionMetadata positionMetadata) {
        Drawable drawable2;
        int n = 1;
        if (positionMetadata.position.type == 2) {
            drawable2 = this.mGroupIndicator;
            if (drawable2 == null || !drawable2.isStateful()) return drawable2;
            int n2 = positionMetadata.groupMetadata == null || positionMetadata.groupMetadata.lastChildFlPos == positionMetadata.groupMetadata.flPos ? n : 0;
            if (!positionMetadata.isExpanded()) {
                n = 0;
            }
            int n3 = 0;
            if (n2 != 0) {
                n3 = 2;
            }
            int n4 = n | n3;
            drawable2.setState(GROUP_STATE_SETS[n4]);
            return drawable2;
        }
        drawable2 = this.mChildIndicator;
        if (drawable2 == null || !drawable2.isStateful()) return drawable2;
        int[] nArray = positionMetadata.position.flatListPos == positionMetadata.groupMetadata.lastChildFlPos ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
        drawable2.setState(nArray);
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getPackedPositionChild(long l) {
        if (l == 0xFFFFFFFFL || (l & Long.MIN_VALUE) != Long.MIN_VALUE) {
            return -1;
        }
        return (int)(l & 0xFFFFFFFFL);
    }

    public static long getPackedPositionForChild(int n, int n2) {
        return Long.MIN_VALUE | (Integer.MAX_VALUE & (long)n) << 32 | 0xFFFFFFFFFFFFFFFFL & (long)n2;
    }

    public static long getPackedPositionForGroup(int n) {
        return (Integer.MAX_VALUE & (long)n) << 32;
    }

    public static int getPackedPositionGroup(long l) {
        if (l == 0xFFFFFFFFL) {
            return -1;
        }
        return (int)((0x7FFFFFFF00000000L & l) >> 32);
    }

    public static int getPackedPositionType(long l) {
        if (l == 0xFFFFFFFFL) {
            return 2;
        }
        if ((l & Long.MIN_VALUE) == Long.MIN_VALUE) {
            return 1;
        }
        return 0;
    }

    private boolean hasRtlSupport() {
        return this.mContext.getApplicationInfo().hasRtlSupport();
    }

    private boolean isHeaderOrFooterPosition(int n) {
        int n2 = this.mItemCount - this.getFooterViewsCount();
        return n < this.getHeaderViewsCount() || n >= n2;
    }

    private boolean isRtlCompatibilityMode() {
        return this.mContext.getApplicationInfo().targetSdkVersion < 17 || !this.hasRtlSupport();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resolveChildIndicator() {
        if (this.isLayoutRtl()) {
            if (this.mChildIndicatorStart >= -1) {
                this.mChildIndicatorRight = this.mChildIndicatorStart;
            }
            if (this.mChildIndicatorEnd < -1) return;
            this.mChildIndicatorLeft = this.mChildIndicatorEnd;
            return;
        }
        if (this.mChildIndicatorStart >= -1) {
            this.mChildIndicatorLeft = this.mChildIndicatorStart;
        }
        if (this.mChildIndicatorEnd < -1) return;
        this.mChildIndicatorRight = this.mChildIndicatorEnd;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resolveIndicator() {
        if (this.isLayoutRtl()) {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorRight = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorLeft = this.mIndicatorEnd;
            }
        } else {
            if (this.mIndicatorStart >= 0) {
                this.mIndicatorLeft = this.mIndicatorStart;
            }
            if (this.mIndicatorEnd >= 0) {
                this.mIndicatorRight = this.mIndicatorEnd;
            }
        }
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    public boolean collapseGroup(int n) {
        boolean bl = this.mConnector.collapseGroup(n);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(n);
        }
        return bl;
    }

    @Override
    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        if (this.isHeaderOrFooterPosition(n)) {
            return new AdapterView.AdapterContextMenuInfo(view, n, l);
        }
        int n2 = this.getFlatPositionForConnector(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n2);
        ExpandableListPosition expandableListPosition = positionMetadata.position;
        long l2 = this.getChildOrGroupId(expandableListPosition);
        long l3 = expandableListPosition.getPackedPosition();
        positionMetadata.recycle();
        return new ExpandableListContextMenuInfo(view, l3, l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        int n;
        block15: {
            block14: {
                super.dispatchDraw(canvas);
                if (this.mChildIndicator == null && this.mGroupIndicator == null) break block14;
                boolean bl = (0x22 & this.mGroupFlags) == 34;
                n = 0;
                if (bl) {
                    n = canvas.save();
                    int n2 = this.mScrollX;
                    int n3 = this.mScrollY;
                    canvas.clipRect(n2 + this.mPaddingLeft, n3 + this.mPaddingTop, n2 + this.mRight - this.mLeft - this.mPaddingRight, n3 + this.mBottom - this.mTop - this.mPaddingBottom);
                }
                int n4 = this.getHeaderViewsCount();
                int n5 = -1 + (this.mItemCount - this.getFooterViewsCount() - n4);
                int n6 = this.mBottom;
                int n7 = -4;
                Rect rect = this.mIndicatorRect;
                int n8 = this.getChildCount();
                int n9 = this.mFirstPosition - n4;
                for (int i = 0; i < n8; ++i, ++n9) {
                    if (n9 < 0) continue;
                    if (n9 > n5) break;
                    View view = this.getChildAt(i);
                    int n10 = view.getTop();
                    int n11 = view.getBottom();
                    if (n11 < 0 || n10 > n6) continue;
                    ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n9);
                    boolean bl2 = this.isLayoutRtl();
                    int n12 = this.getWidth();
                    if (positionMetadata.position.type != n7) {
                        if (positionMetadata.position.type == 1) {
                            int n13 = this.mChildIndicatorLeft == -1 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                            rect.left = n13;
                            int n14 = this.mChildIndicatorRight == -1 ? this.mIndicatorRight : this.mChildIndicatorRight;
                            rect.right = n14;
                        } else {
                            rect.left = this.mIndicatorLeft;
                            rect.right = this.mIndicatorRight;
                        }
                        if (bl2) {
                            int n15 = rect.left;
                            rect.left = n12 - rect.right;
                            rect.right = n12 - n15;
                            rect.left -= this.mPaddingRight;
                            rect.right -= this.mPaddingRight;
                        } else {
                            rect.left += this.mPaddingLeft;
                            rect.right += this.mPaddingLeft;
                        }
                        n7 = positionMetadata.position.type;
                    }
                    if (rect.left != rect.right) {
                        Drawable drawable2;
                        if (this.mStackFromBottom) {
                            rect.top = n10;
                            rect.bottom = n11;
                        } else {
                            rect.top = n10;
                            rect.bottom = n11;
                        }
                        if ((drawable2 = this.getIndicator(positionMetadata)) != null) {
                            drawable2.setBounds(rect);
                            drawable2.draw(canvas);
                        }
                    }
                    positionMetadata.recycle();
                }
                if (bl) break block15;
            }
            return;
        }
        canvas.restoreToCount(n);
    }

    @Override
    void drawDivider(Canvas canvas, Rect rect, int n) {
        int n2 = n + this.mFirstPosition;
        if (n2 >= 0) {
            int n3 = this.getFlatPositionForConnector(n2);
            ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n3);
            if (positionMetadata.position.type == 1 || positionMetadata.isExpanded() && positionMetadata.groupMetadata.lastChildFlPos != positionMetadata.groupMetadata.flPos) {
                Drawable drawable2 = this.mChildDivider;
                drawable2.setBounds(rect);
                drawable2.draw(canvas);
                positionMetadata.recycle();
                return;
            }
            positionMetadata.recycle();
        }
        super.drawDivider(canvas, rect, n2);
    }

    public boolean expandGroup(int n) {
        return this.expandGroup(n, false);
    }

    public boolean expandGroup(int n, boolean bl) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtain(2, n, -1, -1);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        expandableListPosition.recycle();
        boolean bl2 = this.mConnector.expandGroup(positionMetadata);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(n);
        }
        if (bl) {
            int n2 = positionMetadata.position.flatListPos + this.getHeaderViewsCount();
            this.smoothScrollToPosition(n2 + this.mAdapter.getChildrenCount(n), n2);
        }
        positionMetadata.recycle();
        return bl2;
    }

    @Override
    public ListAdapter getAdapter() {
        return super.getAdapter();
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return this.mAdapter;
    }

    public long getExpandableListPosition(int n) {
        if (this.isHeaderOrFooterPosition(n)) {
            return 0xFFFFFFFFL;
        }
        int n2 = this.getFlatPositionForConnector(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n2);
        long l = positionMetadata.position.getPackedPosition();
        positionMetadata.recycle();
        return l;
    }

    public int getFlatListPosition(long l) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainPosition(l);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        expandableListPosition.recycle();
        int n = positionMetadata.position.flatListPos;
        positionMetadata.recycle();
        return this.getAbsoluteFlatPosition(n);
    }

    public long getSelectedId() {
        long l = this.getSelectedPosition();
        if (l == 0xFFFFFFFFL) {
            return -1L;
        }
        int n = ExpandableListView.getPackedPositionGroup(l);
        if (ExpandableListView.getPackedPositionType(l) == 0) {
            return this.mAdapter.getGroupId(n);
        }
        return this.mAdapter.getChildId(n, ExpandableListView.getPackedPositionChild(l));
    }

    public long getSelectedPosition() {
        return this.getExpandableListPosition(this.getSelectedItemPosition());
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean handleItemClick(View view, int n, long l) {
        boolean bl;
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getUnflattenedPos(n);
        long l2 = this.getChildOrGroupId(positionMetadata.position);
        if (positionMetadata.position.type == 2) {
            if (this.mOnGroupClickListener != null && this.mOnGroupClickListener.onGroupClick(this, view, positionMetadata.position.groupPos, l2)) {
                positionMetadata.recycle();
                return true;
            }
            if (positionMetadata.isExpanded()) {
                this.mConnector.collapseGroup(positionMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    this.mOnGroupCollapseListener.onGroupCollapse(positionMetadata.position.groupPos);
                }
            } else {
                this.mConnector.expandGroup(positionMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    this.mOnGroupExpandListener.onGroupExpand(positionMetadata.position.groupPos);
                }
                int n2 = positionMetadata.position.groupPos;
                int n3 = positionMetadata.position.flatListPos + this.getHeaderViewsCount();
                this.smoothScrollToPosition(n3 + this.mAdapter.getChildrenCount(n2), n3);
            }
            bl = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                return this.mOnChildClickListener.onChildClick(this, view, positionMetadata.position.groupPos, positionMetadata.position.childPos, l2);
            }
            bl = false;
        }
        positionMetadata.recycle();
        return bl;
    }

    public boolean isGroupExpanded(int n) {
        return this.mConnector.isGroupExpanded(n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ExpandableListView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ExpandableListView.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            SavedState savedState = (SavedState)parcelable;
            super.onRestoreInstanceState(savedState.getSuperState());
            if (this.mConnector == null || savedState.expandedGroupMetadataList == null) return;
            this.mConnector.setExpandedGroupMetadataList(savedState.expandedGroupMetadataList);
            return;
        }
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        this.resolveIndicator();
        this.resolveChildIndicator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parcelable onSaveInstanceState() {
        ArrayList<ExpandableListConnector.GroupMetadata> arrayList;
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.mConnector != null) {
            arrayList = this.mConnector.getExpandedGroupMetadataList();
            return new SavedState(parcelable, arrayList);
        }
        arrayList = null;
        return new SavedState(parcelable, arrayList);
    }

    @Override
    public boolean performItemClick(View view, int n, long l) {
        if (this.isHeaderOrFooterPosition(n)) {
            return super.performItemClick(view, n, l);
        }
        return this.handleItemClick(view, this.getFlatPositionForConnector(n), l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setAdapter(ExpandableListAdapter expandableListAdapter) {
        this.mAdapter = expandableListAdapter;
        this.mConnector = expandableListAdapter != null ? new ExpandableListConnector(expandableListAdapter) : null;
        super.setAdapter(this.mConnector);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    public void setChildDivider(Drawable drawable2) {
        this.mChildDivider = drawable2;
    }

    public void setChildIndicator(Drawable drawable2) {
        this.mChildIndicator = drawable2;
    }

    public void setChildIndicatorBounds(int n, int n2) {
        this.mChildIndicatorLeft = n;
        this.mChildIndicatorRight = n2;
        this.resolveChildIndicator();
    }

    public void setChildIndicatorBoundsRelative(int n, int n2) {
        this.mChildIndicatorStart = n;
        this.mChildIndicatorEnd = n2;
        this.resolveChildIndicator();
    }

    public void setGroupIndicator(Drawable drawable2) {
        this.mGroupIndicator = drawable2;
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    public void setIndicatorBounds(int n, int n2) {
        this.mIndicatorLeft = n;
        this.mIndicatorRight = n2;
        this.resolveIndicator();
    }

    public void setIndicatorBoundsRelative(int n, int n2) {
        this.mIndicatorStart = n;
        this.mIndicatorEnd = n2;
        this.resolveIndicator();
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        super.setOnItemClickListener(onItemClickListener);
    }

    public boolean setSelectedChild(int n, int n2, boolean bl) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainChildPosition(n, n2);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        if (positionMetadata == null) {
            if (!bl) {
                return false;
            }
            this.expandGroup(n);
            positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
            if (positionMetadata == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        super.setSelection(this.getAbsoluteFlatPosition(positionMetadata.position.flatListPos));
        expandableListPosition.recycle();
        positionMetadata.recycle();
        return true;
    }

    public void setSelectedGroup(int n) {
        ExpandableListPosition expandableListPosition = ExpandableListPosition.obtainGroupPosition(n);
        ExpandableListConnector.PositionMetadata positionMetadata = this.mConnector.getFlattenedPos(expandableListPosition);
        expandableListPosition.recycle();
        super.setSelection(this.getAbsoluteFlatPosition(positionMetadata.position.flatListPos));
        positionMetadata.recycle();
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public long packedPosition;
        public View targetView;

        public ExpandableListContextMenuInfo(View view, long l, long l2) {
            this.targetView = view;
            this.packedPosition = l;
            this.id = l2;
        }
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.expandedGroupMetadataList = new ArrayList();
            parcel.readList(this.expandedGroupMetadataList, ExpandableListConnector.class.getClassLoader());
        }

        SavedState(Parcelable parcelable, ArrayList<ExpandableListConnector.GroupMetadata> arrayList) {
            super(parcelable);
            this.expandedGroupMetadataList = arrayList;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeList(this.expandedGroupMetadataList);
        }
    }
}

