/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.IBinder;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.lang.ref.WeakReference;

public class PopupWindow {
    private static final int[] ABOVE_ANCHOR_STATE_SET = new int[]{0x10100AA};
    private static final int DEFAULT_ANCHORED_GRAVITY = 0x800033;
    public static final int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static final int INPUT_METHOD_NEEDED = 1;
    public static final int INPUT_METHOD_NOT_NEEDED = 2;
    private boolean mAboveAnchor;
    private Drawable mAboveAnchorBackgroundDrawable;
    private boolean mAllowScrollingAnchorParent;
    private WeakReference<View> mAnchor;
    private int mAnchorRelativeX;
    private int mAnchorRelativeY;
    private int mAnchorXoff;
    private int mAnchorYoff;
    private int mAnchoredGravity;
    private int mAnimationStyle;
    private Drawable mBackground;
    private Drawable mBelowAnchorBackgroundDrawable;
    private boolean mClipToScreen;
    private boolean mClippingEnabled;
    private View mContentView;
    private Context mContext;
    private int[] mDrawingLocation;
    private float mElevation;
    private boolean mFocusable;
    private int mHeight;
    private int mHeightMode;
    private boolean mIgnoreCheekPress;
    private int mInputMethodMode;
    private boolean mIsDropdown;
    private boolean mIsShowing;
    private int mLastHeight;
    private int mLastWidth;
    private boolean mLayoutInScreen;
    private boolean mLayoutInsetDecor;
    private boolean mNotTouchModal;
    private OnDismissListener mOnDismissListener;
    private final ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private boolean mOutsideTouchable;
    private boolean mOverlapAnchor;
    private int mPopupHeight;
    private View mPopupView;
    private boolean mPopupViewInitialLayoutDirectionInherited;
    private int mPopupWidth;
    private int[] mScreenLocation;
    private int mSoftInputMode;
    private int mSplitTouchEnabled;
    private Rect mTempRect;
    private View.OnTouchListener mTouchInterceptor;
    private boolean mTouchable;
    private int mWidth;
    private int mWidthMode;
    private int mWindowLayoutType;
    private WindowManager mWindowManager;

    public PopupWindow() {
        this(null, 0, 0);
    }

    public PopupWindow(int n, int n2) {
        this(null, n, n2);
    }

    public PopupWindow(Context context) {
        this(context, null);
    }

    public PopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842870);
    }

    public PopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        TypedArray typedArray;
        block6: {
            this.mInputMethodMode = 0;
            this.mSoftInputMode = 1;
            this.mTouchable = true;
            this.mOutsideTouchable = false;
            this.mClippingEnabled = true;
            this.mSplitTouchEnabled = -1;
            this.mAllowScrollingAnchorParent = true;
            this.mLayoutInsetDecor = false;
            this.mDrawingLocation = new int[2];
            this.mScreenLocation = new int[2];
            this.mTempRect = new Rect();
            this.mWindowLayoutType = 1000;
            this.mIgnoreCheekPress = false;
            this.mAnimationStyle = -1;
            this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void onScrollChanged() {
                    if (PopupWindow.this.mAnchor == null) return;
                    View view = (View)PopupWindow.this.mAnchor.get();
                    if (view == null) return;
                    if (PopupWindow.this.mPopupView == null) return;
                    WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)PopupWindow.this.mPopupView.getLayoutParams();
                    PopupWindow.this.updateAboveAnchor(PopupWindow.this.findDropDownPosition(view, layoutParams, PopupWindow.this.mAnchorXoff, PopupWindow.this.mAnchorYoff, PopupWindow.this.mAnchoredGravity));
                    PopupWindow.this.update(layoutParams.x, layoutParams.y, -1, -1, true);
                }
            };
            this.mContext = context;
            this.mWindowManager = (WindowManager)context.getSystemService("window");
            typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PopupWindow, n, n2);
            this.mBackground = typedArray.getDrawable(0);
            this.mElevation = typedArray.getDimension(3, 0.0f);
            this.mOverlapAnchor = typedArray.getBoolean(2, false);
            int n3 = typedArray.getResourceId(1, -1);
            if (n3 == 16974564) {
                n3 = -1;
            }
            this.mAnimationStyle = n3;
            if (!(this.mBackground instanceof StateListDrawable)) break block6;
            StateListDrawable stateListDrawable = (StateListDrawable)this.mBackground;
            int n4 = stateListDrawable.getStateDrawableIndex(ABOVE_ANCHOR_STATE_SET);
            int n5 = stateListDrawable.getStateCount();
            int n6 = -1;
            int n7 = 0;
            while (true) {
                block8: {
                    block7: {
                        if (n7 >= n5) break block7;
                        if (n7 == n4) break block8;
                        n6 = n7;
                    }
                    if (n4 != -1 && n6 != -1) {
                        this.mAboveAnchorBackgroundDrawable = stateListDrawable.getStateDrawable(n4);
                        this.mBelowAnchorBackgroundDrawable = stateListDrawable.getStateDrawable(n6);
                        break;
                    }
                    this.mBelowAnchorBackgroundDrawable = null;
                    this.mAboveAnchorBackgroundDrawable = null;
                    break;
                }
                ++n7;
            }
        }
        typedArray.recycle();
    }

    public PopupWindow(View view) {
        this(view, 0, 0);
    }

    public PopupWindow(View view, int n, int n2) {
        this(view, n, n2, false);
    }

    public PopupWindow(View view, int n, int n2, boolean bl) {
        this.mInputMethodMode = 0;
        this.mSoftInputMode = 1;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        this.mSplitTouchEnabled = -1;
        this.mAllowScrollingAnchorParent = true;
        this.mLayoutInsetDecor = false;
        this.mDrawingLocation = new int[2];
        this.mScreenLocation = new int[2];
        this.mTempRect = new Rect();
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mOnScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        if (view != null) {
            this.mContext = view.getContext();
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(view);
        this.setWidth(n);
        this.setHeight(n2);
        this.setFocusable(bl);
    }

    private int computeAnimationResource() {
        if (this.mAnimationStyle == -1) {
            if (this.mIsDropdown) {
                if (this.mAboveAnchor) {
                    return 16974556;
                }
                return 16974555;
            }
            return 0;
        }
        return this.mAnimationStyle;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeFlags(int n) {
        int n2 = n & 0xFF797DE7;
        if (this.mIgnoreCheekPress) {
            n2 |= 0x8000;
        }
        if (!this.mFocusable) {
            n2 |= 8;
            if (this.mInputMethodMode == 1) {
                n2 |= 0x20000;
            }
        } else if (this.mInputMethodMode == 2) {
            n2 |= 0x20000;
        }
        if (!this.mTouchable) {
            n2 |= 0x10;
        }
        if (this.mOutsideTouchable) {
            n2 |= 0x40000;
        }
        if (!this.mClippingEnabled) {
            n2 |= 0x200;
        }
        if (this.isSplitTouchEnabled()) {
            n2 |= 0x800000;
        }
        if (this.mLayoutInScreen) {
            n2 |= 0x100;
        }
        if (this.mLayoutInsetDecor) {
            n2 |= 0x10000;
        }
        if (this.mNotTouchModal) {
            n2 |= 0x20;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private WindowManager.LayoutParams createPopupLayout(IBinder iBinder) {
        int n;
        int n2;
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.gravity = 0x800033;
        this.mLastWidth = n2 = this.mWidth;
        layoutParams.width = n2;
        this.mLastHeight = n = this.mHeight;
        layoutParams.height = n;
        layoutParams.format = this.mBackground != null ? this.mBackground.getOpacity() : -3;
        layoutParams.flags = this.computeFlags(layoutParams.flags);
        layoutParams.type = this.mWindowLayoutType;
        layoutParams.token = iBinder;
        layoutParams.softInputMode = this.mSoftInputMode;
        layoutParams.setTitle("PopupWindow:" + Integer.toHexString(this.hashCode()));
        return layoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean findDropDownPosition(View view, WindowManager.LayoutParams layoutParams, int n, int n2, int n3) {
        boolean bl;
        Rect rect;
        int n4;
        int n5;
        block18: {
            View view2;
            int n6;
            block17: {
                n5 = view.getHeight();
                n4 = view.getWidth();
                if (this.mOverlapAnchor) {
                    n2 -= n5;
                }
                view.getLocationInWindow(this.mDrawingLocation);
                layoutParams.x = n + this.mDrawingLocation[0];
                layoutParams.y = n2 + (n5 + this.mDrawingLocation[1]);
                n6 = 7 & Gravity.getAbsoluteGravity(n3, view.getLayoutDirection());
                if (n6 == 5) {
                    layoutParams.x -= this.mPopupWidth - n4;
                }
                layoutParams.gravity = 51;
                view.getLocationOnScreen(this.mScreenLocation);
                rect = new Rect();
                view.getWindowVisibleDisplayFrame(rect);
                int n7 = n2 + (n5 + this.mScreenLocation[1]);
                view2 = view.getRootView();
                if (n7 + this.mPopupHeight > rect.bottom) break block17;
                int n8 = layoutParams.x + this.mPopupWidth - view2.getWidth();
                bl = false;
                if (n8 <= 0) break block18;
            }
            if (this.mAllowScrollingAnchorParent) {
                int n9 = view.getScrollX();
                int n10 = view.getScrollY();
                view.requestRectangleOnScreen(new Rect(n9, n10, n + (n9 + this.mPopupWidth), n2 + (n5 + (n10 + this.mPopupHeight))), true);
            }
            view.getLocationInWindow(this.mDrawingLocation);
            layoutParams.x = n + this.mDrawingLocation[0];
            layoutParams.y = n2 + (n5 + this.mDrawingLocation[1]);
            if (n6 == 5) {
                layoutParams.x -= this.mPopupWidth - n4;
            }
            view.getLocationOnScreen(this.mScreenLocation);
            bl = rect.bottom - this.mScreenLocation[1] - n5 - n2 < this.mScreenLocation[1] - n2 - rect.top;
            if (bl) {
                layoutParams.gravity = 83;
                layoutParams.y = n2 + (view2.getHeight() - this.mDrawingLocation[1]);
            } else {
                layoutParams.y = n2 + (n5 + this.mDrawingLocation[1]);
            }
        }
        if (this.mClipToScreen) {
            int n11 = layoutParams.x + layoutParams.width;
            int n12 = rect.right - rect.left;
            if (n11 > n12) {
                layoutParams.x -= n11 - n12;
            }
            if (layoutParams.x < rect.left) {
                layoutParams.x = rect.left;
                layoutParams.width = Math.min(layoutParams.width, n12);
            }
            if (bl) {
                int n13 = n2 + this.mScreenLocation[1] - this.mPopupHeight;
                if (n13 < 0) {
                    layoutParams.y = n13 + layoutParams.y;
                }
            } else {
                layoutParams.y = Math.max(layoutParams.y, rect.top);
            }
        }
        layoutParams.gravity = 0x10000000 | layoutParams.gravity;
        this.mAnchorRelativeX = this.mDrawingLocation[0] - layoutParams.x + n5 / 2;
        this.mAnchorRelativeY = this.mDrawingLocation[1] - layoutParams.y + n4 / 2;
        return bl;
    }

    private void invokePopup(WindowManager.LayoutParams layoutParams) {
        if (this.mContext != null) {
            layoutParams.packageName = this.mContext.getPackageName();
        }
        this.mPopupView.setFitsSystemWindows(this.mLayoutInsetDecor);
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.addView(this.mPopupView, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preparePopup(WindowManager.LayoutParams layoutParams) {
        if (this.mContentView == null || this.mContext == null || this.mWindowManager == null) {
            throw new IllegalStateException("You must specify a valid content view by calling setContentView() before attempting to show the popup.");
        }
        if (this.mBackground != null) {
            ViewGroup.LayoutParams layoutParams2 = this.mContentView.getLayoutParams();
            int n = -1;
            if (layoutParams2 != null && layoutParams2.height == -2) {
                n = -2;
            }
            PopupViewContainer popupViewContainer = new PopupViewContainer(this.mContext);
            FrameLayout.LayoutParams layoutParams3 = new FrameLayout.LayoutParams(-1, n);
            popupViewContainer.setBackground(this.mBackground);
            popupViewContainer.addView(this.mContentView, layoutParams3);
            this.mPopupView = popupViewContainer;
        } else {
            this.mPopupView = this.mContentView;
        }
        this.mPopupView.setElevation(this.mElevation);
        boolean bl = this.mPopupView.getRawLayoutDirection() == 2;
        this.mPopupViewInitialLayoutDirectionInherited = bl;
        this.mPopupWidth = layoutParams.width;
        this.mPopupHeight = layoutParams.height;
    }

    private void registerForScrollChanged(View view, int n, int n2, int n3) {
        this.unregisterForScrollChanged();
        this.mAnchor = new WeakReference<View>(view);
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver != null) {
            viewTreeObserver.addOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchorXoff = n;
        this.mAnchorYoff = n2;
        this.mAnchoredGravity = n3;
    }

    private void setLayoutDirectionFromAnchor() {
        View view;
        if (this.mAnchor != null && (view = (View)this.mAnchor.get()) != null && this.mPopupViewInitialLayoutDirectionInherited) {
            this.mPopupView.setLayoutDirection(view.getLayoutDirection());
        }
    }

    private void unregisterForScrollChanged() {
        WeakReference<View> weakReference = this.mAnchor;
        View view = null;
        if (weakReference != null) {
            view = (View)weakReference.get();
        }
        if (view != null) {
            view.getViewTreeObserver().removeOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchor = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void update(View view, boolean bl, int n, int n2, boolean bl2, int n3, int n4, int n5) {
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WeakReference<View> weakReference = this.mAnchor;
        boolean bl3 = bl && (this.mAnchorXoff != n || this.mAnchorYoff != n2);
        if (weakReference == null || weakReference.get() != view || bl3 && !this.mIsDropdown) {
            this.registerForScrollChanged(view, n, n2, n5);
        } else if (bl3) {
            this.mAnchorXoff = n;
            this.mAnchorYoff = n2;
            this.mAnchoredGravity = n5;
        }
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        if (bl2) {
            if (n3 == -1) {
                n3 = this.mPopupWidth;
            } else {
                this.mPopupWidth = n3;
            }
            if (n4 == -1) {
                n4 = this.mPopupHeight;
            } else {
                this.mPopupHeight = n4;
            }
        }
        int n6 = layoutParams.x;
        int n7 = layoutParams.y;
        if (bl) {
            this.updateAboveAnchor(this.findDropDownPosition(view, layoutParams, n, n2, n5));
        } else {
            this.updateAboveAnchor(this.findDropDownPosition(view, layoutParams, this.mAnchorXoff, this.mAnchorYoff, this.mAnchoredGravity));
        }
        int n8 = layoutParams.x;
        int n9 = layoutParams.y;
        boolean bl4 = n6 != layoutParams.x || n7 != layoutParams.y;
        this.update(n8, n9, n3, n4, bl4);
    }

    private void updateAboveAnchor(boolean bl) {
        block3: {
            block4: {
                block2: {
                    if (bl == this.mAboveAnchor) break block2;
                    this.mAboveAnchor = bl;
                    if (this.mBackground == null) break block2;
                    if (this.mAboveAnchorBackgroundDrawable == null) break block3;
                    if (!this.mAboveAnchor) break block4;
                    this.mPopupView.setBackground(this.mAboveAnchorBackgroundDrawable);
                }
                return;
            }
            this.mPopupView.setBackground(this.mBelowAnchorBackgroundDrawable);
            return;
        }
        this.mPopupView.refreshDrawableState();
    }

    public void dismiss() {
        if (this.isShowing() && this.mPopupView != null) {
            this.mIsShowing = false;
            this.unregisterForScrollChanged();
            this.mWindowManager.removeViewImmediate(this.mPopupView);
        }
        return;
        finally {
            if (this.mPopupView != this.mContentView && this.mPopupView instanceof ViewGroup) {
                ((ViewGroup)this.mPopupView).removeView(this.mContentView);
            }
            this.mPopupView = null;
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismiss();
            }
        }
    }

    public int getAnimationStyle() {
        return this.mAnimationStyle;
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public float getElevation() {
        return this.mElevation;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getInputMethodMode() {
        return this.mInputMethodMode;
    }

    public int getMaxAvailableHeight(View view) {
        return this.getMaxAvailableHeight(view, 0);
    }

    public int getMaxAvailableHeight(View view, int n) {
        return this.getMaxAvailableHeight(view, n, false);
    }

    public int getMaxAvailableHeight(View view, int n, boolean bl) {
        Rect rect = new Rect();
        view.getWindowVisibleDisplayFrame(rect);
        int[] nArray = this.mDrawingLocation;
        view.getLocationOnScreen(nArray);
        int n2 = rect.bottom;
        if (bl) {
            n2 = view.getContext().getResources().getDisplayMetrics().heightPixels;
        }
        int n3 = Math.max(n2 - (nArray[1] + view.getHeight()) - n, n + (nArray[1] - rect.top));
        if (this.mBackground != null) {
            this.mBackground.getPadding(this.mTempRect);
            n3 -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return n3;
    }

    public int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    public boolean isAboveAnchor() {
        return this.mAboveAnchor;
    }

    public boolean isClippingEnabled() {
        return this.mClippingEnabled;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    public boolean isLayoutInScreenEnabled() {
        return this.mLayoutInScreen;
    }

    public boolean isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSplitTouchEnabled() {
        if (this.mSplitTouchEnabled < 0 && this.mContext != null) {
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 11) return true;
            return false;
        }
        if (this.mSplitTouchEnabled != 1) return false;
        return true;
    }

    public boolean isTouchable() {
        return this.mTouchable;
    }

    void setAllowScrollingAnchorParent(boolean bl) {
        this.mAllowScrollingAnchorParent = bl;
    }

    public void setAnimationStyle(int n) {
        this.mAnimationStyle = n;
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        this.mBackground = drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setClipToScreenEnabled(boolean bl) {
        this.mClipToScreen = bl;
        boolean bl2 = !bl;
        this.setClippingEnabled(bl2);
    }

    public void setClippingEnabled(boolean bl) {
        this.mClippingEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setContentView(View view) {
        block5: {
            block4: {
                if (this.isShowing()) break block4;
                this.mContentView = view;
                if (this.mContext == null && this.mContentView != null) {
                    this.mContext = this.mContentView.getContext();
                }
                if (this.mWindowManager == null && this.mContentView != null) break block5;
            }
            return;
        }
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
    }

    public void setElevation(float f) {
        this.mElevation = f;
    }

    public void setFocusable(boolean bl) {
        this.mFocusable = bl;
    }

    public void setHeight(int n) {
        this.mHeight = n;
    }

    public void setIgnoreCheekPress() {
        this.mIgnoreCheekPress = true;
    }

    public void setInputMethodMode(int n) {
        this.mInputMethodMode = n;
    }

    public void setLayoutInScreenEnabled(boolean bl) {
        this.mLayoutInScreen = bl;
    }

    public void setLayoutInsetDecor(boolean bl) {
        this.mLayoutInsetDecor = bl;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setOutsideTouchable(boolean bl) {
        this.mOutsideTouchable = bl;
    }

    public void setSoftInputMode(int n) {
        this.mSoftInputMode = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSplitTouchEnabled(boolean bl) {
        int n = bl ? 1 : 0;
        this.mSplitTouchEnabled = n;
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        this.mTouchInterceptor = onTouchListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTouchModal(boolean bl) {
        boolean bl2 = !bl;
        this.mNotTouchModal = bl2;
    }

    public void setTouchable(boolean bl) {
        this.mTouchable = bl;
    }

    public void setWidth(int n) {
        this.mWidth = n;
    }

    public void setWindowLayoutMode(int n, int n2) {
        this.mWidthMode = n;
        this.mHeightMode = n2;
    }

    public void setWindowLayoutType(int n) {
        this.mWindowLayoutType = n;
    }

    public void showAsDropDown(View view) {
        this.showAsDropDown(view, 0, 0);
    }

    public void showAsDropDown(View view, int n, int n2) {
        this.showAsDropDown(view, n, n2, 0x800033);
    }

    public void showAsDropDown(View view, int n, int n2, int n3) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.registerForScrollChanged(view, n, n2, n3);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        WindowManager.LayoutParams layoutParams = this.createPopupLayout(view.getWindowToken());
        this.preparePopup(layoutParams);
        this.updateAboveAnchor(this.findDropDownPosition(view, layoutParams, n, n2, n3));
        if (this.mHeightMode < 0) {
            int n4;
            this.mLastHeight = n4 = this.mHeightMode;
            layoutParams.height = n4;
        }
        if (this.mWidthMode < 0) {
            int n5;
            this.mLastWidth = n5 = this.mWidthMode;
            layoutParams.width = n5;
        }
        layoutParams.windowAnimations = this.computeAnimationResource();
        this.invokePopup(layoutParams);
    }

    public void showAtLocation(IBinder iBinder, int n, int n2, int n3) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.unregisterForScrollChanged();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        WindowManager.LayoutParams layoutParams = this.createPopupLayout(iBinder);
        layoutParams.windowAnimations = this.computeAnimationResource();
        this.preparePopup(layoutParams);
        if (n == 0) {
            n = 0x800033;
        }
        layoutParams.gravity = n;
        layoutParams.x = n2;
        layoutParams.y = n3;
        if (this.mHeightMode < 0) {
            int n4;
            this.mLastHeight = n4 = this.mHeightMode;
            layoutParams.height = n4;
        }
        if (this.mWidthMode < 0) {
            int n5;
            this.mLastWidth = n5 = this.mWidthMode;
            layoutParams.width = n5;
        }
        this.invokePopup(layoutParams);
    }

    public void showAtLocation(View view, int n, int n2, int n3) {
        this.showAtLocation(view.getWindowToken(), n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update() {
        WindowManager.LayoutParams layoutParams;
        block6: {
            block5: {
                int n;
                if (!this.isShowing() || this.mContentView == null) break block5;
                layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
                int n2 = this.computeAnimationResource();
                int n3 = layoutParams.windowAnimations;
                boolean bl = false;
                if (n2 != n3) {
                    layoutParams.windowAnimations = n2;
                    bl = true;
                }
                if ((n = this.computeFlags(layoutParams.flags)) != layoutParams.flags) {
                    layoutParams.flags = n;
                    bl = true;
                }
                if (bl) break block6;
            }
            return;
        }
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.updateViewLayout(this.mPopupView, layoutParams);
    }

    public void update(int n, int n2) {
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        this.update(layoutParams.x, layoutParams.y, n, n2, false);
    }

    public void update(int n, int n2, int n3, int n4) {
        this.update(n, n2, n3, n4, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(int n, int n2, int n3, int n4, boolean bl) {
        WindowManager.LayoutParams layoutParams;
        block12: {
            block11: {
                int n5;
                int n6;
                if (n3 != -1) {
                    this.mLastWidth = n3;
                    this.setWidth(n3);
                }
                if (n4 != -1) {
                    this.mLastHeight = n4;
                    this.setHeight(n4);
                }
                if (!this.isShowing() || this.mContentView == null) break block11;
                layoutParams = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
                boolean bl2 = bl;
                int n7 = this.mWidthMode < 0 ? this.mWidthMode : this.mLastWidth;
                if (n3 != -1 && layoutParams.width != n7) {
                    this.mLastWidth = n7;
                    layoutParams.width = n7;
                    bl2 = true;
                }
                int n8 = this.mHeightMode < 0 ? this.mHeightMode : this.mLastHeight;
                if (n4 != -1 && layoutParams.height != n8) {
                    this.mLastHeight = n8;
                    layoutParams.height = n8;
                    bl2 = true;
                }
                if (layoutParams.x != n) {
                    layoutParams.x = n;
                    bl2 = true;
                }
                if (layoutParams.y != n2) {
                    layoutParams.y = n2;
                    bl2 = true;
                }
                if ((n6 = this.computeAnimationResource()) != layoutParams.windowAnimations) {
                    layoutParams.windowAnimations = n6;
                    bl2 = true;
                }
                if ((n5 = this.computeFlags(layoutParams.flags)) != layoutParams.flags) {
                    layoutParams.flags = n5;
                    bl2 = true;
                }
                if (bl2) break block12;
            }
            return;
        }
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.updateViewLayout(this.mPopupView, layoutParams);
    }

    public void update(View view, int n, int n2) {
        this.update(view, false, 0, 0, true, n, n2, this.mAnchoredGravity);
    }

    public void update(View view, int n, int n2, int n3, int n4) {
        this.update(view, true, n, n2, true, n3, n4, this.mAnchoredGravity);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    private class PopupViewContainer
    extends FrameLayout {
        private static final String TAG = "PopupWindow.PopupViewContainer";

        public PopupViewContainer(Context context) {
            super(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl = true;
            if (keyEvent.getKeyCode() != 4) return super.dispatchKeyEvent(keyEvent);
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(keyEvent);
            }
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                if (dispatcherState == null) return bl;
                dispatcherState.startTracking(keyEvent, this);
                return bl;
            }
            if (keyEvent.getAction() != bl) return super.dispatchKeyEvent(keyEvent);
            KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
            if (dispatcherState == null) return super.dispatchKeyEvent(keyEvent);
            if (!dispatcherState.isTracking(keyEvent)) return super.dispatchKeyEvent(keyEvent);
            if (keyEvent.isCanceled()) return super.dispatchKeyEvent(keyEvent);
            PopupWindow.this.dismiss();
            return bl;
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            if (PopupWindow.this.mTouchInterceptor != null && PopupWindow.this.mTouchInterceptor.onTouch(this, motionEvent)) {
                return true;
            }
            return super.dispatchTouchEvent(motionEvent);
        }

        @Override
        protected int[] onCreateDrawableState(int n) {
            if (PopupWindow.this.mAboveAnchor) {
                int[] nArray = super.onCreateDrawableState(n + 1);
                View.mergeDrawableStates(nArray, ABOVE_ANCHOR_STATE_SET);
                return nArray;
            }
            return super.onCreateDrawableState(n);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            int n = (int)motionEvent.getX();
            int n2 = (int)motionEvent.getY();
            if (motionEvent.getAction() == 0 && (n < 0 || n >= this.getWidth() || n2 < 0 || n2 >= this.getHeight())) {
                PopupWindow.this.dismiss();
                return true;
            }
            if (motionEvent.getAction() == 4) {
                PopupWindow.this.dismiss();
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }

        @Override
        public void sendAccessibilityEvent(int n) {
            if (PopupWindow.this.mContentView != null) {
                PopupWindow.this.mContentView.sendAccessibilityEvent(n);
                return;
            }
            super.sendAccessibilityEvent(n);
        }
    }
}

