/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PendingIntent;
import android.appwidget.AppWidgetHostView;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.ImageView;
import android.widget.RemoteViewsListAdapter;
import android.widget.TextView;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import libcore.util.Objects;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    public static final Parcelable.Creator<RemoteViews> CREATOR;
    private static final OnClickHandler DEFAULT_ON_CLICK_HANDLER;
    static final String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    private static final String LOG_TAG = "RemoteViews";
    private static final int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private static final int MODE_NORMAL;
    private static final ThreadLocal<Object[]> sInvokeArgsTls;
    private static final ArrayMap<Class<? extends View>, ArrayMap<MutablePair<String, Class<?>>, Method>> sMethods;
    private static final Object[] sMethodsLock;
    private ArrayList<Action> mActions;
    private ApplicationInfo mApplication;
    private BitmapCache mBitmapCache;
    private boolean mIsRoot;
    private boolean mIsWidgetCollectionChild;
    private RemoteViews mLandscape;
    private final int mLayoutId;
    private MemoryUsageCounter mMemoryUsageCounter;
    private final MutablePair<String, Class<?>> mPair;
    private RemoteViews mPortrait;

    static {
        DEFAULT_ON_CLICK_HANDLER = new OnClickHandler();
        sMethodsLock = new Object[0];
        sMethods = new ArrayMap();
        sInvokeArgsTls = new ThreadLocal<Object[]>(){

            @Override
            protected Object[] initialValue() {
                return new Object[1];
            }
        };
        CREATOR = new Parcelable.Creator<RemoteViews>(){

            @Override
            public RemoteViews createFromParcel(Parcel parcel) {
                return new RemoteViews(parcel);
            }

            public RemoteViews[] newArray(int n) {
                return new RemoteViews[n];
            }
        };
    }

    protected RemoteViews(ApplicationInfo applicationInfo, int n) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mPair = new MutablePair<Object, Object>(null, null);
        this.mApplication = applicationInfo;
        this.mLayoutId = n;
        this.mBitmapCache = new BitmapCache();
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.recalculateMemoryUsage();
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private RemoteViews(Parcel parcel, BitmapCache bitmapCache) {
        block21: {
            int n;
            block22: {
                block20: {
                    this.mIsRoot = true;
                    this.mLandscape = null;
                    this.mPortrait = null;
                    this.mIsWidgetCollectionChild = false;
                    this.mPair = new MutablePair<Object, Object>(null, null);
                    int n2 = parcel.readInt();
                    if (bitmapCache == null) {
                        this.mBitmapCache = new BitmapCache(parcel);
                    } else {
                        this.setBitmapCache(bitmapCache);
                        this.setNotRoot();
                    }
                    if (n2 != 0) break block20;
                    this.mApplication = (ApplicationInfo)parcel.readParcelable(null);
                    this.mLayoutId = parcel.readInt();
                    boolean bl = parcel.readInt() == 1;
                    this.mIsWidgetCollectionChild = bl;
                    n = parcel.readInt();
                    if (n <= 0) break block21;
                    this.mActions = new ArrayList(n);
                    break block22;
                }
                this.mLandscape = new RemoteViews(parcel, this.mBitmapCache);
                this.mPortrait = new RemoteViews(parcel, this.mBitmapCache);
                this.mApplication = this.mPortrait.mApplication;
                this.mLayoutId = this.mPortrait.getLayoutId();
                break block21;
            }
            block17: for (int i = 0; i < n; ++i) {
                int n3 = parcel.readInt();
                switch (n3) {
                    default: {
                        throw new ActionException("Tag " + n3 + " not found");
                    }
                    case 1: {
                        this.mActions.add(new SetOnClickPendingIntent(parcel));
                        continue block17;
                    }
                    case 3: {
                        this.mActions.add(new SetDrawableParameters(parcel));
                        continue block17;
                    }
                    case 2: {
                        this.mActions.add(new ReflectionAction(parcel));
                        continue block17;
                    }
                    case 4: {
                        this.mActions.add(new ViewGroupAction(parcel, this.mBitmapCache));
                        continue block17;
                    }
                    case 5: {
                        this.mActions.add(new ReflectionActionWithoutParams(parcel));
                        continue block17;
                    }
                    case 6: {
                        this.mActions.add(new SetEmptyView(parcel));
                        continue block17;
                    }
                    case 8: {
                        this.mActions.add(new SetPendingIntentTemplate(parcel));
                        continue block17;
                    }
                    case 9: {
                        this.mActions.add(new SetOnClickFillInIntent(parcel));
                        continue block17;
                    }
                    case 10: {
                        this.mActions.add(new SetRemoteViewsAdapterIntent(parcel));
                        continue block17;
                    }
                    case 11: {
                        this.mActions.add(new TextViewDrawableAction(parcel));
                        continue block17;
                    }
                    case 13: {
                        this.mActions.add(new TextViewSizeAction(parcel));
                        continue block17;
                    }
                    case 14: {
                        this.mActions.add(new ViewPaddingAction(parcel));
                        continue block17;
                    }
                    case 12: {
                        this.mActions.add(new BitmapReflectionAction(parcel));
                        continue block17;
                    }
                    case 15: {
                        this.mActions.add(new SetRemoteViewsAdapterList(parcel));
                        continue block17;
                    }
                    case 17: {
                        this.mActions.add(new TextViewDrawableColorFilterAction(parcel));
                    }
                }
            }
        }
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.recalculateMemoryUsage();
    }

    public RemoteViews(RemoteViews remoteViews, RemoteViews remoteViews2) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mPair = new MutablePair<Object, Object>(null, null);
        if (remoteViews == null || remoteViews2 == null) {
            throw new RuntimeException("Both RemoteViews must be non-null");
        }
        if (remoteViews.mApplication.uid != remoteViews2.mApplication.uid || !remoteViews.mApplication.packageName.equals(remoteViews2.mApplication.packageName)) {
            throw new RuntimeException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = remoteViews2.mApplication;
        this.mLayoutId = remoteViews2.getLayoutId();
        this.mLandscape = remoteViews;
        this.mPortrait = remoteViews2;
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.mBitmapCache = new BitmapCache();
        this.configureRemoteViewsAsChild(remoteViews);
        this.configureRemoteViewsAsChild(remoteViews2);
        this.recalculateMemoryUsage();
    }

    public RemoteViews(String string2, int n) {
        this(RemoteViews.getApplicationInfo(string2, UserHandle.myUserId()), n);
    }

    public RemoteViews(String string2, int n, int n2) {
        this(RemoteViews.getApplicationInfo(string2, n), n2);
    }

    private void addAction(Action action) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate landscape and portrait layouts cannot be modified. Instead, fully configure the landscape and portrait layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(action);
        action.updateMemoryUsageEstimate(this.mMemoryUsageCounter);
    }

    private void configureRemoteViewsAsChild(RemoteViews remoteViews) {
        this.mBitmapCache.assimilate(remoteViews.mBitmapCache);
        remoteViews.setBitmapCache(this.mBitmapCache);
        remoteViews.setNotRoot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ApplicationInfo getApplicationInfo(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) == n) {
            if (applicationInfo.packageName.equals(string2)) return applicationInfo;
        }
        try {
            return application.getBaseContext().createPackageContextAsUser(string2, 0, new UserHandle(n)).getApplicationInfo();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException("No such package " + string2);
        }
    }

    private Context getContextForResources(Context context) {
        if (this.mApplication == null || context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
            return context;
        }
        try {
            Context context2 = context.createApplicationContext(this.mApplication, 4);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(LOG_TAG, "Package name " + this.mApplication.packageName + " not found");
            return context;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Method getMethod(View var1_1, String var2_2, Class<?> var3_3) {
        var4_4 = var1_1.getClass();
        var5_5 = RemoteViews.sMethodsLock;
        synchronized (var5_5) {
            block9: {
                block8: {
                    var7_6 = RemoteViews.sMethods.get(var4_4);
                    if (var7_6 == null) {
                        var7_6 = new ArrayMap<K, V>();
                        RemoteViews.sMethods.put(var4_4, var7_6);
                    }
                    this.mPair.first = var2_2;
                    this.mPair.second = var3_3;
                    var9_7 = var7_6.get(this.mPair);
                    if (var9_7 != null) break block9;
                    if (var3_3 != null) ** GOTO lbl22
                    try {
                        var9_7 = var13_8 = var4_4.getMethod(var2_2, new Class[0]);
                    }
                    catch (NoSuchMethodException var10_10) {
                        throw new ActionException("view: " + var4_4.getName() + " doesn't have method: " + var2_2 + RemoteViews.getParameters(var3_3));
                    }
lbl19:
                    // 2 sources

                    while (!var9_7.isAnnotationPresent(RemotableViewMethod.class)) {
                        throw new ActionException("view: " + var4_4.getName() + " can't use method with RemoteViews: " + var2_2 + RemoteViews.getParameters(var3_3));
                    }
                    {
                        break block8;
lbl22:
                        // 1 sources

                        var9_7 = var11_9 = var4_4.getMethod(var2_2, new Class[]{var3_3});
                        ** GOTO lbl19
                    }
                }
                var7_6.put(new MutablePair<String, Class<?>>(var2_2, var3_3), var9_7);
            }
            return var9_7;
        }
    }

    private static String getParameters(Class<?> clazz) {
        if (clazz == null) {
            return "()";
        }
        return "(" + clazz + ")";
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        block3: {
            block2: {
                if (!remoteViews.hasLandscapeAndPortraitLayouts()) break block2;
                if (context.getResources().getConfiguration().orientation != 2) break block3;
                RemoteViews remoteViews = remoteViews.mLandscape;
            }
            return remoteViews;
        }
        return remoteViews.mPortrait;
    }

    private static Rect getSourceBounds(View view) {
        float f = view.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        Rect rect = new Rect();
        rect.left = (int)(0.5f + f * (float)nArray[0]);
        rect.top = (int)(0.5f + f * (float)nArray[1]);
        rect.right = (int)(0.5f + f * (float)(nArray[0] + view.getWidth()));
        rect.bottom = (int)(0.5f + f * (float)(nArray[1] + view.getHeight()));
        return rect;
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    private void performApply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        if (this.mActions != null) {
            if (onClickHandler == null) {
                onClickHandler = DEFAULT_ON_CLICK_HANDLER;
            }
            int n = this.mActions.size();
            for (int i = 0; i < n; ++i) {
                this.mActions.get(i).apply(view, viewGroup, onClickHandler);
            }
        }
    }

    private void recalculateMemoryUsage() {
        this.mMemoryUsageCounter.clear();
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int n = this.mActions.size();
                for (int i = 0; i < n; ++i) {
                    this.mActions.get(i).updateMemoryUsageEstimate(this.mMemoryUsageCounter);
                }
            }
            if (this.mIsRoot) {
                this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
            }
            return;
        }
        this.mMemoryUsageCounter.increment(this.mLandscape.estimateMemoryUsage());
        this.mMemoryUsageCounter.increment(this.mPortrait.estimateMemoryUsage());
        this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
    }

    private void setBitmapCache(BitmapCache bitmapCache) {
        this.mBitmapCache = bitmapCache;
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int n = this.mActions.size();
                for (int i = 0; i < n; ++i) {
                    this.mActions.get(i).setBitmapCache(bitmapCache);
                }
            }
        } else {
            this.mLandscape.setBitmapCache(bitmapCache);
            this.mPortrait.setBitmapCache(bitmapCache);
        }
    }

    private static Object[] wrapArg(Object object) {
        Object[] objectArray = sInvokeArgsTls.get();
        objectArray[0] = object;
        return objectArray;
    }

    public void addView(int n, RemoteViews remoteViews) {
        this.addAction(new ViewGroupAction(n, remoteViews));
    }

    public View apply(Context context, ViewGroup viewGroup) {
        return this.apply(context, viewGroup, null);
    }

    public View apply(Context context, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        RemoteViews remoteViews = this.getRemoteViewsToApply(context);
        ContextWrapper contextWrapper = new ContextWrapper(context, this.getContextForResources(context)){
            final /* synthetic */ Context val$contextForResources;
            {
                this.val$contextForResources = context2;
                super(context);
            }

            @Override
            public Resources getResources() {
                return this.val$contextForResources.getResources();
            }

            @Override
            public Resources.Theme getTheme() {
                return this.val$contextForResources.getTheme();
            }
        };
        LayoutInflater layoutInflater = ((LayoutInflater)context.getSystemService("layout_inflater")).cloneInContext(contextWrapper);
        layoutInflater.setFilter(this);
        View view = layoutInflater.inflate(remoteViews.getLayoutId(), viewGroup, false);
        remoteViews.performApply(view, viewGroup, onClickHandler);
        return view;
    }

    public RemoteViews clone() {
        Parcel parcel = Parcel.obtain();
        this.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        RemoteViews remoteViews = new RemoteViews(parcel);
        parcel.recycle();
        return remoteViews;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int estimateMemoryUsage() {
        return this.mMemoryUsageCounter.getMemoryUsage();
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    public String getPackage() {
        if (this.mApplication != null) {
            return this.mApplication.packageName;
        }
        return null;
    }

    public int getSequenceNumber() {
        if (this.mActions == null) {
            return 0;
        }
        return this.mActions.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mergeRemoteViews(RemoteViews remoteViews) {
        ArrayList<Action> arrayList;
        HashMap<String, Action> hashMap;
        block10: {
            block9: {
                if (remoteViews == null) break block9;
                RemoteViews remoteViews2 = remoteViews.clone();
                hashMap = new HashMap<String, Action>();
                if (this.mActions == null) {
                    this.mActions = new ArrayList();
                }
                int n = this.mActions.size();
                for (int i = 0; i < n; ++i) {
                    Action action = this.mActions.get(i);
                    hashMap.put(action.getUniqueKey(), action);
                }
                arrayList = remoteViews2.mActions;
                if (arrayList != null) break block10;
            }
            return;
        }
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mBitmapCache = new BitmapCache();
                this.setBitmapCache(this.mBitmapCache);
                return;
            }
            Action action = arrayList.get(n2);
            String string2 = arrayList.get(n2).getUniqueKey();
            int n3 = arrayList.get(n2).mergeBehavior();
            if (hashMap.containsKey(string2) && n3 == 0) {
                this.mActions.remove(hashMap.get(string2));
                hashMap.remove(string2);
            }
            if (n3 == 0 || n3 == 1) {
                this.mActions.add(action);
            }
            ++n2;
        }
    }

    @Override
    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    public void reapply(Context context, View view) {
        this.reapply(context, view, null);
    }

    public void reapply(Context context, View view, OnClickHandler onClickHandler) {
        RemoteViews remoteViews = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && view.getId() != remoteViews.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        remoteViews.performApply(view, (ViewGroup)view.getParent(), onClickHandler);
    }

    public void removeAllViews(int n) {
        this.addAction(new ViewGroupAction(n, null));
    }

    public void setBitmap(int n, String string2, Bitmap bitmap) {
        this.addAction(new BitmapReflectionAction(n, string2, bitmap));
    }

    public void setBoolean(int n, String string2, boolean bl) {
        this.addAction(new ReflectionAction(n, string2, 1, bl));
    }

    public void setBundle(int n, String string2, Bundle bundle) {
        this.addAction(new ReflectionAction(n, string2, 13, bundle));
    }

    public void setByte(int n, String string2, byte by) {
        this.addAction(new ReflectionAction(n, string2, 2, by));
    }

    public void setChar(int n, String string2, char c) {
        this.addAction(new ReflectionAction(n, string2, 8, Character.valueOf(c)));
    }

    public void setCharSequence(int n, String string2, CharSequence charSequence) {
        this.addAction(new ReflectionAction(n, string2, 10, charSequence));
    }

    public void setChronometer(int n, long l, String string2, boolean bl) {
        this.setLong(n, "setBase", l);
        this.setString(n, "setFormat", string2);
        this.setBoolean(n, "setStarted", bl);
    }

    public void setContentDescription(int n, CharSequence charSequence) {
        this.setCharSequence(n, "setContentDescription", charSequence);
    }

    public void setDisplayedChild(int n, int n2) {
        this.setInt(n, "setDisplayedChild", n2);
    }

    public void setDouble(int n, String string2, double d) {
        this.addAction(new ReflectionAction(n, string2, 7, d));
    }

    public void setDrawableParameters(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
        this.addAction(new SetDrawableParameters(n, bl, n2, n3, mode, n4));
    }

    public void setEmptyView(int n, int n2) {
        this.addAction(new SetEmptyView(n, n2));
    }

    public void setFloat(int n, String string2, float f) {
        this.addAction(new ReflectionAction(n, string2, 6, Float.valueOf(f)));
    }

    public void setImageViewBitmap(int n, Bitmap bitmap) {
        this.setBitmap(n, "setImageBitmap", bitmap);
    }

    public void setImageViewResource(int n, int n2) {
        this.setInt(n, "setImageResource", n2);
    }

    public void setImageViewUri(int n, Uri uri) {
        this.setUri(n, "setImageURI", uri);
    }

    public void setInt(int n, String string2, int n2) {
        this.addAction(new ReflectionAction(n, string2, 4, n2));
    }

    public void setIntent(int n, String string2, Intent intent) {
        this.addAction(new ReflectionAction(n, string2, 14, intent));
    }

    void setIsWidgetCollectionChild(boolean bl) {
        this.mIsWidgetCollectionChild = bl;
    }

    public void setLabelFor(int n, int n2) {
        this.setInt(n, "setLabelFor", n2);
    }

    public void setLong(int n, String string2, long l) {
        this.addAction(new ReflectionAction(n, string2, 5, l));
    }

    void setNotRoot() {
        this.mIsRoot = false;
    }

    public void setOnClickFillInIntent(int n, Intent intent) {
        this.addAction(new SetOnClickFillInIntent(n, intent));
    }

    public void setOnClickPendingIntent(int n, PendingIntent pendingIntent) {
        this.addAction(new SetOnClickPendingIntent(n, pendingIntent));
    }

    public void setPendingIntentTemplate(int n, PendingIntent pendingIntent) {
        this.addAction(new SetPendingIntentTemplate(n, pendingIntent));
    }

    public void setProgressBar(int n, int n2, int n3, boolean bl) {
        this.setBoolean(n, "setIndeterminate", bl);
        if (!bl) {
            this.setInt(n, "setMax", n2);
            this.setInt(n, "setProgress", n3);
        }
    }

    public void setRelativeScrollPosition(int n, int n2) {
        this.setInt(n, "smoothScrollByOffset", n2);
    }

    @Deprecated
    public void setRemoteAdapter(int n, int n2, Intent intent) {
        this.setRemoteAdapter(n2, intent);
    }

    public void setRemoteAdapter(int n, Intent intent) {
        this.addAction(new SetRemoteViewsAdapterIntent(n, intent));
    }

    public void setRemoteAdapter(int n, ArrayList<RemoteViews> arrayList, int n2) {
        this.addAction(new SetRemoteViewsAdapterList(n, arrayList, n2));
    }

    public void setScrollPosition(int n, int n2) {
        this.setInt(n, "smoothScrollToPosition", n2);
    }

    public void setShort(int n, String string2, short s) {
        this.addAction(new ReflectionAction(n, string2, 3, s));
    }

    public void setString(int n, String string2, String string3) {
        this.addAction(new ReflectionAction(n, string2, 9, string3));
    }

    public void setTextColor(int n, int n2) {
        this.setInt(n, "setTextColor", n2);
    }

    public void setTextViewCompoundDrawables(int n, int n2, int n3, int n4, int n5) {
        this.addAction(new TextViewDrawableAction(n, false, n2, n3, n4, n5));
    }

    public void setTextViewCompoundDrawablesRelative(int n, int n2, int n3, int n4, int n5) {
        this.addAction(new TextViewDrawableAction(n, true, n2, n3, n4, n5));
    }

    public void setTextViewCompoundDrawablesRelativeColorFilter(int n, int n2, int n3, PorterDuff.Mode mode) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("index must be in range [0, 3].");
        }
        this.addAction(new TextViewDrawableColorFilterAction(n, true, n2, n3, mode));
    }

    public void setTextViewText(int n, CharSequence charSequence) {
        this.setCharSequence(n, "setText", charSequence);
    }

    public void setTextViewTextSize(int n, int n2, float f) {
        this.addAction(new TextViewSizeAction(n, n2, f));
    }

    public void setUri(int n, String string2, Uri uri) {
        if (uri != null) {
            uri = uri.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                uri.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(n, string2, 11, uri));
    }

    public void setViewPadding(int n, int n2, int n3, int n4, int n5) {
        this.addAction(new ViewPaddingAction(n, n2, n3, n4, n5));
    }

    public void setViewVisibility(int n, int n2) {
        this.setInt(n, "setVisibility", n2);
    }

    public void showNext(int n) {
        this.addAction(new ReflectionActionWithoutParams(n, "showNext"));
    }

    public void showPrevious(int n) {
        this.addAction(new ReflectionActionWithoutParams(n, "showPrevious"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        if (!this.hasLandscapeAndPortraitLayouts()) {
            parcel.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(parcel, n);
            }
            parcel.writeParcelable(this.mApplication, n);
            parcel.writeInt(this.mLayoutId);
            if (!this.mIsWidgetCollectionChild) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            int n3 = this.mActions != null ? this.mActions.size() : 0;
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                this.mActions.get(i).writeToParcel(parcel, 0);
            }
            return;
        } else {
            parcel.writeInt(n2);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(parcel, n);
            }
            this.mLandscape.writeToParcel(parcel, n);
            this.mPortrait.writeToParcel(parcel, n);
        }
    }

    private static abstract class Action
    implements Parcelable {
        public static final int MERGE_APPEND = 1;
        public static final int MERGE_IGNORE = 2;
        public static final int MERGE_REPLACE;
        int viewId;

        private Action() {
        }

        public abstract void apply(View var1, ViewGroup var2, OnClickHandler var3) throws ActionException;

        @Override
        public int describeContents() {
            return 0;
        }

        public abstract String getActionName();

        public String getUniqueKey() {
            return this.getActionName() + this.viewId;
        }

        public int mergeBehavior() {
            return 0;
        }

        public void setBitmapCache(BitmapCache bitmapCache) {
        }

        public void updateMemoryUsageEstimate(MemoryUsageCounter memoryUsageCounter) {
        }
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception exception) {
            super(exception);
        }

        public ActionException(String string2) {
            super(string2);
        }
    }

    private static class BitmapCache {
        ArrayList<Bitmap> mBitmaps;

        public BitmapCache() {
            this.mBitmaps = new ArrayList();
        }

        public BitmapCache(Parcel parcel) {
            int n = parcel.readInt();
            this.mBitmaps = new ArrayList();
            for (int i = 0; i < n; ++i) {
                Bitmap bitmap = Bitmap.CREATOR.createFromParcel(parcel);
                this.mBitmaps.add(bitmap);
            }
        }

        public void addBitmapMemory(MemoryUsageCounter memoryUsageCounter) {
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                memoryUsageCounter.addBitmapMemory(this.mBitmaps.get(i));
            }
        }

        public void assimilate(BitmapCache bitmapCache) {
            ArrayList<Bitmap> arrayList = bitmapCache.mBitmaps;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Bitmap bitmap = arrayList.get(i);
                if (this.mBitmaps.contains(bitmap)) continue;
                this.mBitmaps.add(bitmap);
            }
        }

        public Bitmap getBitmapForId(int n) {
            if (n == -1 || n >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(n);
        }

        public int getBitmapId(Bitmap bitmap) {
            if (bitmap == null) {
                return -1;
            }
            if (this.mBitmaps.contains(bitmap)) {
                return this.mBitmaps.indexOf(bitmap);
            }
            this.mBitmaps.add(bitmap);
            return -1 + this.mBitmaps.size();
        }

        public void writeBitmapsToParcel(Parcel parcel, int n) {
            int n2 = this.mBitmaps.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.mBitmaps.get(i).writeToParcel(parcel, n);
            }
        }
    }

    private class BitmapReflectionAction
    extends Action {
        public static final int TAG = 12;
        Bitmap bitmap;
        int bitmapId;
        String methodName;

        BitmapReflectionAction(int n, String string2, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.viewId = n;
            this.methodName = string2;
            this.bitmapId = RemoteViews.this.mBitmapCache.getBitmapId(bitmap);
        }

        BitmapReflectionAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.methodName = parcel.readString();
            this.bitmapId = parcel.readInt();
            this.bitmap = RemoteViews.this.mBitmapCache.getBitmapForId(this.bitmapId);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) throws ActionException {
            new ReflectionAction(this.viewId, this.methodName, 12, this.bitmap).apply(view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return "BitmapReflectionAction";
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            this.bitmapId = bitmapCache.getBitmapId(this.bitmap);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(12);
            parcel.writeInt(this.viewId);
            parcel.writeString(this.methodName);
            parcel.writeInt(this.bitmapId);
        }
    }

    private class MemoryUsageCounter {
        int mMemoryUsage;

        private MemoryUsageCounter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void addBitmapMemory(Bitmap bitmap) {
            Bitmap.Config config = bitmap.getConfig();
            int n = 4;
            if (config != null) {
                switch (4.$SwitchMap$android$graphics$Bitmap$Config[config.ordinal()]) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                }
            }
            this.increment(n * (bitmap.getWidth() * bitmap.getHeight()));
        }

        public void clear() {
            this.mMemoryUsage = 0;
        }

        public int getMemoryUsage() {
            return this.mMemoryUsage;
        }

        public void increment(int n) {
            this.mMemoryUsage = n + this.mMemoryUsage;
        }
    }

    static class MutablePair<F, S> {
        F first;
        S second;

        MutablePair(F f, S s) {
            this.first = f;
            this.second = s;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof MutablePair)) break block2;
                    MutablePair mutablePair = (MutablePair)object;
                    if (Objects.equal(mutablePair.first, this.first) && Objects.equal(mutablePair.second, this.second)) break block3;
                }
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n = this.first == null ? 0 : this.first.hashCode();
            S s = this.second;
            int n2 = 0;
            if (s == null) {
                return n ^ n2;
            }
            n2 = this.second.hashCode();
            return n ^ n2;
        }
    }

    public static class OnClickHandler {
        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent intent) {
            try {
                Context context = view.getContext();
                ActivityOptions activityOptions = ActivityOptions.makeScaleUpAnimation(view, 0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
                context.startIntentSender(pendingIntent.getIntentSender(), intent, 0x10000000, 0x10000000, 0, activityOptions.toBundle());
                return true;
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                Log.e(RemoteViews.LOG_TAG, "Cannot send pending intent: ", sendIntentException);
                return false;
            }
            catch (Exception exception) {
                Log.e(RemoteViews.LOG_TAG, "Cannot send pending intent due to unknown exception: ", exception);
                return false;
            }
        }
    }

    private final class ReflectionAction
    extends Action {
        static final int BITMAP = 12;
        static final int BOOLEAN = 1;
        static final int BUNDLE = 13;
        static final int BYTE = 2;
        static final int CHAR = 8;
        static final int CHAR_SEQUENCE = 10;
        static final int DOUBLE = 7;
        static final int FLOAT = 6;
        static final int INT = 4;
        static final int INTENT = 14;
        static final int LONG = 5;
        static final int SHORT = 3;
        static final int STRING = 9;
        static final int TAG = 2;
        static final int URI = 11;
        String methodName;
        int type;
        Object value;

        ReflectionAction(int n, String string2, int n2, Object object) {
            this.viewId = n;
            this.methodName = string2;
            this.type = n2;
            this.value = object;
        }

        /*
         * Enabled aggressive block sorting
         */
        ReflectionAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.methodName = parcel.readString();
            this.type = parcel.readInt();
            switch (this.type) {
                case 1: {
                    boolean bl = parcel.readInt() != 0;
                    this.value = bl;
                    return;
                }
                case 2: {
                    this.value = parcel.readByte();
                    return;
                }
                case 3: {
                    this.value = (short)parcel.readInt();
                    return;
                }
                case 4: {
                    this.value = parcel.readInt();
                    return;
                }
                case 5: {
                    this.value = parcel.readLong();
                    return;
                }
                case 6: {
                    this.value = Float.valueOf(parcel.readFloat());
                    return;
                }
                case 7: {
                    this.value = parcel.readDouble();
                    return;
                }
                case 8: {
                    this.value = Character.valueOf((char)parcel.readInt());
                    return;
                }
                case 9: {
                    this.value = parcel.readString();
                    return;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                    return;
                }
                case 11: {
                    if (parcel.readInt() == 0) return;
                    this.value = Uri.CREATOR.createFromParcel(parcel);
                    return;
                }
                case 12: {
                    if (parcel.readInt() == 0) return;
                    this.value = Bitmap.CREATOR.createFromParcel(parcel);
                    return;
                }
                default: {
                    return;
                }
                case 13: {
                    this.value = parcel.readBundle();
                    return;
                }
                case 14: 
            }
            if (parcel.readInt() == 0) return;
            this.value = Intent.CREATOR.createFromParcel(parcel);
        }

        private Class<?> getParameterType() {
            switch (this.type) {
                default: {
                    return null;
                }
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Short.TYPE;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 5: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Double.TYPE;
                }
                case 8: {
                    return Character.TYPE;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return CharSequence.class;
                }
                case 11: {
                    return Uri.class;
                }
                case 12: {
                    return Bitmap.class;
                }
                case 13: {
                    return Bundle.class;
                }
                case 14: 
            }
            return Intent.class;
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2 = view.findViewById(this.viewId);
            if (view2 == null) {
                return;
            }
            Class<?> clazz = this.getParameterType();
            if (clazz == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                RemoteViews.this.getMethod(view2, this.methodName, clazz).invoke(view2, RemoteViews.wrapArg(this.value));
                return;
            }
            catch (ActionException actionException) {
                throw actionException;
            }
            catch (Exception exception) {
                throw new ActionException(exception);
            }
        }

        @Override
        public String getActionName() {
            return "ReflectionAction" + this.methodName + this.type;
        }

        @Override
        public int mergeBehavior() {
            if (this.methodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = 1;
            parcel.writeInt(2);
            parcel.writeInt(this.viewId);
            parcel.writeString(this.methodName);
            parcel.writeInt(this.type);
            switch (this.type) {
                case 1: {
                    int n3 = (Boolean)this.value != false ? n2 : 0;
                    parcel.writeInt(n3);
                    return;
                }
                case 2: {
                    parcel.writeByte((Byte)this.value);
                    return;
                }
                case 3: {
                    parcel.writeInt(((Short)this.value).shortValue());
                    return;
                }
                case 4: {
                    parcel.writeInt((Integer)this.value);
                    return;
                }
                case 5: {
                    parcel.writeLong((Long)this.value);
                    return;
                }
                case 6: {
                    parcel.writeFloat(((Float)this.value).floatValue());
                    return;
                }
                case 7: {
                    parcel.writeDouble((Double)this.value);
                    return;
                }
                case 8: {
                    parcel.writeInt(((Character)this.value).charValue());
                    return;
                }
                case 9: {
                    parcel.writeString((String)this.value);
                    return;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, parcel, n);
                    return;
                }
                case 11: {
                    if (this.value == null) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    if (this.value == null) return;
                    ((Uri)this.value).writeToParcel(parcel, n);
                    return;
                }
                case 12: {
                    if (this.value == null) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    if (this.value == null) return;
                    ((Bitmap)this.value).writeToParcel(parcel, n);
                    return;
                }
                default: {
                    return;
                }
                case 13: {
                    parcel.writeBundle((Bundle)this.value);
                    return;
                }
                case 14: 
            }
            if (this.value == null) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            if (this.value == null) return;
            ((Intent)this.value).writeToParcel(parcel, n);
        }
    }

    private final class ReflectionActionWithoutParams
    extends Action {
        public static final int TAG = 5;
        final String methodName;

        ReflectionActionWithoutParams(int n, String string2) {
            this.viewId = n;
            this.methodName = string2;
        }

        ReflectionActionWithoutParams(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.methodName = parcel.readString();
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2 = view.findViewById(this.viewId);
            if (view2 == null) {
                return;
            }
            try {
                RemoteViews.this.getMethod(view2, this.methodName, null).invoke(view2, new Object[0]);
                return;
            }
            catch (ActionException actionException) {
                throw actionException;
            }
            catch (Exception exception) {
                throw new ActionException(exception);
            }
        }

        @Override
        public String getActionName() {
            return "ReflectionActionWithoutParams";
        }

        @Override
        public int mergeBehavior() {
            if (this.methodName.equals("showNext") || this.methodName.equals("showPrevious")) {
                return 2;
            }
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(5);
            parcel.writeInt(this.viewId);
            parcel.writeString(this.methodName);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface RemoteView {
    }

    private class SetDrawableParameters
    extends Action {
        public static final int TAG = 3;
        int alpha;
        int colorFilter;
        PorterDuff.Mode filterMode;
        int level;
        boolean targetBackground;

        public SetDrawableParameters(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
            this.viewId = n;
            this.targetBackground = bl;
            this.alpha = n2;
            this.colorFilter = n3;
            this.filterMode = mode;
            this.level = n4;
        }

        /*
         * Enabled aggressive block sorting
         */
        public SetDrawableParameters(Parcel parcel) {
            this.viewId = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.targetBackground = bl;
            this.alpha = parcel.readInt();
            this.colorFilter = parcel.readInt();
            boolean bl2 = parcel.readInt() != 0;
            this.filterMode = bl2 ? PorterDuff.Mode.valueOf(parcel.readString()) : null;
            this.level = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            Drawable drawable2;
            block9: {
                block8: {
                    View view2 = view.findViewById(this.viewId);
                    if (view2 == null) break block8;
                    if (this.targetBackground) {
                        drawable2 = view2.getBackground();
                    } else {
                        boolean bl = view2 instanceof ImageView;
                        drawable2 = null;
                        if (bl) {
                            drawable2 = ((ImageView)view2).getDrawable();
                        }
                    }
                    if (drawable2 == null) break block8;
                    if (this.alpha != -1) {
                        drawable2.setAlpha(this.alpha);
                    }
                    if (this.filterMode != null) {
                        drawable2.setColorFilter(this.colorFilter, this.filterMode);
                    }
                    if (this.level != -1) break block9;
                }
                return;
            }
            drawable2.setLevel(this.level);
        }

        @Override
        public String getActionName() {
            return "SetDrawableParameters";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(3);
            parcel.writeInt(this.viewId);
            int n2 = this.targetBackground ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeInt(this.alpha);
            parcel.writeInt(this.colorFilter);
            if (this.filterMode != null) {
                parcel.writeInt(1);
                parcel.writeString(this.filterMode.toString());
            } else {
                parcel.writeInt(0);
            }
            parcel.writeInt(this.level);
        }
    }

    private class SetEmptyView
    extends Action {
        public static final int TAG = 6;
        int emptyViewId;
        int viewId;

        SetEmptyView(int n, int n2) {
            this.viewId = n;
            this.emptyViewId = n2;
        }

        SetEmptyView(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.emptyViewId = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2;
            AdapterView adapterView;
            block3: {
                block2: {
                    View view3 = view.findViewById(this.viewId);
                    if (!(view3 instanceof AdapterView)) break block2;
                    adapterView = (AdapterView)view3;
                    view2 = view.findViewById(this.emptyViewId);
                    if (view2 != null) break block3;
                }
                return;
            }
            adapterView.setEmptyView(view2);
        }

        @Override
        public String getActionName() {
            return "SetEmptyView";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(6);
            parcel.writeInt(this.viewId);
            parcel.writeInt(this.emptyViewId);
        }
    }

    private class SetOnClickFillInIntent
    extends Action {
        public static final int TAG = 9;
        Intent fillInIntent;

        public SetOnClickFillInIntent(int n, Intent intent) {
            this.viewId = n;
            this.fillInIntent = intent;
        }

        public SetOnClickFillInIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.fillInIntent = Intent.CREATOR.createFromParcel(parcel);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, final OnClickHandler onClickHandler) {
            View view2;
            block6: {
                block5: {
                    view2 = view.findViewById(this.viewId);
                    if (view2 == null) break block5;
                    if (!RemoteViews.this.mIsWidgetCollectionChild) {
                        Log.e(RemoteViews.LOG_TAG, "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                        return;
                    }
                    if (view2 == view) {
                        view2.setTagInternal(16908345, this.fillInIntent);
                        return;
                    }
                    if (this.fillInIntent != null) break block6;
                }
                return;
            }
            view2.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    View view2;
                    for (view2 = (View)((Object)view.getParent()); view2 != null && !(view2 instanceof AdapterView) && !(view2 instanceof AppWidgetHostView); view2 = (View)((Object)view2.getParent())) {
                    }
                    if (view2 instanceof AppWidgetHostView || view2 == null) {
                        Log.e(RemoteViews.LOG_TAG, "Collection item doesn't have AdapterView parent");
                        return;
                    }
                    if (!(view2.getTag() instanceof PendingIntent)) {
                        Log.e(RemoteViews.LOG_TAG, "Attempting setOnClickFillInIntent without calling setPendingIntentTemplate on parent.");
                        return;
                    }
                    PendingIntent pendingIntent = (PendingIntent)view2.getTag();
                    Rect rect = RemoteViews.getSourceBounds(view);
                    SetOnClickFillInIntent.this.fillInIntent.setSourceBounds(rect);
                    onClickHandler.onClickHandler(view, pendingIntent, SetOnClickFillInIntent.this.fillInIntent);
                }
            });
        }

        @Override
        public String getActionName() {
            return "SetOnClickFillInIntent";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(9);
            parcel.writeInt(this.viewId);
            this.fillInIntent.writeToParcel(parcel, 0);
        }
    }

    private class SetOnClickPendingIntent
    extends Action {
        public static final int TAG = 1;
        PendingIntent pendingIntent;

        public SetOnClickPendingIntent(int n, PendingIntent pendingIntent) {
            this.viewId = n;
            this.pendingIntent = pendingIntent;
        }

        public SetOnClickPendingIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            if (parcel.readInt() != 0) {
                this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, final OnClickHandler onClickHandler) {
            View view2;
            block5: {
                block4: {
                    view2 = view.findViewById(this.viewId);
                    if (view2 == null) break block4;
                    if (!RemoteViews.this.mIsWidgetCollectionChild) break block5;
                    Log.w(RemoteViews.LOG_TAG, "Cannot setOnClickPendingIntent for collection item (id: " + this.viewId + ")");
                    ApplicationInfo applicationInfo = view.getContext().getApplicationInfo();
                    if (applicationInfo == null || applicationInfo.targetSdkVersion < 16) break block5;
                }
                return;
            }
            PendingIntent pendingIntent = this.pendingIntent;
            View.OnClickListener onClickListener = null;
            if (pendingIntent != null) {
                onClickListener = new View.OnClickListener(){

                    @Override
                    public void onClick(View view) {
                        Rect rect = RemoteViews.getSourceBounds(view);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        onClickHandler.onClickHandler(view, SetOnClickPendingIntent.this.pendingIntent, intent);
                    }
                };
            }
            view2.setOnClickListener(onClickListener);
        }

        @Override
        public String getActionName() {
            return "SetOnClickPendingIntent";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = 1;
            parcel.writeInt(n2);
            parcel.writeInt(this.viewId);
            if (this.pendingIntent == null) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            if (this.pendingIntent != null) {
                this.pendingIntent.writeToParcel(parcel, 0);
            }
        }
    }

    private class SetPendingIntentTemplate
    extends Action {
        public static final int TAG = 8;
        PendingIntent pendingIntentTemplate;

        public SetPendingIntentTemplate(int n, PendingIntent pendingIntent) {
            this.viewId = n;
            this.pendingIntentTemplate = pendingIntent;
        }

        public SetPendingIntentTemplate(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, final OnClickHandler onClickHandler) {
            View view2 = view.findViewById(this.viewId);
            if (view2 == null) {
                return;
            }
            if (view2 instanceof AdapterView) {
                AdapterView adapterView = (AdapterView)view2;
                adapterView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        Intent intent;
                        block3: {
                            block4: {
                                if (!(view instanceof ViewGroup)) break block4;
                                ViewGroup viewGroup = (ViewGroup)view;
                                if (adapterView instanceof AdapterViewAnimator) {
                                    viewGroup = (ViewGroup)viewGroup.getChildAt(0);
                                }
                                if (viewGroup == null) break block4;
                                int n2 = viewGroup.getChildCount();
                                int n3 = 0;
                                while (true) {
                                    block6: {
                                        block5: {
                                            intent = null;
                                            if (n3 >= n2) break block5;
                                            Object object = viewGroup.getChildAt(n3).getTag(16908345);
                                            if (!(object instanceof Intent)) break block6;
                                            intent = (Intent)object;
                                        }
                                        if (intent == null) break;
                                        break block3;
                                    }
                                    ++n3;
                                }
                            }
                            return;
                        }
                        Rect rect = RemoteViews.getSourceBounds(view);
                        new Intent().setSourceBounds(rect);
                        onClickHandler.onClickHandler(view, SetPendingIntentTemplate.this.pendingIntentTemplate, intent);
                    }
                });
                adapterView.setTag(this.pendingIntentTemplate);
                return;
            }
            Log.e(RemoteViews.LOG_TAG, "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.viewId + ")");
        }

        @Override
        public String getActionName() {
            return "SetPendingIntentTemplate";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(8);
            parcel.writeInt(this.viewId);
            this.pendingIntentTemplate.writeToParcel(parcel, 0);
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action {
        public static final int TAG = 10;
        Intent intent;

        public SetRemoteViewsAdapterIntent(int n, Intent intent) {
            this.viewId = n;
            this.intent = intent;
        }

        public SetRemoteViewsAdapterIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.intent = Intent.CREATOR.createFromParcel(parcel);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2;
            block7: {
                block6: {
                    view2 = view.findViewById(this.viewId);
                    if (view2 == null) break block6;
                    if (!(viewGroup instanceof AppWidgetHostView)) {
                        Log.e(RemoteViews.LOG_TAG, "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                        return;
                    }
                    if (!(view2 instanceof AbsListView) && !(view2 instanceof AdapterViewAnimator)) {
                        Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                        return;
                    }
                    AppWidgetHostView appWidgetHostView = (AppWidgetHostView)viewGroup;
                    this.intent.putExtra(RemoteViews.EXTRA_REMOTEADAPTER_APPWIDGET_ID, appWidgetHostView.getAppWidgetId());
                    if (view2 instanceof AbsListView) {
                        AbsListView absListView = (AbsListView)view2;
                        absListView.setRemoteViewsAdapter(this.intent);
                        absListView.setRemoteViewsOnClickHandler(onClickHandler);
                        return;
                    }
                    if (view2 instanceof AdapterViewAnimator) break block7;
                }
                return;
            }
            AdapterViewAnimator adapterViewAnimator = (AdapterViewAnimator)view2;
            adapterViewAnimator.setRemoteViewsAdapter(this.intent);
            adapterViewAnimator.setRemoteViewsOnClickHandler(onClickHandler);
        }

        @Override
        public String getActionName() {
            return "SetRemoteViewsAdapterIntent";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(10);
            parcel.writeInt(this.viewId);
            this.intent.writeToParcel(parcel, n);
        }
    }

    private class SetRemoteViewsAdapterList
    extends Action {
        public static final int TAG = 15;
        ArrayList<RemoteViews> list;
        int viewTypeCount;

        public SetRemoteViewsAdapterList(int n, ArrayList<RemoteViews> arrayList, int n2) {
            this.viewId = n;
            this.list = arrayList;
            this.viewTypeCount = n2;
        }

        public SetRemoteViewsAdapterList(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.viewTypeCount = parcel.readInt();
            int n = parcel.readInt();
            this.list = new ArrayList();
            for (int i = 0; i < n; ++i) {
                RemoteViews remoteViews2 = CREATOR.createFromParcel(parcel);
                this.list.add(remoteViews2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2;
            block9: {
                block8: {
                    view2 = view.findViewById(this.viewId);
                    if (view2 == null) break block8;
                    if (!(viewGroup instanceof AppWidgetHostView)) {
                        Log.e(RemoteViews.LOG_TAG, "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                        return;
                    }
                    if (!(view2 instanceof AbsListView) && !(view2 instanceof AdapterViewAnimator)) {
                        Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                        return;
                    }
                    if (view2 instanceof AbsListView) {
                        AbsListView absListView = (AbsListView)view2;
                        Object t = absListView.getAdapter();
                        if (t instanceof RemoteViewsListAdapter && this.viewTypeCount <= t.getViewTypeCount()) {
                            ((RemoteViewsListAdapter)t).setViewsList(this.list);
                            return;
                        }
                        absListView.setAdapter(new RemoteViewsListAdapter(absListView.getContext(), this.list, this.viewTypeCount));
                        return;
                    }
                    if (view2 instanceof AdapterViewAnimator) break block9;
                }
                return;
            }
            AdapterViewAnimator adapterViewAnimator = (AdapterViewAnimator)view2;
            Adapter adapter = adapterViewAnimator.getAdapter();
            if (adapter instanceof RemoteViewsListAdapter && this.viewTypeCount <= adapter.getViewTypeCount()) {
                ((RemoteViewsListAdapter)adapter).setViewsList(this.list);
                return;
            }
            adapterViewAnimator.setAdapter(new RemoteViewsListAdapter(adapterViewAnimator.getContext(), this.list, this.viewTypeCount));
        }

        @Override
        public String getActionName() {
            return "SetRemoteViewsAdapterList";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(15);
            parcel.writeInt(this.viewId);
            parcel.writeInt(this.viewTypeCount);
            if (this.list == null || this.list.size() == 0) {
                parcel.writeInt(0);
                return;
            } else {
                int n2 = this.list.size();
                parcel.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    this.list.get(i).writeToParcel(parcel, n);
                }
            }
        }
    }

    private class TextViewDrawableAction
    extends Action {
        public static final int TAG = 11;
        int d1;
        int d2;
        int d3;
        int d4;
        boolean isRelative = false;

        public TextViewDrawableAction(int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.viewId = n;
            this.isRelative = bl;
            this.d1 = n2;
            this.d2 = n3;
            this.d3 = n4;
            this.d4 = n5;
        }

        public TextViewDrawableAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            int n = parcel.readInt();
            boolean bl = false;
            if (n != 0) {
                bl = true;
            }
            this.isRelative = bl;
            this.d1 = parcel.readInt();
            this.d2 = parcel.readInt();
            this.d3 = parcel.readInt();
            this.d4 = parcel.readInt();
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            TextView textView = (TextView)view.findViewById(this.viewId);
            if (textView == null) {
                return;
            }
            if (this.isRelative) {
                textView.setCompoundDrawablesRelativeWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
                return;
            }
            textView.setCompoundDrawablesWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
        }

        @Override
        public String getActionName() {
            return "TextViewDrawableAction";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(11);
            parcel.writeInt(this.viewId);
            int n2 = this.isRelative ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeInt(this.d1);
            parcel.writeInt(this.d2);
            parcel.writeInt(this.d3);
            parcel.writeInt(this.d4);
        }
    }

    private class TextViewDrawableColorFilterAction
    extends Action {
        public static final int TAG = 17;
        final int color;
        final int index;
        final boolean isRelative;
        final PorterDuff.Mode mode;

        public TextViewDrawableColorFilterAction(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode) {
            this.viewId = n;
            this.isRelative = bl;
            this.index = n2;
            this.color = n3;
            this.mode = mode;
        }

        /*
         * Enabled aggressive block sorting
         */
        public TextViewDrawableColorFilterAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.isRelative = bl;
            this.index = parcel.readInt();
            this.color = parcel.readInt();
            this.mode = this.readPorterDuffMode(parcel);
        }

        private PorterDuff.Mode readPorterDuffMode(Parcel parcel) {
            int n = parcel.readInt();
            if (n >= 0 && n < PorterDuff.Mode.values().length) {
                return PorterDuff.Mode.values()[n];
            }
            return PorterDuff.Mode.CLEAR;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            Drawable drawable2;
            block5: {
                block4: {
                    TextView textView = (TextView)view.findViewById(this.viewId);
                    if (textView == null) break block4;
                    Drawable[] drawableArray = this.isRelative ? textView.getCompoundDrawablesRelative() : textView.getCompoundDrawables();
                    if (this.index < 0 || this.index >= 4) {
                        throw new IllegalStateException("index must be in range [0, 3].");
                    }
                    drawable2 = drawableArray[this.index];
                    if (drawable2 != null) break block5;
                }
                return;
            }
            drawable2.mutate();
            drawable2.setColorFilter(this.color, this.mode);
        }

        @Override
        public String getActionName() {
            return "TextViewDrawableColorFilterAction";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(17);
            parcel.writeInt(this.viewId);
            int n2 = this.isRelative ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeInt(this.index);
            parcel.writeInt(this.color);
            parcel.writeInt(this.mode.ordinal());
        }
    }

    private class TextViewSizeAction
    extends Action {
        public static final int TAG = 13;
        float size;
        int units;

        public TextViewSizeAction(int n, int n2, float f) {
            this.viewId = n;
            this.units = n2;
            this.size = f;
        }

        public TextViewSizeAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.units = parcel.readInt();
            this.size = parcel.readFloat();
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            TextView textView = (TextView)view.findViewById(this.viewId);
            if (textView == null) {
                return;
            }
            textView.setTextSize(this.units, this.size);
        }

        @Override
        public String getActionName() {
            return "TextViewSizeAction";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(13);
            parcel.writeInt(this.viewId);
            parcel.writeInt(this.units);
            parcel.writeFloat(this.size);
        }
    }

    private class ViewGroupAction
    extends Action {
        public static final int TAG = 4;
        RemoteViews nestedViews;

        public ViewGroupAction(int n, RemoteViews remoteViews2) {
            this.viewId = n;
            this.nestedViews = remoteViews2;
            if (remoteViews2 != null) {
                RemoteViews.this.configureRemoteViewsAsChild(remoteViews2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public ViewGroupAction(Parcel parcel, BitmapCache bitmapCache) {
            this.viewId = parcel.readInt();
            boolean bl = parcel.readInt() == 0;
            if (!bl) {
                this.nestedViews = new RemoteViews(parcel, bitmapCache);
                return;
            }
            this.nestedViews = null;
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            Context context = view.getContext();
            ViewGroup viewGroup2 = (ViewGroup)view.findViewById(this.viewId);
            if (viewGroup2 == null) {
                return;
            }
            if (this.nestedViews != null) {
                viewGroup2.addView(this.nestedViews.apply(context, viewGroup2, onClickHandler));
                return;
            }
            viewGroup2.removeAllViews();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getActionName() {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append("ViewGroupAction");
            if (this.nestedViews == null) {
                string2 = "Remove";
                return stringBuilder.append(string2).toString();
            }
            string2 = "Add";
            return stringBuilder.append(string2).toString();
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            if (this.nestedViews != null) {
                this.nestedViews.setBitmapCache(bitmapCache);
            }
        }

        @Override
        public void updateMemoryUsageEstimate(MemoryUsageCounter memoryUsageCounter) {
            if (this.nestedViews != null) {
                memoryUsageCounter.increment(this.nestedViews.estimateMemoryUsage());
            }
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(4);
            parcel.writeInt(this.viewId);
            if (this.nestedViews != null) {
                parcel.writeInt(1);
                this.nestedViews.writeToParcel(parcel, n);
                return;
            }
            parcel.writeInt(0);
        }
    }

    private class ViewPaddingAction
    extends Action {
        public static final int TAG = 14;
        int bottom;
        int left;
        int right;
        int top;

        public ViewPaddingAction(int n, int n2, int n3, int n4, int n5) {
            this.viewId = n;
            this.left = n2;
            this.top = n3;
            this.right = n4;
            this.bottom = n5;
        }

        public ViewPaddingAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.left = parcel.readInt();
            this.top = parcel.readInt();
            this.right = parcel.readInt();
            this.bottom = parcel.readInt();
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            View view2 = view.findViewById(this.viewId);
            if (view2 == null) {
                return;
            }
            view2.setPadding(this.left, this.top, this.right, this.bottom);
        }

        @Override
        public String getActionName() {
            return "ViewPaddingAction";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(14);
            parcel.writeInt(this.viewId);
            parcel.writeInt(this.left);
            parcel.writeInt(this.top);
            parcel.writeInt(this.right);
            parcel.writeInt(this.bottom);
        }
    }
}

