/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.LocalActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TabWidget;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public class TabHost
extends FrameLayout
implements ViewTreeObserver.OnTouchModeChangeListener {
    private static final int TABWIDGET_LOCATION_BOTTOM = 3;
    private static final int TABWIDGET_LOCATION_LEFT = 0;
    private static final int TABWIDGET_LOCATION_RIGHT = 2;
    private static final int TABWIDGET_LOCATION_TOP = 1;
    protected int mCurrentTab = -1;
    private View mCurrentView = null;
    protected LocalActivityManager mLocalActivityManager = null;
    private OnTabChangeListener mOnTabChangeListener;
    private FrameLayout mTabContent;
    private View.OnKeyListener mTabKeyListener;
    private int mTabLayoutId;
    private List<TabSpec> mTabSpecs = new ArrayList<TabSpec>(2);
    private TabWidget mTabWidget;

    public TabHost(Context context) {
        super(context);
        this.initTabHost();
    }

    public TabHost(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
    }

    public TabHost(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TabHost(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabWidget, n, n2);
        this.mTabLayoutId = typedArray.getResourceId(4, 0);
        typedArray.recycle();
        if (this.mTabLayoutId == 0) {
            this.mTabLayoutId = 17367278;
        }
        this.initTabHost();
    }

    private int getTabWidgetLocation() {
        switch (this.mTabWidget.getOrientation()) {
            default: {
                if (this.mTabContent.getTop() >= this.mTabWidget.getTop()) break;
                return 3;
            }
            case 1: {
                if (this.mTabContent.getLeft() < this.mTabWidget.getLeft()) {
                    return 2;
                }
                return 0;
            }
        }
        return 1;
    }

    private void initTabHost() {
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
    }

    private void invokeOnTabChangeListener() {
        if (this.mOnTabChangeListener != null) {
            this.mOnTabChangeListener.onTabChanged(this.getCurrentTabTag());
        }
    }

    public void addTab(TabSpec tabSpec) {
        if (tabSpec.mIndicatorStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab indicator.");
        }
        if (tabSpec.mContentStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab content");
        }
        View view = tabSpec.mIndicatorStrategy.createIndicatorView();
        view.setOnKeyListener(this.mTabKeyListener);
        if (tabSpec.mIndicatorStrategy instanceof ViewIndicatorStrategy) {
            this.mTabWidget.setStripEnabled(false);
        }
        this.mTabWidget.addView(view);
        this.mTabSpecs.add(tabSpec);
        if (this.mCurrentTab == -1) {
            this.setCurrentTab(0);
        }
    }

    public void clearAllTabs() {
        this.mTabWidget.removeAllViews();
        this.initTabHost();
        this.mTabContent.removeAllViews();
        this.mTabSpecs.clear();
        this.requestLayout();
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        int n;
        int n2;
        int n3;
        boolean bl = super.dispatchKeyEvent(keyEvent);
        if (bl) return bl;
        if (keyEvent.getAction() != 0) return bl;
        if (this.mCurrentView == null) return bl;
        if (!this.mCurrentView.isRootNamespace()) return bl;
        if (!this.mCurrentView.hasFocus()) return bl;
        switch (this.getTabWidgetLocation()) {
            default: {
                n3 = 19;
                n2 = 33;
                n = 2;
                break;
            }
            case 0: {
                n3 = 21;
                n2 = 17;
                n = 1;
                break;
            }
            case 2: {
                n3 = 22;
                n2 = 66;
                n = 3;
                break;
            }
            case 3: {
                n3 = 20;
                n2 = 130;
                n = 4;
            }
        }
        if (keyEvent.getKeyCode() != n3) return bl;
        if (this.mCurrentView.findFocus().focusSearch(n2) != null) return bl;
        this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
        this.playSoundEffect(n);
        return true;
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        if (this.mCurrentView != null) {
            this.mCurrentView.dispatchWindowFocusChanged(bl);
        }
    }

    public int getCurrentTab() {
        return this.mCurrentTab;
    }

    public String getCurrentTabTag() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabSpecs.get(this.mCurrentTab).getTag();
        }
        return null;
    }

    public View getCurrentTabView() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabWidget.getChildTabViewAt(this.mCurrentTab);
        }
        return null;
    }

    public View getCurrentView() {
        return this.mCurrentView;
    }

    public FrameLayout getTabContentView() {
        return this.mTabContent;
    }

    public TabWidget getTabWidget() {
        return this.mTabWidget;
    }

    public TabSpec newTabSpec(String string2) {
        return new TabSpec(string2);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnTouchModeChangeListener(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(TabHost.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(TabHost.class.getName());
    }

    @Override
    public void onTouchModeChanged(boolean bl) {
        if (!(bl || this.mCurrentView == null || this.mCurrentView.hasFocus() && !this.mCurrentView.isFocused())) {
            this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
        }
    }

    @Override
    public void sendAccessibilityEvent(int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentTab(int n) {
        if (n < 0 || n >= this.mTabSpecs.size() || n == this.mCurrentTab) {
            return;
        }
        if (this.mCurrentTab != -1) {
            this.mTabSpecs.get(this.mCurrentTab).mContentStrategy.tabClosed();
        }
        this.mCurrentTab = n;
        TabSpec tabSpec = this.mTabSpecs.get(n);
        this.mTabWidget.focusCurrentTab(this.mCurrentTab);
        this.mCurrentView = tabSpec.mContentStrategy.getContentView();
        if (this.mCurrentView.getParent() == null) {
            this.mTabContent.addView(this.mCurrentView, new ViewGroup.LayoutParams(-1, -1));
        }
        if (!this.mTabWidget.hasFocus()) {
            this.mCurrentView.requestFocus();
        }
        this.invokeOnTabChangeListener();
    }

    public void setCurrentTabByTag(String string2) {
        int n = 0;
        while (true) {
            block4: {
                block3: {
                    if (n >= this.mTabSpecs.size()) break block3;
                    if (!this.mTabSpecs.get(n).getTag().equals(string2)) break block4;
                    this.setCurrentTab(n);
                }
                return;
            }
            ++n;
        }
    }

    public void setOnTabChangedListener(OnTabChangeListener onTabChangeListener) {
        this.mOnTabChangeListener = onTabChangeListener;
    }

    public void setup() {
        this.mTabWidget = (TabWidget)this.findViewById(16908307);
        if (this.mTabWidget == null) {
            throw new RuntimeException("Your TabHost must have a TabWidget whose id attribute is 'android.R.id.tabs'");
        }
        this.mTabKeyListener = new View.OnKeyListener(){

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                switch (n) {
                    default: {
                        TabHost.this.mTabContent.requestFocus(2);
                        return TabHost.this.mTabContent.dispatchKeyEvent(keyEvent);
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 66: 
                }
                return false;
            }
        };
        this.mTabWidget.setTabSelectionListener(new TabWidget.OnTabSelectionChanged(){

            @Override
            public void onTabSelectionChanged(int n, boolean bl) {
                TabHost.this.setCurrentTab(n);
                if (bl) {
                    TabHost.this.mTabContent.requestFocus(2);
                }
            }
        });
        this.mTabContent = (FrameLayout)this.findViewById(0x1020011);
        if (this.mTabContent == null) {
            throw new RuntimeException("Your TabHost must have a FrameLayout whose id attribute is 'android.R.id.tabcontent'");
        }
    }

    public void setup(LocalActivityManager localActivityManager) {
        this.setup();
        this.mLocalActivityManager = localActivityManager;
    }

    private static interface ContentStrategy {
        public View getContentView();

        public void tabClosed();
    }

    private class FactoryContentStrategy
    implements ContentStrategy {
        private TabContentFactory mFactory;
        private View mTabContent;
        private final CharSequence mTag;

        public FactoryContentStrategy(CharSequence charSequence, TabContentFactory tabContentFactory) {
            this.mTag = charSequence;
            this.mFactory = tabContentFactory;
        }

        @Override
        public View getContentView() {
            if (this.mTabContent == null) {
                this.mTabContent = this.mFactory.createTabContent(this.mTag.toString());
            }
            this.mTabContent.setVisibility(0);
            return this.mTabContent;
        }

        @Override
        public void tabClosed() {
            this.mTabContent.setVisibility(8);
        }
    }

    private static interface IndicatorStrategy {
        public View createIndicatorView();
    }

    private class IntentContentStrategy
    implements ContentStrategy {
        private final Intent mIntent;
        private View mLaunchedView;
        private final String mTag;

        private IntentContentStrategy(String string2, Intent intent) {
            this.mTag = string2;
            this.mIntent = intent;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getContentView() {
            if (TabHost.this.mLocalActivityManager == null) {
                throw new IllegalStateException("Did you forget to call 'public void setup(LocalActivityManager activityGroup)'?");
            }
            Window window = TabHost.this.mLocalActivityManager.startActivity(this.mTag, this.mIntent);
            View view = window != null ? window.getDecorView() : null;
            if (this.mLaunchedView != view && this.mLaunchedView != null && this.mLaunchedView.getParent() != null) {
                TabHost.this.mTabContent.removeView(this.mLaunchedView);
            }
            this.mLaunchedView = view;
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(0);
                this.mLaunchedView.setFocusableInTouchMode(true);
                ((ViewGroup)this.mLaunchedView).setDescendantFocusability(262144);
            }
            return this.mLaunchedView;
        }

        @Override
        public void tabClosed() {
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(8);
            }
        }
    }

    private class LabelAndIconIndicatorStrategy
    implements IndicatorStrategy {
        private final Drawable mIcon;
        private final CharSequence mLabel;

        private LabelAndIconIndicatorStrategy(CharSequence charSequence, Drawable drawable2) {
            this.mLabel = charSequence;
            this.mIcon = drawable2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View createIndicatorView() {
            boolean bl = true;
            Context context = TabHost.this.getContext();
            View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(TabHost.this.mTabLayoutId, (ViewGroup)TabHost.this.mTabWidget, false);
            TextView textView = (TextView)view.findViewById(16908310);
            ImageView imageView = (ImageView)view.findViewById(16908294);
            boolean bl2 = imageView.getVisibility() == 8 ? bl : false;
            if (bl2 && !TextUtils.isEmpty(this.mLabel)) {
                bl = false;
            }
            textView.setText(this.mLabel);
            if (bl && this.mIcon != null) {
                imageView.setImageDrawable(this.mIcon);
                imageView.setVisibility(0);
            }
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                view.setBackgroundResource(17303502);
                textView.setTextColor(context.getResources().getColorStateList(17170839));
            }
            return view;
        }
    }

    private class LabelIndicatorStrategy
    implements IndicatorStrategy {
        private final CharSequence mLabel;

        private LabelIndicatorStrategy(CharSequence charSequence) {
            this.mLabel = charSequence;
        }

        @Override
        public View createIndicatorView() {
            Context context = TabHost.this.getContext();
            View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(TabHost.this.mTabLayoutId, (ViewGroup)TabHost.this.mTabWidget, false);
            TextView textView = (TextView)view.findViewById(16908310);
            textView.setText(this.mLabel);
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                view.setBackgroundResource(17303502);
                textView.setTextColor(context.getResources().getColorStateList(17170839));
            }
            return view;
        }
    }

    public static interface OnTabChangeListener {
        public void onTabChanged(String var1);
    }

    public static interface TabContentFactory {
        public View createTabContent(String var1);
    }

    public class TabSpec {
        private ContentStrategy mContentStrategy;
        private IndicatorStrategy mIndicatorStrategy;
        private String mTag;

        private TabSpec(String string2) {
            this.mTag = string2;
        }

        public String getTag() {
            return this.mTag;
        }

        public TabSpec setContent(int n) {
            this.mContentStrategy = new ViewIdContentStrategy(n);
            return this;
        }

        public TabSpec setContent(Intent intent) {
            this.mContentStrategy = new IntentContentStrategy(this.mTag, intent);
            return this;
        }

        public TabSpec setContent(TabContentFactory tabContentFactory) {
            this.mContentStrategy = new FactoryContentStrategy(this.mTag, tabContentFactory);
            return this;
        }

        public TabSpec setIndicator(View view) {
            this.mIndicatorStrategy = new ViewIndicatorStrategy(view);
            return this;
        }

        public TabSpec setIndicator(CharSequence charSequence) {
            this.mIndicatorStrategy = new LabelIndicatorStrategy(charSequence);
            return this;
        }

        public TabSpec setIndicator(CharSequence charSequence, Drawable drawable2) {
            this.mIndicatorStrategy = new LabelAndIconIndicatorStrategy(charSequence, drawable2);
            return this;
        }
    }

    private class ViewIdContentStrategy
    implements ContentStrategy {
        private final View mView;

        private ViewIdContentStrategy(int n) {
            this.mView = TabHost.this.mTabContent.findViewById(n);
            if (this.mView != null) {
                this.mView.setVisibility(8);
                return;
            }
            throw new RuntimeException("Could not create tab content because could not find view with id " + n);
        }

        @Override
        public View getContentView() {
            this.mView.setVisibility(0);
            return this.mView;
        }

        @Override
        public void tabClosed() {
            this.mView.setVisibility(8);
        }
    }

    private class ViewIndicatorStrategy
    implements IndicatorStrategy {
        private final View mView;

        private ViewIndicatorStrategy(View view) {
            this.mView = view;
        }

        @Override
        public View createIndicatorView() {
            return this.mView;
        }
    }
}

