/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.TimePickerClockDelegate;
import android.widget.TimePickerSpinnerDelegate;
import com.android.internal.R;
import java.util.Locale;

public class TimePicker
extends FrameLayout {
    private static final int MODE_CLOCK = 2;
    private static final int MODE_SPINNER = 1;
    private final TimePickerDelegate mDelegate;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843933);
    }

    public TimePicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TimePicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TimePicker, n, n2);
        int n3 = typedArray.getInt(8, 1);
        typedArray.recycle();
        switch (n3) {
            default: {
                this.mDelegate = new TimePickerClockDelegate(this, context, attributeSet, n, n2);
                return;
            }
            case 2: 
        }
        this.mDelegate = new TimePickerSpinnerDelegate(this, context, attributeSet, n, n2);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Override
    public int getBaseline() {
        return this.mDelegate.getBaseline();
    }

    public Integer getCurrentHour() {
        return this.mDelegate.getCurrentHour();
    }

    public Integer getCurrentMinute() {
        return this.mDelegate.getCurrentMinute();
    }

    public boolean is24HourView() {
        return this.mDelegate.is24HourView();
    }

    @Override
    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mDelegate.onConfigurationChanged(configuration);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        this.mDelegate.onInitializeAccessibilityEvent(accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        this.mDelegate.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        this.mDelegate.onPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        View.BaseSavedState baseSavedState = (View.BaseSavedState)parcelable;
        super.onRestoreInstanceState(baseSavedState.getSuperState());
        this.mDelegate.onRestoreInstanceState(baseSavedState);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(parcelable);
    }

    public void setCurrentHour(Integer n) {
        this.mDelegate.setCurrentHour(n);
    }

    public void setCurrentMinute(Integer n) {
        this.mDelegate.setCurrentMinute(n);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mDelegate.setEnabled(bl);
    }

    public void setIs24HourView(Boolean bl) {
        this.mDelegate.setIs24HourView(bl);
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mDelegate.setOnTimeChangedListener(onTimeChangedListener);
    }

    public void setValidationCallback(ValidationCallback validationCallback) {
        this.mDelegate.setValidationCallback(validationCallback);
    }

    static abstract class AbstractTimePickerDelegate
    implements TimePickerDelegate {
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected TimePicker mDelegator;
        protected OnTimeChangedListener mOnTimeChangedListener;
        protected ValidationCallback mValidationCallback;

        public AbstractTimePickerDelegate(TimePicker timePicker, Context context) {
            this.mDelegator = timePicker;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void onValidationChanged(boolean bl) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(bl);
            }
        }

        public void setCurrentLocale(Locale locale) {
            if (locale.equals(this.mCurrentLocale)) {
                return;
            }
            this.mCurrentLocale = locale;
        }

        @Override
        public void setValidationCallback(ValidationCallback validationCallback) {
            this.mValidationCallback = validationCallback;
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }

    static interface TimePickerDelegate {
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public int getBaseline();

        public Integer getCurrentHour();

        public Integer getCurrentMinute();

        public boolean is24HourView();

        public boolean isEnabled();

        public void onConfigurationChanged(Configuration var1);

        public void onInitializeAccessibilityEvent(AccessibilityEvent var1);

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onRestoreInstanceState(Parcelable var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void setCurrentHour(Integer var1);

        public void setCurrentMinute(Integer var1);

        public void setEnabled(boolean var1);

        public void setIs24HourView(Boolean var1);

        public void setOnTimeChangedListener(OnTimeChangedListener var1);

        public void setValidationCallback(ValidationCallback var1);
    }

    public static interface ValidationCallback {
        public void onValidationChanged(boolean var1);
    }
}

