/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Canvas;
import android.media.AudioManager;
import android.media.ClosedCaptionRenderer;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.Metadata;
import android.media.SubtitleController;
import android.media.SubtitleTrack;
import android.media.TtmlRenderer;
import android.media.WebVttRenderer;
import android.net.Uri;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.MediaController;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Vector;

public class VideoView
extends SurfaceView
implements MediaController.MediaPlayerControl,
SubtitleController.Anchor {
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PREPARING = 1;
    private String TAG = "VideoView";
    private int mAudioSession;
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private MediaPlayer.OnCompletionListener mCompletionListener;
    private int mCurrentBufferPercentage;
    private int mCurrentState = 0;
    private MediaPlayer.OnErrorListener mErrorListener;
    private Map<String, String> mHeaders;
    private MediaPlayer.OnInfoListener mInfoListener;
    private MediaController mMediaController;
    private MediaPlayer mMediaPlayer = null;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private Vector<Pair<InputStream, MediaFormat>> mPendingSubtitleTracks;
    MediaPlayer.OnPreparedListener mPreparedListener;
    SurfaceHolder.Callback mSHCallback;
    private int mSeekWhenPrepared;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
            VideoView.access$002(VideoView.this, mediaPlayer.getVideoWidth());
            VideoView.access$102(VideoView.this, mediaPlayer.getVideoHeight());
            if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                VideoView.this.getHolder().setFixedSize(VideoView.this.mVideoWidth, VideoView.this.mVideoHeight);
                VideoView.this.requestLayout();
            }
        }
    };
    private SubtitleTrack.RenderingWidget mSubtitleWidget;
    private SubtitleTrack.RenderingWidget.OnChangedListener mSubtitlesChangedListener;
    private int mSurfaceHeight;
    private SurfaceHolder mSurfaceHolder = null;
    private int mSurfaceWidth;
    private int mTargetState = 0;
    private Uri mUri;
    private int mVideoHeight;
    private int mVideoWidth;

    public VideoView(Context context) {
        super(context);
        this.mPreparedListener = new MediaPlayer.OnPreparedListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                VideoView.access$202(VideoView.this, 2);
                Metadata metadata = mediaPlayer.getMetadata(false, false);
                if (metadata != null) {
                    VideoView videoView = VideoView.this;
                    boolean bl = !metadata.has(1) || metadata.getBoolean(1);
                    VideoView.access$302(videoView, bl);
                    VideoView videoView2 = VideoView.this;
                    boolean bl2 = !metadata.has(2) || metadata.getBoolean(2);
                    VideoView.access$402(videoView2, bl2);
                    VideoView videoView3 = VideoView.this;
                    boolean bl3 = !metadata.has(3) || metadata.getBoolean(3);
                    VideoView.access$502(videoView3, bl3);
                } else {
                    VideoView.access$302(VideoView.this, VideoView.access$402(VideoView.this, VideoView.access$502(VideoView.this, true)));
                }
                if (VideoView.this.mOnPreparedListener != null) {
                    VideoView.this.mOnPreparedListener.onPrepared(VideoView.this.mMediaPlayer);
                }
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.setEnabled(true);
                }
                VideoView.access$002(VideoView.this, mediaPlayer.getVideoWidth());
                VideoView.access$102(VideoView.this, mediaPlayer.getVideoHeight());
                int n = VideoView.this.mSeekWhenPrepared;
                if (n != 0) {
                    VideoView.this.seekTo(n);
                }
                if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                    VideoView.this.getHolder().setFixedSize(VideoView.this.mVideoWidth, VideoView.this.mVideoHeight);
                    if (VideoView.this.mSurfaceWidth != VideoView.this.mVideoWidth || VideoView.this.mSurfaceHeight != VideoView.this.mVideoHeight) return;
                    if (VideoView.this.mTargetState == 3) {
                        VideoView.this.start();
                        if (VideoView.this.mMediaController == null) return;
                        VideoView.this.mMediaController.show();
                        return;
                    }
                    if (VideoView.this.isPlaying() || n == 0 && VideoView.this.getCurrentPosition() <= 0 || VideoView.this.mMediaController == null) return;
                    VideoView.this.mMediaController.show(0);
                    return;
                }
                if (VideoView.this.mTargetState != 3) return;
                VideoView.this.start();
            }
        };
        this.mCompletionListener = new MediaPlayer.OnCompletionListener(){

            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                VideoView.access$202(VideoView.this, 5);
                VideoView.access$1202(VideoView.this, 5);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                if (VideoView.this.mOnCompletionListener != null) {
                    VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
                }
            }
        };
        this.mInfoListener = new MediaPlayer.OnInfoListener(){

            @Override
            public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
                if (VideoView.this.mOnInfoListener != null) {
                    VideoView.this.mOnInfoListener.onInfo(mediaPlayer, n, n2);
                }
                return true;
            }
        };
        this.mErrorListener = new MediaPlayer.OnErrorListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                Log.d(VideoView.this.TAG, "Error: " + n + "," + n2);
                VideoView.access$202(VideoView.this, -1);
                VideoView.access$1202(VideoView.this, -1);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                if (VideoView.this.mOnErrorListener != null && VideoView.this.mOnErrorListener.onError(VideoView.this.mMediaPlayer, n, n2) || VideoView.this.getWindowToken() == null) {
                    return true;
                }
                VideoView.this.mContext.getResources();
                int n3 = n == 200 ? 17039381 : 0x1040011;
                new AlertDialog.Builder(VideoView.this.mContext).setMessage(n3).setPositiveButton(0x1040010, new DialogInterface.OnClickListener(){

                    @Override
                    public void onClick(DialogInterface dialogInterface, int n) {
                        if (VideoView.this.mOnCompletionListener != null) {
                            VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
                return true;
            }
        };
        this.mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

            @Override
            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
                VideoView.access$1902(VideoView.this, n);
            }
        };
        this.mSHCallback = new SurfaceHolder.Callback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                VideoView.access$1002(VideoView.this, n2);
                VideoView.access$1102(VideoView.this, n3);
                boolean bl = VideoView.this.mTargetState == 3;
                boolean bl2 = VideoView.this.mVideoWidth == n2 && VideoView.this.mVideoHeight == n3;
                if (VideoView.this.mMediaPlayer != null && bl && bl2) {
                    if (VideoView.this.mSeekWhenPrepared != 0) {
                        VideoView.this.seekTo(VideoView.this.mSeekWhenPrepared);
                    }
                    VideoView.this.start();
                }
            }

            @Override
            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                VideoView.access$2002(VideoView.this, surfaceHolder);
                VideoView.this.openVideo();
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                VideoView.access$2002(VideoView.this, null);
                if (VideoView.this.mMediaController != null) {
                    VideoView.this.mMediaController.hide();
                }
                VideoView.this.release(true);
            }
        };
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.initVideoView();
    }

    public VideoView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public VideoView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mPreparedListener = new /* invalid duplicate definition of identical inner class */;
        this.mCompletionListener = new /* invalid duplicate definition of identical inner class */;
        this.mInfoListener = new /* invalid duplicate definition of identical inner class */;
        this.mErrorListener = new /* invalid duplicate definition of identical inner class */;
        this.mBufferingUpdateListener = new /* invalid duplicate definition of identical inner class */;
        this.mSHCallback = new /* invalid duplicate definition of identical inner class */;
        this.initVideoView();
    }

    static /* synthetic */ int access$002(VideoView videoView, int n) {
        videoView.mVideoWidth = n;
        return n;
    }

    static /* synthetic */ int access$1002(VideoView videoView, int n) {
        videoView.mSurfaceWidth = n;
        return n;
    }

    static /* synthetic */ int access$102(VideoView videoView, int n) {
        videoView.mVideoHeight = n;
        return n;
    }

    static /* synthetic */ int access$1102(VideoView videoView, int n) {
        videoView.mSurfaceHeight = n;
        return n;
    }

    static /* synthetic */ int access$1202(VideoView videoView, int n) {
        videoView.mTargetState = n;
        return n;
    }

    static /* synthetic */ int access$1902(VideoView videoView, int n) {
        videoView.mCurrentBufferPercentage = n;
        return n;
    }

    static /* synthetic */ SurfaceHolder access$2002(VideoView videoView, SurfaceHolder surfaceHolder) {
        videoView.mSurfaceHolder = surfaceHolder;
        return surfaceHolder;
    }

    static /* synthetic */ int access$202(VideoView videoView, int n) {
        videoView.mCurrentState = n;
        return n;
    }

    static /* synthetic */ boolean access$302(VideoView videoView, boolean bl) {
        videoView.mCanPause = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(VideoView videoView, boolean bl) {
        videoView.mCanSeekBack = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(VideoView videoView, boolean bl) {
        videoView.mCanSeekForward = bl;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            void var1_2;
            this.mMediaController.setMediaPlayer(this);
            if (this.getParent() instanceof View) {
                View view = (View)((Object)this.getParent());
            } else {
                VideoView videoView = this;
            }
            this.mMediaController.setAnchorView((View)var1_2);
            this.mMediaController.setEnabled(this.isInPlaybackState());
        }
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mPendingSubtitleTracks = new Vector();
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    private void measureAndLayoutSubtitleWidget() {
        int n = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int n2 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.mSubtitleWidget.setSize(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openVideo() {
        if (this.mUri == null) return;
        if (this.mSurfaceHolder == null) {
            return;
        }
        ((AudioManager)this.mContext.getSystemService("audio")).requestAudioFocus(null, 3, 1);
        this.release(false);
        try {
            try {
                this.mMediaPlayer = new MediaPlayer();
                Context context = this.getContext();
                SubtitleController subtitleController = new SubtitleController(context, this.mMediaPlayer.getMediaTimeProvider(), this.mMediaPlayer);
                subtitleController.registerRenderer(new WebVttRenderer(context));
                subtitleController.registerRenderer(new TtmlRenderer(context));
                subtitleController.registerRenderer(new ClosedCaptionRenderer(context));
                this.mMediaPlayer.setSubtitleAnchor(subtitleController, this);
                if (this.mAudioSession != 0) {
                    this.mMediaPlayer.setAudioSessionId(this.mAudioSession);
                } else {
                    this.mAudioSession = this.mMediaPlayer.getAudioSessionId();
                }
                this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
                this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
                this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
                this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
                this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
                this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
                this.mCurrentBufferPercentage = 0;
                this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders);
                this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
                this.mMediaPlayer.setAudioStreamType(3);
                this.mMediaPlayer.setScreenOnWhilePlaying(true);
                this.mMediaPlayer.prepareAsync();
                for (Pair pair : this.mPendingSubtitleTracks) {
                    try {
                        this.mMediaPlayer.addSubtitleSource((InputStream)pair.first, (MediaFormat)pair.second);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.mInfoListener.onInfo(this.mMediaPlayer, 901, 0);
                    }
                }
            }
            catch (IOException iOException) {
                Log.w(this.TAG, "Unable to open content: " + this.mUri, iOException);
                this.mCurrentState = -1;
                this.mTargetState = -1;
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w(this.TAG, "Unable to open content: " + this.mUri, illegalArgumentException);
                this.mCurrentState = -1;
                this.mTargetState = -1;
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
                return;
            }
            this.mCurrentState = 1;
            this.attachMediaController();
            return;
        }
        finally {
            this.mPendingSubtitleTracks.clear();
        }
    }

    private void release(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mPendingSubtitleTracks.clear();
            this.mCurrentState = 0;
            if (bl) {
                this.mTargetState = 0;
            }
        }
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
            return;
        }
        this.mMediaController.show();
    }

    public void addSubtitleSource(InputStream inputStream, MediaFormat mediaFormat) {
        if (this.mMediaPlayer == null) {
            this.mPendingSubtitleTracks.add(Pair.create(inputStream, mediaFormat));
            return;
        }
        try {
            this.mMediaPlayer.addSubtitleSource(inputStream, mediaFormat);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.mInfoListener.onInfo(this.mMediaPlayer, 901, 0);
            return;
        }
    }

    @Override
    public boolean canPause() {
        return this.mCanPause;
    }

    @Override
    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    @Override
    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mSubtitleWidget != null) {
            int n = canvas.save();
            canvas.translate(this.getPaddingLeft(), this.getPaddingTop());
            this.mSubtitleWidget.draw(canvas);
            canvas.restoreToCount(n);
        }
    }

    @Override
    public int getAudioSessionId() {
        if (this.mAudioSession == 0) {
            MediaPlayer mediaPlayer = new MediaPlayer();
            this.mAudioSession = mediaPlayer.getAudioSessionId();
            mediaPlayer.release();
        }
        return this.mAudioSession;
    }

    @Override
    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    @Override
    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public int getDuration() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    @Override
    public Looper getSubtitleLooper() {
        return Looper.getMainLooper();
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onAttachedToWindow();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onDetachedFromWindow();
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(VideoView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(VideoView.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        boolean bl = n != 4 && n != 24 && n != 25 && n != 164 && n != 82 && n != 5 && n != 6;
        if (!this.isInPlaybackState() || !bl || this.mMediaController == null) return super.onKeyDown(n, keyEvent);
        if (n == 79 || n == 85) {
            if (!this.mMediaPlayer.isPlaying()) {
                this.start();
                this.mMediaController.hide();
                return true;
            }
            this.pause();
            this.mMediaController.show();
            return true;
        }
        if (n == 126) {
            if (this.mMediaPlayer.isPlaying()) return true;
            this.start();
            this.mMediaController.hide();
            return true;
        }
        if (n == 86 || n == 127) {
            if (!this.mMediaPlayer.isPlaying()) return true;
            this.pause();
            this.mMediaController.show();
            return true;
        }
        this.toggleMediaControlsVisiblity();
        return super.onKeyDown(n, keyEvent);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (this.mSubtitleWidget != null) {
            this.measureAndLayoutSubtitleWidget();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        block11: {
            int n5;
            int n6;
            int n7;
            int n8;
            block12: {
                n4 = VideoView.getDefaultSize(this.mVideoWidth, n);
                n3 = VideoView.getDefaultSize(this.mVideoHeight, n2);
                if (this.mVideoWidth <= 0 || this.mVideoHeight <= 0) break block11;
                n8 = View.MeasureSpec.getMode(n);
                n7 = View.MeasureSpec.getSize(n);
                n6 = View.MeasureSpec.getMode(n2);
                n5 = View.MeasureSpec.getSize(n2);
                if (n8 != 0x40000000 || n6 != 0x40000000) break block12;
                n3 = n5;
                n4 = n7;
                if (n3 * this.mVideoWidth < n4 * this.mVideoHeight) {
                    n4 = n3 * this.mVideoWidth / this.mVideoHeight;
                    break block11;
                } else if (n3 * this.mVideoWidth > n4 * this.mVideoHeight) {
                    n3 = n4 * this.mVideoHeight / this.mVideoWidth;
                }
                break block11;
            }
            if (n8 == 0x40000000) {
                n4 = n7;
                n3 = n4 * this.mVideoHeight / this.mVideoWidth;
                if (n6 == Integer.MIN_VALUE && n3 > n5) {
                    n3 = n5;
                }
            } else if (n6 == 0x40000000) {
                n3 = n5;
                n4 = n3 * this.mVideoWidth / this.mVideoHeight;
                if (n8 == Integer.MIN_VALUE && n4 > n7) {
                    n4 = n7;
                }
            } else {
                n4 = this.mVideoWidth;
                n3 = this.mVideoHeight;
                if (n6 == Integer.MIN_VALUE && n3 > n5) {
                    n3 = n5;
                    n4 = n3 * this.mVideoWidth / this.mVideoHeight;
                }
                if (n8 == Integer.MIN_VALUE && n4 > n7) {
                    n4 = n7;
                    n3 = n4 * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        this.setMeasuredDimension(n4, n3);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public int resolveAdjustedSize(int n, int n2) {
        return VideoView.getDefaultSize(n, n2);
    }

    public void resume() {
        this.openVideo();
    }

    @Override
    public void seekTo(int n) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(n);
            this.mSeekWhenPrepared = 0;
            return;
        }
        this.mSeekWhenPrepared = n;
    }

    public void setMediaController(MediaController mediaController) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = mediaController;
        this.attachMediaController();
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSubtitleWidget(SubtitleTrack.RenderingWidget renderingWidget) {
        if (this.mSubtitleWidget == renderingWidget) {
            return;
        }
        boolean bl = this.isAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            if (bl) {
                this.mSubtitleWidget.onDetachedFromWindow();
            }
            this.mSubtitleWidget.setOnChangedListener(null);
        }
        this.mSubtitleWidget = renderingWidget;
        if (renderingWidget != null) {
            if (this.mSubtitlesChangedListener == null) {
                this.mSubtitlesChangedListener = new SubtitleTrack.RenderingWidget.OnChangedListener(){

                    @Override
                    public void onChanged(SubtitleTrack.RenderingWidget renderingWidget) {
                        VideoView.this.invalidate();
                    }
                };
            }
            this.setWillNotDraw(false);
            renderingWidget.setOnChangedListener(this.mSubtitlesChangedListener);
            if (bl) {
                renderingWidget.onAttachedToWindow();
                this.requestLayout();
            }
        } else {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public void setVideoPath(String string2) {
        this.setVideoURI(Uri.parse(string2));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, Map<String, String> map) {
        this.mUri = uri;
        this.mHeaders = map;
        this.mSeekWhenPrepared = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    public void suspend() {
        this.release(false);
    }
}

