/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageButton;

public class ZoomButton
extends ImageButton
implements View.OnLongClickListener {
    private final Handler mHandler;
    private boolean mIsInLongpress;
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (ZoomButton.this.hasOnClickListeners() && ZoomButton.this.mIsInLongpress && ZoomButton.this.isEnabled()) {
                ZoomButton.this.callOnClick();
                ZoomButton.this.mHandler.postDelayed(this, ZoomButton.this.mZoomSpeed);
            }
        }
    };
    private long mZoomSpeed = 1000L;

    public ZoomButton(Context context) {
        this(context, null);
    }

    public ZoomButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZoomButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ZoomButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mHandler = new Handler();
        this.setOnLongClickListener(this);
    }

    @Override
    public boolean dispatchUnhandledMove(View view, int n) {
        this.clearFocus();
        return super.dispatchUnhandledMove(view, n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ZoomButton.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ZoomButton.class.getName());
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        this.mIsInLongpress = false;
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    public boolean onLongClick(View view) {
        this.mIsInLongpress = true;
        this.mHandler.post(this.mRunnable);
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 3 || motionEvent.getAction() == 1) {
            this.mIsInLongpress = false;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (!bl) {
            this.setPressed(false);
        }
        super.setEnabled(bl);
    }

    public void setZoomSpeed(long l) {
        this.mZoomSpeed = l;
    }
}

