/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.ListFragment;
import android.app.backup.BackupManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.RemoteException;
import android.provider.Settings;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class LocalePicker
extends ListFragment {
    private static final boolean DEBUG = false;
    private static final String TAG = "LocalePicker";
    LocaleSelectionListener mListener;

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context) {
        return LocalePicker.constructAdapter(context, 17367173, 16908748);
    }

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context, int n, int n2) {
        int n3 = Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0);
        boolean bl = false;
        if (n3 != 0) {
            bl = true;
        }
        return new ArrayAdapter<LocaleInfo>(context, n, n2, LocalePicker.getAllAssetLocales(context, bl), (LayoutInflater)context.getSystemService("layout_inflater"), n, n2){
            final /* synthetic */ int val$fieldId;
            final /* synthetic */ LayoutInflater val$inflater;
            final /* synthetic */ int val$layoutId;
            {
                this.val$inflater = layoutInflater;
                this.val$layoutId = n3;
                this.val$fieldId = n4;
                super(context, n, n2, list);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public View getView(int n, View view, ViewGroup viewGroup) {
                TextView textView;
                View view2;
                if (view == null) {
                    view2 = this.val$inflater.inflate(this.val$layoutId, viewGroup, false);
                    textView = (TextView)view2.findViewById(this.val$fieldId);
                    view2.setTag(textView);
                } else {
                    view2 = view;
                    textView = (TextView)view2.getTag();
                }
                LocaleInfo localeInfo = (LocaleInfo)this.getItem(n);
                textView.setText(localeInfo.toString());
                textView.setTextLocale(localeInfo.getLocale());
                return view2;
            }
        };
    }

    public static List<LocaleInfo> getAllAssetLocales(Context context, boolean bl) {
        Resources resources = context.getResources();
        String[] stringArray = Resources.getSystem().getAssets().getLocales();
        ArrayList arrayList = new ArrayList(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        if (!bl) {
            arrayList.remove("ar-XB");
            arrayList.remove("en-XA");
        }
        Collections.sort(arrayList);
        String[] stringArray2 = resources.getStringArray(17235976);
        String[] stringArray3 = resources.getStringArray(17235977);
        ArrayList<LocaleInfo> arrayList2 = new ArrayList<LocaleInfo>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Locale locale = Locale.forLanguageTag(((String)iterator.next()).replace('_', '-'));
            if (locale == null || "und".equals(locale.getLanguage()) || locale.getLanguage().isEmpty() || locale.getCountry().isEmpty()) continue;
            if (arrayList2.isEmpty()) {
                arrayList2.add(new LocaleInfo(LocalePicker.toTitleCase(locale.getDisplayLanguage(locale)), locale));
                continue;
            }
            LocaleInfo localeInfo = arrayList2.get(-1 + arrayList2.size());
            if (localeInfo.locale.getLanguage().equals(locale.getLanguage()) && !localeInfo.locale.getLanguage().equals("zz")) {
                localeInfo.label = LocalePicker.toTitleCase(LocalePicker.getDisplayName(localeInfo.locale, stringArray2, stringArray3));
                arrayList2.add(new LocaleInfo(LocalePicker.toTitleCase(LocalePicker.getDisplayName(locale, stringArray2, stringArray3)), locale));
                continue;
            }
            arrayList2.add(new LocaleInfo(LocalePicker.toTitleCase(locale.getDisplayLanguage(locale)), locale));
        }
        Collections.sort(arrayList2);
        return arrayList2;
    }

    private static String getDisplayName(Locale locale, String[] stringArray, String[] stringArray2) {
        String string2 = locale.toString();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return stringArray2[i];
        }
        return locale.getDisplayName(locale);
    }

    private static String toTitleCase(String string2) {
        if (string2.length() == 0) {
            return string2;
        }
        return Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    public static void updateLocale(Locale locale) {
        try {
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Configuration configuration = iActivityManager.getConfiguration();
            configuration.setLocale(locale);
            iActivityManager.updateConfiguration(configuration);
            BackupManager.dataChanged("com.android.providers.settings");
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.setListAdapter(LocalePicker.constructAdapter(this.getActivity()));
    }

    @Override
    public void onListItemClick(ListView listView, View view, int n, long l) {
        if (this.mListener != null) {
            Locale locale = ((LocaleInfo)this.getListAdapter().getItem((int)n)).locale;
            this.mListener.onLocaleSelected(locale);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getListView().requestFocus();
    }

    public void setLocaleSelectionListener(LocaleSelectionListener localeSelectionListener) {
        this.mListener = localeSelectionListener;
    }

    public static class LocaleInfo
    implements Comparable<LocaleInfo> {
        static final Collator sCollator = Collator.getInstance();
        String label;
        Locale locale;

        public LocaleInfo(String string2, Locale locale) {
            this.label = string2;
            this.locale = locale;
        }

        @Override
        public int compareTo(LocaleInfo localeInfo) {
            return sCollator.compare(this.label, localeInfo.label);
        }

        public String getLabel() {
            return this.label;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.label;
        }
    }

    public static interface LocaleSelectionListener {
        public void onLocaleSelected(Locale var1);
    }
}

