/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.database;

import android.database.AbstractCursor;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.util.Log;
import java.lang.reflect.Array;

public class SortCursor
extends AbstractCursor {
    private static final String TAG = "SortCursor";
    private final int ROWCACHESIZE;
    private int[][] mCurRowNumCache;
    private Cursor mCursor;
    private int[] mCursorCache;
    private Cursor[] mCursors;
    private int mLastCacheHit = -1;
    private DataSetObserver mObserver;
    private int[] mRowNumCache = new int[64];
    private int[] mSortColumns;

    /*
     * Enabled aggressive block sorting
     */
    public SortCursor(Cursor[] cursorArray, String string2) {
        this.ROWCACHESIZE = 64;
        this.mCursorCache = new int[64];
        this.mObserver = new DataSetObserver(){

            @Override
            public void onChanged() {
                SortCursor.access$002(SortCursor.this, -1);
            }

            @Override
            public void onInvalidated() {
                SortCursor.access$102(SortCursor.this, -1);
            }
        };
        this.mCursors = cursorArray;
        int n = this.mCursors.length;
        this.mSortColumns = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(this.mObserver);
            this.mCursors[i].moveToFirst();
            this.mSortColumns[i] = this.mCursors[i].getColumnIndexOrThrow(string2);
        }
        this.mCursor = null;
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null || this.mCursors[i].isAfterLast()) continue;
            String string4 = this.mCursors[i].getString(this.mSortColumns[i]);
            if (this.mCursor != null && string4.compareToIgnoreCase(string3) >= 0) continue;
            string3 = string4;
            this.mCursor = this.mCursors[i];
        }
        int n2 = -1 + this.mRowNumCache.length;
        while (true) {
            if (n2 < 0) {
                int[] nArray = new int[]{64, n};
                this.mCurRowNumCache = (int[][])Array.newInstance(Integer.TYPE, nArray);
                return;
            }
            this.mRowNumCache[n2] = -2;
            --n2;
        }
    }

    static /* synthetic */ int access$002(SortCursor sortCursor, int n) {
        sortCursor.mPos = n;
        return n;
    }

    static /* synthetic */ int access$102(SortCursor sortCursor, int n) {
        sortCursor.mPos = n;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void close() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].close();
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deactivate() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null) {
                this.mCursors[n2].deactivate();
            }
            ++n2;
        }
        return;
    }

    @Override
    public byte[] getBlob(int n) {
        return this.mCursor.getBlob(n);
    }

    @Override
    public String[] getColumnNames() {
        if (this.mCursor != null) {
            return this.mCursor.getColumnNames();
        }
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            return this.mCursors[i].getColumnNames();
        }
        throw new IllegalStateException("No cursor that can return names");
    }

    @Override
    public int getCount() {
        int n = 0;
        int n2 = this.mCursors.length;
        for (int i = 0; i < n2; ++i) {
            if (this.mCursors[i] == null) continue;
            n += this.mCursors[i].getCount();
        }
        return n;
    }

    @Override
    public double getDouble(int n) {
        return this.mCursor.getDouble(n);
    }

    @Override
    public float getFloat(int n) {
        return this.mCursor.getFloat(n);
    }

    @Override
    public int getInt(int n) {
        return this.mCursor.getInt(n);
    }

    @Override
    public long getLong(int n) {
        return this.mCursor.getLong(n);
    }

    @Override
    public short getShort(int n) {
        return this.mCursor.getShort(n);
    }

    @Override
    public String getString(int n) {
        return this.mCursor.getString(n);
    }

    @Override
    public int getType(int n) {
        return this.mCursor.getType(n);
    }

    @Override
    public boolean isNull(int n) {
        return this.mCursor.isNull(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onMove(int n, int n2) {
        if (n == n2) {
            return true;
        }
        int n3 = n2 % 64;
        if (this.mRowNumCache[n3] == n2) {
            int n4 = this.mCursorCache[n3];
            this.mCursor = this.mCursors[n4];
            if (this.mCursor == null) {
                Log.w(TAG, "onMove: cache results in a null cursor.");
                return false;
            }
            this.mCursor.moveToPosition(this.mCurRowNumCache[n3][n4]);
            this.mLastCacheHit = n3;
            return true;
        }
        this.mCursor = null;
        int n5 = this.mCursors.length;
        if (this.mLastCacheHit >= 0) {
            for (int i = 0; i < n5; ++i) {
                if (this.mCursors[i] == null) continue;
                this.mCursors[i].moveToPosition(this.mCurRowNumCache[this.mLastCacheHit][i]);
            }
        }
        if (n2 < n || n == -1) {
            for (int i = 0; i < n5; ++i) {
                if (this.mCursors[i] == null) continue;
                this.mCursors[i].moveToFirst();
            }
            n = 0;
        }
        if (n < 0) {
            n = 0;
        }
        int n6 = -1;
        for (int i = n; i <= n2; ++i) {
            String string2 = "";
            n6 = -1;
            for (int j = 0; j < n5; ++j) {
                if (this.mCursors[j] == null || this.mCursors[j].isAfterLast()) continue;
                String string3 = this.mCursors[j].getString(this.mSortColumns[j]);
                if (n6 >= 0 && string3.compareToIgnoreCase(string2) >= 0) continue;
                string2 = string3;
                n6 = j;
            }
            if (i == n2) break;
            if (this.mCursors[n6] == null) continue;
            this.mCursors[n6].moveToNext();
        }
        this.mCursor = this.mCursors[n6];
        this.mRowNumCache[n3] = n2;
        this.mCursorCache[n3] = n6;
        int n7 = 0;
        while (true) {
            if (n7 >= n5) {
                this.mLastCacheHit = -1;
                return true;
            }
            if (this.mCursors[n7] != null) {
                this.mCurRowNumCache[n3][n7] = this.mCursors[n7].getPosition();
            }
            ++n7;
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(dataSetObserver);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean requery() {
        int n = this.mCursors.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.mCursors[n2] != null && !this.mCursors[n2].requery()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        int n = this.mCursors.length;
        for (int i = 0; i < n; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterDataSetObserver(dataSetObserver);
        }
    }
}

