/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.textservice;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.textservice.TextInfo;

public interface ISpellCheckerSession
extends IInterface {
    public void onCancel() throws RemoteException;

    public void onClose() throws RemoteException;

    public void onGetSentenceSuggestionsMultiple(TextInfo[] var1, int var2) throws RemoteException;

    public void onGetSuggestionsMultiple(TextInfo[] var1, int var2, boolean var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpellCheckerSession {
        private static final String DESCRIPTOR = "com.android.internal.textservice.ISpellCheckerSession";
        static final int TRANSACTION_onCancel = 3;
        static final int TRANSACTION_onClose = 4;
        static final int TRANSACTION_onGetSentenceSuggestionsMultiple = 2;
        static final int TRANSACTION_onGetSuggestionsMultiple = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpellCheckerSession asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISpellCheckerSession) {
                return (ISpellCheckerSession)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    TextInfo[] textInfoArray = parcel.createTypedArray(TextInfo.CREATOR);
                    int n3 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.onGetSuggestionsMultiple(textInfoArray, n3, bl);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onGetSentenceSuggestionsMultiple(parcel.createTypedArray(TextInfo.CREATOR), parcel.readInt());
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onCancel();
                    return true;
                }
                case 4: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.onClose();
            return true;
        }

        private static class Proxy
        implements ISpellCheckerSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onCancel() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onClose() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onGetSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedArray(textInfoArray, 0);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onGetSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedArray(textInfoArray, 0);
                    parcel.writeInt(n);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(1, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

