/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

public class BitwiseInputStream {
    private byte[] mBuf;
    private int mEnd;
    private int mPos;

    public BitwiseInputStream(byte[] byArray) {
        this.mBuf = byArray;
        this.mEnd = byArray.length << 3;
        this.mPos = 0;
    }

    public int available() {
        return this.mEnd - this.mPos;
    }

    public int read(int n) throws AccessException {
        int n2 = this.mPos >>> 3;
        int n3 = 16 - (7 & this.mPos) - n;
        if (n < 0 || n > 8 || n + this.mPos > this.mEnd) {
            throw new AccessException("illegal read (pos " + this.mPos + ", end " + this.mEnd + ", bits " + n + ")");
        }
        int n4 = (0xFF & this.mBuf[n2]) << 8;
        if (n3 < 8) {
            n4 |= 0xFF & this.mBuf[n2 + 1];
        }
        int n5 = n4 >>> n3 & -1 >>> 32 - n;
        this.mPos = n + this.mPos;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] readByteArray(int n) throws AccessException {
        int n2 = n >>> 3;
        int n3 = (n & 7) > 0 ? 1 : 0;
        int n4 = n2 + n3;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = Math.min(8, n - (n5 << 3));
            byArray[n5] = (byte)(this.read(n6) << 8 - n6);
            ++n5;
        }
        return byArray;
    }

    public void skip(int n) throws AccessException {
        if (n + this.mPos > this.mEnd) {
            throw new AccessException("illegal skip (pos " + this.mPos + ", end " + this.mEnd + ", bits " + n + ")");
        }
        this.mPos = n + this.mPos;
    }

    public static class AccessException
    extends Exception {
        public AccessException(String string2) {
            super("BitwiseInputStream access failed: " + string2);
        }
    }
}

