/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;

public class ProcFileReader
implements Closeable {
    private final byte[] mBuffer;
    private boolean mLineFinished;
    private final InputStream mStream;
    private int mTail;

    public ProcFileReader(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
    }

    public ProcFileReader(InputStream inputStream, int n) throws IOException {
        this.mStream = inputStream;
        this.mBuffer = new byte[n];
        this.fillBuf();
    }

    private void consumeBuf(int n) throws IOException {
        System.arraycopy((byte[])this.mBuffer, (int)n, (byte[])this.mBuffer, (int)0, (int)(this.mTail - n));
        this.mTail -= n;
        if (this.mTail == 0) {
            this.fillBuf();
        }
    }

    private int fillBuf() throws IOException {
        int n = this.mBuffer.length - this.mTail;
        if (n == 0) {
            throw new IOException("attempting to fill already-full buffer");
        }
        int n2 = this.mStream.read(this.mBuffer, this.mTail, n);
        if (n2 != -1) {
            this.mTail = n2 + this.mTail;
        }
        return n2;
    }

    private NumberFormatException invalidLong(int n) {
        return new NumberFormatException("invalid long: " + new String(this.mBuffer, 0, n, StandardCharsets.US_ASCII));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int nextTokenIndex() throws IOException {
        if (this.mLineFinished) {
            return -1;
        }
        int n = 0;
        while (true) {
            if (n < this.mTail) {
                byte by = this.mBuffer[n];
                if (by == 10) {
                    this.mLineFinished = true;
                    return n;
                }
                if (by == 32) return n;
                ++n;
                continue;
            }
            if (this.fillBuf() <= 0) throw new ProtocolException("End of stream while looking for token boundary");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private long parseAndConsumeLong(int n) throws IOException {
        int n2 = 1;
        int n3 = this.mBuffer[0] == 45 ? n2 : 0;
        long l = 0L;
        if (n3 == 0) {
            n2 = 0;
        }
        while (n2 < n) {
            int n4 = -48 + this.mBuffer[n2];
            if (n4 < 0 || n4 > 9) {
                throw this.invalidLong(n);
            }
            long l2 = 10L * l - (long)n4;
            if (l2 > l) {
                throw this.invalidLong(n);
            }
            l = l2;
            ++n2;
        }
        this.consumeBuf(n + 1);
        if (n3 != 0) {
            return l;
        }
        return -l;
    }

    private String parseAndConsumeString(int n) throws IOException {
        String string2 = new String(this.mBuffer, 0, n, StandardCharsets.US_ASCII);
        this.consumeBuf(n + 1);
        return string2;
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }

    public void finishLine() throws IOException {
        if (this.mLineFinished) {
            this.mLineFinished = false;
            return;
        }
        int n = 0;
        while (true) {
            if (n < this.mTail) {
                if (this.mBuffer[n] == 10) {
                    this.consumeBuf(n + 1);
                    return;
                }
                ++n;
                continue;
            }
            if (this.fillBuf() <= 0) break;
        }
        throw new ProtocolException("End of stream while looking for line boundary");
    }

    public boolean hasMoreData() {
        return this.mTail > 0;
    }

    public int nextInt() throws IOException {
        long l = this.nextLong();
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new NumberFormatException("parsed value larger than integer");
        }
        return (int)l;
    }

    public long nextLong() throws IOException {
        int n = this.nextTokenIndex();
        if (n == -1) {
            throw new ProtocolException("Missing required long");
        }
        return this.parseAndConsumeLong(n);
    }

    public long nextOptionalLong(long l) throws IOException {
        int n = this.nextTokenIndex();
        if (n == -1) {
            return l;
        }
        return this.parseAndConsumeLong(n);
    }

    public String nextString() throws IOException {
        int n = this.nextTokenIndex();
        if (n == -1) {
            throw new ProtocolException("Missing required string");
        }
        return this.parseAndConsumeString(n);
    }
}

