/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import com.android.internal.view.menu.ActionMenuItem;
import java.util.ArrayList;
import java.util.List;

public class ActionMenu
implements Menu {
    private Context mContext;
    private boolean mIsQwerty;
    private ArrayList<ActionMenuItem> mItems;

    public ActionMenu(Context context) {
        this.mContext = context;
        this.mItems = new ArrayList();
    }

    private int findItemIndex(int n) {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            if (arrayList.get(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ActionMenuItem findItemWithShortcut(int n, KeyEvent keyEvent) {
        boolean bl = this.mIsQwerty;
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            ActionMenuItem actionMenuItem = arrayList.get(n3);
            char c = bl ? actionMenuItem.getAlphabeticShortcut() : actionMenuItem.getNumericShortcut();
            if (n == c) {
                return actionMenuItem;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public MenuItem add(int n) {
        return this.add(0, 0, 0, n);
    }

    @Override
    public MenuItem add(int n, int n2, int n3, int n4) {
        return this.add(n, n2, n3, this.mContext.getResources().getString(n4));
    }

    @Override
    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        ActionMenuItem actionMenuItem = new ActionMenuItem(this.getContext(), n, n2, 0, n3, charSequence);
        this.mItems.add(n3, actionMenuItem);
        return actionMenuItem;
    }

    @Override
    public MenuItem add(CharSequence charSequence) {
        return this.add(0, 0, 0, charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentActivityOptions(componentName, intentArray, intent, 0);
        int n5 = list != null ? list.size() : 0;
        if ((n4 & 1) == 0) {
            this.removeGroup(n);
        }
        int n6 = 0;
        while (n6 < n5) {
            ResolveInfo resolveInfo = list.get(n6);
            Intent intent2 = resolveInfo.specificIndex < 0 ? intent : intentArray[resolveInfo.specificIndex];
            Intent intent3 = new Intent(intent2);
            intent3.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            MenuItem menuItem = this.add(n, n2, n3, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent3);
            if (menuItemArray != null && resolveInfo.specificIndex >= 0) {
                menuItemArray[resolveInfo.specificIndex] = menuItem;
            }
            ++n6;
        }
        return n5;
    }

    @Override
    public SubMenu addSubMenu(int n) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        return null;
    }

    @Override
    public SubMenu addSubMenu(CharSequence charSequence) {
        return null;
    }

    @Override
    public void clear() {
        this.mItems.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public MenuItem findItem(int n) {
        return this.mItems.get(this.findItemIndex(n));
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public MenuItem getItem(int n) {
        return this.mItems.get(n);
    }

    @Override
    public boolean hasVisibleItems() {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return this.findItemWithShortcut(n, keyEvent) != null;
    }

    @Override
    public boolean performIdentifierAction(int n, int n2) {
        int n3 = this.findItemIndex(n);
        if (n3 < 0) {
            return false;
        }
        return this.mItems.get(n3).invoke();
    }

    @Override
    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        ActionMenuItem actionMenuItem = this.findItemWithShortcut(n, keyEvent);
        if (actionMenuItem == null) {
            return false;
        }
        return actionMenuItem.invoke();
    }

    @Override
    public void removeGroup(int n) {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            if (arrayList.get(n3).getGroupId() == n) {
                arrayList.remove(n3);
                --n2;
                continue;
            }
            ++n3;
        }
    }

    @Override
    public void removeItem(int n) {
        this.mItems.remove(this.findItemIndex(n));
    }

    @Override
    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ActionMenuItem actionMenuItem = arrayList.get(i);
            if (actionMenuItem.getGroupId() != n) continue;
            actionMenuItem.setCheckable(bl);
            actionMenuItem.setExclusiveCheckable(bl2);
        }
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ActionMenuItem actionMenuItem = arrayList.get(i);
            if (actionMenuItem.getGroupId() != n) continue;
            actionMenuItem.setEnabled(bl);
        }
    }

    @Override
    public void setGroupVisible(int n, boolean bl) {
        ArrayList<ActionMenuItem> arrayList = this.mItems;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ActionMenuItem actionMenuItem = arrayList.get(i);
            if (actionMenuItem.getGroupId() != n) continue;
            actionMenuItem.setVisible(bl);
        }
    }

    @Override
    public void setQwertyMode(boolean bl) {
        this.mIsQwerty = bl;
    }

    @Override
    public int size() {
        return this.mItems.size();
    }
}

